/***********************************************************************
*  (c)       : Moore Industries International                          *
************************************************************************
*  Project   : Temperature Profibus Transmitter	
*-----------------------------------------------------------------------
*  Name      : Moore TPZ
*-----------------------------------------------------------------------
*  File name : TPZ.ddl
*-----------------------------------------------------------------------
*  Dictionary: TPZ.dct					
*-----------------------------------------------------------------------
*  System    : PDM 5.1
*-----------------------------------------------------------------------
*  Compiler  : PDM 5.1
*-----------------------------------------------------------------------
*  Date      : 10 June 2003
*-----------------------------------------------------------------------
*  Revision  : 1.02.05
*-----------------------------------------------------------------------
*  Revision Date : 17 October 2006
*-----------------------------------------------------------------------
*  Author    : Youssef Elghor
******************+*****************************************************
*  Device:			Moore TPZ for PROFIBUS PA 
*  Communication:	
*  Description:		TRANSMITTER - TEMPERATURE Profile 3
*					
***********************************************************************/

MANUFACTURER	32,
DEVICE_TYPE		1,
DEVICE_REVISION 0x0300,
DD_REVISION		2


/* Includes ------------------------------------------------------ */



//fbi #include "SIPAST_CommError.inc"
#include "SIPAST_Macros_300.inc"
#include "SIPAST.inc"

#include "SI_FileM.inc"
#include "SI_HlpM.inc"
#include "SI_OptM.inc"

// DEFINES/--------------------------------------------------------*/

#define DEFAULT_MANUFACTURER_ID		0x0020

#define	FLOAT_MIN	-3.4E+38
#define	FLOAT_MAX	 3.4E+38


#define YT1_LABEL	[func_out_value]
#define YT1_VALUE	func1_AI_out_value				
#define	YT1_LRV		func1_AI_out_lower_range_value	
#define YT1_URV		func1_AI_out_upper_range_value	

#include "SI_YT.inc"

/***********************************************************************/

#define SERVICECODE ((phys_write_locking & 0x93e9  )== 0x93e9 )

#define func_upper_value			func_pv_scale_upper_value
#define func_lower_value			func_pv_scale_lower_value
#define func_tot_total_value		func_tot_out_total_value
#define func_tot_total_value_help	func_tot_out_total_value_help

#define	BLOCK_MODE_AUTO				0x08
#define	BLOCK_MODE_MAN				0x10
#define	BLOCK_MODE_OUT_OF_SERVICE	0x80

#define	DEVICE_TYPE					[menu_table_sensor_temperature_tpz]






#define	TAB_X_LABEL_0			"X (0)"
#define	TAB_X_LABEL_1			"X (1)"
#define	TAB_X_LABEL_2			"X (2)"
#define	TAB_X_LABEL_3			"X (3)"
#define	TAB_X_LABEL_4			"X (4)"
#define	TAB_X_LABEL_5			"X (5)"
#define	TAB_X_LABEL_6			"X (6)"
#define	TAB_X_LABEL_7			"X (7)"
#define	TAB_X_LABEL_8			"X (8)"
#define	TAB_X_LABEL_9			"X (9)"
#define	TAB_X_LABEL_10			"X (10)"
#define	TAB_X_LABEL_11			"X (11)"
#define	TAB_X_LABEL_12			"X (12)"
#define	TAB_X_LABEL_13			"X (13)"
#define	TAB_X_LABEL_14			"X (14)"
#define	TAB_X_LABEL_15			"X (15)"
#define	TAB_X_LABEL_16			"X (16)"
#define	TAB_X_LABEL_17			"X (17)"
#define	TAB_X_LABEL_18			"X (18)"
#define	TAB_X_LABEL_19			"X (19)"
#define	TAB_X_LABEL_20			"X (20)"
#define	TAB_X_LABEL_21			"X (21)"
#define	TAB_X_LABEL_22			"X (22)"		
#define	TAB_X_LABEL_23			"X (23)"		
#define	TAB_X_LABEL_24			"X (24)"		
#define	TAB_X_LABEL_25			"X (25)"		
#define	TAB_X_LABEL_26			"X (26)"		
#define	TAB_X_LABEL_27			"X (27)"		
#define	TAB_X_LABEL_28			"X (28)"		
#define	TAB_X_LABEL_29			"X (29)"		
#define	TAB_X_LABEL_30			"X (30)"		
#define	TAB_X_LABEL_31			"X (31)"		
#define	TAB_X_LABEL_32			"X (32)"		
#define	TAB_X_LABEL_33			"X (33)"		
#define	TAB_X_LABEL_34			"X (34)"		
#define	TAB_X_LABEL_35			"X (35)"		
#define	TAB_X_LABEL_36			"X (36)"		
#define	TAB_X_LABEL_37			"X (37)"		
#define	TAB_X_LABEL_38			"X (38)"		
#define	TAB_X_LABEL_39			"X (39)"		
#define	TAB_X_LABEL_40			"X (40)"		
#define	TAB_X_LABEL_41			"X (41)"		
#define	TAB_X_LABEL_42			"X (42)"		
#define	TAB_X_LABEL_43			"X (43)"		
#define	TAB_X_LABEL_44			"X (44)"		
#define	TAB_X_LABEL_45			"X (45)"		
#define	TAB_X_LABEL_46			"X (46)"		
#define	TAB_X_LABEL_47			"X (47)"		
#define	TAB_X_LABEL_48			"X (48)"		
#define	TAB_X_LABEL_49			"X (49)"		
#define	TAB_X_LABEL_50			"X (50)"		
#define	TAB_X_LABEL_51			"X (51)"		
#define	TAB_X_LABEL_52			"X (52)"		
#define	TAB_X_LABEL_53			"X (53)"		
#define	TAB_X_LABEL_54			"X (54)"		
#define	TAB_X_LABEL_55			"X (55)"		
#define	TAB_X_LABEL_56			"X (56)"		
#define	TAB_X_LABEL_57			"X (57)"		
#define	TAB_X_LABEL_58			"X (58)"		
#define	TAB_X_LABEL_59			"X (59)"		
#define	TAB_X_LABEL_60			"X (60)"		
#define	TAB_X_LABEL_61			"X (61)"		
#define	TAB_X_LABEL_62			"X (62)"		
#define	TAB_X_LABEL_63			"X (63)"		
#define	TAB_X_LABEL_64			"X (64)"		
#define	TAB_X_LABEL_65			"X (65)"		
#define	TAB_X_LABEL_66			"X (66)"		
#define	TAB_X_LABEL_67			"X (67)"		
#define	TAB_X_LABEL_68			"X (68)"		
#define	TAB_X_LABEL_69			"X (69)"		
#define	TAB_X_LABEL_70			"X (70)"		
#define	TAB_X_LABEL_71			"X (71)"		
#define	TAB_X_LABEL_72			"X (72)"		
#define	TAB_X_LABEL_73			"X (73)"		
#define	TAB_X_LABEL_74			"X (74)"		
#define	TAB_X_LABEL_75			"X (75)"		
#define	TAB_X_LABEL_76			"X (76)"		
#define	TAB_X_LABEL_77			"X (77)"		
#define	TAB_X_LABEL_78			"X (78)"		
#define	TAB_X_LABEL_79			"X (79)"		
#define	TAB_X_LABEL_80			"X (80)"		
#define	TAB_X_LABEL_81			"X (81)"		
#define	TAB_X_LABEL_82			"X (82)"		
#define	TAB_X_LABEL_83			"X (83)"		
#define	TAB_X_LABEL_84			"X (84)"		
#define	TAB_X_LABEL_85			"X (85)"		
#define	TAB_X_LABEL_86			"X (86)"		
#define	TAB_X_LABEL_87			"X (87)"		
#define	TAB_X_LABEL_88			"X (88)"		
#define	TAB_X_LABEL_89			"X (89)"		
#define	TAB_X_LABEL_90			"X (90)"		
#define	TAB_X_LABEL_91			"X (91)"		
#define	TAB_X_LABEL_92			"X (92)"		
#define	TAB_X_LABEL_93			"X (93)"		
#define	TAB_X_LABEL_94			"X (94)"	
#define	TAB_X_LABEL_95			"X (95)"	
#define	TAB_X_LABEL_96			"X (96)"	
#define	TAB_X_LABEL_97			"X (97)"	
#define	TAB_X_LABEL_98			"X (98)"	
#define	TAB_X_LABEL_99			"X (99)"	
#define	TAB_X_LABEL_100			"X (100)"		
#define	TAB_X_LABEL_101			"X (101)"		
#define	TAB_X_LABEL_102			"X (102)"		
#define	TAB_X_LABEL_103			"X (103)"		
#define	TAB_X_LABEL_104			"X (104)"		
#define	TAB_X_LABEL_105			"X (105)"		
#define	TAB_X_LABEL_106			"X (106)"		
#define	TAB_X_LABEL_107			"X (107)"		
#define	TAB_X_LABEL_108			"X (108)"		
#define	TAB_X_LABEL_109			"X (109)"		
#define	TAB_X_LABEL_110			"X (110)"		
#define	TAB_X_LABEL_111			"X (111)"		
#define	TAB_X_LABEL_112			"X (112)"		
#define	TAB_X_LABEL_113			"X (113)"		
#define	TAB_X_LABEL_114			"X (114)"		
#define	TAB_X_LABEL_115			"X (115)"		
#define	TAB_X_LABEL_116			"X (116)"		
#define	TAB_X_LABEL_117			"X (117)"		
#define	TAB_X_LABEL_118			"X (118)"		
#define	TAB_X_LABEL_119			"X (119)"		
#define	TAB_X_LABEL_120			"X (120)"		
#define	TAB_X_LABEL_121			"X (121)"		
#define	TAB_X_LABEL_122			"X (122)"		
#define	TAB_X_LABEL_123			"X (123)"		
#define	TAB_X_LABEL_124			"X (124)"		
#define	TAB_X_LABEL_125			"X (125)"		
#define	TAB_X_LABEL_126			"X (126)"		
#define	TAB_X_LABEL_127			"X (127)"		
#define	TAB_X_LABEL_128			"X (128)"		



#define	TAB_Y_LABEL_0			"Y (0)"
#define	TAB_Y_LABEL_1			"Y (1)"
#define	TAB_Y_LABEL_2			"Y (2)"
#define	TAB_Y_LABEL_3			"Y (3)"
#define	TAB_Y_LABEL_4			"Y (4)"
#define	TAB_Y_LABEL_5			"Y (5)"
#define	TAB_Y_LABEL_6			"Y (6)"
#define	TAB_Y_LABEL_7			"Y (7)"
#define	TAB_Y_LABEL_8			"Y (8)"
#define	TAB_Y_LABEL_9			"Y (9)"
#define	TAB_Y_LABEL_10			"Y (10)"
#define	TAB_Y_LABEL_11			"Y (11)"
#define	TAB_Y_LABEL_12			"Y (12)"
#define	TAB_Y_LABEL_13			"Y (13)"
#define	TAB_Y_LABEL_14			"Y (14)"
#define	TAB_Y_LABEL_15			"Y (15)"
#define	TAB_Y_LABEL_16			"Y (16)"
#define	TAB_Y_LABEL_17			"Y (17)"
#define	TAB_Y_LABEL_18			"Y (18)"
#define	TAB_Y_LABEL_19			"Y (19)"
#define	TAB_Y_LABEL_20			"Y (20)"
#define	TAB_Y_LABEL_21			"Y (21)"
#define	TAB_Y_LABEL_22			"Y (22)"		
#define	TAB_Y_LABEL_23			"Y (23)"		
#define	TAB_Y_LABEL_24			"Y (24)"		
#define	TAB_Y_LABEL_25			"Y (25)"		
#define	TAB_Y_LABEL_26			"Y (26)"		
#define	TAB_Y_LABEL_27			"Y (27)"		
#define	TAB_Y_LABEL_28			"Y (28)"		
#define	TAB_Y_LABEL_29			"Y (29)"		
#define	TAB_Y_LABEL_30			"Y (30)"		
#define	TAB_Y_LABEL_31			"Y (31)"		
#define	TAB_Y_LABEL_32			"Y (32)"		
#define	TAB_Y_LABEL_33			"Y (33)"		
#define	TAB_Y_LABEL_34			"Y (34)"		
#define	TAB_Y_LABEL_35			"Y (35)"		
#define	TAB_Y_LABEL_36			"Y (36)"		
#define	TAB_Y_LABEL_37			"Y (37)"		
#define	TAB_Y_LABEL_38			"Y (38)"		
#define	TAB_Y_LABEL_39			"Y (39)"		
#define	TAB_Y_LABEL_40			"Y (40)"		
#define	TAB_Y_LABEL_41			"Y (41)"		
#define	TAB_Y_LABEL_42			"Y (42)"		
#define	TAB_Y_LABEL_43			"Y (43)"		
#define	TAB_Y_LABEL_44			"Y (44)"		
#define	TAB_Y_LABEL_45			"Y (45)"		
#define	TAB_Y_LABEL_46			"Y (46)"		
#define	TAB_Y_LABEL_47			"Y (47)"		
#define	TAB_Y_LABEL_48			"Y (48)"		
#define	TAB_Y_LABEL_49			"Y (49)"		
#define	TAB_Y_LABEL_50			"Y (50)"		
#define	TAB_Y_LABEL_51			"Y (51)"		
#define	TAB_Y_LABEL_52			"Y (52)"		
#define	TAB_Y_LABEL_53			"Y (53)"		
#define	TAB_Y_LABEL_54			"Y (54)"		
#define	TAB_Y_LABEL_55			"Y (55)"		
#define	TAB_Y_LABEL_56			"Y (56)"		
#define	TAB_Y_LABEL_57			"Y (57)"		
#define	TAB_Y_LABEL_58			"Y (58)"		
#define	TAB_Y_LABEL_59			"Y (59)"		
#define	TAB_Y_LABEL_60			"Y (60)"		
#define	TAB_Y_LABEL_61			"Y (61)"		
#define	TAB_Y_LABEL_62			"Y (62)"		
#define	TAB_Y_LABEL_63			"Y (63)"		
#define	TAB_Y_LABEL_64			"Y (64)"		
#define	TAB_Y_LABEL_65			"Y (65)"		
#define	TAB_Y_LABEL_66			"Y (66)"		
#define	TAB_Y_LABEL_67			"Y (67)"		
#define	TAB_Y_LABEL_68			"Y (68)"		
#define	TAB_Y_LABEL_69			"Y (69)"		
#define	TAB_Y_LABEL_70			"Y (70)"		
#define	TAB_Y_LABEL_71			"Y (71)"		
#define	TAB_Y_LABEL_72			"Y (72)"		
#define	TAB_Y_LABEL_73			"Y (73)"		
#define	TAB_Y_LABEL_74			"Y (74)"		
#define	TAB_Y_LABEL_75			"Y (75)"		
#define	TAB_Y_LABEL_76			"Y (76)"		
#define	TAB_Y_LABEL_77			"Y (77)"		
#define	TAB_Y_LABEL_78			"Y (78)"		
#define	TAB_Y_LABEL_79			"Y (79)"		
#define	TAB_Y_LABEL_80			"Y (80)"		
#define	TAB_Y_LABEL_81			"Y (81)"		
#define	TAB_Y_LABEL_82			"Y (82)"		
#define	TAB_Y_LABEL_83			"Y (83)"		
#define	TAB_Y_LABEL_84			"Y (84)"		
#define	TAB_Y_LABEL_85			"Y (85)"		
#define	TAB_Y_LABEL_86			"Y (86)"		
#define	TAB_Y_LABEL_87			"Y (87)"		
#define	TAB_Y_LABEL_88			"Y (88)"		
#define	TAB_Y_LABEL_89			"Y (89)"		
#define	TAB_Y_LABEL_90			"Y (90)"		
#define	TAB_Y_LABEL_91			"Y (91)"		
#define	TAB_Y_LABEL_92			"Y (92)"		
#define	TAB_Y_LABEL_93			"Y (93)"		
#define	TAB_Y_LABEL_94			"Y (94)"	
#define	TAB_Y_LABEL_95			"Y (95)"	
#define	TAB_Y_LABEL_96			"Y (96)"	
#define	TAB_Y_LABEL_97			"Y (97)"	
#define	TAB_Y_LABEL_98			"Y (98)"	
#define	TAB_Y_LABEL_99			"Y (99)"	
#define	TAB_Y_LABEL_100			"Y (100)"		
#define	TAB_Y_LABEL_101			"Y (101)"		
#define	TAB_Y_LABEL_102			"Y (102)"		
#define	TAB_Y_LABEL_103			"Y (103)"		
#define	TAB_Y_LABEL_104			"Y (104)"		
#define	TAB_Y_LABEL_105			"Y (105)"		
#define	TAB_Y_LABEL_106			"Y (106)"		
#define	TAB_Y_LABEL_107			"Y (107)"		
#define	TAB_Y_LABEL_108			"Y (108)"		
#define	TAB_Y_LABEL_109			"Y (109)"		
#define	TAB_Y_LABEL_110			"Y (110)"		
#define	TAB_Y_LABEL_111			"Y (111)"		
#define	TAB_Y_LABEL_112			"Y (112)"		
#define	TAB_Y_LABEL_113			"Y (113)"		
#define	TAB_Y_LABEL_114			"Y (114)"		
#define	TAB_Y_LABEL_115			"Y (115)"		
#define	TAB_Y_LABEL_116			"Y (116)"		
#define	TAB_Y_LABEL_117			"Y (117)"		
#define	TAB_Y_LABEL_118			"Y (118)"		
#define	TAB_Y_LABEL_119			"Y (119)"		
#define	TAB_Y_LABEL_120			"Y (120)"		
#define	TAB_Y_LABEL_121			"Y (121)"		
#define	TAB_Y_LABEL_122			"Y (122)"		
#define	TAB_Y_LABEL_123			"Y (123)"		
#define	TAB_Y_LABEL_124			"Y (124)"		
#define	TAB_Y_LABEL_125			"Y (125)"		
#define	TAB_Y_LABEL_126			"Y (126)"		
#define	TAB_Y_LABEL_127			"Y (127)"		
#define	TAB_Y_LABEL_128			"Y (128)"		
/*----------------------------------------------------------------------------*/

#define LIN_TABLE_USER			(trans1_lin_type == 1)

#define VALID_LIN_TABLE     \
IF (LIN_TABLE_USER)			\
{							\
	TRUE;					\
}							\
ELSE						\
{							\
	FALSE;					\
}


/*fbi #define VALID_LIN_TABLE_XY (index)   					\	*/

#define VALID_LIN_TABLE_XY(index)   					\
IF (  (LIN_TABLE_USER)  &&    (  tab_actual_number >= (index+1))   )		\
{													\
	TRUE;						  					\
}								 					\
ELSE							 					\
{								 					\
	FALSE;						 					\
}


/*--------------------------------------------------------------------------*/
// Validity for Parameter: trans1_input_range, 
#define VALID_LIN_TYPE						\
	IF (trans1_lin_type < 2)				\
	{										\
		TRUE;								\
	}										\
	ELSE									\
	{										\
		FALSE;								\
	}
/*--------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
#define VALID_NOT_LIN		\
	  IF( trans1_lin_type>1)\
		{					\
			TRUE;			\
		}					\
		ELSE				\
		{					\
			FALSE;			\
		}
			   						    


#define VALID_TC							\
	IF (trans1_lin_type >= 128)				\
	{										\
		IF (trans1_lin_type <= 138)			\
		{									\
			TRUE;							\
		}									\
		ELSE								\
		{									\
			FALSE;							\
		}									\
	}										\
	ELSE									\
	{										\
		FALSE;								\
	}
 


#define VALID_NOT_TC				  \
	IF( trans1_lin_type >= 128 )	  \
	{	/* TC */					  \
	   	IF( trans1_lin_type <= 138 )  \
		{	/* TC */				  \
			FALSE ;					  \
		}							  \
		ELSE						  \
		{							  \
									  \
		  TRUE ;					  \
		}							  \
	}								  \
	ELSE							  \
	{								  \
		TRUE ;						  \
	}

#define VALID_NOT_TC1				  \
	IF( trans1_lin_type >= 128 )	  \
	{	/* TC */					  \
	   	IF( trans1_lin_type <= 138 )  \
		{	/* TC */				  \
			FALSE ;					  \
		}							  \
		ELSE						  \
		{							  \
		       IF ( trans1_sensor_connection == 0 ) \
						{							\
							TRUE;					\
						}							\
						ELSE						\
						{							\
							FALSE;					\
						}							\
				}							  		\
	}								  				\
	ELSE									\
	{										\
       IF ( trans1_sensor_connection == 0 ) \
				{							\
					TRUE;					\
				}							\
				ELSE						\
				{							\
					FALSE;					\
				}							\
	}




#define VALID_RTD							\
	IF (trans1_lin_type >= 102)				\
	{										\
		IF (trans1_lin_type <= 126)			\
		{									\
			TRUE;							\
		}									\
		ELSE								\
		{									\
			IF (trans1_lin_type >= 240)		\
			{								\
				IF (trans1_lin_type <= 242)	\
				{							\
					TRUE;					\
				}							\
				ELSE						\
				{							\
					FALSE;					\
				}							\
			}								\
			ELSE							\
			{								\
				FALSE;						\
			}								\
		}									\
	}										\
	ELSE									\
	{										\
		FALSE;								\
	}



/*--------------------------------------------------------------------*/

/*Coding		Input type			LS Limit	LC Range	US Limit	UC Range
2			RTD 100(a=3850)			-240 C		-200C		 960C		 850C
3			RTD 200(a=3850)			-240 C		-200C		 960C		 850C
4			RTD 300(a=3850)			-240C		-200C		 960C		 850C
5			RTD 400(a=3850)			-240C		-200C		 960C		 850C
6			RTD 500(a=3850)			-240 C		-200C		 960C		 850C
7			RTD 1000(a=3850)		-240C		-200C		 960C		 850C
8			RTD 100(a=3902)			-150 C		-100C		 720 C		 650C
9			RTD 200(a=3902)			-150C		-100C		 720C		 650C
11			RTD 400(a=3902)			-150C		-100C		 720C		 650C
12			RTD 500(a=3902)			-150 C		-100C		 720C		 650C
13			RTD 1000(a=3902)		-150C		-100C		 720C		 650C
16			RTD 100(a=3916)			-240C		-200C		 580 C		 510C
22			RTD 120(a=0.672)		-100C		 -80C		 360C		 320C
23			RTD 100(a=0.427)		 -65 C		 -50C		 280C		 250C
40			Potentiometer 125 ohm	   0%		 100%		   0%		 100%
41			Potentiometer 250 ohm	   0%		 100%		   0%		 100%
42			Potentiometer 500 ohm	   0%		 100%		   0%		 100%
43			Potentiometer 1000 ohm	   0%		 100%		   0%		 100%
44			Potentiometer 2000 ohm	   0%		 100%		   0%		 100%
45			Potentiometer 4000 ohm	   0% 		 100%		   0% 		 100%
49			TC-J					-210C		-180C		 770C		 760C
50			TC-K					-270 C		-150C		1390C		1370C
51			TC-E					-270 C		-170C		1013C		1000C
52			TC-T					-270 C		-170C		 407C		 400C
53			TC-R					 -50C		   0C		1786 C		1760C
54			TC-S					 -50C		   0C		1786C		1760C
55			TC-B					 200 C		 400C	 	1836 C		1820C
56			TC-N					-270 C		-130C		1316 C		1300C
57			TC-C					   0 C		   0C		2338 C		2300C
85			mV						 -50mV		 -50mV		1000mV		1000mV
33			ohm						   0 ohm	   0 ohm	4095 ohm	4000 ohm
*/

/*------------------------------------------------------------------------------------*/


/*--------------------------------------------------------------------*/
#define	DEFAULT_UPPER_VAL_CON								  			    		  \
	DEFAULT_VALUE											  			    		  \
		SELECT (trans1_lin_type)					  			    				  \
		{												  			    			  \
			CASE  102    :	850	 ;				  \
			CASE  103    :	850	 ;	  			  \
			CASE  242    :	850	 ;	 			  \
			CASE  240    :	850	 ;	 			  \
			CASE  104    :	850	 ;	  			  \
			CASE  105    :	850	 ;	 			  \
			CASE  111    :	650	 ;	 			  \
			CASE  112    :	650	 ;	 			  \
			CASE  241    :	650	 ;	 			  \
			CASE  113    :	650	 ;	 			  \
			CASE  114    :	650	 ;	 			  \
			CASE  108    :	510	 ;	 			  \
			CASE  120    :	320	 ;	 			  \
			CASE  126    :	250	 ;	 			  \
			CASE  133	:	760  ;	 			  \
			CASE  134	:	1370 ;	 			  \
			CASE  131	:	1000 ;	 			  \
			CASE  138	:	400  ;	 			  \
			CASE  136	:	1760 ;	 			  \
			CASE  137	:	1760 ;	 			  \
			CASE  128	:	1820 ;	 			  \
			CASE  135	:	1300 ;	 			  \
			CASE  129	:	2300 ;	 			  \
			CASE 0:                     			   								  \
					SELECT (trans1_input_range) 	   								  \
					{								   								  \
						CASE  0	:	31.25 ;						  \
						CASE  1	:	62.5 ;						  \
						CASE  2	:	125 ;					  \
						CASE  3	:	250 ;					  \
						CASE  4	:	500 ;					  \
						CASE  5	:	1000 ;					  \
						CASE  128	:	125 ;		  \
						CASE  129	:	250 ;		  \
						CASE  130	:	500 ;		  \
						CASE  131	:	1000 ;		  \
						CASE  132	:	2000 ;		  \
						CASE  133	:	4000 ;		  \
						CASE  240	:	100	 ;	 \
						CASE  241	:	100	 ;	 \
						CASE  242	:	100	 ;	 \
						CASE  243 	:	100	 ;	 \
						CASE  244   :  	100	 ;	 \
						CASE  245   :	100	 ;	 \
					}								   								  \
			CASE 1:                     			   								  \
					SELECT (trans1_input_range) 	   								  \
					{								   								  \
						CASE  0	:	31.25 ;	 	  \
						CASE  1	:	62.5 ;	 	  \
						CASE  2	:	125 ;	   \
						CASE  3	:	250 ;	   \
						CASE  4	:	500 ;	   \
						CASE  5	:	1000 ;	   \
						CASE  128	:	125 ;	  \
						CASE  129	:	250 ;	  \
						CASE  130	:	500 ;	  \
						CASE  131	:	1000 ;	  \
						CASE  132	:	2000 ; 	  \
						CASE  133	:	4000 ;	  \
						CASE  245	:	100 ;	   \
						CASE  244	:	100 ;	   \
						CASE  243	:	100 ;	   \
						CASE  242 	:	100 ;	   \
						CASE  241   :	100 ;	   \
						CASE  240   :	100 ;	   \
					}						  \
		}

/*--------------------------------------------------------------------*/
#define	DEFAULT_LOWER_VAL_CON 								  			    			  \
	DEFAULT_VALUE											  			    			  \
		SELECT (trans1_lin_type)					  			    				  \
		{												  			    			  \
			CASE  102    :	-200	 ;	 		  \
			CASE  103    :	-200	 ;	 		  \
			CASE  242    :	-200	 ;	 		  \
			CASE  240    :	-200	 ;	 		  \
			CASE  104    :	-200	 ;	 		  \
			CASE  105    :	-200	 ;	 		  \
			CASE  111    :	-100	 ;	 		  \
			CASE  112    :	-100	 ;	 		  \
			CASE  241    :	-100	 ;	 		  \
			CASE  113    :	-100	 ;	 		  \
			CASE  114    :	-100	 ;	 		  \
			CASE  108    :	-200	 ;	 		  \
			CASE  120    :	-80 	 ;	 		  \
			CASE  126    :	-50    ;	 		  \
			CASE  133	 : 	-180	 ;		  \
			CASE  134	 :    -150	 ;		  \
			CASE  131	 :    -170	 ;		  \
			CASE  138    :    -170	 ;		  \
			CASE  136	 :    0	 ;	    \
			CASE  137	 :    0	 ;	    \
			CASE  128	 :    400 ;	 		  \
			CASE  135	 :    -130 ;	 		  \
			CASE  129	 :    0	 ;	    \
			CASE 0:                     			   								  \
					SELECT (trans1_input_range) 	   								  \
					{								   								  \
						CASE  0	:	-10  ;		  \
						CASE  1	:	-10  ;		  \
						CASE  2	:	-10  ;	  \
						CASE  3	:	-12.5 ;	  \
						CASE  4	:	-25  ;	  \
						CASE  5	:	-50  ;	  \
						CASE  128	:	0 ;  	  \
						CASE  129	:	0 ;  	  \
						CASE  130	:	0 ;  	  \
						CASE  131	:	0 ;  	  \
						CASE  132	:	0 ;  	  \
						CASE  133	:	0 ;  	  \
						CASE  240	:	0 ;    \
						CASE  241	:	0 ;    \
						CASE  242	:	0 ;    \
						CASE  243 	:	0 ;    \
						CASE  244   :   0 ;    \
						CASE  245   :	0 ;   \
					}								   								  \
			CASE 1:                     			   								  \
					SELECT (trans1_input_range) 	   								  \
					{								   								  \
						CASE  0	:	-10  ;		  \
						CASE  1	:	-10  ;		  \
						CASE  2	:	-10  ;	  \
						CASE  3	:	-12.5;	  \
						CASE  4	:	-25  ;	  \
						CASE  5	:	-50  ;	  \
						CASE  128	:	0 ;  	  \
						CASE  129	:	0 ;  	  \
						CASE  130	:	0 ;  	  \
						CASE  131	:	0 ;  	  \
						CASE  132	:	0 ;  	  \
						CASE  133	:	0 ;  	  \
						CASE  240	:	0 ;    \
						CASE  241	:	0 ;    \
						CASE  242	:	0 ;    \
						CASE  243 	:	0 ;    \
						CASE  244   :   0 ;    \
						CASE  245   :	0 ;    \
					}						  \
		}
/*--------------------------------------------------------------------*/




#define	DEFAULT_UPPER_VAL							  \
	DEFAULT_VALUE								  \
		SELECT (trans1_lin_type)					  \
		{								  \
			CASE  102    :	960	 ;	 			  \
			CASE  103    :	960	 ;	 			  \
			CASE  242    :	960	 ;	 			  \
			CASE  240    :	960	 ;	 			  \
			CASE  104    :	960	 ;	 			  \
			CASE  105    :	960	 ;	 			  \
			CASE  111    :	720	 ;	 			  \
			CASE  112    :	720	 ;	 			  \
			CASE  241    :	720	 ;	 			  \
			CASE  113    :	720	 ;	 			  \
			CASE  114    :	720	 ;	 			  \
			CASE  108    :	580	 ;	 			  \
			CASE  120    :	360	 ;	 			  \
			CASE  126    :	280	 ;	 			  \
			CASE  133	:	770	 ;	 		  \
			CASE  134	:	1390 ;	 			  \
			CASE  131	:	1013 ;	 			  \
			CASE  138	:	407	 ;	 		  \
			CASE  136	:	1786 ;	 			  \
			CASE  137	:	1786 ;	 			  \
			CASE  128	:	1836 ;	 			  \
			CASE  135	:	1316 ;	 			  \
			CASE  129	:	2338 ;	 			  \
			CASE 0:                    				  \
					SELECT (trans1_input_range) 	   	  \
					{					  \
						CASE  0	:	31.25 ;	 	  \
						CASE  1	:	62.5 ;	 	  \
						CASE  2	:	1250 ;	  \
						CASE  3	:	250 ;	  \
						CASE  4	:	500 ;	  \
						CASE  5	:	1000 ;	  \
						CASE  128	:	125 ;	  \
						CASE  129	:	250 ;	  \
						CASE  130	:	500 ;	  \
						CASE  131	:	1000 ;	  \
						CASE  132	:	2000 ;	  \
						CASE  133	:	4000 ;	  \
						CASE  240	:	100 ;	\
						CASE  241	:	100  ; \
						CASE  242	:	100  ; \
						CASE  243 	:	100 ;  \
						CASE  244   :	100 ;  \
						CASE  245   :	100  ; \
					}				  \
			CASE 1:                     			  \
					SELECT (trans1_input_range) 	  \
					{				  \
						CASE  0	:	31.25 ;	 	  \
						CASE  1	:	62.5 ;	 	  \
						CASE  2	:	1250 ;	   \
						CASE  3	:	250 ;	   \
						CASE  4	:	500 ;	   \
						CASE  5	:	1000 ;	   \
						CASE  128	:	125 ;	  \
						CASE  129	:	250 ;	  \
						CASE  130	:	500 ;	  \
						CASE  131	:	1000 ; 	  \
						CASE  132	:	2000 ;	  \
						CASE  133	:	4000 ;	  \
						CASE  240	:  	100 ; \
						CASE  241	:  	100 ;   \
						CASE  242	:  	100 ;   \
						CASE  243 	:	100 ;   \
						CASE  244   : 	100 ;   \
						CASE  245   :	100 ;   \
								\
					}   \
		}

/*--------------------------------------------------------------------*/

#define	DEFAULT_LOWER_VAL									  			    			  \
	DEFAULT_VALUE											  			    			  \
		SELECT (trans1_lin_type)					  			    				  \
		{												  			    			  \
			CASE  102    :	-240	 ;			  \
			CASE  103    :	-240	 ;			  \
			CASE  242    :	-240	 ;			  \
			CASE  240    :	-240	 ;			  \
			CASE  104    :	-240	 ;			  \
			CASE  105    :	-240	 ;			  \
			CASE  111    :	-150	 ;			  \
			CASE  112    :	-150	 ;			  \
			CASE  241    :	-150	 ;			  \
			CASE  113    :	-150	 ;			  \
			CASE  114    :	-150	 ;			  \
			CASE  108    :	-240	 ;			  \
			CASE  120    :	-100	 ;			  \
			CASE  126    :	-65    ;			  \
			CASE  133	:	-210	 ;			  \
			CASE  134	:	-270	 ;			  \
			CASE  131	:	-270	 ;			  \
			CASE  138	:	-270	 ;			  \
			CASE  136	:	-50	 ;	 	  \
			CASE  137	:	-50	 ;	 	  \
			CASE  128	:	200	 ;	 	  \
			CASE  135	:	-270	 ;		  \
			CASE  129	:	0  	 ;	 	  \
			CASE 0:      					  \
					SELECT (trans1_input_range) 	  \
					{				  \
						CASE  0	:	-10  ;		  \
						CASE  1	:	-10  ;		  \
						CASE  2	:	-10  ;	  \
						CASE  3	:	-12.5;	  \
						CASE  4	:	-25  ;	  \
						CASE  5	:	-50  ;	  \
						CASE  128	:	0 ;   	  \
						CASE  129	:	0 ;  	  \
						CASE  130	:	0 ;  	  \
						CASE  131	:	0 ;  	  \
						CASE  132	:	0 ;  	  \
						CASE  133	:	0 ;  	  \
						CASE  240	:	0 ;	  \
						CASE  241	:	0 ;	  \
						CASE  242	:	0 ;	  \
						CASE  243 	:	0 ;	  \
						CASE  244   :   0 ;	  \
						CASE  245   :	0 ;	  \
					}								   								  \
			CASE 1:                     			   								  \
					SELECT (trans1_input_range) 	   								  \
					{								   								  \
						CASE  0	:	-10  ;						  \
						CASE  1	:	-10  ;						  \
						CASE  2	:	-10  ;					  \
						CASE  3	:	-12.5;					  \
						CASE  4	:	-25  ;					  \
						CASE  5	:	-50  ;					  \
						CASE  128	:	0  ;  					  \
						CASE  129	:	0  ; 					  \
						CASE  130	:	0   ;						\
						CASE  131	:	0   ;					  \
						CASE  132	:	0    ;					  \
						CASE  133	:	0    ;					  \
						CASE  240   :	0 	 ;	  \
						CASE  241   :   0	 ;	  \
						CASE  242 	:	0	 ;	  \
						CASE  243	:	0	 ;	  \
						CASE  244	:	0	 ;	  \
						CASE  245	:	0	 ;	  \
					}							  \
		}


/*--------------------------------------------------------------------*/

#define STATUS_INPUT_LIMIT(quality)					\
	IF ((quality) == 0x20)								\
	{													\
		{ 0x00,	"Ok"		},		\
		{ 0x03,	"Constant"	}		\
	}													\
	ELSE {												\
		IF ((quality) == 0x30)							\
		{												\
			{ 0x00,	"Ok"		},	\
			{ 0x03,	"Constant"	}	\
		}												\
		 ELSE {											\
			{ 0x00,	"Ok"				},	\
			{ 0x01,	"Low Limited"		},	\
			{ 0x02,	"High Limited"			},	\
			{ 0x03,	"Constant"		}	\
		}												\
	}

#define STATUS_OUTPUT_LIMIT							\
		{ 0x00,	"Ok"				},	\
		{ 0x01,	"Low Limited"		},	\
		{ 0x02,	"High Limited"			},	\
		{ 0x03,	"Constant"		}	


#define STATUS_INPUT_NO_RCAS				\
		{ 0x20,	"Good(NC): Ok"					},	\
		{ 0x29,	"Good(NC): Maintenance Required"		},	\
		{ 0x21,	"Good(NC): Update Event"			},	\
		{ 0x22,	"Good(NC): Active Advisory Alarm"		},	\
		{ 0x23,	"Good(NC): Active Critical Alarm"		},	\
		{ 0x24,	"Good(NC): Unacknowledged Update Event"	},	\
		{ 0x25,	"Good(NC): Unacknowledged Advisory Alarm"	},	\
		{ 0x26,	"Good(NC): Unacknowledged Critical Alarm"	},	\
		{ 0x28,	"Good(NC): Initial Fail Safe"			},	\
		{ 0x10,	"Uncertain: Non Specific"			},	\
		{ 0x11,	"Uncertain: Last Usable Value (LUV)"	},	\
		{ 0x12,	"Uncertain: Substitute Value"			},	\
		{ 0x13,	"Uncertain: Initial Value"			},	\
		{ 0x14,	"Uncertain: Sensor Conversion Not Accurate"},	\
		{ 0x15,	"Uncertain: Engineering Unit Violation"	},	\
		{ 0x16,	"Uncertain: Sub Normal"				},	\
		{ 0x17,	"Uncertain: Configuration Error"		},	\
		{ 0x19,	"Uncertain: Sensor Calibration"		},	\
		{ 0x18,	"Uncertain: Simulated Value"			},	\
		{ 0x30,	"Good(C): Ok"					},	\
		{ 0x31,	"Good(C): Initialization Acknowledged"	},	\
		{ 0x32,	"Good(C): Initialization Request"		},	\
		{ 0x33,	"Good(C): Not Invited"				},	\
		{ 0x35,	"Good(C): Do Not Select"			},	\
		{ 0x36,	"Good(C): Local Override"			},	\
		{ 0x38,	"Good(C): Initial Fail Safe"			},	\
		{ 0x00,	"Bad: Non Specific"				},	\
		{ 0x01,	"Bad: Configuration Error"			},	\
		{ 0x02,	"Bad: Not Connected"				},	\
		{ 0x04,	"Bad: Sensor Failure"				},	\
		{ 0x03,	"Bad: Device Failure"				},	\
		{ 0x05,	"Bad: No Communication (Last Usable Value)"},	\
		{ 0x06,	"Bad: No Communication (No Usable Value)"	},	\
		{ 0x07,	"Bad: Out Of Service"				}

#define STATUS_OUTPUT_NO_RCAS				\
		{ 0x20,	"Good(NC): Ok"					},	\
		{ 0x29,	"Good(NC): Maintenance Required"		},	\
		{ 0x21,	"Good(NC): Update Event"			},	\
		{ 0x22,	"Good(NC): Active Advisory Alarm"		},	\
		{ 0x23,	"Good(NC): Active Critical Alarm"		},	\
		{ 0x24,	"Good(NC): Unacknowledged Update Event"	},	\
		{ 0x25,	"Good(NC): Unacknowledged Advisory Alarm"	},	\
		{ 0x26,	"Good(NC): Unacknowledged Critical Alarm"	},	\
		{ 0x28,	"Good(NC): Initial Fail Safe"			},	\
		{ 0x10,	"Uncertain: Non Specific"			},	\
		{ 0x11,	"Uncertain: Last Usable Value (LUV)"	},	\
		{ 0x12,	"Uncertain: Substitute Value"			},	\
		{ 0x13,	"Uncertain: Initial Value"			},	\
		{ 0x14,	"Uncertain: Sensor Conversion Not Accurate"},	\
		{ 0x15,	"Uncertain: Engineering Unit Violation"	},	\
		{ 0x16,	"Uncertain: Sub Normal"				},	\
		{ 0x17,	"Uncertain: Configuration Error"		},	\
		{ 0x19,	"Uncertain: Sensor Calibration"		},	\
		{ 0x18,	"Uncertain: Simulated Value"			},	\
		{ 0x30,	"Good(C): Ok"					},	\
		{ 0x31,	"Good(C): Initialization Acknowledged"	},	\
		{ 0x32,	"Good(C): Initialization Request"		},	\
		{ 0x33,	"Good(C): Not Invited"				},	\
		{ 0x35,	"Good(C): Do Not Select"			},	\
		{ 0x36,	"Good(C): Local Override"			},	\
		{ 0x38,	"Good(C): Initial Fail Safe"			},	\
		{ 0x00,	"Bad: Non Specific"				},	\
		{ 0x01,	"Bad: Configuration Error"			},	\
		{ 0x02,	"Bad: Not Connected"				},	\
		{ 0x04,	"Bad: Sensor Failure"				},	\
		{ 0x03,	"Bad: Device Failure"				},	\
		{ 0x05,	"Bad: No Communication (Last Usable Value)"},	\
		{ 0x06,	"Bad: No Communication (No Usable Value)"	},	\
		{ 0x07,	"Bad: Out Of Service"				}


/***********************************************************************/
/*    RENAME Variables												   */
/***********************************************************************/

COLLECTION OF VARIABLE rename_value
{
    MEMBERS
    {
		PHYS_ST_REV,			phys_st_rev,					[blk_block_object_PHYSICAL];
		TRANS_ST_REV,			trans1_st_rev,					[blk_block_object_TRANSDUCER];
		FUNC_ST_REV,			func1_AI_st_rev,			   	[blk_block_object_FUNCTION];
	}
}

/***********************************************************************/
/*    Physical Block												   */
/***********************************************************************/

BLOCK physical_block
{
	TYPE	PHYSICAL;
	NUMBER	1;
}

VARIABLE phys_blk_reserve	 // SLOT 1  Index 0
{
	LABEL		[blk_reserved];
	HELP		[blk_reserved_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		DEFAULT_VALUE	250;
		{	250,	[not_used]		}
	}
	HANDLING	READ;
}

VARIABLE phys_blk_object
{
	LABEL		[blk_block_object];
	HELP		[blk_block_object_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		{	1,	[blk_block_object_PHYSICAL]	}
	}
	HANDLING	READ;
}

VARIABLE phys_blk_parent_class
{
	LABEL		[blk_parent_class];
	HELP		[phys_blk_parent_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	1,	[phys_blk_parent_class_TRANSMITTER]	}
	}
	HANDLING	READ;
}

VARIABLE phys_blk_class
{
	LABEL		[blk_class];
	HELP		[phys_blk_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		DEFAULT_VALUE	250;
		{	250,	[not_used]		}
	}
	HANDLING	READ;
}

VARIABLE phys_blk_dd_reference
{
	LABEL		[blk_dd_reference];
	HELP		[blk_dd_reference_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (4);
	HANDLING	READ;
}

VARIABLE phys_blk_dd_rev
{
	LABEL		[blk_dd_rev];
	HELP		[blk_dd_rev_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER(2);
	HANDLING	READ;
}

VARIABLE phys_blk_profile
{
	LABEL		[blk_profile];
	HELP		[blk_profile_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		{ 0x4001,	[blk_profile_PA_COMPACT_A]	},
		{ 0x4002,	[blk_profile_PA_COMPACT_B]	},
		{ 0x4081,	[blk_profile_PA_SIMPLE_A]	},
		{ 0x4082,	[blk_profile_PA_SIMPLE_B]	}
	}
	HANDLING	READ;
}

VARIABLE phys_blk_profile_rev
{
	LABEL		[blk_profile_rev];
	HELP		[blk_profile_rev_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		DEFAULT_VALUE	0x0300;
		{	0x0300,	"3.0"	}
	}
	HANDLING	READ;
}

VARIABLE phys_blk_execution_time
{
	LABEL		[blk_execution_time];
	HELP		[blk_execution_time_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER(1);
	HANDLING	READ;
}

VARIABLE phys_blk_num_parameters
{
	LABEL		[blk_num_parameters];
	HELP		[blk_num_parameters_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	DEFAULT_VALUE	57;

	HANDLING	READ;
}

VARIABLE phys_blk_index_view_1
{
	LABEL		[blk_index_view_1];
	HELP		[blk_index_view_1_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	DEFAULT_VALUE 0x019d;
	HANDLING	READ;
}

VARIABLE phys_blk_num_view_lists
{
	LABEL		[blk_num_view_lists];
	HELP		[blk_num_view_lists_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	DEFAULT_VALUE	1;

	HANDLING	READ;
}

VARIABLE phys_st_rev  /* index 1 */
{
	LABEL		[st_rev];
	HELP		[st_rev_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ;
}

VARIABLE phys_tag_desc	/* index 2 */
{
	/* ST_REV */
	LABEL		[tag_desc];		
	HELP		[tag_desc_help];
	CLASS		CONTAINED;
	TYPE		ASCII (32);
	DEFAULT_VALUE "                                ";


	HANDLING	READ & WRITE;
}

VARIABLE phys_strategy /* index 3 */
{
	/* ST_REV */
	LABEL		[strategy];		
	HELP		[strategy_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0; 
	}
	HANDLING	READ & WRITE;
}

VARIABLE phys_alert_key	/* index 4 */
{
	/* ST_REV */
	LABEL		[alert_key];		
	HELP		[alert_key_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1)
	{
		DEFAULT_VALUE	0; 
	}
	HANDLING	READ & WRITE;
}

VARIABLE phys_target_mode /* index 5 */
{
	/* ST_REV */
	LABEL		[target_mode];		
	HELP		[target_mode_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		{	0x08,	[mode_AUTO]				}
	}
	HANDLING	READ & WRITE;
}

VARIABLE phys_actual_mode /* index 6 */
{
	LABEL		[actual_mode];		
	HELP		[actual_mode_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
	DEFAULT_VALUE	0x08;

		{	0x08,	[mode_AUTO]				},
		{	0x02,	[mode_RCAS]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ;
}

VARIABLE phys_permitted_mode /* index 6 */
{
	LABEL		[permitted_mode];		
	HELP		[permitted_mode_help];
	CLASS		CONTAINED;
	TYPE		BIT_ENUMERATED (1)
	{
	DEFAULT_VALUE	0x08;

		{	0x08,	[mode_AUTO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ;
}

VARIABLE phys_normal_mode /* index 6 */
{
	LABEL		[normal_mode];		
	HELP		[normal_mode_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
	DEFAULT_VALUE	0x08;

		{	0x08,	[mode_AUTO]				}
	}
	HANDLING	READ;
}

VARIABLE phys_current_state_alarm_sum  /* index 7 */
{
	LABEL		[current_state_alarm_sum];		
	HELP		[current_state_alarm_sum_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		DEFAULT_VALUE	0x0000; 
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
}

VARIABLE phys_unacknowledged_state_alarm_sum  /* index 7 */
{
	LABEL		[unacknowledged_state_alarm_sum];		
	HELP		[unacknowledged_state_alarm_sum_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		DEFAULT_VALUE	0x0000; 
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
}

VARIABLE phys_unreported_state_alarm_sum  /* index 7 */
{
	LABEL		[unreported_state_alarm_sum];		
	HELP		[unreported_state_alarm_sum_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		DEFAULT_VALUE	0x0000; 
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
}

VARIABLE phys_disabled_state_alarm_sum	  /* index 7 */
{
	LABEL		[disabled_state_alarm_sum];		
	HELP		[disabled_state_alarm_sum_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		DEFAULT_VALUE	0x0000; 
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
}

VARIABLE phys_software_rev	 /* index 8 */
{
	LABEL		[phys_software_revision];
	HELP		[phys_software_revision_help];
	CLASS		CONTAINED;
	TYPE		ASCII (16);
	DEFAULT_VALUE "                ";

   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }


}

VARIABLE phys_hardware_rev	 /* index 9 */
{
	LABEL		[phys_hardware_revision];
	HELP		[phys_hardware_revision_help];
	CLASS		CONTAINED;
	TYPE		ASCII (16);
	DEFAULT_VALUE "                ";

   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }

}

VARIABLE phys_device_man_id	  // index 10 
{
	LABEL		[phys_device_man_id];
	HELP		[phys_device_man_id_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		DEFAULT_VALUE	DEFAULT_MANUFACTURER_ID;
      { 0x0020,  [Moore_Industries]				},
      { 0x00FA, [not_used]						},
      { 0x00FB, [none]							},
      { 0x00FC, [unknown]						},
      { 0x00FD, [special]						}
	}
 	HANDLING	READ;
}

VARIABLE phys_device_id	    /* index 11 */
{
	LABEL		[phys_device_type];
	HELP		[phys_device_type_help];
	CLASS		CONTAINED;
	TYPE		ASCII (16);
	DEFAULT_VALUE "                ";

   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }

}

VARIABLE phys_device_ser_num    /* index 12 */
{
	LABEL		[phys_serial_num];
	HELP		[phys_device_ser_num_help];
	CLASS		CONTAINED;
	TYPE		ASCII (16);
	DEFAULT_VALUE "";


   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }

}

#define DIA_HW_ELECTR			0x01000000		/* 0x00000001 */
#define DIA_HW_MECH			0x02000000		/* 0x00000002 */
#define DIA_TEMP_MOTOR			0x04000000		/* 0x00000004 */
#define DIA_TEMP_ELECTR			0x08000000		/* 0x00000008 */
#define DIA_MEM_CHKSUM			0x10000000		/* 0x00000010 */
#define DIA_MEASUREMENT			0x20000000		/* 0x00000020 */
#define DIA_NOT_INIT			0x40000000		/* 0x00000040 */
#define DIA_INIT_ERR			0x80000000		/* 0x00000080 */
#define DIA_ZERO_ERR			0x00010000		/* 0x00000100 */
#define DIA_SUPPLY			0x00020000		/* 0x00000200 */
#define DIA_CONF_INVAL			0x00040000		/* 0x00000400 */
#define DIA_WARMSTART			0x00080000		/* 0x00000800 */
#define DIA_COLDSTART			0x00100000		/* 0x00001000 */
#define DIA_MAINTENANCE			0x00200000		/* 0x00002000 */
#define DIA_CHARACT			0x00400000		/* 0x00004000 */
#define DIA_IDENT_VIOL   		0x00800000  		/* 0x00008000 */	//fbi
#define EXTENSION_AVAILABLE		0x00000080		/* 0x80000000 */

VARIABLE phys_diagnosis					    /* index 13 */
{
	LABEL		[phys_diagnosis];
	HELP		[phys_diagnosis_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (4)
	{
		{	0,				[dia_OK],				[dia_OK_help]					},
		{	DIA_HW_ELECTR,			[dia_HW_ELECTR],			[dia_HW_ELECTR_help]			},
		{	DIA_HW_MECH,			[dia_HW_MECH],				[dia_HW_MECH_help]				},
		{	DIA_TEMP_MOTOR,			[dia_TEMP_MOTOR],			[dia_TEMP_MOTOR_help]			},
		{	DIA_TEMP_ELECTR,		[dia_TEMP_ELECTR],			[dia_TEMP_ELECTR_help]			},
		{	DIA_MEM_CHKSUM,			[dia_MEM_CHKSUM],			[dia_MEM_CHKSUM_help]			},
		{	DIA_MEASUREMENT,		[dia_MEASUREMENT],			[dia_MEASUREMENT_help]			},
		{	DIA_NOT_INIT,			[dia_NOT_INIT],				[dia_NOT_INIT_help]				},
		{	DIA_INIT_ERR,			[dia_INIT_ERR],				[dia_INIT_ERR_help]				},
		{	DIA_ZERO_ERR,			[dia_ZERO_ERR],				[dia_ZERO_ERR_help]				},
		{	DIA_SUPPLY,				[dia_SUPPLY],				[dia_SUPPLY_help]				},
		{	DIA_CONF_INVAL,			[dia_CONF_INVAL],			[dia_CONF_INVAL_help]			},
		{	DIA_WARMSTART,			[dia_WARMSTART],			[dia_WARMSTART_help]			},
		{	DIA_COLDSTART,			[dia_COLDSTART],			[dia_COLDSTART_help]			},
		{	DIA_MAINTENANCE,		[dia_MAINTENANCE],			[dia_MAINTENANCE_help]			},
		{	DIA_CHARACT,			[dia_CHARACT],				[dia_CHARACT_help]				},
		{ 	DIA_IDENT_VIOL,  		[dia_IDENT_VIOL],   			[dia_IDENT_VIOL_help]   },		//fbi
		{	EXTENSION_AVAILABLE,		[dia_EXTENSION_AVAILABLE],		[dia_EXTENSION_AVAILABLE_help]	}
	}
	HANDLING	READ;
}

VARIABLE phys_diagnosis_mask						    /* index 14 */
{
	LABEL		[phys_diagnosis_mask];
	HELP		[phys_diagnosis_mask_help];
	CLASS		CONTAINED;
	TYPE		BIT_ENUMERATED (4)
	{
		{	DIA_HW_ELECTR,			[dia_HW_ELECTR],			[dia_HW_ELECTR_help]			},
		{	DIA_HW_MECH,			[dia_HW_MECH],				[dia_HW_MECH_help]				},
		{	DIA_TEMP_MOTOR,			[dia_TEMP_MOTOR],			[dia_TEMP_MOTOR_help]			},
		{	DIA_TEMP_ELECTR,		[dia_TEMP_ELECTR],			[dia_TEMP_ELECTR_help]			},
		{	DIA_MEM_CHKSUM,			[dia_MEM_CHKSUM],			[dia_MEM_CHKSUM_help]			},
		{	DIA_MEASUREMENT,		[dia_MEASUREMENT],			[dia_MEASUREMENT_help]			},
		{	DIA_NOT_INIT,			[dia_NOT_INIT],				[dia_NOT_INIT_help]				},
		{	DIA_INIT_ERR,			[dia_INIT_ERR],				[dia_INIT_ERR_help]				},
		{	DIA_ZERO_ERR,			[dia_ZERO_ERR],				[dia_ZERO_ERR_help]				},
		{	DIA_SUPPLY,				[dia_SUPPLY],				[dia_SUPPLY_help]				},
		{	DIA_CONF_INVAL,			[dia_CONF_INVAL],			[dia_CONF_INVAL_help]			},
		{	DIA_WARMSTART,			[dia_WARMSTART],			[dia_WARMSTART_help]			},
		{	DIA_COLDSTART,			[dia_COLDSTART],			[dia_COLDSTART_help]			},
		{	DIA_MAINTENANCE,		[dia_MAINTENANCE],			[dia_MAINTENANCE_help]			},
		{	DIA_CHARACT,			[dia_CHARACT],				[dia_CHARACT_help]				},
		{ 	DIA_IDENT_VIOL,  		[dia_IDENT_VIOL],   			[dia_IDENT_VIOL_help]   },	//fbi
		{	EXTENSION_AVAILABLE,		[dia_EXTENSION_AVAILABLE],		[dia_EXTENSION_AVAILABLE_help]	}
	}
	HANDLING	READ;
}

/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */
/* Die Parameter phys_diagnosis_extension und phys_diagnosis_extension_mask
   koennnen keine 6 Byte als BIT_ENUMERATED (6) - Typen einlesen, daher werden
   diese beiden Parameter in 2 Teile aufgesplittet zu 4 Byte und 2 Byte.      */


VARIABLE phys_diagnosis_extension			
{
	LABEL		[phys_diagnosis_extension];
	HELP		[phys_diagnosis_extension_help];
	CLASS		CONTAINED;
	TYPE		ASCII (6);
	HANDLING	READ;
}


VARIABLE phys_diagnosis_extension_mask		
{
	LABEL		[phys_diagnosis_extension_mask];
	HELP		[phys_diagnosis_extension_mask_help];
	CLASS		CONTAINED;
	TYPE		ASCII (6);
	HANDLING	READ;
}



VARIABLE phys_device_certification		     /* index 17 */
{
	LABEL		[phys_device_certification];
	HELP		[phys_device_certification_help];
	CLASS		CONTAINED;
	TYPE		ASCII (32);

   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }

}

VARIABLE phys_write_locking			     /* index 18 */
{
	LABEL		[phys_write_locking];
	HELP		[phys_write_locking_help];
	CLASS		CONTAINED;
	TYPE	  	ENUMERATED(2)
	{
		DEFAULT_VALUE	2457;
		{ 2457,		[off]	},
		{ 0,		[on]	},
		{ 37865,	[moore_service_code]}

	}
	HANDLING	READ & WRITE;

	POST_WRITE_ACTIONS
	{
	  meth_changed
	}
}

METHOD meth_changed
{
  	DEFINITION
	{
		long phys_write_locking_service;
		phys_write_locking_service=0; 

		phys_write_locking_service=lvar_value(phys_write_locking);
		
 		 if(phys_write_locking_service==37865)
		 {
			PUT_MESSAGE([Successful]);
		 }
		 else
		 {	
			PUT_MESSAGE([refresh_download]);
		 }
	}
}

METHOD send_phys_write_locking_on 
{
	LABEL		[on];
	DEFINITION
	{

		iassign(phys_write_locking,	0);
   	    WriteCommand( write_phys_write_locking);
  	    ReadCommand( read_phys_write_locking);

	}
}
METHOD send_phys_write_locking_off 
{
	LABEL		[off];
	DEFINITION
	{

		iassign(phys_write_locking,	2457);
   	    WriteCommand( write_phys_write_locking);
  	    ReadCommand( read_phys_write_locking);

	}
}

METHOD send_service_code
{
	LABEL		[moore_service_code];
	DEFINITION
	{
		long phys_write_locking_service;
		phys_write_locking_service=0;

		phys_write_locking_service=lvar_value(phys_write_locking);
		GET_LOCAL_VAR_VALUE( [enter_service_code] , phys_write_locking_service);

 		if(phys_write_locking_service==37865)
		{

		   phys_write_locking = phys_write_locking_service;
 	  	   WriteCommand( write_phys_write_locking); 

		}
		else
		{
			PUT_MESSAGE([not_Successful]);
		}

		ReadCommand( read_phys_write_locking);

	}


}


VARIABLE phys_factory_reset	 /* index 19 */					/* optional */
{
	/* ST_REV */
	LABEL		[phys_factory_reset];
	HELP		[phys_factory_reset_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		DEFAULT_VALUE	1;
	 	{ 1,	  [factory_reset_PARAMS]	},
		{ 2506, [phys_device_reset_cmd]	},
		{ 2712, [factory_reset_ADDRESS]	}
	}
	HANDLING	 WRITE;
	POST_WRITE_ACTIONS
	{
		method_delay_writing_3s
	}

}




VARIABLE phys_descriptor	/* index 20 */						/* optional */
{
	/* ST_REV */
	LABEL		[phys_descriptor];
	HELP		[phys_descriptor_help];
	CLASS		CONTAINED;
	TYPE		ASCII (32)
	{
		DEFAULT_VALUE "";
	}
	HANDLING	READ & WRITE;
}

VARIABLE phys_message		 /* index 21 */					/* optional */
{
	/* ST_REV */
	LABEL		[phys_message];
	HELP		[phys_message_help];
	CLASS		CONTAINED;
	TYPE		ASCII (32)
	{
		DEFAULT_VALUE "";
	}
	HANDLING	READ & WRITE;
}

VARIABLE phys_install_date	 /* index 22 */					/* optional */
{
	/* ST_REV */
	LABEL		[phys_install_date];
	HELP		[phys_install_date_help];
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
		DEFAULT_VALUE "02.10.2002";
	}
	HANDLING	READ & WRITE;
}

VARIABLE phys_local_operation_enable	   /* index 23 */
{
	LABEL		[trans_act_local_operation];
	HELP		[trans_act_local_operation_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[disabled]	},
		{	1,	[enabled]	}
	}
	HANDLING	READ & WRITE;
}

VARIABLE phys_ident_number	/* index 24 */
{
	/* ST_REV */
	LABEL		[phys_ident_number];
	HELP		[phys_ident_number_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[phys_ident_number_PROFILE]		},
		{	1,	[phys_ident_number_MANUFACURER]	}
//		{	3,	[phys_ident_number_MULTIVARIABLE]},
	}
	HANDLING	READ & WRITE;
}

VARIABLE phys_hw_write_protection  /* index 25 */
{
	LABEL		[phys_hw_write_protection];
	HELP		[phys_hw_write_protection_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[on]	},
		{	1,	[off]	}
	}
	HANDLING	READ;
}
/***********************************************************************/
/*    Physical Block- Manufacturer Specicif Parameters				   */
/***********************************************************************/
VARIABLE phys_TOT_HRS_USED
{
  LABEL [phys_TOT_HRS_USED_LABEL];
  HELP  [phys_TOT_HRS_USED_HELP];
  CLASS CONTAINED & DYNAMIC;
  TYPE UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "h";
  HANDLING READ;
}


COMMAND read_phys_TOT_HRS_USED
{
     BLOCK physical_block;
     INDEX 60;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_TOT_HRS_USED
          }


     }
}
VARIABLE phys_TOT_HRS_CALIB
{
  LABEL [phys_TOT_HRS_CALIB_LABEL];
  HELP  [phys_TOT_HRS_CALIB_HELP];
  CLASS CONTAINED;
  TYPE UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "h";
  HANDLING READ;
}


COMMAND read_phys_TOT_HRS_CALIB
{
     BLOCK physical_block;
     INDEX 61;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_TOT_HRS_CALIB
          }


     }
}
VARIABLE phys_LCD_SELECTOR
{
  LABEL [phys_LCD_SELECTOR_LABEL];
  HELP  [phys_LCD_SELECTOR_HELP];
  CLASS CONTAINED;
  TYPE ENUMERATED (1)
  {
      DEFAULT_VALUE 1;

       {0,	[phys_LCD_SELECTOR_1]	},
	   {1,	[phys_LCD_SELECTOR_2]	},
	   {2,	[phys_LCD_SELECTOR_3]	},
	   {3,	[phys_LCD_SELECTOR_4]	}
  }
  HANDLING READ & WRITE;
}





COMMAND read_phys_LCD_SELECTOR
{
     BLOCK physical_block;
     INDEX 62;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_LCD_SELECTOR
          }


     }
}
COMMAND write_phys_LCD_SELECTOR
{
     BLOCK physical_block;
     INDEX 62;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             phys_LCD_SELECTOR
          }
          REPLY
          {
          }


     }
}
VARIABLE phys_LCD_STRING
{
  LABEL [phys_LCD_STRING_LABEL];
  HELP  [phys_LCD_STRING_HELP];
  CLASS CONTAINED;
  TYPE ASCII (5)
  {
    DEFAULT_VALUE "";
  }
  HANDLING  READ & WRITE;
}


COMMAND write_phys_LCD_STRING
{
     BLOCK physical_block;
     INDEX 63;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             phys_LCD_STRING
          }
          REPLY
          {
          }


     }
}

COMMAND read_phys_LCD_STRING
{
     BLOCK physical_block;
     INDEX 63;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
		phys_LCD_STRING
          }


     }
}

VARIABLE phys_LCD_PRECISION
{
  LABEL [phys_LCD_PRECISION_LABEL];
  HELP  [phys_LCD_PRECISION_HELP];
  CLASS CONTAINED;
  TYPE ENUMERATED (1)
  {
    DEFAULT_VALUE 3;
       {0,  [phys_LCD_PRECISION_0] 		},
		{1, [phys_LCD_PRECISION_1] 		},
		{2, [phys_LCD_PRECISION_2] 		},
		{3, [phys_LCD_PRECISION_3] 		},
		{4, [phys_LCD_PRECISION_4] 		}

  }
  HANDLING READ & WRITE;
}


COMMAND read_phys_LCD_PRECISION
{
     BLOCK physical_block;
     INDEX 64;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_LCD_PRECISION
          }


     }
}
COMMAND write_phys_LCD_PRECISION
{
     BLOCK physical_block;
     INDEX 64;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             phys_LCD_PRECISION
          }
          REPLY
          {
          }


     }
}
VARIABLE phys_LCD_ADDR
{
  LABEL [phys_LCD_ADDR_LABEL];
  HELP  [phys_LCD_ADDR_HELP];
  CLASS CONTAINED;
  TYPE ENUMERATED (1)
  {
    DEFAULT_VALUE 0;
       {0, [phys_LCD_ADDR_0 ]},
		{1,[phys_LCD_ADDR_1 ]}
  }
  HANDLING READ & WRITE;
}


COMMAND read_phys_LCD_ADDR
{
     BLOCK physical_block;
     INDEX 65;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_LCD_ADDR
          }


     }
}
COMMAND write_phys_LCD_ADDR
{
     BLOCK physical_block;
     INDEX 65;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             phys_LCD_ADDR
          }
          REPLY
          {
          }


     }
}
VARIABLE phys_INPUT_FILTER
{
  LABEL [phys_INPUT_FILTER_LABEL];
  HELP  [phys_INPUT_FILTER_HELP];
  CLASS CONTAINED;
  TYPE ENUMERATED (1)
  {
    DEFAULT_VALUE 0;
         {   0, [phys_INPUT_FILTER_0] },
  		{   1,  [phys_INPUT_FILTER_1] }

  }
  HANDLING READ & WRITE;
}


COMMAND read_phys_INPUT_FILTER
{
     BLOCK physical_block;
     INDEX 66;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_INPUT_FILTER
          }


     }
}
COMMAND write_phys_INPUT_FILTER
{
     BLOCK physical_block;
     INDEX 66;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             phys_INPUT_FILTER
          }
          REPLY
          {
          }


     }
}
VARIABLE phys_CONFIG_BYTE_3
{
  LABEL [phys_CONFIG_BYTE_3_LABEL];
  HELP  [phys_CONFIG_BYTE_3_HELP];
  CLASS CONTAINED;
  TYPE BIT_ENUMERATED (1)
  {
		{	0x01,	[BYTE_3_Bit0]	},
		{	0x02,	[BYTE_3_Bit1]	},
		{	0x04,	[BYTE_3_Bit2]	},
		{	0x08,	[BYTE_3_Bit3]	},
		{	0x10,	[BYTE_3_Bit4]	},
		{	0x20,	[BYTE_3_Bit5]	},
		{	0x40,	[BYTE_3_Bit6]	},
		{	0x80,	[BYTE_3_Bit7]	}
  }

  HANDLING READ & WRITE;
	POST_READ_ACTIONS
	{
	method_getStates_CONFIG_BYTE_3
	}

}

/* setzen der bit_codierung */
MENU OnlineDialog_BYTE_3
{
	LABEL		[phys_CONFIG_BYTE_3_LABEL];
	ITEMS
	{
	Page_BYTE_3
	}
}

MENU Page_BYTE_3
{
	LABEL		[phys_CONFIG_BYTE_3_LABEL];
	ITEMS
	{
		 	phys_CONFIG_BYTE_3(READ_ONLY),
            Group_BYTE_3
	 	    
	 	    IF(SERVICECODE)
			{
	 	    method_setStates_CONFIG_BYTE_3
			}
			
	}


}

MENU Group_BYTE_3
{
	LABEL	   "";
	ITEMS
	{

			BYTE_3_Bit7_val,
			BYTE_3_Bit6_val,
			BYTE_3_Bit5_val,
			BYTE_3_Bit4_val,
			BYTE_3_Bit3_val,
			BYTE_3_Bit2_val,
			BYTE_3_Bit1_val,
			BYTE_3_Bit0_val

	}
}



METHOD method_setStates_CONFIG_BYTE_3
{
	LABEL		[transfer_label];
	DEFINITION
	{
	  	int value;

	  	value =ivar_value(BYTE_3_Bit0_val)	 + ivar_value(BYTE_3_Bit1_val)	  		 + ivar_value(BYTE_3_Bit2_val)	  		 + ivar_value(BYTE_3_Bit3_val)	  		 + ivar_value(BYTE_3_Bit4_val)	  		 + ivar_value(BYTE_3_Bit5_val)	  		 + ivar_value(BYTE_3_Bit6_val)	  		 + ivar_value(BYTE_3_Bit7_val) ;

	   if(	value != 0 )
	   {
	  	iassign(phys_CONFIG_BYTE_3,value);
  	  	
  	  	WriteCommand(write_phys_CONFIG_BYTE_3);
	   }
	}
   VALIDITY  IF(SERVICECODE){ TRUE;} ELSE {FALSE;}
}


METHOD method_getStates_CONFIG_BYTE_3
{

	LABEL		[transfer_label];
	DEFINITION
	{
	  	int value;
	  
	  	value =ivar_value(phys_CONFIG_BYTE_3); 

		_TRACE ("CONFIG_BYTE_3 Value" );
		_TRACE (value );


			_TRACE("BIT 0	++++++++++++++++++++++++++++++++++");
		 	if(  (value & 0x01)==0x01 )
			{
  		
  					_TRACE( "BIT 0 is ON ,0x01") ;
  					iassign(BYTE_3_Bit0_val,1);
			}
			else
			{
  					_TRACE( "BIT 0 is OFF ,0x01" ) ;
					iassign(BYTE_3_Bit0_val,0);
			}

			_TRACE("BIT 1	++++++++++++++++++++++++++++++++++");
			if(  (value & 0x02)==0x02 )
			{
  					_TRACE( "BIT 1 is ON ,0x02") ;
					iassign(BYTE_3_Bit1_val,2);
				
			}
			else
			{
  					_TRACE( "BIT 1 is OFF ,0x02") ;
					iassign(BYTE_3_Bit1_val,0);

			}


			_TRACE("BIT 2	++++++++++++++++++++++++++++++++++");

			if(  (value & 0x04)==0x04 )
			{
  					_TRACE( "BIT 2 is ON ,0x04") ;
					iassign(BYTE_3_Bit2_val,4);

				
			}
			else
			{
  					_TRACE( "BIT 2 is OFF ,0x04") ;
					iassign(BYTE_3_Bit2_val,0);

			}



			_TRACE("BIT 3	++++++++++++++++++++++++++++++++++");

			if(  (value & 0x08)==0x08 )
			{
  					_TRACE( "BIT 3 is ON ,0x08");
					iassign(BYTE_3_Bit3_val,8);

				
			}
			else
			{
  					_TRACE( "BIT 3 is OFF ,0x08");
					iassign(BYTE_3_Bit3_val,0);

			}


			_TRACE("BIT 4	++++++++++++++++++++++++++++++++++");
			if(  (value & 0x10)==0x10 )
			{
  					_TRACE( "BIT 4 is ON ,0x10");
					iassign(BYTE_3_Bit4_val,16);

				
			}
			else
			{
  					_TRACE( "BIT 4 is OFF ,0x10") ;
					iassign(BYTE_3_Bit4_val,0);

 			}

			_TRACE("BIT 5	++++++++++++++++++++++++++++++++++");
			if(  (value & 0x20)==0x20 )
			{
  					_TRACE( "BIT 5 is ON ,0x20") ;
					iassign(BYTE_3_Bit5_val,32);

				
			}
			else
			{
  					_TRACE( "BIT 5 is OFF ,0x20");
					iassign(BYTE_3_Bit5_val,0);

			}

			_TRACE("BIT 6	++++++++++++++++++++++++++++++++++");
			if(  (value & 0x40)==0x40 )
			{
  					_TRACE( "BIT 6 is ON ,0x40")  ;
					iassign(BYTE_3_Bit6_val,64);

				
			}
			else
			{
  					_TRACE( "BIT 6 is OFF ,0x40") ;
					iassign(BYTE_3_Bit6_val,0);
			}


			_TRACE("BIT 7	++++++++++++++++++++++++++++++++++");
			if(  (value & 0x80)==0x80 )
			{
  					_TRACE( "BIT 7 is ON ,0x80")  ;
					iassign(BYTE_3_Bit7_val,128);
				
			}
			else
			{
  					_TRACE( "BIT 7 is OFF ,0x80") ;
					iassign(BYTE_3_Bit7_val,0);
			}



	}
}

VARIABLE BYTE_3_Bit0_val  
{
   LABEL         [BYTE_3_Bit0];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	1, 	[_on]	}
  		   
	}
   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }

}
VARIABLE BYTE_3_Bit1_val 
{
   LABEL         [BYTE_3_Bit1];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	2, 	[_on]	}
  		   
	}
   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }

}

VARIABLE BYTE_3_Bit2_val   
{
   LABEL         [BYTE_3_Bit2];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	4, 	[_on]	}
  		   
	}
   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }

}
VARIABLE BYTE_3_Bit3_val   
{
   LABEL         [BYTE_3_Bit3];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	8, 	[_on]	}
  		   
	}
   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }

}
VARIABLE BYTE_3_Bit4_val   
{
   LABEL         [BYTE_3_Bit4];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	16, [_on]	}
  		   
	}
   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }
}
VARIABLE BYTE_3_Bit5_val   
{
   LABEL         [BYTE_3_Bit5];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	32, [_on]	}
  		   
	}
   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }
}
VARIABLE BYTE_3_Bit6_val   
{
   LABEL         [BYTE_3_Bit6];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	64, [_on]	}
  		   
	}
   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }
}
VARIABLE BYTE_3_Bit7_val   
{
   LABEL         [BYTE_3_Bit7];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	128, [_on]	}
  		   
	}
   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }
}



COMMAND read_phys_CONFIG_BYTE_3
{
     BLOCK physical_block;
     INDEX 67;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_CONFIG_BYTE_3
          }


     }
}
COMMAND write_phys_CONFIG_BYTE_3
{
     BLOCK physical_block;
     INDEX 67;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             phys_CONFIG_BYTE_3
          }
          REPLY
          {
          }


     }
}


VARIABLE phys_CONFIG_BYTE_4
{
  LABEL [phys_CONFIG_BYTE_4_LABEL];
  HELP  [phys_CONFIG_BYTE_4_HELP];
  CLASS CONTAINED;
  TYPE BIT_ENUMERATED (1)
  {
		{	0x01,	[BYTE_4_Bit0]	},
		{	0x02,	[BYTE_4_Bit1]	},
		{	0x04,	[BYTE_4_Bit2]	},
		{	0x08,	[BYTE_4_Bit3]	},
		{	0x10,	[BYTE_4_Bit4]	},
		{	0x20,	[BYTE_4_Bit5]	},
		{	0x40,	[BYTE_4_Bit6]	},
		{	0x80,	[BYTE_4_Bit7]	}
  }

  HANDLING READ & WRITE;
	POST_READ_ACTIONS
	{
	method_getStates_CONFIG_BYTE_4
	}

}

MENU OnlineDialog_BYTES
{
	LABEL		[phys_CONFIG_BYTES];
	ITEMS
	{

	  phys_CONFIG_BYTE_3(READ_ONLY),
	  phys_CONFIG_BYTE_4(READ_ONLY)
	}
}


/* setzen der bit_codierung */
MENU OnlineDialog_BYTE_4
{
	LABEL		[phys_CONFIG_BYTE_4_LABEL];
	ITEMS
	{
	Page_BYTE_4
	}
}

MENU Page_BYTE_4
{
	LABEL		[phys_CONFIG_BYTE_4_LABEL];
	ITEMS
	{
		 	phys_CONFIG_BYTE_4(READ_ONLY),
            Group_BYTE_4
			IF(SERVICECODE)
			{
	 	    method_setStates_CONFIG_BYTE_4
			}
			
	}


}

MENU Group_BYTE_4
{
	LABEL		"";
	ITEMS
	{

			BYTE_4_Bit7_val,
			BYTE_4_Bit6_val,
			BYTE_4_Bit5_val,
			BYTE_4_Bit4_val,
			BYTE_4_Bit3_val,
			BYTE_4_Bit2_val,
			BYTE_4_Bit1_val,
			BYTE_4_Bit0_val

	}
}
METHOD method_setStates_CONFIG_BYTE_4
{
	LABEL		[transfer_label];
	DEFINITION
	{
	  	int value;

	  	value =ivar_value(BYTE_4_Bit0_val)	 + ivar_value(BYTE_4_Bit1_val)	  		 + ivar_value(BYTE_4_Bit2_val)	  		 + ivar_value(BYTE_4_Bit3_val)	  		 + ivar_value(BYTE_4_Bit4_val)	  		 + ivar_value(BYTE_4_Bit5_val)	  		 + ivar_value(BYTE_4_Bit6_val)	  		 + ivar_value(BYTE_4_Bit7_val) ;

	   if(	value != 0 )
	   {
	  	iassign(phys_CONFIG_BYTE_4,value);
  	  	
  	  	WriteCommand(write_phys_CONFIG_BYTE_4);
	   }
	}
   VALIDITY  IF(SERVICECODE){ TRUE;} ELSE {FALSE;}
}

METHOD method_getStates_CONFIG_BYTE_4
{

	LABEL		[transfer_label];
	DEFINITION
	{
	  	int value;


	  	value =ivar_value(phys_CONFIG_BYTE_4); 
		_TRACE ("CONFIG_BYTE_4 Value" );
		_TRACE (value );



			_TRACE("BIT 0	++++++++++++++++++++++++++++++++++");
		 	if(  (value & 0x01)==0x01 )
			{
  		
  					_TRACE( "BIT 0 is ON ,0x01")  ;
  							iassign(BYTE_4_Bit0_val,1);
			}
			else
			{
  					_TRACE( "BIT 0 is OFF ,0x01" )	;
					iassign(BYTE_4_Bit0_val,0);
			}

			_TRACE("BIT 1	++++++++++++++++++++++++++++++++++");
			if(  (value & 0x02)==0x02 )
			{
  					_TRACE( "BIT 1 is ON ,0x02")   ;
					iassign(BYTE_4_Bit1_val,2);
				
			}
			else
			{
  					_TRACE( "BIT 1 is OFF ,0x02")  ;
					iassign(BYTE_4_Bit1_val,0);

			}


			_TRACE("BIT 2	++++++++++++++++++++++++++++++++++");

			if(  (value & 0x04)==0x04 )
			{
  					_TRACE( "BIT 2 is ON ,0x04") ;
					iassign(BYTE_4_Bit2_val,4);

				
			}
			else
			{
  					_TRACE( "BIT 2 is OFF ,0x04")  ;
					iassign(BYTE_4_Bit2_val,0);

			}



			_TRACE("BIT 3	++++++++++++++++++++++++++++++++++");

			if(  (value & 0x08)==0x08 )
			{
  					_TRACE( "BIT 3 is ON ,0x08") ;
					iassign(BYTE_4_Bit3_val,8);

				
			}
			else
			{
  					_TRACE( "BIT 3 is OFF ,0x08") ;
					iassign(BYTE_4_Bit3_val,0);

			}


			_TRACE("BIT 4	++++++++++++++++++++++++++++++++++");
			if(  (value & 0x10)==0x10 )
			{
  					_TRACE( "BIT 4 is ON ,0x10")  ;
					iassign(BYTE_4_Bit4_val,16);

				
			}
			else
			{
  					_TRACE( "BIT 4 is OFF ,0x10") ;
					iassign(BYTE_4_Bit4_val,0);

 			}

			_TRACE("BIT 5	++++++++++++++++++++++++++++++++++");
			if(  (value & 0x20)==0x20 )
			{
  					_TRACE( "BIT 5 is ON ,0x20")  ;
					iassign(BYTE_4_Bit5_val,32);

				
			}
			else
			{
  					_TRACE( "BIT 5 is OFF ,0x20") ;
					iassign(BYTE_4_Bit5_val,0);

			}

			_TRACE("BIT 6	++++++++++++++++++++++++++++++++++");
			if(  (value & 0x40)==0x40 )
			{
  					_TRACE( "BIT 6 is ON ,0x40") ;
					iassign(BYTE_4_Bit6_val,64);

				
			}
			else
			{
  					_TRACE( "BIT 6 is OFF ,0x40") ;
					iassign(BYTE_4_Bit6_val,0);
			}


			_TRACE("BIT 7	++++++++++++++++++++++++++++++++++");
			if(  (value & 0x80)==0x80 )
			{
  					_TRACE( "BIT 7 is ON ,0x80")  ;
					iassign(BYTE_4_Bit7_val,128);
				
			}
			else
			{
  					_TRACE( "BIT 7 is OFF ,0x80") ;
					iassign(BYTE_4_Bit7_val,0);
			}




	}
}

VARIABLE BYTE_4_Bit0_val  
{
   LABEL         [BYTE_4_Bit0];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	1, 	[_on]	}
  		   
	}
/*   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }
*/
	HANDLING READ;

}
VARIABLE BYTE_4_Bit1_val 
{
   LABEL         [BYTE_4_Bit1];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	2, 	[_on]	}
  		   
	}
/*   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }
*/
	HANDLING READ;

}

VARIABLE BYTE_4_Bit2_val   
{
   LABEL         [BYTE_4_Bit2];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	4, 	[_on]	}
  		   
	}
/*   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }
*/
	HANDLING READ;

}
VARIABLE BYTE_4_Bit3_val   
{
   LABEL         [BYTE_4_Bit3];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	8, 	[_on]	}
  		   
	}
/*   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }
*/
	HANDLING READ;
}
VARIABLE BYTE_4_Bit4_val   
{
   LABEL         [BYTE_4_Bit4];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	16, [_on]	}
  		   
	}
/*   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }
*/
	HANDLING READ;
}
VARIABLE BYTE_4_Bit5_val   
{
   LABEL         [BYTE_4_Bit5];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	32, [_on]	}
  		   
	}
   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }
}
VARIABLE BYTE_4_Bit6_val   
{
   LABEL         [BYTE_4_Bit6];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	64, [_on]	}
  		   
	}
   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }
}
VARIABLE BYTE_4_Bit7_val   
{
   LABEL         [BYTE_4_Bit7];
   CLASS         LOCAL;
   TYPE			 ENUMERATED (1)
	{
		{	0, 	[_off]	},
		{	128, [_on]	}
  		   
	}
   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }
}




COMMAND read_phys_CONFIG_BYTE_4
{
     BLOCK physical_block;
     INDEX 68;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_CONFIG_BYTE_4
          }


     }
}
COMMAND write_phys_CONFIG_BYTE_4
{
     BLOCK physical_block;
     INDEX 68;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             phys_CONFIG_BYTE_4
          }
          REPLY
          {
          }


     }
}
VARIABLE phys_MEASUREMENT_TYPE
{
  LABEL [phys_MEASUREMENT_TYPE_LABEL];
  HELP  [phys_MEASUREMENT_TYPE_HELP];
  CLASS CONTAINED;
   TYPE			 ENUMERATED (1)
  {

	DEFAULT_VALUE 2;

	{2	,  [ SENSOR_TYPE_2	] },
	{3	,  [ SENSOR_TYPE_3	] },
	{4	,  [ SENSOR_TYPE_4	] },
	{5	,  [ SENSOR_TYPE_5	] },
	{6	,  [ SENSOR_TYPE_6	] },
	{7	,  [ SENSOR_TYPE_7	] },
	{8	,  [ SENSOR_TYPE_8	] },
	{9	,  [ SENSOR_TYPE_9	] },
	{11	,  [ SENSOR_TYPE_11	] },
	{12	,  [ SENSOR_TYPE_12	] },
	{13	,  [ SENSOR_TYPE_13	] },
	{16	,  [ SENSOR_TYPE_16	] },
	{22	,  [ SENSOR_TYPE_22	] },
	{23	,  [ SENSOR_TYPE_23	] },
	{40	,  [ SENSOR_TYPE_40	] },
	{41	,  [ SENSOR_TYPE_41	] },
	{42	,  [ SENSOR_TYPE_42	] },
	{43	,  [ SENSOR_TYPE_43	] },
	{44	,  [ SENSOR_TYPE_44	] },
   {49,	[TC_type_J]},
   {50,	[TC_type_K]},
   {51,	[TC_type_E]},
   {52,	[TC_type_T]},
   {53,	[TC_type_R]},
   {54,	[TC_type_S]},
   {55,	[TC_type_B]},
   {56,	[TC_type_N]},
   {57,	[TC_type_C]},
   {85,	[unit_1243]},
   {33,	[unit_1281]}
  }


   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }

}


COMMAND read_phys_MEASUREMENT_TYPE
{
     BLOCK physical_block;
     INDEX 69;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_MEASUREMENT_TYPE
          }


     }
}
COMMAND write_phys_MEASUREMENT_TYPE
{
     BLOCK physical_block;
     INDEX 69;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             phys_MEASUREMENT_TYPE
          }
          REPLY
          {
          }


     }
}



VARIABLE phys_INPUT_SENSOR_TYPE
{
  LABEL [phys_INPUT_SENSOR_TYPE_LABEL];
  HELP  [phys_INPUT_SENSOR_TYPE_HELP];
  CLASS CONTAINED;
   TYPE			 ENUMERATED (1)
  {

	DEFAULT_VALUE 2;

	{2	,  [ SENSOR_TYPE_2	] },
	{3	,  [ SENSOR_TYPE_3	] },
	{4	,  [ SENSOR_TYPE_4	] },
	{5	,  [ SENSOR_TYPE_5	] },
	{6	,  [ SENSOR_TYPE_6	] },
	{7	,  [ SENSOR_TYPE_7	] },
	{8	,  [ SENSOR_TYPE_8	] },
	{9	,  [ SENSOR_TYPE_9	] },
	{11	,  [ SENSOR_TYPE_11	] },
	{12	,  [ SENSOR_TYPE_12	] },
	{13	,  [ SENSOR_TYPE_13	] },
	{16	,  [ SENSOR_TYPE_16	] },
	{22	,  [ SENSOR_TYPE_22	] },
	{23	,  [ SENSOR_TYPE_23	] },
	{40	,  [ SENSOR_TYPE_40	] },
	{41	,  [ SENSOR_TYPE_41	] },
	{42	,  [ SENSOR_TYPE_42	] },
	{43	,  [ SENSOR_TYPE_43	] },
	{44	,  [ SENSOR_TYPE_44	] },
   {49,	[TC_type_J]},
   {50,	[TC_type_K]},
   {51,	[TC_type_E]},
   {52,	[TC_type_T]},
   {53,	[TC_type_R]},
   {54,	[TC_type_S]},
   {55,	[TC_type_B]},
   {56,	[TC_type_N]},
   {57,	[TC_type_C]},
   {85,	[unit_1243]},
   {33,	[unit_1281]}
  }

   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }

}


COMMAND read_phys_INPUT_SENSOR_TYPE
{
     BLOCK physical_block;
     INDEX 70;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_INPUT_SENSOR_TYPE
          }


     }
}
COMMAND write_phys_INPUT_SENSOR_TYPE
{
     BLOCK physical_block;
     INDEX 70;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             phys_INPUT_SENSOR_TYPE
          }
          REPLY
          {
          }


     }
}
VARIABLE phys_PRIMARY_MEASURE_UNIT
{
  LABEL [phys_PRIMARY_MEASURE_UNIT_LABEL];
  HELP  [phys_PRIMARY_MEASURE_UNIT_HELP];
  CLASS CONTAINED;

	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE 32;


			/* degC	*/	{ 32,	[unit_1001],	[unit_1001_help]	},
			/* degF	*/	{ 33,	[unit_1002],	[unit_1002_help]	},
			/* Rk	*/	{ 34,	[unit_1003],	[unit_1003_help]	},
			/* K	*/	{ 35,	[unit_1000],	[unit_1000_help]	},
			/* mV	*/	{ 36,	[unit_1243],	[unit_1243_help]	},
			/* Ohm	*/	{ 37,	[unit_1281],	[unit_1281_help]	},
			/* Hz	*/	{ 38,	[unit_1077],	[unit_1077_help]	},
			/* mA	*/	{ 39,	[unit_1211],	[unit_1211_help]	},
			/* s	*/	{ 51,	[unit_1054],	[unit_1054_help]	},
			/* %	*/	{ 57,	[unit_1342],	[unit_1342_help]	},
			/*  V	*/	{ 58,	[unit_1240],	[unit_1240_help]	}

	}


   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }

}


COMMAND read_phys_PRIMARY_MEASURE_UNIT
{
     BLOCK physical_block;
     INDEX 71;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_PRIMARY_MEASURE_UNIT
          }


     }
}
COMMAND write_phys_PRIMARY_MEASURE_UNIT
{
     BLOCK physical_block;
     INDEX 71;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             phys_PRIMARY_MEASURE_UNIT
          }
          REPLY
          {
          }


     }
}
VARIABLE phys_AMBIENT_MEASURE_UNIT
{
  LABEL [phys_AMBIENT_MEASURE_UNIT_LABEL];
  HELP  [phys_AMBIENT_MEASURE_UNIT_HELP];
  CLASS CONTAINED;

	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE 32;


			/* degC	*/	{ 32,	[unit_1001],	[unit_1001_help]	},
			/* degF	*/	{ 33,	[unit_1002],	[unit_1002_help]	},
			/* Rk	*/	{ 34,	[unit_1003],	[unit_1003_help]	},
			/* K	*/	{ 35,	[unit_1000],	[unit_1000_help]	},
			/* mV	*/	{ 36,	[unit_1243],	[unit_1243_help]	},
			/* Ohm	*/	{ 37,	[unit_1281],	[unit_1281_help]	},
			/* Hz	*/	{ 38,	[unit_1077],	[unit_1077_help]	},
			/* mA	*/	{ 39,	[unit_1211],	[unit_1211_help]	},
			/* s	*/	{ 51,	[unit_1054],	[unit_1054_help]	},
			/* %	*/	{ 57,	[unit_1342],	[unit_1342_help]	},
			/*  V	*/	{ 58,	[unit_1240],	[unit_1240_help]	}

	}



   HANDLING     IF(SERVICECODE)
   				{ READ & WRITE;}
				ELSE{ READ; }

}


COMMAND read_phys_AMBIENT_MEASURE_UNIT
{
     BLOCK physical_block;
     INDEX 72;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_AMBIENT_MEASURE_UNIT
          }


     }
}
COMMAND write_phys_AMBIENT_MEASURE_UNIT
{
     BLOCK physical_block;
     INDEX 72;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             phys_AMBIENT_MEASURE_UNIT
          }
          REPLY
          {
          }


     }
}
VARIABLE phys_POINT_64_RESP_BYTE_1
{
  LABEL [phys_POINT_64_RESP_BYTE_1_LABEL];
  HELP  [phys_POINT_64_RESP_BYTE_1_HELP];
  CLASS CONTAINED & DYNAMIC;
  TYPE UNSIGNED_INTEGER (1);
  HANDLING READ;
}


COMMAND read_phys_POINT_64_RESP_BYTE_1
{
     BLOCK physical_block;
     INDEX 73;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_POINT_64_RESP_BYTE_1
          }


     }
}
VARIABLE phys_POINT_20_RESP_BYTE_1
{
  LABEL [phys_POINT_20_RESP_BYTE_1_LABEL];
  HELP  [phys_POINT_20_RESP_BYTE_1_HELP];
  CLASS CONTAINED & DYNAMIC;
  TYPE UNSIGNED_INTEGER (1);
  HANDLING READ;
}


COMMAND read_phys_POINT_20_RESP_BYTE_1
{
     BLOCK physical_block;
     INDEX 74;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_POINT_20_RESP_BYTE_1
          }


     }
}

VARIABLE phys_ADC_BIN_OUTPUT
{
  LABEL [phys_ADC_BIN_OUTPUT_LABEL];
  HELP  [phys_ADC_BIN_OUTPUT_HELP];
  CLASS CONTAINED & DYNAMIC;
  TYPE INTEGER (4);
  HANDLING READ & WRITE;
}


COMMAND read_phys_ADC_BIN_OUTPUT
{
     BLOCK physical_block;
     INDEX 76;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_ADC_BIN_OUTPUT
          }


     }
}
COMMAND write_phys_ADC_BIN_OUTPUT
{
     BLOCK physical_block;
     INDEX 76;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             phys_ADC_BIN_OUTPUT
          }
          REPLY
          {
          }


     }
}

VARIABLE phys_FILTER_SIZE
{
  LABEL [phys_FILTER_SIZE_LABEL];
  HELP  [phys_FILTER_SIZE_HELP];
  CLASS CONTAINED;
  TYPE UNSIGNED_INTEGER(1)
  {
	MIN_VALUE	1;
	MAX_VALUE  16;
    DEFAULT_VALUE 4;
  }

  HANDLING READ & WRITE;
}


COMMAND read_phys_FILTER_SIZE
{
     BLOCK physical_block;
     INDEX 78;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             phys_FILTER_SIZE
          }
     }
}

COMMAND write_phys_FILTER_SIZE
{
     BLOCK physical_block;
     INDEX 78;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             phys_FILTER_SIZE
          }
          REPLY
          {
          }
     }
}


/***********************************************************************/
/*    Transducer Block												   */
/***********************************************************************/

BLOCK transducer_block_1
{
	TYPE	TRANSDUCER;
	NUMBER	1;
}

trans1_blk_reserve							LIKE VARIABLE	phys_blk_reserve
{
}

VARIABLE trans1_blk_object
{
	LABEL		[blk_block_object];
	HELP		[blk_block_object_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	3,	[blk_block_object_TRANSDUCER]		}
	}
	HANDLING	READ;
}

VARIABLE trans1_blk_parent_class
{
	LABEL		[blk_parent_class];
	HELP		[trans_blk_parent_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	2,	[trans_blk_parent_class_TEMP]	}
	}
	HANDLING	READ;
}

VARIABLE trans1_blk_class
{
	LABEL		[blk_class];
	HELP		[trans_blk_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		DEFAULT_VALUE	18;
		{	1,		[trans_temp_blk_class_TC]	},
		{	2,		[trans_temp_blk_class_RTD]	},
		{	3,		[trans_temp_blk_class_PYR]	},
		{	16,		"TC + DC U"					},
		{	17,		"RTD + R"					},
		{	18,		"TC + RTD + R + DC U"		},
		{	250,	[not_used] 					},
		{	251,	[none]						},
		{	252,	[unknown]					},
		{	253,	[special]					}
	}
	HANDLING	READ;
}

trans1_blk_dd_reference						LIKE VARIABLE	phys_blk_dd_reference
{											
}											
											
trans1_blk_dd_rev							LIKE VARIABLE	phys_blk_dd_rev
{											
}											
											
trans1_blk_profile						LIKE VARIABLE	phys_blk_profile
{											
}											
											
trans1_blk_profile_rev						LIKE VARIABLE	phys_blk_profile_rev
{											
}											
											
trans1_blk_execution_time					LIKE VARIABLE	phys_blk_execution_time
{											
}											
											
trans1_blk_num_parameters					LIKE VARIABLE	phys_blk_num_parameters
{	
	REDEFINE  DEFAULT_VALUE 64;										
}											
											
trans1_blk_index_view_1						LIKE VARIABLE	phys_blk_index_view_1
{
  /* REDEFINE DEFAULT_VALUE 0x01e0;			*/
}

trans1_blk_num_view_lists					LIKE VARIABLE	phys_blk_num_view_lists
{											
}											
											
trans1_st_rev							LIKE VARIABLE	phys_st_rev
{											
}											
											
trans1_tag_desc							LIKE VARIABLE	phys_tag_desc
{											
}											
											
trans1_strategy							LIKE VARIABLE	phys_strategy
{											
}											
											
trans1_alert_key							LIKE VARIABLE	phys_alert_key
{											
}											
											
trans1_target_mode						LIKE VARIABLE	phys_target_mode
{											
}											
											
trans1_actual_mode						LIKE VARIABLE	phys_actual_mode
{											
}											
											
trans1_permitted_mode						LIKE VARIABLE	phys_permitted_mode
{											
}											
											
trans1_normal_mode						LIKE VARIABLE	phys_normal_mode
{
}

trans1_current_state_alarm_sum				LIKE VARIABLE	phys_current_state_alarm_sum
{
}

trans1_unacknowledged_state_alarm_sum			LIKE VARIABLE	phys_unacknowledged_state_alarm_sum
{
}

trans1_unreported_state_alarm_sum				LIKE VARIABLE	phys_unreported_state_alarm_sum
{
}

trans1_disabled_state_alarm_sum				LIKE VARIABLE	phys_disabled_state_alarm_sum
{
}


/*---------------------------------------------------------------------*/
/*    Transducer Block: Temperature Transmitter						   */
/*---------------------------------------------------------------------*/

VARIABLE trans1_lin_type /*index 14*/
{
	LABEL		[trans_lin_type_label];
	HELP		[trans_lin_type_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	102;
		{	0,	[linear_label]		 },
		{	1,	[linearization_table]	 },
		{	102,  [enum_102] 			 },
		{	103,  [enum_103]			 },
		{	242 , [RTD_Pt300] 		 },
		{	240 , [RTD_Pt400] 		 },
		{	104,  [enum_104]			 },
		{	105,  [enum_105]			 },
		{	111,  [enum_111]			 },
		{	112,  [enum_112]			 },
		{	241 , [RTD_Pt400b] 		 },
		{	113,  [enum_113]			 },
		{	114,  [enum_114]			 },
		{	108,  [enum_108]			 },
		{	120,  [enum_120]			 },
		{	126,  [enum_126]			 },
		{	128,  [TC_type_B]			 },
		{	129,  [TC_type_C]			 },
		{	131,  [TC_type_E]			 },
		{	133,  [TC_type_J]			 },
		{	134,  [TC_type_K]			 },
		{	135,  [TC_type_N]			 },
		{	136,  [TC_type_R]			 },
		{	137,  [TC_type_S]			 },
		{	138,  [TC_type_T]			 }
		
	}
	HANDLING	READ & WRITE;

	POST_EDIT_ACTIONS
	{
		method_set_trans1_primary_value_unit, 	
		method_set_trans1_input_range,
		method_set_upper_and_lower_values,
		method_set_upper_and_lower_values_func,
		method_set_upper_and_lower_values_func_default,
		method_set_upper_and_lower_values_conformance_default,
		method_set_upper_and_lower_values_conformance,
		method_set_sensor_wire,
		method_set_rj_type,
		method_set_trans1_sensor_connection
	}

}


VARIABLE trans1_primary_value  /* index 8 */
{
	LABEL		[trans_value];
	HELP		[trans_temp_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DISPLAY_FORMAT	"7.3f";	
	}
	HANDLING	READ;
}

VARIABLE trans1_primary_value_status_quality   /* index 8 */
{
	LABEL		[status_quality];
	HELP		[value_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
	   	STATUS_OUTPUT_NO_RCAS
	}
	HANDLING	READ;
}

/* index 8 */
trans1_primary_value_status_limit			LIKE VARIABLE	trans1_primary_value_status_quality
{
	REDEFINE LABEL		[status_limit];		
	REDEFINE TYPE		ENUMERATED (1)
	{
		STATUS_OUTPUT_LIMIT
	}
}

VARIABLE trans1_primary_value_unit	/* index 9 */
{
	LABEL		[digital_units];	
	HELP		[digital_units_help];  
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		
	   DEFAULT_VALUE	
		IF(trans1_lin_type == 1)
			{   1243;  	}
		ELSE
		{
			IF(trans1_lin_type == 0)
				{   1243;  	}
			ELSE
				{   1001; 	}
		}
		

		IF(trans1_lin_type == 1)
		{
		  	{ 1240,	[unit_1240],	[unit_1240_help]	},
			{ 1243,	[unit_1243],	[unit_1243_help]	},
			{ 1281,	[unit_1281],	[unit_1281_help]	}

	  	}
		ELSE
		{
				IF(trans1_lin_type == 0)
				{
				 
					{ 1240,	[unit_1240],	[unit_1240_help]	},
					{ 1243,	[unit_1243],	[unit_1243_help]	},
					{ 1281,	[unit_1281],	[unit_1281_help]	},
					{ 1342,	[unit_1342],	[unit_1342_help]	}
			  	}
				ELSE
				{
					{ 1000,	[unit_1000],	[unit_1000_help]	},
					{ 1001,	[unit_1001],	[unit_1001_help]	},
					{ 1002,	[unit_1002],	[unit_1002_help]	},
					{ 1003,	[unit_1003],	[unit_1003_help]	}
				}
		}
	}
	POST_EDIT_ACTIONS
	{
		method_set_out_unit,
		method_set_trans1_input_range ,

		method_set_upper_and_lower_values,
		method_set_upper_and_lower_values_func,
	   	method_set_upper_and_lower_values_func_default,
		method_set_upper_and_lower_values_conformance_default,
		method_set_upper_and_lower_values_conformance,

		method_set_sensor_wire,
		method_set_rj_type,
		method_set_trans1_sensor_connection

	}


	HANDLING	READ & WRITE;
}




VARIABLE trans1_secondary_value_1	/*index 10*/
{
	LABEL		[trans_temp_temperature_1_label];	
	HELP		[trans_temp_temperature_1_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DISPLAY_FORMAT	"7.3f";	
	}
	HANDLING	READ;
}

VARIABLE trans1_secondary_value_1_status_quality
{
	LABEL		[status_quality];
	HELP		[value_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_OUTPUT_NO_RCAS
	}
	HANDLING	READ;
}

trans1_secondary_value_1_status_limit		LIKE VARIABLE	trans1_secondary_value_1_status_quality
{
	REDEFINE LABEL		[status_limit];		
	REDEFINE TYPE		ENUMERATED (1)
	{
		STATUS_OUTPUT_LIMIT
	}
}




VARIABLE trans1_sensor_measure_type	  /*index 12*/
{
	LABEL		[trans_temp_sensor_measure_type];	
	HELP		[trans_temp_sensor_measure_type_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE 0 ;

		{	0,		[trans_temp_sensor_measure_type_T1]				}
	   
	}
	HANDLING	READ & WRITE;
}

VARIABLE trans1_input_range	   /*index 13*/
{
	LABEL		[trans_temp_input_range]; 
	HELP		[trans_temp_input_range_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	250;

		IF( (trans1_lin_type == 0) ||  (trans1_lin_type > 1 ) )
		{

			{	0,	 [trans_temp_input_range_mV_label_1]   	},
			{	1,	 [trans_temp_input_range_mV_label_2]   	},
			{	2,	 [trans_temp_input_range_mV_label_3]   	},
			{	3,	 [trans_temp_input_range_mV_label_4]   	},
			{	4,	 [trans_temp_input_range_mV_label_5]   	},
			{	5,	 [trans_temp_input_range_mV_label_6]   	},
		  	{	128, [trans_temp_input_range_Ohm_label_1]	},
		  	{	129, [trans_temp_input_range_Ohm_label_2]	},
		  	{	130, [trans_temp_input_range_Ohm_label_3]	},
		  	{	131, [trans_temp_input_range_Ohm_label_4]	},
		  	{	132, [trans_temp_input_range_Ohm_label_5]	},
		  	{	133, [trans_temp_input_range_Ohm_label_6]	},
			{	240, [potentiometer_1]	},
			{	241, [potentiometer_2]	},
			{	242, [potentiometer_3]	},
			{	243, [potentiometer_4]	},
			{	244, [potentiometer_5]	},
			{	245, [potentiometer_6]	}
		   
		}
		ELSE 
		{
				IF	(trans1_lin_type == 1)
				{

					{	0,	 [trans_temp_input_range_mV_label_1]   	},
					{	1,	 [trans_temp_input_range_mV_label_2]   	},
					{	2,	 [trans_temp_input_range_mV_label_3]   	},
					{	3,	 [trans_temp_input_range_mV_label_4]   	},
					{	4,	 [trans_temp_input_range_mV_label_5]   	},
					{	5,	 [trans_temp_input_range_mV_label_6]   	},
		  			{	128, [trans_temp_input_range_Ohm_label_1]	},
		  			{	129, [trans_temp_input_range_Ohm_label_2]	},
		  			{	130, [trans_temp_input_range_Ohm_label_3]	},
		  			{	131, [trans_temp_input_range_Ohm_label_4]	},
		  			{	132, [trans_temp_input_range_Ohm_label_5]	},
		  			{	133, [trans_temp_input_range_Ohm_label_6]	}

				}
		}

		{	250, [not_used]}



	}
	POST_EDIT_ACTIONS
	{
		method_set_trans1_primary_value_unit,
		method_set_upper_and_lower_values,
		method_set_upper_and_lower_values_func,
		method_set_upper_and_lower_values_func_default,
		method_set_upper_and_lower_values_conformance_default,
		method_set_upper_and_lower_values_conformance,
		method_set_sensor_wire,
		method_set_rj_type,
		method_set_trans1_sensor_connection

	}


	HANDLING	READ & WRITE;
	VALIDITY VALID_LIN_TYPE
}

VARIABLE trans1_bias_1	 /*index 19*/
{
	LABEL		[trans_temp_bias_1];	
	HELP		[trans_temp_bias_1_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;	
		DISPLAY_FORMAT	"7.3f";	
	}
	HANDLING	READ & WRITE;

}


VARIABLE trans1_upper_sensor_limit  /*index 21*/
{
	LABEL		[trans_sensor_upper_limit];	
	HELP		[trans_sensor_upper_limit_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
 		DEFAULT_UPPER_VAL
	}
	HANDLING	READ & WRITE;
	
}

VARIABLE trans1_lower_sensor_limit  /*index 21*/
{
	LABEL		[trans_sensor_lower_limit];	
	HELP		[trans_sensor_lower_limit_help];
	CLASS		CONTAINED;
   	TYPE		FLOAT
	{
 		DEFAULT_LOWER_VAL
	}

	HANDLING	READ & WRITE;

	POST_READ_ACTIONS
	{
		method_set_upper_and_lower_values_conformance_default
	}


}


VARIABLE lower_sensor_limit_def
{
	LABEL	   "low def" ;	

	CLASS		LOCAL;
   	TYPE		FLOAT
	{
 	   	DEFAULT_LOWER_VAL
	}
	HANDLING	READ & WRITE;
	
}


VARIABLE upper_sensor_limit_def
{
	LABEL	   "upper def"	 ;
	CLASS		LOCAL;
   	TYPE		FLOAT
	{
	   	DEFAULT_UPPER_VAL
	}

	HANDLING	READ & WRITE;


}


/* LOCAL VALUES FOR UPPER AND LOWER SENSOR CONFORMANCE */

VARIABLE lower_sensor_limit_con
{
	LABEL		[lower_sensor_limit_con];	
	CLASS		LOCAL;
   	TYPE		FLOAT
	{
 	   	DEFAULT_LOWER_VAL_CON
	}
	HANDLING	READ & WRITE;
	
}


VARIABLE upper_sensor_limit_con
{
	LABEL		[upper_sensor_limit_con];	
	CLASS		LOCAL;
   	TYPE		FLOAT
	{
	   	DEFAULT_UPPER_VAL_CON
	}

	HANDLING	READ & WRITE;


}



/* LOCAL VALUES FOR UPPER AND LOWER SENSOR CONFORMANCE */


VARIABLE trans1_max_sensor_value_1	/*index 29*/
{
	LABEL		[trans1_max_sensor_value_1_l];	
	HELP		[trans1_max_sensor_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	HANDLING	READ & WRITE;


}




VARIABLE trans1_min_sensor_value_1 /*index 30*/
{
	LABEL		[trans1_min_sensor_value_1_l];	
	HELP		[trans1_min_sensor_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT;
	HANDLING	READ & WRITE;


}


VARIABLE trans1_input_fault_gen	/*index 24*/
{
	LABEL		[trans_temp_input_fault];	
	HELP		[trans_temp_input_fault_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (1)
	{
		{ 0x00,	[trans_temp_input_fault_OK]			},
		{ 0x01,	[trans_temp_input_fault_RJ_ERR]		},
		{ 0x02,	[trans_temp_input_fault_HW_ERR]		}
	}
	HANDLING	READ;
}

VARIABLE trans1_input_fault_1  /*index 25*/
{
	LABEL		[trans_temp_input_fault_CH1_FAULT_label]; 
	HELP		[trans_temp_input_fault_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (1)
	{

		{ 0x00,	[trans_temp_input_fault_OK]				},
		{ 0x01,	[trans_temp_input_fault_UNDERRANGE]		},	// bit0
		{ 0x02,	[trans_temp_input_fault_OVERRANGE]		},	// bit1
		{ 0x04,	[trans_temp_input_fault_LEAD_BREAK]		},	// bit2
		{ 0x08,	[trans_temp_input_fault_SHORT_CIRCUIT]		}	// bit3

	}
	HANDLING	READ;
}


VARIABLE trans1_sensor_wire_check_1	/*index 27*/
{
	LABEL		[trans_sensor_wire_check_label];
	HELP		[trans_sensor_wire_check_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
	   	DEFAULT_VALUE 3;

			{	1,	[enabled]	},  
			{	3,	[disabled]	}



	}
	HANDLING	READ & WRITE;

}



/*---------------------------------------------------------------------*/
/*    Transducer Block: Thermocouple Temperature Device (TC)		   */
/*---------------------------------------------------------------------*/

VARIABLE trans1_reference_junction_temp	 /*index 33*/
{
	LABEL		[trans_temp_rj_temp_l];	
	HELP		[trans_temp_rj_temp_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	HANDLING	READ;

    CONSTANT_UNIT IF( trans1_primary_value_unit==/* K    */   1000)
           { 
               [unit_1000];

           }
           ELSE
           {
               IF( trans1_primary_value_unit==/* degC */   1001){ [unit_1001];} 
               ELSE
               {
                   IF( trans1_primary_value_unit==/* degF */   1002){ [unit_1002];}
                   ELSE
                   {
                      IF( trans1_primary_value_unit==/* Rk   */   1003){ [unit_1003];}   
                      ELSE
                      {
                          [unit_1001];

                      }

                   }
               }
           }




   /* VALIDITY	VALID_TC */
}

VARIABLE trans1_reference_junction_type	/*index 34*/
{
	LABEL		[trans_temp_rj_type]; 
	HELP		[trans_temp_rj_type_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
	   //	DEFAULT_VALUE 0;



		//LIN, TABLE
		IF(	trans1_lin_type ==0   || 	trans1_lin_type==1    )
		{
			{ 0,	[trans_temp_rj_type_NONE] }
		}
		ELSE
		{
				// RTD
				IF( (trans1_lin_type >= 102) && (trans1_lin_type <= 126) || (trans1_lin_type >= 240) && (trans1_lin_type <= 242)  )
				{
						{ 0,	[trans_temp_rj_type_NONE] }
				}
				// TC
				ELSE 
				{	  
				
					{ 0,	[trans_temp_rj_type_NONE] },
					{ 1,	[trans_temp_rj_type_INT] }

				}
		}


	}
	HANDLING	READ & WRITE;
	VALIDITY	VALID_TC
}


/*---------------------------------------------------------------------*/
/*    Transducer Block: Thermoresistance Temperature Device (RTD)	   */
/*---------------------------------------------------------------------*/

VARIABLE trans1_sensor_connection  /*index 36*/
{
	LABEL		[trans_temp_sensor_connection];	
	HELP		[trans_temp_sensor_connection_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
 
		// RTD
		IF( (trans1_lin_type >= 102) && (trans1_lin_type <= 126) || (trans1_lin_type >= 240) && (trans1_lin_type <= 242)  )
		{
			{	0,	[trans_temp_sensor_connection_2_WIRE]		},
			{	1,	[trans_temp_sensor_connection_3_WIRE]		},
			{	2,	[trans_temp_sensor_connection_4_WIRE]		}
		}
		ELSE 
		{		//TC
				IF( (trans1_lin_type >= 128) && (trans1_lin_type <= 138))
				{
					{	0,	[trans_temp_sensor_connection_2_WIRE]		}

				}
				ELSE
				{		//LIN ,TABLE
						IF( (trans1_lin_type ==0) || (trans1_lin_type ==1))
						{
						   
						    //mV
							IF(	(trans1_input_range >=0) && (trans1_input_range <=5) )
							{
								{	0,	[trans_temp_sensor_connection_2_WIRE]		}

							}
							ELSE 
							{
								// poti
								IF( (trans1_input_range >=240) && (trans1_input_range <=245) )
								{
									{	1,	[trans_temp_sensor_connection_3_WIRE]		}

								}
								// Ohm
								ELSE
								{
									{	0,	[trans_temp_sensor_connection_2_WIRE]		},
									{	1,	[trans_temp_sensor_connection_3_WIRE]		},
									{	2,	[trans_temp_sensor_connection_4_WIRE]		}
								}
							}

						}
				}
		}




 	}
	HANDLING	READ & WRITE;
	VALIDITY	VALID_NOT_TC
}

VARIABLE trans1_comp_wire_1	/*index 37*/
{
	LABEL		[trans_temp_comp_wire1];	
	HELP		[trans_temp_comp_wire1_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0; 
		DISPLAY_FORMAT	"7.3f";
	}
	CONSTANT_UNIT	[Ohm];
	HANDLING	READ & WRITE;
	VALIDITY	VALID_NOT_TC1 
}

/*--- Table Object ----------------------------------------------------*/

VARIABLE trans1_tab_entry						/*45 optional */
{
	LABEL		[lin_tab_entry];
	HELP		[lin_tab_entry_help];
	CLASS		CONTAINED & DYNAMIC;

	TYPE		UNSIGNED_INTEGER (1)
	{
		DEFAULT_VALUE	1;
		MIN_VALUE 1;
		MAX_VALUE 128;
	}
	HANDLING	READ & WRITE;
	VALIDITY    VALID_LIN_TABLE
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_tab_min_number					/*46 optional */
{
	LABEL		[lin_tab_min_number];	
	HELP		[lin_tab_min_number_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1)
	{
		DEFAULT_VALUE	2;
	}
	HANDLING	READ;
	VALIDITY    VALID_LIN_TABLE
}
/*----------------------------------------------------------------------------*/

VARIABLE trans1_tab_max_number					/*48 optional */
{
	LABEL		[lin_tab_max_number];	
	HELP		[lin_tab_max_number_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1)
	{
		DEFAULT_VALUE	128;
	}
	HANDLING	READ;
	VALIDITY    VALID_LIN_TABLE
}
/*----------------------------------------------------------------------------*/

VARIABLE trans1_tab_actual_number				/*51 optional */
{
	LABEL		[lin_tab_actual_number];	
	HELP		[lin_tab_actual_number_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1)
	{
	  DEFAULT_VALUE	2;
   


	}
	HANDLING	READ;
	VALIDITY    VALID_LIN_TABLE
   	POST_READ_ACTIONS
   {  	set_tab_actual_number	}
}

VARIABLE tab_actual_number 
{
		LABEL		[number_of_coordinates];
		CLASS		LOCAL;
		TYPE		UNSIGNED_INTEGER (1)
		{
			DEFAULT_VALUE	2;
		  	MIN_VALUE 0;
		  	MAX_VALUE 128;


		}

		HANDLING	READ & WRITE;
   		POST_EDIT_ACTIONS
   			{  	set_valid_coordinates	}
}


/*----------------------------------------------------------------------------*/
VARIABLE trans1_tab_op_code						/*49 optional */
{
	LABEL		[lin_tab_op_code];	
	HELP		[lin_tab_op_code_help];
	CLASS		CONTAINED & DYNAMIC;

	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[lin_tab_op_code_NOT_INIT]			},
		{	1,	[lin_tab_op_code_START]				},
		{	3,	[lin_tab_op_code_END]				} 
	   	}													
	HANDLING	READ & WRITE;
}
/*----------------------------------------------------------------------------*/

VARIABLE trans1_tab_status						/*50 optional */
{
	LABEL		[lin_tab_status];	
	HELP		[lin_tab_status_help];
	CLASS		CONTAINED & DYNAMIC;

	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[lin_tab_status_NOT_INIT]			},
		{	1,	[lin_tab_status_GOOD]				},
		{	2,	[lin_tab_status_NOT_INC]			},
		{	3,	[lin_tab_status_NOT_DEC]			},
		{	4,	[lin_tab_status_NOT_ENOUGH_VALUES]	},
		{	5,	[lin_tab_status_TOO_MANY_VALUES]	},
		{	6,	[lin_tab_status_GRADIENT]			},
		{	7,	[lin_tab_status_NOT_ACCEPTED]		},
		{  	8,  [table_currently_loaded_label] }

	}
	HANDLING	READ;
	VALIDITY    VALID_LIN_TABLE
}

/*--- x|y-Value: Entry 0 ----------------------------------------------*/

VARIABLE trans1_tab_y_value_0					/* optional */
{
	LABEL		TAB_Y_LABEL_0;
	HELP		[lin_tab_y_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
	   	DEFAULT_VALUE	0.0;
	}
  /*	CONSTANT_UNIT		[Percent]; */
	HANDLING	READ & WRITE;
	VALIDITY    VALID_LIN_TABLE_XY (0)
}




trans1_tab_x_value_0		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_X_LABEL_0;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS	
	{
		method_set_tab_entry (0)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_start_table_transfer,
		method_set_tab_entry (0)
	}
	REDEFINE	PRE_EDIT_ACTIONS	
	 {	
		method_lese_y_werte,
		method_lese_x_werte
	 }
	//VALIDITY    VALID_LIN_TABLE_XY (0)
}


//--- x|y-Value: Entry 1 ----------------------------------------------

trans1_tab_y_value_1  	LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_1;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer (1)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(1)
}

trans1_tab_x_value_1		LIKE VARIABLE	trans1_tab_y_value_1
{
	REDEFINE	LABEL			TAB_X_LABEL_1;
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (1)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (1)
	}
	DELETE POST_WRITE_ACTIONS;
}


//--- x|y-Value: Entry 2 ----------------------------------------------

trans1_tab_y_value_2		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_2;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer (2)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(2) 
}

trans1_tab_x_value_2		LIKE VARIABLE	trans1_tab_y_value_2
{
	REDEFINE	LABEL			TAB_X_LABEL_2;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (2)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (2)
	}
	DELETE POST_WRITE_ACTIONS;
}

//--- x|y-Value: Entry 3 ----------------------------------------------

trans1_tab_y_value_3		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_3;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer (3)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(3) 
}

trans1_tab_x_value_3		LIKE VARIABLE	trans1_tab_y_value_3
{
	REDEFINE	LABEL			TAB_X_LABEL_3;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (3)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (3)
	}
	DELETE POST_WRITE_ACTIONS;
}

//--- x|y-Value: Entry 4 ----------------------------------------------

trans1_tab_y_value_4		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_4;
	
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer  (4)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(4) 
}

trans1_tab_x_value_4		LIKE VARIABLE	trans1_tab_y_value_4
{
	REDEFINE	LABEL			TAB_X_LABEL_4;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (4)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (4)
	}
	DELETE POST_WRITE_ACTIONS;
}

//--- x|y-Value: Entry 5 ----------------------------------------------

trans1_tab_y_value_5		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_5;
	
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer	(5)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(5) 
}

trans1_tab_x_value_5		LIKE VARIABLE	trans1_tab_y_value_5
{
	REDEFINE	LABEL			TAB_X_LABEL_5;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (5)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (5)
	}
	DELETE POST_WRITE_ACTIONS;
}


//--- x|y-Value: Entry 6 ----------------------------------------------

trans1_tab_y_value_6		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_6;
	
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer  (6)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(6) 
}

trans1_tab_x_value_6		LIKE VARIABLE	trans1_tab_y_value_6
{										
	REDEFINE	LABEL			TAB_X_LABEL_6;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (6)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (6)
	}
	DELETE POST_WRITE_ACTIONS;
}										
										
//--- x|y-Value: Entry 7 ----------------------------------------------

trans1_tab_y_value_7		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_7;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer  (7)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(7) 
}

trans1_tab_x_value_7		LIKE VARIABLE	trans1_tab_y_value_7
{											
	REDEFINE	LABEL			TAB_X_LABEL_7;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (7)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (7)
	}
	DELETE POST_WRITE_ACTIONS;
}											
											
//--- x|y-Value: Entry 8 ----------------------------------------------

trans1_tab_y_value_8		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_8;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer (8)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(8) 
}

trans1_tab_x_value_8		LIKE VARIABLE	trans1_tab_y_value_8
{											
	REDEFINE	LABEL			TAB_X_LABEL_8;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (8)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (8)
	}
	DELETE POST_WRITE_ACTIONS;
}											
											
//--- x|y-Value: Entry 9 ----------------------------------------------

trans1_tab_y_value_9		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_9;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer	(9)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(9) 
}

trans1_tab_x_value_9		LIKE VARIABLE	trans1_tab_y_value_9
{											
	REDEFINE	LABEL			TAB_X_LABEL_9;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (9)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (9)
	}
	DELETE POST_WRITE_ACTIONS;
}											
											
//--- x|y-Value: Entry 10 ---------------------------------------------

trans1_tab_y_value_10		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_10;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer  (10)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(10) 
}

trans1_tab_x_value_10		LIKE VARIABLE	trans1_tab_y_value_10
{											
	REDEFINE	LABEL			TAB_X_LABEL_10;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (10)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (10)
	}
	DELETE POST_WRITE_ACTIONS;
}											
											
//--- x|y-Value: Entry 11 ---------------------------------------------

trans1_tab_y_value_11		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_11;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer	(11)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(11)
}

trans1_tab_x_value_11		LIKE VARIABLE	trans1_tab_y_value_11
{											
	REDEFINE	LABEL			TAB_X_LABEL_11;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (11)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (11)
	}
	DELETE POST_WRITE_ACTIONS;
}											
											
//--- x|y-Value: Entry 12 ---------------------------------------------

trans1_tab_y_value_12		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_12;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer  (12)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(12) 
}

trans1_tab_x_value_12		LIKE VARIABLE	trans1_tab_y_value_12
{										
	REDEFINE	LABEL			TAB_X_LABEL_12;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (12)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (12)
	}
	DELETE POST_WRITE_ACTIONS;
}										
										
//--- x|y-Value: Entry 13 ---------------------------------------------

trans1_tab_y_value_13		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_13;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer (13)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(13) 
}

trans1_tab_x_value_13		LIKE VARIABLE	trans1_tab_y_value_13
{										
	REDEFINE	LABEL			TAB_X_LABEL_13;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (13)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (13)
	}
	DELETE POST_WRITE_ACTIONS;
}										
										
//--- x|y-Value: Entry 14 ---------------------------------------------

trans1_tab_y_value_14		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_14;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer (14)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(14) 
}

trans1_tab_x_value_14		LIKE VARIABLE	trans1_tab_y_value_14
{											
	REDEFINE	LABEL			TAB_X_LABEL_14;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (14)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (14)
	}
	DELETE POST_WRITE_ACTIONS;
}											
											
//--- x|y-Value: Entry 15 ---------------------------------------------

trans1_tab_y_value_15		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_15;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer(15)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(15) 
}

trans1_tab_x_value_15		LIKE VARIABLE	trans1_tab_y_value_15
{										
	REDEFINE	LABEL			TAB_X_LABEL_15;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (15)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (15)
	}
	DELETE POST_WRITE_ACTIONS;
}										
										
//--- x|y-Value: Entry 16 ---------------------------------------------

trans1_tab_y_value_16		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_16;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer (16)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(16)
}

trans1_tab_x_value_16		LIKE VARIABLE	trans1_tab_y_value_16
{											
	REDEFINE	LABEL			TAB_X_LABEL_16;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (16)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (16)
	}
	DELETE POST_WRITE_ACTIONS;
}											
											
//--- x|y-Value: Entry 17 ---------------------------------------------

trans1_tab_y_value_17		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_17;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer (17)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(17) 
}

trans1_tab_x_value_17		LIKE VARIABLE	trans1_tab_y_value_17
{											
	REDEFINE	LABEL			TAB_X_LABEL_17;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (17)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (17)
	}
	DELETE POST_WRITE_ACTIONS;
}											
											
//--- x|y-Value: Entry 18 ---------------------------------------------

trans1_tab_y_value_18		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_18;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer (18)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(18) 
}

trans1_tab_x_value_18		LIKE VARIABLE	trans1_tab_y_value_18
{											
	REDEFINE	LABEL			TAB_X_LABEL_18;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (18)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (18)
	}
	DELETE POST_WRITE_ACTIONS;
}											
											
//--- x|y-Value: Entry 19 ---------------------------------------------

trans1_tab_y_value_19		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_19;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer (19)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(19)
}

trans1_tab_x_value_19		LIKE VARIABLE	trans1_tab_y_value_19
{											
	REDEFINE	LABEL			TAB_X_LABEL_19;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (19)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (19)
	}
	DELETE POST_WRITE_ACTIONS;
}											
											

//--- x|y-Value: Entry 20 ---------------------------------------------

trans1_tab_y_value_20		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_20;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer (20)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(20) 
}

trans1_tab_x_value_20		LIKE VARIABLE	trans1_tab_y_value_20
{											
	REDEFINE	LABEL			TAB_X_LABEL_20;
	REDEFINE	HELP			[lin_tab_y_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (20)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (20)
	}
	DELETE		POST_WRITE_ACTIONS;
}											
											

//--- x|y-Value: Entry 21 ---------------------------------------------

trans1_tab_y_value_21		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_21;
	REDEFINE	POST_WRITE_ACTIONS
	{
		method_end_table_transfer (21)
	}
	REDEFINE VALIDITY    VALID_LIN_TABLE_XY(21)
}

trans1_tab_x_value_21		LIKE VARIABLE	trans1_tab_y_value_21
{											
	REDEFINE	LABEL			TAB_X_LABEL_21;
	REDEFINE	HELP			[lin_tab_x_value_help];
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (21)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (21)
	}
	DELETE POST_WRITE_ACTIONS;
}											
											

/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 22 ---------------------------------------------*/

trans1_tab_y_value_22        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_22;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (22)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(22)
}

trans1_tab_x_value_22        LIKE VARIABLE   trans1_tab_y_value_22
{   
    REDEFINE    LABEL           TAB_X_LABEL_22;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (22)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (22)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 23 ---------------------------------------------*/

trans1_tab_y_value_23        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_23;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (23)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(23)
}

trans1_tab_x_value_23        LIKE VARIABLE   trans1_tab_y_value_23
{   
    REDEFINE    LABEL           TAB_X_LABEL_23;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (23)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (23)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 24 ---------------------------------------------*/

trans1_tab_y_value_24        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_24;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (24)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(24)
}

trans1_tab_x_value_24        LIKE VARIABLE   trans1_tab_y_value_24
{   
    REDEFINE    LABEL           TAB_X_LABEL_24;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (24)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (24)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 25 ---------------------------------------------*/

trans1_tab_y_value_25        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_25;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (25)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(25)
}

trans1_tab_x_value_25        LIKE VARIABLE   trans1_tab_y_value_25
{   
    REDEFINE    LABEL           TAB_X_LABEL_25;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (25)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (25)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 26 ---------------------------------------------*/

trans1_tab_y_value_26        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_26;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (26)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(26)
}

trans1_tab_x_value_26        LIKE VARIABLE   trans1_tab_y_value_26
{   
    REDEFINE    LABEL           TAB_X_LABEL_26;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (26)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (26)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 27 ---------------------------------------------*/

trans1_tab_y_value_27        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_27;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (27)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(27)
}

trans1_tab_x_value_27        LIKE VARIABLE   trans1_tab_y_value_27
{   
    REDEFINE    LABEL           TAB_X_LABEL_27;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (27)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (27)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 28 ---------------------------------------------*/

trans1_tab_y_value_28        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_28;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (28)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(28)
}

trans1_tab_x_value_28        LIKE VARIABLE   trans1_tab_y_value_28
{   
    REDEFINE    LABEL           TAB_X_LABEL_28;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (28)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (28)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 29 ---------------------------------------------*/

trans1_tab_y_value_29        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_29;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (29)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(29)
}

trans1_tab_x_value_29        LIKE VARIABLE   trans1_tab_y_value_29
{   
    REDEFINE    LABEL           TAB_X_LABEL_29;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (29)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (29)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 30 ---------------------------------------------*/

trans1_tab_y_value_30        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_30;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (30)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(30)
}

trans1_tab_x_value_30        LIKE VARIABLE   trans1_tab_y_value_30
{   
    REDEFINE    LABEL           TAB_X_LABEL_30;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (30)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (30)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 31 ---------------------------------------------*/

trans1_tab_y_value_31        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_31;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (31)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(31)
}

trans1_tab_x_value_31        LIKE VARIABLE   trans1_tab_y_value_31
{   
    REDEFINE    LABEL           TAB_X_LABEL_31;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (31)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (31)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 32 ---------------------------------------------*/

trans1_tab_y_value_32        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_32;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (32)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(32)
}

trans1_tab_x_value_32        LIKE VARIABLE   trans1_tab_y_value_32
{   
    REDEFINE    LABEL           TAB_X_LABEL_32;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (32)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (32)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 33 ---------------------------------------------*/

trans1_tab_y_value_33        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_33;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (33)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(33)
}

trans1_tab_x_value_33        LIKE VARIABLE   trans1_tab_y_value_33
{   
    REDEFINE    LABEL           TAB_X_LABEL_33;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (33)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (33)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 34 ---------------------------------------------*/

trans1_tab_y_value_34        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_34;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (34)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(34)
}

trans1_tab_x_value_34        LIKE VARIABLE   trans1_tab_y_value_34
{   
    REDEFINE    LABEL           TAB_X_LABEL_34;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (34)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (34)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 35 ---------------------------------------------*/

trans1_tab_y_value_35        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_35;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (35)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(35)
}

trans1_tab_x_value_35        LIKE VARIABLE   trans1_tab_y_value_35
{   
    REDEFINE    LABEL           TAB_X_LABEL_35;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (35)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (35)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 36 ---------------------------------------------*/

trans1_tab_y_value_36        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_36;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (36)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(36)
}

trans1_tab_x_value_36        LIKE VARIABLE   trans1_tab_y_value_36
{   
    REDEFINE    LABEL           TAB_X_LABEL_36;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (36)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (36)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 37 ---------------------------------------------*/

trans1_tab_y_value_37        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_37;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (37)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(37)
}

trans1_tab_x_value_37        LIKE VARIABLE   trans1_tab_y_value_37
{   
    REDEFINE    LABEL           TAB_X_LABEL_37;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (37)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (37)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 38 ---------------------------------------------*/

trans1_tab_y_value_38        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_38;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (38)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(38)
}

trans1_tab_x_value_38        LIKE VARIABLE   trans1_tab_y_value_38
{   
    REDEFINE    LABEL           TAB_X_LABEL_38;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (38)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (38)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 39 ---------------------------------------------*/

trans1_tab_y_value_39        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_39;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (39)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(39)
}

trans1_tab_x_value_39        LIKE VARIABLE   trans1_tab_y_value_39
{   
    REDEFINE    LABEL           TAB_X_LABEL_39;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (39)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (39)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 40 ---------------------------------------------*/

trans1_tab_y_value_40        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_40;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (40)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(40)
}

trans1_tab_x_value_40        LIKE VARIABLE   trans1_tab_y_value_40
{   
    REDEFINE    LABEL           TAB_X_LABEL_40;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (40)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (40)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 41 ---------------------------------------------*/

trans1_tab_y_value_41        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_41;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (41)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(41)
}

trans1_tab_x_value_41        LIKE VARIABLE   trans1_tab_y_value_41
{   
    REDEFINE    LABEL           TAB_X_LABEL_41;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (41)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (41)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 42 ---------------------------------------------*/

trans1_tab_y_value_42        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_42;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (42)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(42)
}

trans1_tab_x_value_42        LIKE VARIABLE   trans1_tab_y_value_42
{   
    REDEFINE    LABEL           TAB_X_LABEL_42;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (42)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (42)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 43 ---------------------------------------------*/

trans1_tab_y_value_43        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_43;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (43)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(43)
}

trans1_tab_x_value_43        LIKE VARIABLE   trans1_tab_y_value_43
{   
    REDEFINE    LABEL           TAB_X_LABEL_43;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (43)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (43)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 44 ---------------------------------------------*/

trans1_tab_y_value_44        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_44;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (44)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(44)
}

trans1_tab_x_value_44        LIKE VARIABLE   trans1_tab_y_value_44
{   
    REDEFINE    LABEL           TAB_X_LABEL_44;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (44)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (44)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 45 ---------------------------------------------*/

trans1_tab_y_value_45        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_45;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (45)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(45)
}

trans1_tab_x_value_45        LIKE VARIABLE   trans1_tab_y_value_45
{   
    REDEFINE    LABEL           TAB_X_LABEL_45;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (45)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (45)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 46 ---------------------------------------------*/

trans1_tab_y_value_46        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_46;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (46)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(46)
}

trans1_tab_x_value_46        LIKE VARIABLE   trans1_tab_y_value_46
{   
    REDEFINE    LABEL           TAB_X_LABEL_46;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (46)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (46)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 47 ---------------------------------------------*/

trans1_tab_y_value_47        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_47;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (47)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(47)
}

trans1_tab_x_value_47        LIKE VARIABLE   trans1_tab_y_value_47
{   
    REDEFINE    LABEL           TAB_X_LABEL_47;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (47)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (47)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 48 ---------------------------------------------*/

trans1_tab_y_value_48        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_48;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (48)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(48)
}

trans1_tab_x_value_48        LIKE VARIABLE   trans1_tab_y_value_48
{   
    REDEFINE    LABEL           TAB_X_LABEL_48;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (48)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (48)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 49 ---------------------------------------------*/

trans1_tab_y_value_49        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_49;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (49)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(49)
}

trans1_tab_x_value_49        LIKE VARIABLE   trans1_tab_y_value_49
{   
    REDEFINE    LABEL           TAB_X_LABEL_49;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (49)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (49)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 50 ---------------------------------------------*/

trans1_tab_y_value_50        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_50;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (50)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(50)
}

trans1_tab_x_value_50        LIKE VARIABLE   trans1_tab_y_value_50
{   
    REDEFINE    LABEL           TAB_X_LABEL_50;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (50)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (50)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 51 ---------------------------------------------*/

trans1_tab_y_value_51        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_51;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (51)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(51)
}

trans1_tab_x_value_51        LIKE VARIABLE   trans1_tab_y_value_51
{   
    REDEFINE    LABEL           TAB_X_LABEL_51;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (51)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (51)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 52 ---------------------------------------------*/

trans1_tab_y_value_52        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_52;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (52)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(52)
}

trans1_tab_x_value_52        LIKE VARIABLE   trans1_tab_y_value_52
{   
    REDEFINE    LABEL           TAB_X_LABEL_52;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (52)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (52)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 53 ---------------------------------------------*/

trans1_tab_y_value_53        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_53;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (53)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(53)
}

trans1_tab_x_value_53        LIKE VARIABLE   trans1_tab_y_value_53
{   
    REDEFINE    LABEL           TAB_X_LABEL_53;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (53)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (53)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 54 ---------------------------------------------*/

trans1_tab_y_value_54        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_54;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (54)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(54)
}

trans1_tab_x_value_54        LIKE VARIABLE   trans1_tab_y_value_54
{   
    REDEFINE    LABEL           TAB_X_LABEL_54;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (54)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (54)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 55 ---------------------------------------------*/

trans1_tab_y_value_55        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_55;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (55)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(55)
}

trans1_tab_x_value_55        LIKE VARIABLE   trans1_tab_y_value_55
{   
    REDEFINE    LABEL           TAB_X_LABEL_55;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (55)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (55)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 56 ---------------------------------------------*/

trans1_tab_y_value_56        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_56;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (56)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(56)
}

trans1_tab_x_value_56        LIKE VARIABLE   trans1_tab_y_value_56
{   
    REDEFINE    LABEL           TAB_X_LABEL_56;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (56)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (56)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 57 ---------------------------------------------*/

trans1_tab_y_value_57        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_57;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (57)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(57)
}

trans1_tab_x_value_57        LIKE VARIABLE   trans1_tab_y_value_57
{   
    REDEFINE    LABEL           TAB_X_LABEL_57;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (57)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (57)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 58 ---------------------------------------------*/

trans1_tab_y_value_58        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_58;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (58)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(58)
}

trans1_tab_x_value_58        LIKE VARIABLE   trans1_tab_y_value_58
{   
    REDEFINE    LABEL           TAB_X_LABEL_58;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (58)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (58)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 59 ---------------------------------------------*/

trans1_tab_y_value_59        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_59;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (59)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(59)
}

trans1_tab_x_value_59        LIKE VARIABLE   trans1_tab_y_value_59
{   
    REDEFINE    LABEL           TAB_X_LABEL_59;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (59)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (59)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 60 ---------------------------------------------*/

trans1_tab_y_value_60        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_60;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (60)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(60)
}

trans1_tab_x_value_60        LIKE VARIABLE   trans1_tab_y_value_60
{   
    REDEFINE    LABEL           TAB_X_LABEL_60;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (60)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (60)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 61 ---------------------------------------------*/

trans1_tab_y_value_61        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_61;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (61)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(61)
}

trans1_tab_x_value_61        LIKE VARIABLE   trans1_tab_y_value_61
{   
    REDEFINE    LABEL           TAB_X_LABEL_61;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (61)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (61)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 62 ---------------------------------------------*/

trans1_tab_y_value_62        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_62;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (62)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(62)
}

trans1_tab_x_value_62        LIKE VARIABLE   trans1_tab_y_value_62
{   
    REDEFINE    LABEL           TAB_X_LABEL_62;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (62)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (62)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 63 ---------------------------------------------*/

trans1_tab_y_value_63        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_63;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (63)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(63)
}

trans1_tab_x_value_63        LIKE VARIABLE   trans1_tab_y_value_63
{   
    REDEFINE    LABEL           TAB_X_LABEL_63;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (63)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (63)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 64 ---------------------------------------------*/

trans1_tab_y_value_64        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_64;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (64)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(64)
}

trans1_tab_x_value_64        LIKE VARIABLE   trans1_tab_y_value_64
{   
    REDEFINE    LABEL           TAB_X_LABEL_64;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (64)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (64)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 65 ---------------------------------------------*/

trans1_tab_y_value_65        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_65;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (65)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(65)
}

trans1_tab_x_value_65        LIKE VARIABLE   trans1_tab_y_value_65
{   
    REDEFINE    LABEL           TAB_X_LABEL_65;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (65)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (65)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 66 ---------------------------------------------*/

trans1_tab_y_value_66        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_66;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (66)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(66)
}

trans1_tab_x_value_66        LIKE VARIABLE   trans1_tab_y_value_66
{   
    REDEFINE    LABEL           TAB_X_LABEL_66;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (66)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (66)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 67 ---------------------------------------------*/

trans1_tab_y_value_67        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_67;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (67)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(67)
}

trans1_tab_x_value_67        LIKE VARIABLE   trans1_tab_y_value_67
{   
    REDEFINE    LABEL           TAB_X_LABEL_67;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (67)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (67)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 68 ---------------------------------------------*/

trans1_tab_y_value_68        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_68;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (68)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(68)
}

trans1_tab_x_value_68        LIKE VARIABLE   trans1_tab_y_value_68
{   
    REDEFINE    LABEL           TAB_X_LABEL_68;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (68)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (68)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 69 ---------------------------------------------*/

trans1_tab_y_value_69        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_69;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (69)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(69)
}

trans1_tab_x_value_69        LIKE VARIABLE   trans1_tab_y_value_69
{   
    REDEFINE    LABEL           TAB_X_LABEL_69;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (69)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (69)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 70 ---------------------------------------------*/

trans1_tab_y_value_70        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_70;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (70)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(70)
}

trans1_tab_x_value_70        LIKE VARIABLE   trans1_tab_y_value_70
{   
    REDEFINE    LABEL           TAB_X_LABEL_70;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (70)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (70)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 71 ---------------------------------------------*/

trans1_tab_y_value_71        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_71;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (71)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(71)
}

trans1_tab_x_value_71        LIKE VARIABLE   trans1_tab_y_value_71
{   
    REDEFINE    LABEL           TAB_X_LABEL_71;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (71)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (71)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 72 ---------------------------------------------*/

trans1_tab_y_value_72        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_72;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (72)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(72)
}

trans1_tab_x_value_72        LIKE VARIABLE   trans1_tab_y_value_72
{   
    REDEFINE    LABEL           TAB_X_LABEL_72;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (72)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (72)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 73 ---------------------------------------------*/

trans1_tab_y_value_73        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_73;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (73)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(73)
}

trans1_tab_x_value_73        LIKE VARIABLE   trans1_tab_y_value_73
{   
    REDEFINE    LABEL           TAB_X_LABEL_73;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (73)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (73)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 74 ---------------------------------------------*/

trans1_tab_y_value_74        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_74;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (74)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(74)
}

trans1_tab_x_value_74        LIKE VARIABLE   trans1_tab_y_value_74
{   
    REDEFINE    LABEL           TAB_X_LABEL_74;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (74)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (74)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 75 ---------------------------------------------*/

trans1_tab_y_value_75        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_75;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (75)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(75)
}

trans1_tab_x_value_75        LIKE VARIABLE   trans1_tab_y_value_75
{   
    REDEFINE    LABEL           TAB_X_LABEL_75;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (75)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (75)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 76 ---------------------------------------------*/

trans1_tab_y_value_76        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_76;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (76)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(76)
}

trans1_tab_x_value_76        LIKE VARIABLE   trans1_tab_y_value_76
{   
    REDEFINE    LABEL           TAB_X_LABEL_76;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (76)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (76)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 77 ---------------------------------------------*/

trans1_tab_y_value_77        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_77;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (77)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(77)
}

trans1_tab_x_value_77        LIKE VARIABLE   trans1_tab_y_value_77
{   
    REDEFINE    LABEL           TAB_X_LABEL_77;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (77)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (77)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 78 ---------------------------------------------*/

trans1_tab_y_value_78        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_78;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (78)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(78)
}

trans1_tab_x_value_78        LIKE VARIABLE   trans1_tab_y_value_78
{   
    REDEFINE    LABEL           TAB_X_LABEL_78;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (78)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (78)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 79 ---------------------------------------------*/

trans1_tab_y_value_79        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_79;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (79)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(79)
}

trans1_tab_x_value_79        LIKE VARIABLE   trans1_tab_y_value_79
{   
    REDEFINE    LABEL           TAB_X_LABEL_79;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (79)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (79)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 80 ---------------------------------------------*/

trans1_tab_y_value_80        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_80;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (80)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(80)
}

trans1_tab_x_value_80        LIKE VARIABLE   trans1_tab_y_value_80
{   
    REDEFINE    LABEL           TAB_X_LABEL_80;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (80)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (80)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 81 ---------------------------------------------*/

trans1_tab_y_value_81        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_81;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (81)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(81)
}

trans1_tab_x_value_81        LIKE VARIABLE   trans1_tab_y_value_81
{   
    REDEFINE    LABEL           TAB_X_LABEL_81;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (81)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (81)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 82 ---------------------------------------------*/

trans1_tab_y_value_82        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_82;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (82)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(82)
}

trans1_tab_x_value_82        LIKE VARIABLE   trans1_tab_y_value_82
{   
    REDEFINE    LABEL           TAB_X_LABEL_82;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (82)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (82)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 83 ---------------------------------------------*/

trans1_tab_y_value_83        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_83;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (83)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(83)
}

trans1_tab_x_value_83        LIKE VARIABLE   trans1_tab_y_value_83
{   
    REDEFINE    LABEL           TAB_X_LABEL_83;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (83)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (83)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 84 ---------------------------------------------*/

trans1_tab_y_value_84        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_84;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (84)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(84)
}

trans1_tab_x_value_84        LIKE VARIABLE   trans1_tab_y_value_84
{   
    REDEFINE    LABEL           TAB_X_LABEL_84;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (84)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (84)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 85 ---------------------------------------------*/

trans1_tab_y_value_85        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_85;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (85)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(85)
}

trans1_tab_x_value_85        LIKE VARIABLE   trans1_tab_y_value_85
{   
    REDEFINE    LABEL           TAB_X_LABEL_85;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (85)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (85)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 86 ---------------------------------------------*/

trans1_tab_y_value_86        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_86;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (86)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(86)
}

trans1_tab_x_value_86        LIKE VARIABLE   trans1_tab_y_value_86
{   
    REDEFINE    LABEL           TAB_X_LABEL_86;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (86)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (86)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 87 ---------------------------------------------*/

trans1_tab_y_value_87        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_87;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (87)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(87)
}

trans1_tab_x_value_87        LIKE VARIABLE   trans1_tab_y_value_87
{   
    REDEFINE    LABEL           TAB_X_LABEL_87;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (87)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (87)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 88 ---------------------------------------------*/

trans1_tab_y_value_88        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_88;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (88)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(88)
}

trans1_tab_x_value_88        LIKE VARIABLE   trans1_tab_y_value_88
{   
    REDEFINE    LABEL           TAB_X_LABEL_88;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (88)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (88)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 89 ---------------------------------------------*/

trans1_tab_y_value_89        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_89;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (89)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(89)
}

trans1_tab_x_value_89        LIKE VARIABLE   trans1_tab_y_value_89
{   
    REDEFINE    LABEL           TAB_X_LABEL_89;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (89)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (89)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 90 ---------------------------------------------*/

trans1_tab_y_value_90        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_90;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (90)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(90)
}

trans1_tab_x_value_90        LIKE VARIABLE   trans1_tab_y_value_90
{   
    REDEFINE    LABEL           TAB_X_LABEL_90;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (90)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (90)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 91 ---------------------------------------------*/

trans1_tab_y_value_91        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_91;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (91)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(91)
}

trans1_tab_x_value_91        LIKE VARIABLE   trans1_tab_y_value_91
{   
    REDEFINE    LABEL           TAB_X_LABEL_91;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (91)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (91)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 92 ---------------------------------------------*/

trans1_tab_y_value_92        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_92;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (92)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(92)
}

trans1_tab_x_value_92        LIKE VARIABLE   trans1_tab_y_value_92
{   
    REDEFINE    LABEL           TAB_X_LABEL_92;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (92)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (92)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 93 ---------------------------------------------*/

trans1_tab_y_value_93        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_93;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (93)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(93)
}

trans1_tab_x_value_93        LIKE VARIABLE   trans1_tab_y_value_93
{   
    REDEFINE    LABEL           TAB_X_LABEL_93;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (93)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (93)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 94 ---------------------------------------------*/

trans1_tab_y_value_94        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_94;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (94)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(94)
}

trans1_tab_x_value_94        LIKE VARIABLE   trans1_tab_y_value_94
{   
    REDEFINE    LABEL           TAB_X_LABEL_94;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (94)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (94)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 95 ---------------------------------------------*/

trans1_tab_y_value_95        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_95;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (95)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(95)
}

trans1_tab_x_value_95        LIKE VARIABLE   trans1_tab_y_value_95
{   
    REDEFINE    LABEL           TAB_X_LABEL_95;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (95)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (95)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 96 ---------------------------------------------*/

trans1_tab_y_value_96        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_96;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (96)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(96)
}

trans1_tab_x_value_96        LIKE VARIABLE   trans1_tab_y_value_96
{   
    REDEFINE    LABEL           TAB_X_LABEL_96;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (96)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (96)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 97 ---------------------------------------------*/

trans1_tab_y_value_97        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_97;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (97)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(97)
}

trans1_tab_x_value_97        LIKE VARIABLE   trans1_tab_y_value_97
{   
    REDEFINE    LABEL           TAB_X_LABEL_97;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (97)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (97)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 98 ---------------------------------------------*/

trans1_tab_y_value_98        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_98;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (98)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(98)
}

trans1_tab_x_value_98        LIKE VARIABLE   trans1_tab_y_value_98
{   
    REDEFINE    LABEL           TAB_X_LABEL_98;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (98)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (98)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 99 ---------------------------------------------*/

trans1_tab_y_value_99        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_99;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (99)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(99)
}

trans1_tab_x_value_99        LIKE VARIABLE   trans1_tab_y_value_99
{   
    REDEFINE    LABEL           TAB_X_LABEL_99;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (99)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (99)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 100 --------------------------------------------*/

trans1_tab_y_value_100        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_100;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (100)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(100)
}

trans1_tab_x_value_100        LIKE VARIABLE   trans1_tab_y_value_100
{   
    REDEFINE    LABEL           TAB_X_LABEL_100;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (100)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (100)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 101 --------------------------------------------*/

trans1_tab_y_value_101        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_101;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (101)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(101)
}

trans1_tab_x_value_101        LIKE VARIABLE   trans1_tab_y_value_101
{   
    REDEFINE    LABEL           TAB_X_LABEL_101;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (101)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (101)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 102 --------------------------------------------*/

trans1_tab_y_value_102        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_102;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (102)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(102)
}

trans1_tab_x_value_102        LIKE VARIABLE   trans1_tab_y_value_102
{   
    REDEFINE    LABEL           TAB_X_LABEL_102;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (102)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (102)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 102 --------------------------------------------*/

trans1_tab_y_value_103        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_103;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (103)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(103)
}

trans1_tab_x_value_103        LIKE VARIABLE   trans1_tab_y_value_103
{   
    REDEFINE    LABEL           TAB_X_LABEL_103;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (103)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (103)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 104 --------------------------------------------*/

trans1_tab_y_value_104        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_104;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (104)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(104)
}

trans1_tab_x_value_104        LIKE VARIABLE   trans1_tab_y_value_104
{   
    REDEFINE    LABEL           TAB_X_LABEL_104;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (104)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (104)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 105 --------------------------------------------*/

trans1_tab_y_value_105        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_105;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (105)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(105)
}

trans1_tab_x_value_105        LIKE VARIABLE   trans1_tab_y_value_105
{   
    REDEFINE    LABEL           TAB_X_LABEL_105;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (105)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (105)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 106 --------------------------------------------*/

trans1_tab_y_value_106        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_106;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (106)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(106)
}

trans1_tab_x_value_106        LIKE VARIABLE   trans1_tab_y_value_106
{   
    REDEFINE    LABEL           TAB_X_LABEL_106;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (106)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (106)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 107 --------------------------------------------*/

trans1_tab_y_value_107        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_107;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (107)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(107)
}

trans1_tab_x_value_107        LIKE VARIABLE   trans1_tab_y_value_107
{   
    REDEFINE    LABEL           TAB_X_LABEL_107;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (107)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (107)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 108 --------------------------------------------*/

trans1_tab_y_value_108        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_108;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (108)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(108)
}

trans1_tab_x_value_108        LIKE VARIABLE   trans1_tab_y_value_108
{   
    REDEFINE    LABEL           TAB_X_LABEL_108;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (108)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (108)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 109 --------------------------------------------*/

trans1_tab_y_value_109        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_109;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (109)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(109)
}

trans1_tab_x_value_109        LIKE VARIABLE   trans1_tab_y_value_109
{   
    REDEFINE    LABEL           TAB_X_LABEL_109;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (109)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (109)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 110 --------------------------------------------*/

trans1_tab_y_value_110        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_110;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (110)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(110)
}

trans1_tab_x_value_110        LIKE VARIABLE   trans1_tab_y_value_110
{   
    REDEFINE    LABEL           TAB_X_LABEL_110;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (110)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (110)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 111 --------------------------------------------*/

trans1_tab_y_value_111        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_111;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (111)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(111)
}

trans1_tab_x_value_111        LIKE VARIABLE   trans1_tab_y_value_111
{   
    REDEFINE    LABEL           TAB_X_LABEL_111;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (111)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (111)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 112 --------------------------------------------*/

trans1_tab_y_value_112        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_112;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (112)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(112)
}

trans1_tab_x_value_112        LIKE VARIABLE   trans1_tab_y_value_112
{   
    REDEFINE    LABEL           TAB_X_LABEL_112;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (112)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (112)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 113 --------------------------------------------*/

trans1_tab_y_value_113        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_113;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (113)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(113)
}

trans1_tab_x_value_113        LIKE VARIABLE   trans1_tab_y_value_113
{   
    REDEFINE    LABEL           TAB_X_LABEL_113;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (113)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (113)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 114 --------------------------------------------*/

trans1_tab_y_value_114        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_114;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (114)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(114)
}

trans1_tab_x_value_114        LIKE VARIABLE   trans1_tab_y_value_114
{   
    REDEFINE    LABEL           TAB_X_LABEL_114;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (114)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (114)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 115 --------------------------------------------*/

trans1_tab_y_value_115        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_115;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (115)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(115)
}

trans1_tab_x_value_115        LIKE VARIABLE   trans1_tab_y_value_115
{   
    REDEFINE    LABEL           TAB_X_LABEL_115;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (115)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (115)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 116 --------------------------------------------*/

trans1_tab_y_value_116        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_116;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (116)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(116)
}

trans1_tab_x_value_116        LIKE VARIABLE   trans1_tab_y_value_116
{   
    REDEFINE    LABEL           TAB_X_LABEL_116;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (116)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (116)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 117 --------------------------------------------*/

trans1_tab_y_value_117        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_117;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (117)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(117)
}

trans1_tab_x_value_117        LIKE VARIABLE   trans1_tab_y_value_117
{   
    REDEFINE    LABEL           TAB_X_LABEL_117;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (117)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (117)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 118 --------------------------------------------*/

trans1_tab_y_value_118        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_118;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (118)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(118)
}

trans1_tab_x_value_118        LIKE VARIABLE   trans1_tab_y_value_118
{   
    REDEFINE    LABEL           TAB_X_LABEL_118;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (118)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (118)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 119 --------------------------------------------*/

trans1_tab_y_value_119        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_119;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (119)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(119)
}

trans1_tab_x_value_119        LIKE VARIABLE   trans1_tab_y_value_119
{   
    REDEFINE    LABEL           TAB_X_LABEL_119;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (119)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (119)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 120 --------------------------------------------*/

trans1_tab_y_value_120        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_120;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (120)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(120)
}

trans1_tab_x_value_120        LIKE VARIABLE   trans1_tab_y_value_120
{   
    REDEFINE    LABEL           TAB_X_LABEL_120;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (120)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (120)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 121 --------------------------------------------*/

trans1_tab_y_value_121        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_121;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (121)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(121)
}

trans1_tab_x_value_121        LIKE VARIABLE   trans1_tab_y_value_121
{   
    REDEFINE    LABEL           TAB_X_LABEL_121;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (121)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (121)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 122 --------------------------------------------*/

trans1_tab_y_value_122        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_122;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (122)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(122)
}

trans1_tab_x_value_122        LIKE VARIABLE   trans1_tab_y_value_122
{   
    REDEFINE    LABEL           TAB_X_LABEL_122;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (122)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (122)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 123 --------------------------------------------*/

trans1_tab_y_value_123        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_123;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (123)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(123)
}

trans1_tab_x_value_123        LIKE VARIABLE   trans1_tab_y_value_123
{   
    REDEFINE    LABEL           TAB_X_LABEL_123;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (123)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (123)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 124 --------------------------------------------*/

trans1_tab_y_value_124        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_124;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (124)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(124)
}

trans1_tab_x_value_124        LIKE VARIABLE   trans1_tab_y_value_124
{   
    REDEFINE    LABEL           TAB_X_LABEL_124;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (124)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (124)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 125 --------------------------------------------*/

trans1_tab_y_value_125        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_125;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (125)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(125)
}

trans1_tab_x_value_125        LIKE VARIABLE   trans1_tab_y_value_125
{   
    REDEFINE    LABEL           TAB_X_LABEL_125;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (125)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (125)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 126 --------------------------------------------*/

trans1_tab_y_value_126        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_126;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (126)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(126)
}

trans1_tab_x_value_126        LIKE VARIABLE   trans1_tab_y_value_126
{   
    REDEFINE    LABEL           TAB_X_LABEL_126;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (126)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (126)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/
/*--- x|y-Value: Entry 127 --------------------------------------------*/

trans1_tab_y_value_127        LIKE VARIABLE   trans1_tab_y_value_0
{
    REDEFINE    LABEL           TAB_Y_LABEL_127;
    REDEFINE    POST_WRITE_ACTIONS
    {
        method_end_table_transfer (127)
    }
    REDEFINE VALIDITY    VALID_LIN_TABLE_XY(127)
}

trans1_tab_x_value_127        LIKE VARIABLE   trans1_tab_y_value_127
{   
    REDEFINE    LABEL           TAB_X_LABEL_127;
    REDEFINE    HELP            [lin_tab_x_value_help];
    REDEFINE    PRE_READ_ACTIONS
    {
        method_set_tab_entry (127)
    }
    REDEFINE    PRE_WRITE_ACTIONS
    {
        method_set_tab_entry (127)
    }
    DELETE POST_WRITE_ACTIONS;
}


/*---------------------------------------------------------------------*/


/***********************************************************************/
/*    Transducer Block Man.Spec.					   */
/***********************************************************************/

VARIABLE trans1_INPUT_LOWER_RANGE /*index 62*/
{
  LABEL [trans1_INPUT_LOWER_RANGE_LABEL];
  HELP  [trans1_INPUT_LOWER_RANGE_HELP];
  CLASS CONTAINED;
  TYPE FLOAT
  {
    DEFAULT_VALUE trans1_lower_sensor_limit;
	MAX_VALUE trans1_upper_sensor_limit	;
	MIN_VALUE trans1_lower_sensor_limit;
  }
  HANDLING READ & WRITE;
}


COMMAND read_trans1_INPUT_LOWER_RANGE
{
     BLOCK transducer_block_1;
     INDEX 62;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             trans1_INPUT_LOWER_RANGE
          }


     }
}
COMMAND write_trans1_INPUT_LOWER_RANGE
{
     BLOCK transducer_block_1;
     INDEX 62;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             trans1_INPUT_LOWER_RANGE
          }
          REPLY
          {
          }


     }
}
VARIABLE trans1_INPUT_UPPER_RANGE
{
  LABEL [trans1_INPUT_UPPER_RANGE_LABEL];
  HELP  [trans1_INPUT_UPPER_RANGE_HELP];
  CLASS CONTAINED;
  TYPE FLOAT
  {
    DEFAULT_VALUE trans1_upper_sensor_limit;
	MAX_VALUE trans1_upper_sensor_limit;
	MIN_VALUE trans1_lower_sensor_limit;

  }
  HANDLING READ & WRITE;
}


COMMAND read_trans1_INPUT_UPPER_RANGE
{
     BLOCK transducer_block_1;
     INDEX 63;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             trans1_INPUT_UPPER_RANGE
          }


     }
}
COMMAND write_trans1_INPUT_UPPER_RANGE
{
     BLOCK transducer_block_1;
     INDEX 63;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             trans1_INPUT_UPPER_RANGE
          }
          REPLY
          {
          }


     }
}

VARIABLE trans1_ADC_CAL_INDEX
{
  LABEL [trans1_ADC_CAL_INDEX_LABEL];
  HELP  [trans1_ADC_CAL_INDEX_HELP];
  CLASS CONTAINED & DYNAMIC;
  TYPE UNSIGNED_INTEGER (4)
  {
    DEFAULT_VALUE 0;
  }
  HANDLING READ & WRITE;
}


COMMAND read_trans1_ADC_CAL_INDEX
{
     BLOCK transducer_block_1;
     INDEX 64;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             trans1_ADC_CAL_INDEX
          }


     }
}
COMMAND write_trans1_ADC_CAL_INDEX
{
     BLOCK transducer_block_1;
     INDEX 64;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             trans1_ADC_CAL_INDEX
          }
          REPLY
          {
          }


     }
}



/***********************************************************************/
/*    Function Block                                                   */
/***********************************************************************/

BLOCK function_block_1
{
	TYPE	FUNCTION;
	NUMBER	1;
}

func1_AI_blk_reserve						LIKE VARIABLE	phys_blk_reserve
{
}

VARIABLE func1_AI_blk_object
{
	LABEL		[blk_block_object];
	HELP		[blk_block_object_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	2,	[blk_block_object_FUNCTION]		}
	}
	HANDLING	READ;
}

VARIABLE func1_AI_blk_parent_class
{
	LABEL		[blk_parent_class];
	HELP		[func_blk_parent_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	1,	[func_blk_parent_class_INPUT]	}
	}
	HANDLING	READ;
}

VARIABLE func1_AI_blk_class
{
	LABEL		[blk_class];
	HELP		[func_blk_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	1,	[func_blk_class_AI]			}
	}	
	HANDLING	READ;
}

func1_AI_blk_dd_reference						LIKE VARIABLE	phys_blk_dd_reference
{											
}											
											
func1_AI_blk_dd_rev							LIKE VARIABLE	phys_blk_dd_rev
{											
}											
											
func1_AI_blk_profile							LIKE VARIABLE	phys_blk_profile
{
}

func1_AI_blk_profile_rev						LIKE VARIABLE	phys_blk_profile_rev
{											
}											
											
func1_AI_blk_execution_time					LIKE VARIABLE	phys_blk_execution_time
{											
}											
											
func1_AI_blk_num_parameters					LIKE VARIABLE	phys_blk_num_parameters
{											
}											
											
func1_AI_blk_index_view_1						LIKE VARIABLE	phys_blk_index_view_1
{											
}											
											
func1_AI_blk_num_view_lists					LIKE VARIABLE	phys_blk_num_view_lists
{											
}											
											
func1_AI_st_rev								LIKE VARIABLE	phys_st_rev
{											
}											
											
func1_AI_tag_desc								LIKE VARIABLE	phys_tag_desc
{											
}											
											
func1_AI_strategy								LIKE VARIABLE	phys_strategy
{											
}											
											
func1_AI_alert_key								LIKE VARIABLE	phys_alert_key
{
}

VARIABLE func1_AI_target_mode
{
	LABEL		[target_mode];		
	HELP		[target_mode_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0x08;
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_actual_mode
{
	LABEL		[actual_mode];		
	HELP		[actual_mode_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0x08;
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ;
}

VARIABLE func1_AI_permitted_mode
{
	LABEL		[permitted_mode];		
	HELP		[permitted_mode_help];
	CLASS		CONTAINED;
	TYPE		BIT_ENUMERATED (1)
	{
		DEFAULT_VALUE	0x08;
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ;
}

VARIABLE func1_AI_normal_mode
{
	LABEL		[normal_mode];		
	HELP		[normal_mode_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0x08;
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ;
}

func1_AI_current_state_alarm_sum				LIKE VARIABLE	phys_current_state_alarm_sum
{
	REDEFINE TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x0200,	[limit_state_HI_HI]		},
		{	0x0400,	[limit_state_HI]		},
		{	0x0800,	[limit_state_LO_LO]		},
		{	0x1000,	[limit_state_LO]		},
		{	0x8000,	[limit_state_ST_REV]	}
	}

}

func1_AI_unacknowledged_state_alarm_sum		LIKE VARIABLE	phys_unacknowledged_state_alarm_sum
{
	REDEFINE TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x0200,	[limit_state_HI_HI]		},
		{	0x0400,	[limit_state_HI]		},
		{	0x0800,	[limit_state_LO_LO]		},
		{	0x1000,	[limit_state_LO]		},
		{	0x8000,	[limit_state_ST_REV]	}
	}
}

func1_AI_unreported_state_alarm_sum			LIKE VARIABLE	phys_unreported_state_alarm_sum
{
	REDEFINE TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x0200,	[limit_state_HI_HI]		},
		{	0x0400,	[limit_state_HI]		},
		{	0x0800,	[limit_state_LO_LO]		},
		{	0x1000,	[limit_state_LO]		},
		{	0x8000,	[limit_state_ST_REV]	}
	}
}

func1_AI_disabled_state_alarm_sum				LIKE VARIABLE	phys_disabled_state_alarm_sum
{
	REDEFINE TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x0200,	[limit_state_HI_HI]		},
		{	0x0400,	[limit_state_HI]		},
		{	0x0800,	[limit_state_LO_LO]		},
		{	0x1000,	[limit_state_LO]		},
		{	0x8000,	[limit_state_ST_REV]	}
	}
}

VARIABLE func1_AI_batch_id	 /*index 8*/
{
	LABEL		[func_batch_id];		
	HELP		[func_batch_id_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (4)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_batch_unit  /*index 8*/
{
	LABEL		[func_batch_unit];		
	HELP		[func_batch_unit_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_batch_operation/*index 8*/
{
	LABEL		[func_batch_operation];		
	HELP		[func_batch_operation_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_batch_phase/*index 8*/
{
	LABEL		[func_batch_phase];		
	HELP		[func_batch_phase_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_out_value	 /*index 10*/
{
	LABEL		[func_out_value];
	HELP		[func_ai_out_value_help];
	CLASS		OUTPUT & DYNAMIC;
	TYPE        FLOAT
	{
		DEFAULT_VALUE	0.0;
		DISPLAY_FORMAT	"7.3f";
	}
   
   HANDLING	IF (func1_AI_target_mode == BLOCK_MODE_MAN)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
 
}

VARIABLE func1_AI_out_status_quality  /*index 10*/
{
	LABEL		[status_quality];
	HELP		[func_out_status_help];
	CLASS		OUTPUT & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
	   	STATUS_OUTPUT_NO_RCAS
	}
	POST_EDIT_ACTIONS
	{
		IF (func1_AI_target_mode == BLOCK_MODE_MAN)
		{
			method_set_status_limit
		}
	}
   
	 HANDLING	IF (func1_AI_target_mode == BLOCK_MODE_MAN)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}

/*index 10*/
VARIABLE func1_AI_out_status_limit	
{
	LABEL		[status_limit];
	HELP		[func_out_status_help];
	CLASS		OUTPUT & DYNAMIC;				
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_INPUT_LIMIT (func1_AI_out_status_quality)
	}
	HANDLING	IF (func1_AI_target_mode == BLOCK_MODE_MAN)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}


VARIABLE func1_AI_pv_upper_range_value	/*index 11*/
{
	LABEL		[func_pv_scale_upper_value];
	HELP		[func_pv_scale_upper_value_help];
	CLASS		CONTAINED;
	TYPE        FLOAT
	{
	  	DEFAULT_VALUE trans1_upper_sensor_limit;
	  /*	MAX_VALUE trans1_upper_sensor_limit;
	    	MIN_VALUE trans1_lower_sensor_limit;
			*/

	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_pv_lower_range_value	/*index 11*/
{
	LABEL		[func_pv_scale_lower_value];
	HELP		[func_pv_scale_lower_value_help];
	CLASS		CONTAINED;
	TYPE        FLOAT
	{
	 	DEFAULT_VALUE trans1_lower_sensor_limit;
	  /*	MAX_VALUE trans1_upper_sensor_limit;
	  		MIN_VALUE trans1_lower_sensor_limit;
		*/

	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_out_upper_range_value	  /*index 12*/
{
	LABEL		[func_upper_value];
	HELP		[func_out_scale_upper_value_help];
	CLASS		CONTAINED;
	TYPE        FLOAT
	{
		
	   	DEFAULT_VALUE IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){	upper_sensor_limit_def;}ELSE{0;}
	 /*	MAX_VALUE IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){		upper_sensor_limit_def;}ELSE{FLOAT_MAX;}
	 	MIN_VALUE IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){		lower_sensor_limit_def;}ELSE{FLOAT_MIN;}
	 */	

	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_out_lower_range_value	 /*index 12*/
{
	LABEL		[func_lower_value];
	HELP		[func_out_scale_lower_value_help];
	CLASS		CONTAINED;
	TYPE        FLOAT
	{

	   	DEFAULT_VALUE IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){ lower_sensor_limit_def;}ELSE{0;}
	  /*	MAX_VALUE IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){	  upper_sensor_limit_def;}ELSE{FLOAT_MAX;}
	    	MIN_VALUE IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){	  lower_sensor_limit_def;}ELSE{FLOAT_MIN;}
	   */

	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_out_unit	  /*index 12*/
{
	LABEL		[digital_units];	
	HELP		[digital_units_help];
	CLASS		CONTAINED & SERVICE;
	TYPE		ENUMERATED (2)
	{
		DEFAULT_VALUE 1001;

			/*  V	*/	{ 1240,	[unit_1240],	[unit_1240_help]	},
			/* mV	*/	{ 1243,	[unit_1243],	[unit_1243_help]	},
			/* Ohm	*/	{ 1281,	[unit_1281],	[unit_1281_help]	},
			/* K	*/	{ 1000,	[unit_1000],	[unit_1000_help]	},
			/* degC	*/	{ 1001,	[unit_1001],	[unit_1001_help]	},
			/* degF	*/	{ 1002,	[unit_1002],	[unit_1002_help]	},
			/* Rk	*/	{ 1003,	[unit_1003],	[unit_1003_help]	},
			/* %	*/	{ 1342,	[unit_1342],	[unit_1342_help]	},
			/* mA	*/	{ 1211,	[unit_1211],	[unit_1211_help]	},
			/* Hz	*/	{ 1077,	[unit_1077],	[unit_1077_help]	},
			/* s	*/	{ 1054,	[unit_1054],	[unit_1054_help]	}



	}
	HANDLING	READ & WRITE;

	POST_EDIT_ACTIONS
	{
	   	method_set_upper_and_lower_values_func_default,
		method_set_upper_and_lower_values_conformance_default
	}
	POST_READ_ACTIONS
	{
	   	method_set_upper_and_lower_values_func_default
		
	}

}

VARIABLE func1_AI_out_decimal_point	 /*index 12*/
{
	LABEL		[decimal_point];
	HELP		[decimal_point_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	3;
		{	0,   "0"		},
		{	1,   "1"		},
		{	2,   "2"		},
		{	3,   "3"		},
		{	4,   [phys_LCD_PRECISION_4]		}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_lin_type	/*index 13*/
{
	LABEL		[trans_lin_type];
	HELP		[trans_lin_type_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{ 0,	[linear]	}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_channel  /*index 14*/
{
	LABEL		[func_channel];
	HELP		[func_channel_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		DEFAULT_VALUE		0x0108	;
		{ 0x0108,  [func1_AI_channel_1] 	},
		{ 0x0110,  [func1_AI_channel_2] }
   	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_pv_ftime  /*index 16*/
{
	LABEL		[func_pv_ftime_label];
	HELP		[func_pv_ftime_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
		MIN_VALUE		0.0;
		MAX_VALUE		30.0;
	}
	CONSTANT_UNIT	[sec];
	HANDLING	READ & WRITE;
}


VARIABLE func1_AI_FSafeType /*idnex 17*/
{
	/* ST_REV */
	LABEL		[func_ao_fsafe_type];
	HELP		[func_ao_fsafe_type_help_PROFILE_3];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE    1;
		{ 0, 	[func1_AI_FSafeType_0]		},
		{ 1,	[func1_AI_FSafeType_1]		},
		{ 2, 	[func1_AI_FSafeType_2]		}
	}
   HANDLING  READ & WRITE;
}


VARIABLE func1_AI_FSafeValue /* index 18*/
{
   /* ST_REV */
   LABEL     [func_ao_fsafe_value] ;
   HELP      [func_ao_fsafe_value_help];
   CLASS     CONTAINED;
   TYPE      FLOAT
   {
      DEFAULT_VALUE    0;
   }
   HANDLING  READ & WRITE;
}


VARIABLE func1_AI_alarm_hys	 /* index 19*/
{
	LABEL		[limit_hysteresis];
	HELP		[limit_hysteresis_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE 5.0;
		DISPLAY_FORMAT	"7.3f";	
	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_hi_hi_lim	 /* index 21*/
{
	LABEL		[limit_hi_hi];
	HELP		[limit_hi_hi_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
																				 
	   	DEFAULT_VALUE 	IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){ upper_sensor_limit_def;}ELSE{0;}
	 /*	MAX_VALUE 		IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){	  upper_sensor_limit_def;}ELSE{FLOAT_MAX;}
	 	MIN_VALUE 		IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){	  lower_sensor_limit_def;}ELSE{FLOAT_MIN;}
	 */

		}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_hi_lim /* index 22*/
{
	LABEL		[limit_hi];
	HELP		[limit_hi_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
	   	DEFAULT_VALUE IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){upper_sensor_limit_con;}ELSE{0;}
	  /*	MAX_VALUE IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){	 upper_sensor_limit_con;}ELSE{FLOAT_MAX;}
	    	MIN_VALUE IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){	 lower_sensor_limit_con;}ELSE{FLOAT_MIN;}
	   */

	  
	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_lo_lim  /* index 25*/
{
	LABEL		[limit_lo];
	HELP		[limit_lo_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
	   	DEFAULT_VALUE IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){ lower_sensor_limit_con;}ELSE{0;}
	   /*	MAX_VALUE IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){	 upper_sensor_limit_con;}ELSE{FLOAT_MAX;}
	    	MIN_VALUE IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){	 lower_sensor_limit_con;}ELSE{FLOAT_MIN;}
		*/

	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_lo_lo_lim	/* index 27*/
{
	LABEL		[limit_lo_lo];
	HELP		[limit_lo_lo_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{

																					   
																					   
																					   
	   	DEFAULT_VALUE IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){ lower_sensor_limit_def;}ELSE{0;}
	  /*	MAX_VALUE IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){	  upper_sensor_limit_def;}ELSE{FLOAT_MAX;}
	    	MIN_VALUE IF(  (func1_AI_out_unit!=1077) && (func1_AI_out_unit!=1211) && (func1_AI_out_unit!=1054) ){	  lower_sensor_limit_def;}ELSE{FLOAT_MIN;}
	   */


	}
	HANDLING	READ & WRITE;
}

VARIABLE func1_AI_hi_hi_alm_unacknowledged	  /* index 30*/
{
	LABEL		[limit_alarm_unacknowledged];
	HELP		[limit_alarm_unacknowledged_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
}

VARIABLE func1_AI_hi_hi_alm_state
{
	LABEL		[limit_state];
	HELP		[limit_hi_hi_state_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[limit_state_NO_ALARM]	},
		{	1,	[limit_state_HI_HI]		}
	}
	HANDLING	READ;
}

VARIABLE func1_AI_hi_hi_alm_time_stamp 	
{
	LABEL		[limit_time_stamp];
	HELP		[limit_time_stamp_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE        TIME;
	HANDLING	READ;
}

VARIABLE func1_AI_hi_hi_alm_subcode
{
	LABEL		[limit_subcode];
	HELP		[limit_hi_hi_subcode_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
}

VARIABLE func1_AI_hi_hi_alm_value
{
	LABEL		[limit_alarm_value];
	HELP		[limit_hi_hi_alarm_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	HANDLING	READ;
}	

VARIABLE func1_AI_hi_alm_unacknowledged	  /* index 31*/
{
	LABEL		[limit_warn_unacknowledged];
	HELP		[limit_warn_unacknowledged_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
}

VARIABLE func1_AI_hi_alm_state
{
	LABEL		[limit_state];
	HELP		[limit_hi_state_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[limit_state_NO_WARNING]	},
		{	1,	[limit_state_HI]			}
	}
	HANDLING	READ;
}

VARIABLE func1_AI_hi_alm_time_stamp 	
{
	LABEL		[limit_time_stamp];
	HELP		[limit_time_stamp_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE        TIME;
	HANDLING	READ;
}

VARIABLE func1_AI_hi_alm_subcode
{
	LABEL		[limit_subcode];
	HELP		[limit_hi_subcode_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
}

VARIABLE func1_AI_hi_alm_value
{
	LABEL		[limit_warn_value];
	HELP		[limit_hi_warn_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	HANDLING	READ;
}

VARIABLE func1_AI_lo_alm_unacknowledged	 /* index 32*/
{
	LABEL		[limit_warn_unacknowledged];
	HELP		[limit_warn_unacknowledged_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
}

VARIABLE func1_AI_lo_alm_state
{
	LABEL		[limit_state];
	HELP		[limit_lo_state_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[limit_state_NO_WARNING]	},
		{	1,	[limit_state_LO]			}
	}
	HANDLING	READ;
}

VARIABLE func1_AI_lo_alm_time_stamp 	
{
	LABEL		[limit_time_stamp];
	HELP		[limit_time_stamp_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE        TIME;
	HANDLING	READ;
}

VARIABLE func1_AI_lo_alm_subcode
{
	LABEL		[limit_subcode];
	HELP		[limit_lo_subcode_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
}

VARIABLE func1_AI_lo_alm_value
{
	LABEL		[limit_warn_value];
	HELP		[limit_lo_warn_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	HANDLING	READ;
}

VARIABLE func1_AI_lo_lo_alm_unacknowledged	 /* index 33*/
{
	LABEL		[limit_alarm_unacknowledged];
	HELP		[limit_alarm_unacknowledged_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
}

VARIABLE func1_AI_lo_lo_alm_state
{
	LABEL		[limit_state];
	HELP		[limit_lo_lo_state_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[limit_state_NO_ALARM]		},
		{	1,	[limit_state_LO_LO]			}
	}
	HANDLING	READ;
}

VARIABLE func1_AI_lo_lo_alm_time_stamp 	
{
	LABEL		[limit_time_stamp];
	HELP		[limit_time_stamp_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE        TIME;
	HANDLING	READ;
}

VARIABLE func1_AI_lo_lo_alm_subcode
{
	LABEL		[limit_subcode];
	HELP		[limit_lo_lo_subcode_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
}

VARIABLE func1_AI_lo_lo_alm_value
{
	LABEL		[limit_alarm_value];
	HELP		[limit_lo_lo_alarm_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	HANDLING	READ;
}

VARIABLE func1_AI_simulate_value  /* index 34*/
{
	LABEL		[func_simulate_value];
	HELP		[func_ai_simulate_value_help];
	CLASS		CONTAINED & SERVICE;
	TYPE        FLOAT
	{
		DEFAULT_VALUE	0.0;
	}   
	HANDLING	IF (func1_AI_simulation_enabled == 1)
		{
			READ & WRITE;
		}
		ELSE
		{
			READ;
		}
}

VARIABLE func1_AI_simulate_status_quality
{
	LABEL		[status_quality];
	HELP		[func_simulate_status_help];
	CLASS		CONTAINED & SERVICE;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
	   	STATUS_INPUT_NO_RCAS
	}
	POST_EDIT_ACTIONS
	{
		IF (func1_AI_simulation_enabled == 1)
			{
				method_set_status_limit
			}
	}
	HANDLING	IF (func1_AI_simulation_enabled == 1)
		{
			READ & WRITE;
		}
		ELSE
		{
			READ;
		}
}

VARIABLE func1_AI_simulate_status_limit
{
	LABEL		[status_limit];
	HELP		[func_simulate_status_help];
	CLASS		CONTAINED & SERVICE;				
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_INPUT_LIMIT (func1_AI_simulate_status_quality)
	}
	HANDLING	IF (func1_AI_simulation_enabled == 1)
		{
			READ & WRITE;
		}
		ELSE
		{
			READ;
		}
}


VARIABLE func1_AI_simulation_enabled
{
	LABEL		[func_simulation_enabled];
	HELP		[func_simulation_enabled_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[disabled]		},
		{	1,	[enabled]		}
	}
	HANDLING	READ & WRITE;
}


/*******************************************************************************/
/*****	MENU Bar  **************************************************************/
/*******************************************************************************/

MENU Menu_Main_Specialist
{
	LABEL		[main_menu];
	ITEMS
	{
		Menu_File,
		Menu_S_Device,
		Menu_S_View,
		Menu_S_Options,
		Menu_Help
	}
}

MENU Menu_Main_Maintenance
{
	LABEL		[main_menu];
	ITEMS
	{
		Menu_File,
		Menu_M_Device,
		Menu_M_View,
		Menu_M_Options,
		Menu_Help
	}
}

/*---------------------------------------------------------------------*/
/*    Menu: Device													   */
/*---------------------------------------------------------------------*/

MENU Menu_S_Device
{
	LABEL		[menu_Device];
	ITEMS
	{
		std_NodeAddress,
		SEPARATOR,
		std_LoadinDevice,										
		std_LoadinPC,
		SEPARATOR,
		Menu_sensor_trim,
		SEPARATOR,
		OnlineWindow_simulation,
		OnlineDialog_reset,
		SEPARATOR,
	   	OnlineDialog_write_locking
	}
}

MENU Menu_M_Device
{
	LABEL		[menu_Device];
	ITEMS
	{
		std_LoadinDevice,										
		std_LoadinPC											
	}
}


METHOD std_NodeAddress
{
	LABEL		[menu_Device_NodeAddress];
	DEFINITION
	{
	}
}

METHOD std_LoadinDevice
{
	LABEL		[menu_Device_LoadinDevice];
	DEFINITION
	{
	}
}

METHOD std_LoadinPC
{
	LABEL		[menu_Device_LoadinPC];
	DEFINITION
	{
	}
}

/*---------------------------------------------------------------------*/
/*    Menu: View													   */
/*---------------------------------------------------------------------*/

MENU Menu_S_View
{
	LABEL		[menu_View];
	ITEMS
	{
		OnlineWindow_display,
		OnlineWindow_yt,
		OfflineWindow_Kennlinie,
		OnlineWindow_kennlinie_2,
		OnlineWindow_S_alarm,
		OnlineWindow_diagnosis,
		SEPARATOR,
		std_Funktionsleiste,
		std_Statuszeile,
		SEPARATOR,
		std_Update
	}
}

MENU Menu_M_View
{
	LABEL		[menu_View];
	ITEMS
	{
		OnlineWindow_display,
		OnlineWindow_yt,
		OfflineWindow_Kennlinie,
		OnlineWindow_M_alarm,
		OnlineWindow_diagnosis,
		SEPARATOR,
		std_Funktionsleiste,
		std_Statuszeile,
		SEPARATOR,
		std_Update
	}
}

METHOD std_Funktionsleiste
{
	LABEL		[menu_View_Toolbar];
	DEFINITION
	{
	}
}

METHOD std_Statuszeile
{
	LABEL		[menu_View_Statusbar];
	DEFINITION
	{
	}
}

METHOD std_Update
{
	LABEL		[menu_View_Update];
	DEFINITION
	{
	}
}

/*******************************************************************************/
/*****	Online-Windows  ********************************************************/
/*******************************************************************************/

/*---------------------------------------------------------------------*/
/*    OnlineWindow: Display											   */
/*---------------------------------------------------------------------*/

MENU OnlineWindow_display
{
	LABEL		[menu_dialog_display];
	ITEMS
	{
		Page_display_out,
		Page_display_measure
	}
}

MENU Page_display_out
{
	LABEL		[menu_dialog_display_output];
	ITEMS
	{
		BarVal_out_display,
		Group_display_out
	}
}

MENU BarVal_out_display
{
	LABEL		[func_out_value];
	ITEMS
	{
		func1_AI_out_value,
		func1_AI_out_lower_range_value (READ_ONLY),
		func1_AI_out_upper_range_value	(READ_ONLY)
	}
}

MENU Group_display_out
{
	LABEL		[func_out_value];
	ITEMS
	{
		func1_AI_out_value (READ_ONLY),
		SEPARATOR,
		func1_AI_out_status_quality (READ_ONLY),
		func1_AI_out_status_limit (READ_ONLY)
	}
}


MENU Page_display_measure
{
	LABEL		[menu_dialog_display_measure];
	ITEMS
	{
		BarVal_pv_display,
		Group_display_primary,
		Group_display_secondary
	}
}

MENU BarVal_pv_display
{
	LABEL		[trans_value];
	ITEMS
	{
		trans1_primary_value,
		func1_AI_pv_lower_range_value (READ_ONLY),
		func1_AI_pv_upper_range_value (READ_ONLY)
	}
}

MENU Group_display_primary
{
	LABEL		[trans_value];
	ITEMS
	{
		trans1_primary_value,
		SEPARATOR,
		trans1_primary_value_status_quality,
		trans1_primary_value_status_limit
	}
}

MENU Group_display_secondary
{
	LABEL		"Group_display_secondary";
	ITEMS
	{
		trans1_secondary_value_1,
		trans1_reference_junction_temp,
		SEPARATOR,
		trans1_input_fault_gen,
		trans1_input_fault_1
		
	}
}



/*---------------------------------------------------------------------*/
/*    OnlineWindow: Alarm States									   */
/*---------------------------------------------------------------------*/

MENU OnlineWindow_S_alarm
{
	LABEL		[menu_dialog_alarm];
	ITEMS
	{
		Page_alarm_sum,
		Page_hi_hi_alm,
		Page_hi_alm,
		Page_lo_alm,
		Page_lo_lo_alm
	}
}

MENU OnlineWindow_M_alarm
{
	LABEL		[menu_dialog_alarm];
	ITEMS
	{
   		Page_alarm_sum,
		Page_hi_hi_alm,
		Page_hi_alm,
		Page_lo_alm,
		Page_lo_lo_alm

	}
}

MENU Page_alarm_sum
{
	LABEL		[menu_dialog_alarm_sum];
	ITEMS
	{
	    func1_AI_current_state_alarm_sum,
		func1_AI_unacknowledged_state_alarm_sum,
		func1_AI_unreported_state_alarm_sum,
		func1_AI_disabled_state_alarm_sum
	}
}

MENU Page_hi_hi_alm
{
	LABEL		[limit_hi_hi];
	ITEMS
	{
		func1_AI_hi_hi_alm_unacknowledged,
		func1_AI_hi_hi_alm_state,

		func1_AI_hi_hi_alm_subcode,
		func1_AI_hi_hi_lim				(READ_ONLY),
		func1_AI_hi_hi_alm_value
	}
}

MENU Page_hi_alm
{
	LABEL		[limit_hi];
	ITEMS
	{
		func1_AI_hi_alm_unacknowledged,
		func1_AI_hi_alm_state,

		func1_AI_hi_alm_subcode,
		func1_AI_hi_lim				(READ_ONLY),
		func1_AI_hi_alm_value
	}
}

MENU Page_lo_alm
{
	LABEL		[limit_lo];
	ITEMS
	{
		func1_AI_lo_alm_unacknowledged,
		func1_AI_lo_alm_state,

		func1_AI_lo_alm_subcode,
		func1_AI_lo_lim				(READ_ONLY),
		func1_AI_lo_alm_value
	}
}

MENU Page_lo_lo_alm
{
	LABEL		[limit_lo_lo];
	ITEMS
	{
		func1_AI_lo_lo_alm_unacknowledged,
		func1_AI_lo_lo_alm_state,

		func1_AI_lo_lo_alm_subcode,
		func1_AI_lo_lo_lim				(READ_ONLY),
		func1_AI_lo_lo_alm_value
	}
}


/*---------------------------------------------------------------------*/
/*    OnlineWindow: Diagnosis										   */
/*---------------------------------------------------------------------*/

MENU OnlineWindow_diagnosis
{
	LABEL		[menu_dialog_diagnosis];
	ITEMS
	{
		Page_diagnosis_general,
		Page_diagnosis_phys_block,
		Page_diagnosis_trans_block,
		Page_diagnosis_func_block
	}
}

MENU Page_diagnosis_general
{
	LABEL		[menu_dialog_general];
	ITEMS
	{
		phys_tag_desc			(READ_ONLY),
		phys_device_man_id,
		phys_device_id,
		phys_device_ser_num,
		phys_software_rev,
		phys_hardware_rev,
		phys_install_date		(READ_ONLY),
		phys_diagnosis,
		phys_diagnosis_mask
	}
}

MENU Page_diagnosis_phys_block
{
	LABEL		[blk_block_object_PHYSICAL];
	ITEMS
	{
		phys_blk_object,
		phys_blk_parent_class,
		phys_blk_class,
		phys_blk_profile,
		phys_blk_profile_rev,
		phys_st_rev,
		phys_actual_mode
	}
}

MENU Page_diagnosis_trans_block
{
	LABEL		[blk_block_object_TRANSDUCER];
	ITEMS
	{
		trans1_blk_object,
		trans1_blk_parent_class,
		trans1_blk_class,
		trans1_blk_profile,
		trans1_blk_profile_rev,
		trans1_st_rev,
		trans1_actual_mode
	}
}

MENU Page_diagnosis_func_block
{
	LABEL		[blk_block_object_FUNCTION];
	ITEMS
	{
		func1_AI_blk_object,
		func1_AI_blk_parent_class,
		func1_AI_blk_class,
		func1_AI_blk_profile,
		func1_AI_blk_profile_rev,
		func1_AI_st_rev,
		func1_AI_actual_mode
	}
}


/*---------------------------------------------------------------------*/
/*    OnlineWindow: Simulation										   */
/*---------------------------------------------------------------------*/

MENU OnlineWindow_simulation
{
	LABEL		[menu_dialog_simulation];
	ITEMS
	{
		Page_simulation_input,
		Page_simulation_output
	}
}

MENU Page_simulation_input
{
	LABEL		[menu_dialog_simulation_input];
	ITEMS
	{
		func1_AI_simulation_enabled,
		Group_simulate_input,
		method_set
	}
}

MENU Group_simulate_input
{
	LABEL		[func_simulate_value];
	ITEMS
	{
		func1_AI_simulate_value,
		SEPARATOR,
		func1_AI_simulate_status_quality,
		func1_AI_simulate_status_limit
	}
}
MENU Page_simulation_output
{
	LABEL		[menu_dialog_simulation_output];
	ITEMS
	{
		func1_AI_target_mode,
		func1_AI_actual_mode,
		Group_simulate_output,
		method_set
	}
}

MENU Group_simulate_output
{
	LABEL		[func_out_value];
	ITEMS
	{
		func1_AI_out_value,
		SEPARATOR,
		func1_AI_out_status_quality,
		func1_AI_out_status_limit
	}
}

/*******************************************************************************/
/*****	Online-Dialogs  ********************************************************/
/*******************************************************************************/

/*---------------------------------------------------------------------*/
/*    OnlineDialog: Reset											   */
/*---------------------------------------------------------------------*/

MENU OnlineDialog_reset
{
	LABEL		[master_reset];
	HELP		[master_reset_help];
	ITEMS
	{
		phys_factory_reset,
	 /*	phys_diagnosis,*/
		method_set
	}
}

/*---------------------------------------------------------------------*/
/*    OnlineDialog: Write Locking									   */
/*---------------------------------------------------------------------*/

MENU OnlineDialog_write_locking
{
	LABEL		[phys_write_locking];
	HELP		[phys_write_locking_help];
	ITEMS
	{
		phys_write_locking(READ_ONLY),
		phys_hw_write_protection,
	   	send_phys_write_locking_on,
	   	send_phys_write_locking_off
	}
}

MENU Menu_manu_spec
{
	LABEL		[menu_manu_configs];
	HELP		[menu_manu_spec_help];

	ITEMS
	{
		Menu_manu_calib,
		/* bugzilla #413 mod */
		Menu_sensor_trim,
		/* bugzilla #413 mod end */
		OnlineDialog_BYTES,
		OnlineDialog_manu_spec_param
	}
}


MENU Menu_sensor_trim
{
	LABEL		[menu_sensor_trim];


	ITEMS
	{
		method_select_trim_mode
		IF ( (trans1_SENSOR_TRIM_MODE == 1) || (trans1_SENSOR_TRIM_MODE == 2) )
		{
			method_set_sensor_trim,
			method_apply_sensor_trim
		}
	}
	
}


MENU OnlineDialog_manu_spec_param
{
	LABEL		[menu_manu_spec_dialog];
	HELP		[menu_manu_spec_help];

	ITEMS
	{
	   phys_TOT_HRS_USED,	
	   phys_POINT_64_RESP_BYTE_1,
	   phys_POINT_20_RESP_BYTE_1,
	   trans1_ADC_CAL_INDEX (READ_ONLY) ,
	   phys_ADC_BIN_OUTPUT(READ_ONLY) ,
	   phys_FILTER_SIZE
	}
}

MENU Menu_manu_calib
{
	LABEL		[menu_calib];


	ITEMS
	{
		method_calibration_mv,
		method_calibration_ohm

	}
	
}

MENU Menu_manu_set
{
	LABEL		[menu_sets];


	ITEMS
	{
		method_set_to_ohm,
		method_set_to_mv,
		method_set_to_tck,
		method_set_to_rtd,
		method_set_to_poti,
		method_set_to_4wohm

	}
}


/*******************************************************************************/
/*****	Table: Specialist  *****************************************************/
/*******************************************************************************/

MENU Table_Main_Specialist
{
	LABEL	DEVICE_TYPE;
	ITEMS
	{
		Tab_s_ident,
		Tab_s_input,
		Tab_s_output,
		Tab_s_interface,
		Tab_s_certificates
	}
}

MENU Tab_s_ident
{
	LABEL		[menu_ident];

	ITEMS
	{
		Tab_s_ident_opunit,
		Tab_s_ident_device,
		Tab_s_man_spec_pys_param
	}
}

MENU Tab_s_man_spec_pys_param
{
	LABEL		[menu_manu_spec];
	ITEMS
	{

  	 phys_INPUT_FILTER,
     phys_FILTER_SIZE,
	 phys_LCD_ADDR,
	 phys_LCD_SELECTOR,
	 phys_LCD_STRING ,
	 phys_LCD_PRECISION,
	 phys_TOT_HRS_CALIB

	}
}


MENU Tab_s_ident_opunit
{
	LABEL		[menu_ident_opunit];
	ITEMS
	{
		phys_tag_desc,
		phys_descriptor,	
		phys_message	
	}
}

MENU Tab_s_ident_device
{
	LABEL		[menu_ident_device];
	HELP		[DD_Version];
	ITEMS
	{
		phys_device_man_id,
		phys_device_id,
		phys_device_ser_num,
		phys_software_rev,
		phys_hardware_rev,
		phys_install_date,
		phys_blk_profile_rev,
		phys_ident_number,
		Tab_st_rev
	}
}

MENU Tab_st_rev
{
	LABEL		[st_rev];
	ITEMS
	{
		rename_value.PHYS_ST_REV,
		rename_value.TRANS_ST_REV,
		rename_value.FUNC_ST_REV
	}
}

MENU Tab_s_input
{
	LABEL		[menu_input];
	ITEMS
	{
		trans1_lin_type
	

		IF (trans1_lin_type < 2)
		{
 		  trans1_primary_value_unit(READ_ONLY)

		}
		ELSE
		{
			trans1_primary_value_unit
		} 

		trans1_input_range,
	   	trans1_bias_1, 
		 
		trans1_reference_junction_type,
		
		trans1_sensor_connection,
		trans1_comp_wire_1,
		
		trans1_sensor_wire_check_1,

		Tab_s_trim,
		Tab_s_characterization,


		Tab_s_input_measindicator,
		Tab_s_input_measrange,
		Tab_s_input_measwindow

	}
}

MENU Tab_s_trim
{
	LABEL		[menu_Sensor_Trim];
	ITEMS
	{
		/* bugzilla #413 mod */
		trans1_SENSOR_TRIM_MODE(READ_ONLY)
		/* bugzilla #413 mod end */
       /**/
/* ### */
		IF (trans1_SENSOR_TRIM_MODE == 1)
		{
			trans1_TRIM_POINT_ZERO (READ_ONLY),
			trans1_TRIM_VALUE_ZERO (READ_ONLY)
		}
		ELSE
		{
			IF (trans1_SENSOR_TRIM_MODE == 2)
			{
				trans1_TRIM_POINT_ZERO (READ_ONLY),
				trans1_TRIM_VALUE_ZERO (READ_ONLY),
				trans1_TRIM_POINT_SPAN (READ_ONLY),
				trans1_TRIM_VALUE_SPAN (READ_ONLY)
			}
		}
       /**/
	}
}

MENU Tab_s_characterization
{
	LABEL		[menu_input_table];
	ITEMS
	{
		trans1_tab_min_number		,			/*19 optional */
		trans1_tab_max_number		,			/*20 optional */
		trans1_tab_actual_number				/*21 optional */

		IF(trans1_lin_type==1)
		{Tab_s_Custom_Curve}
		}
}

 
MENU Tab_s_Custom_Curve
{
	LABEL		[menu_Custom_Curve];
	ITEMS
	{

		tab_actual_number,

	
	   
		trans1_tab_x_value_0, 
		trans1_tab_y_value_0,
		trans1_tab_x_value_1,
		trans1_tab_y_value_1,
		trans1_tab_x_value_2,
		trans1_tab_y_value_2,
		trans1_tab_x_value_3,
		trans1_tab_y_value_3,
		trans1_tab_x_value_4,
		trans1_tab_y_value_4,
		trans1_tab_x_value_5,
		trans1_tab_y_value_5,
		trans1_tab_x_value_6, 
		trans1_tab_y_value_6,
		trans1_tab_x_value_7, 
		trans1_tab_y_value_7,
		trans1_tab_x_value_8, 
		trans1_tab_y_value_8,
		trans1_tab_x_value_9, 
		trans1_tab_y_value_9,
		trans1_tab_x_value_10  , 
		trans1_tab_y_value_10,
		trans1_tab_x_value_11  , 
		trans1_tab_y_value_11,
		trans1_tab_x_value_12  , 
		trans1_tab_y_value_12,
		trans1_tab_x_value_13  , 
		trans1_tab_y_value_13,
		trans1_tab_x_value_14  , 
		trans1_tab_y_value_14,
		trans1_tab_x_value_15  , 
		trans1_tab_y_value_15,

		trans1_tab_x_value_16  , 
		trans1_tab_y_value_16,
		trans1_tab_x_value_17  , 
		trans1_tab_y_value_17,
		trans1_tab_x_value_18  , 
		trans1_tab_y_value_18,
		trans1_tab_x_value_19  , 
		trans1_tab_y_value_19,
		trans1_tab_x_value_20  , 
		trans1_tab_y_value_20,
		trans1_tab_x_value_21  , 
		trans1_tab_y_value_21 ,
		trans1_tab_x_value_22, 
		trans1_tab_y_value_22, 
		trans1_tab_x_value_23, 
		trans1_tab_y_value_23, 
		trans1_tab_x_value_24, 
		trans1_tab_y_value_24, 
		trans1_tab_x_value_25, 
		trans1_tab_y_value_25, 
		trans1_tab_x_value_26, 
		trans1_tab_y_value_26, 
		trans1_tab_x_value_27, 
		trans1_tab_y_value_27, 
		trans1_tab_x_value_28, 
		trans1_tab_y_value_28, 
		trans1_tab_x_value_29, 
		trans1_tab_y_value_29, 
		trans1_tab_x_value_30, 
		trans1_tab_y_value_30, 
		trans1_tab_x_value_31, 
		trans1_tab_y_value_31, 

		trans1_tab_x_value_32, 
		trans1_tab_y_value_32, 
		trans1_tab_x_value_33, 
		trans1_tab_y_value_33, 
		trans1_tab_x_value_34, 
		trans1_tab_y_value_34, 
		trans1_tab_x_value_35, 
		trans1_tab_y_value_35, 
		trans1_tab_x_value_36, 
		trans1_tab_y_value_36, 
		trans1_tab_x_value_37, 
		trans1_tab_y_value_37, 
		trans1_tab_x_value_38, 
		trans1_tab_y_value_38, 
		trans1_tab_x_value_39, 
		trans1_tab_y_value_39, 
		trans1_tab_x_value_40, 
		trans1_tab_y_value_40, 
		trans1_tab_x_value_41, 
		trans1_tab_y_value_41, 
		trans1_tab_x_value_42, 
		trans1_tab_y_value_42, 
		trans1_tab_x_value_43, 
		trans1_tab_y_value_43, 
		trans1_tab_x_value_44, 
		trans1_tab_y_value_44, 
		trans1_tab_x_value_45, 
		trans1_tab_y_value_45, 
		trans1_tab_x_value_46, 
		trans1_tab_y_value_46, 
		trans1_tab_x_value_47, 
		trans1_tab_y_value_47, 

		trans1_tab_x_value_48, 
		trans1_tab_y_value_48, 
		trans1_tab_x_value_49, 
		trans1_tab_y_value_49, 
		trans1_tab_x_value_50, 
		trans1_tab_y_value_50, 
		trans1_tab_x_value_51, 
		trans1_tab_y_value_51, 
		trans1_tab_x_value_52, 
		trans1_tab_y_value_52, 
		trans1_tab_x_value_53, 
		trans1_tab_y_value_53, 
		trans1_tab_x_value_54, 
		trans1_tab_y_value_54, 
		trans1_tab_x_value_55, 
		trans1_tab_y_value_55, 
		trans1_tab_x_value_56, 
		trans1_tab_y_value_56, 
		trans1_tab_x_value_57, 
		trans1_tab_y_value_57, 
		trans1_tab_x_value_58, 
		trans1_tab_y_value_58, 
		trans1_tab_x_value_59, 
		trans1_tab_y_value_59, 
		trans1_tab_x_value_60, 
		trans1_tab_y_value_60, 
		trans1_tab_x_value_61, 
		trans1_tab_y_value_61, 
		trans1_tab_x_value_62, 
		trans1_tab_y_value_62, 
		trans1_tab_x_value_63, 
		trans1_tab_y_value_63, 

		trans1_tab_x_value_64, 
		trans1_tab_y_value_64, 
		trans1_tab_x_value_65, 
		trans1_tab_y_value_65, 
		trans1_tab_x_value_66, 
		trans1_tab_y_value_66, 
		trans1_tab_x_value_67, 
		trans1_tab_y_value_67, 
		trans1_tab_x_value_68, 
		trans1_tab_y_value_68, 
		trans1_tab_x_value_69, 
		trans1_tab_y_value_69, 
		trans1_tab_x_value_70, 
		trans1_tab_y_value_70, 
		trans1_tab_x_value_71, 
		trans1_tab_y_value_71, 
		trans1_tab_x_value_72, 
		trans1_tab_y_value_72, 
		trans1_tab_x_value_73, 
		trans1_tab_y_value_73, 
		trans1_tab_x_value_74, 
		trans1_tab_y_value_74, 
		trans1_tab_x_value_75, 
		trans1_tab_y_value_75, 
		trans1_tab_x_value_76, 
		trans1_tab_y_value_76, 
		trans1_tab_x_value_77, 
		trans1_tab_y_value_77, 
		trans1_tab_x_value_78, 
		trans1_tab_y_value_78, 
		trans1_tab_x_value_79, 
		trans1_tab_y_value_79, 

		trans1_tab_x_value_80, 
		trans1_tab_y_value_80, 
		trans1_tab_x_value_81, 
		trans1_tab_y_value_81, 
		trans1_tab_x_value_82, 
		trans1_tab_y_value_82, 
		trans1_tab_x_value_83, 
		trans1_tab_y_value_83, 
		trans1_tab_x_value_84, 
		trans1_tab_y_value_84, 
		trans1_tab_x_value_85, 
		trans1_tab_y_value_85, 
		trans1_tab_x_value_86, 
		trans1_tab_y_value_86, 
		trans1_tab_x_value_87, 
		trans1_tab_y_value_87, 
		trans1_tab_x_value_88, 
		trans1_tab_y_value_88, 
		trans1_tab_x_value_89, 
		trans1_tab_y_value_89, 
		trans1_tab_x_value_90, 
		trans1_tab_y_value_90, 
		trans1_tab_x_value_91, 
		trans1_tab_y_value_91, 
		trans1_tab_x_value_92, 
		trans1_tab_y_value_92, 
		trans1_tab_x_value_93, 
		trans1_tab_y_value_93, 
		trans1_tab_x_value_94, 
		trans1_tab_y_value_94, 
		trans1_tab_x_value_95, 
		trans1_tab_y_value_95, 

		trans1_tab_x_value_96, 
		trans1_tab_y_value_96, 
		trans1_tab_x_value_97, 
		trans1_tab_y_value_97, 
		trans1_tab_x_value_98, 
		trans1_tab_y_value_98, 
		trans1_tab_x_value_99, 
		trans1_tab_y_value_99, 
		trans1_tab_x_value_100, 
		trans1_tab_y_value_100, 
		trans1_tab_x_value_101, 
		trans1_tab_y_value_101, 
		trans1_tab_x_value_102, 
		trans1_tab_y_value_102, 
		trans1_tab_x_value_103, 
		trans1_tab_y_value_103, 
		trans1_tab_x_value_104, 
		trans1_tab_y_value_104, 
		trans1_tab_x_value_105, 
		trans1_tab_y_value_105, 
		trans1_tab_x_value_106, 
		trans1_tab_y_value_106, 
		trans1_tab_x_value_107, 
		trans1_tab_y_value_107, 
		trans1_tab_x_value_108, 
		trans1_tab_y_value_108, 
		trans1_tab_x_value_109, 
		trans1_tab_y_value_109, 
		trans1_tab_x_value_110, 
		trans1_tab_y_value_110, 
		trans1_tab_x_value_111, 
		trans1_tab_y_value_111, 

		trans1_tab_x_value_112, 
		trans1_tab_y_value_112, 
		trans1_tab_x_value_113, 
		trans1_tab_y_value_113, 
		trans1_tab_x_value_114, 
		trans1_tab_y_value_114, 
		trans1_tab_x_value_115, 
		trans1_tab_y_value_115, 
		trans1_tab_x_value_116, 
		trans1_tab_y_value_116, 
		trans1_tab_x_value_117, 
		trans1_tab_y_value_117, 
		trans1_tab_x_value_118, 
		trans1_tab_y_value_118, 
		trans1_tab_x_value_119, 
		trans1_tab_y_value_119, 
		trans1_tab_x_value_120, 
		trans1_tab_y_value_120, 
		trans1_tab_x_value_121, 
		trans1_tab_y_value_121, 
		trans1_tab_x_value_122, 
		trans1_tab_y_value_122, 
		trans1_tab_x_value_123, 
		trans1_tab_y_value_123, 
		trans1_tab_x_value_124, 
		trans1_tab_y_value_124, 
		trans1_tab_x_value_125, 
		trans1_tab_y_value_125, 
		trans1_tab_x_value_126, 
		trans1_tab_y_value_126, 
		trans1_tab_x_value_127, 
		trans1_tab_y_value_127 
	}
}


MENU Tab_s_input_measindicator
{
	LABEL		[menu_output_indicator];
	ITEMS
	{
		trans1_min_sensor_value_1,
		trans1_max_sensor_value_1
		
	}
}

MENU Tab_s_input_measrange
{
	LABEL		[menu_input_measrange];
	ITEMS
	{
		trans1_lower_sensor_limit(READ_ONLY),	
		trans1_upper_sensor_limit(READ_ONLY),
		trans1_INPUT_LOWER_RANGE,
        trans1_INPUT_UPPER_RANGE
	}
}

MENU Tab_s_input_measwindow
{
	LABEL		[menu_input_measwindow];
	ITEMS
	{
		func1_AI_pv_lower_range_value,	
		func1_AI_pv_upper_range_value	
	}
}

MENU Tab_s_output
{
	LABEL		[menu_output];
	ITEMS
	{
		Tab_s_output_scalewindow,
		Tab_s_output_signal,
		Tab_s_output_limits	
	}
}

MENU Tab_s_output_scalewindow
{
	LABEL		[menu_output_scalewindow];
	ITEMS
	{
		func1_AI_out_lower_range_value,	
		func1_AI_out_upper_range_value
	}
}

MENU Tab_s_output_signal
{
	LABEL		[menu_output_signal];
	ITEMS
	{
		func1_AI_out_unit,	
		func1_AI_out_decimal_point,
		func1_AI_pv_ftime,
		func1_AI_FSafeType,		
		func1_AI_FSafeValue		
	}
}

MENU Tab_s_output_limits
{
	LABEL		[menu_output_limits];
	ITEMS
	{
		func1_AI_lo_lo_lim,	
		func1_AI_lo_lim,	
		func1_AI_hi_lim,	
		func1_AI_hi_hi_lim,	
		func1_AI_alarm_hys	
	}
}




MENU Tab_s_interface
{
	LABEL		[menu_interface];
	ITEMS
	{
		Tab_s_interface_simulate
	}
}

MENU Tab_s_interface_simulate
{
	LABEL		[menu_interface_simulate];
	ITEMS
	{
		func1_AI_simulation_enabled		(READ_ONLY),
		func1_AI_simulate_value			(READ_ONLY),
		func1_AI_simulate_status_quality	(READ_ONLY),
		func1_AI_simulate_status_limit		(READ_ONLY)
	}
}

MENU Tab_s_certificates
{
	LABEL		[menu_certificates];
	ITEMS
	{
		phys_device_certification	
	}
}


/*******************************************************************************/
/*****	Table: Maintenance  ****************************************************/
/*******************************************************************************/

MENU Table_Main_Maintenance
{
	LABEL	DEVICE_TYPE;
	ITEMS
	{
		Tab_m_ident,
		Tab_m_input,
		Tab_m_output,
		Tab_m_interface,
		Tab_m_certificates

	}
}

MENU Tab_m_ident
{
	LABEL		[menu_ident];

	ITEMS
	{
		Tab_m_ident_opunit,
		Tab_m_ident_device,
		Tab_m_man_spec_pys_param
	}
}

MENU Tab_m_ident_opunit
{
	LABEL		[menu_ident_opunit];
	ITEMS
	{
		phys_tag_desc		(READ_ONLY),
		phys_descriptor,	
		phys_message	
	}
}

MENU Tab_m_ident_device
{
	LABEL		[menu_ident_device];
	ITEMS
	{
		phys_device_man_id,
		phys_device_id,
		phys_device_ser_num,
		phys_software_rev,
		phys_hardware_rev,
		phys_install_date		(READ_ONLY),
		phys_blk_profile_rev,
		phys_ident_number		(READ_ONLY),
		Tab_st_rev
	}
}


MENU Tab_m_man_spec_pys_param
{
	LABEL		[menu_manu_spec];
	ITEMS
	{

	 phys_INPUT_FILTER(READ_ONLY),
	 phys_LCD_ADDR(READ_ONLY),
	 phys_LCD_SELECTOR(READ_ONLY),
	 phys_LCD_STRING (READ_ONLY),
	 phys_LCD_PRECISION(READ_ONLY),
	 phys_TOT_HRS_CALIB(READ_ONLY)

	}
}



MENU Tab_m_input
{
	LABEL		[menu_input];
	ITEMS
	{
		trans1_lin_type(READ_ONLY),
		trans1_primary_value_unit(READ_ONLY),
		trans1_input_range(READ_ONLY),
	   	trans1_bias_1(READ_ONLY), 
		 
		trans1_reference_junction_type(READ_ONLY),
		
		trans1_sensor_connection(READ_ONLY),
		trans1_comp_wire_1(READ_ONLY),
		
		trans1_sensor_wire_check_1(READ_ONLY),
		/* bugzilla #413 mod */
		trans1_SENSOR_TRIM_MODE(READ_ONLY),
		/* bugzilla #413 mod end */
	/**/	trans1_TRIM_POINT_ZERO (READ_ONLY),
		trans1_TRIM_POINT_SPAN (READ_ONLY),
		trans1_TRIM_VALUE_ZERO (READ_ONLY),
		trans1_TRIM_VALUE_SPAN (READ_ONLY),
     /**/
		Tab_m_characterization,


		Tab_m_input_measindicator,
		Tab_m_input_measrange,
		Tab_m_input_measwindow

	}
}

MENU Tab_m_characterization
{
	LABEL		[menu_input_table];
	ITEMS
	{
		trans1_tab_min_number (READ_ONLY)		,			/*19 optional */
		trans1_tab_max_number (READ_ONLY)		,			/*20 optional */
		trans1_tab_actual_number(READ_ONLY)				/*21 optional */

		IF(trans1_lin_type==1)
		{Tab_m_Custom_Curve}
		}
}

 
MENU Tab_m_Custom_Curve
{
	LABEL		[menu_Custom_Curve];
	ITEMS
	{

		tab_actual_number(READ_ONLY),

	
	   
		trans1_tab_x_value_0(READ_ONLY), 
		trans1_tab_y_value_0(READ_ONLY),
		trans1_tab_x_value_1(READ_ONLY),
		trans1_tab_y_value_1(READ_ONLY),
		trans1_tab_x_value_2(READ_ONLY),
		trans1_tab_y_value_2(READ_ONLY),
		trans1_tab_x_value_3(READ_ONLY),
		trans1_tab_y_value_3(READ_ONLY),
		trans1_tab_x_value_4(READ_ONLY),
		trans1_tab_y_value_4(READ_ONLY),
		trans1_tab_x_value_5(READ_ONLY),
		trans1_tab_y_value_5(READ_ONLY),
		trans1_tab_x_value_6(READ_ONLY), 
		trans1_tab_y_value_6(READ_ONLY),
		trans1_tab_x_value_7(READ_ONLY), 
		trans1_tab_y_value_7(READ_ONLY),
		trans1_tab_x_value_8(READ_ONLY), 
		trans1_tab_y_value_8(READ_ONLY),
		trans1_tab_x_value_9(READ_ONLY), 
		trans1_tab_y_value_9(READ_ONLY),
		trans1_tab_x_value_10(READ_ONLY), 
		trans1_tab_y_value_10(READ_ONLY),
		trans1_tab_x_value_11(READ_ONLY), 
		trans1_tab_y_value_11(READ_ONLY),
		trans1_tab_x_value_12(READ_ONLY), 
		trans1_tab_y_value_12(READ_ONLY),
		trans1_tab_x_value_13(READ_ONLY), 
		trans1_tab_y_value_13(READ_ONLY),
		trans1_tab_x_value_14(READ_ONLY), 
		trans1_tab_y_value_14(READ_ONLY),
		trans1_tab_x_value_15(READ_ONLY), 
		trans1_tab_y_value_15(READ_ONLY),

		trans1_tab_x_value_16(READ_ONLY), 
		trans1_tab_y_value_16(READ_ONLY),
		trans1_tab_x_value_17(READ_ONLY), 
		trans1_tab_y_value_17(READ_ONLY),
		trans1_tab_x_value_18(READ_ONLY), 
		trans1_tab_y_value_18(READ_ONLY),
		trans1_tab_x_value_19(READ_ONLY), 
		trans1_tab_y_value_19(READ_ONLY),
		trans1_tab_x_value_20(READ_ONLY), 
		trans1_tab_y_value_20(READ_ONLY),
		trans1_tab_x_value_21(READ_ONLY), 
		trans1_tab_y_value_21(READ_ONLY),
		trans1_tab_x_value_22(READ_ONLY), 
		trans1_tab_y_value_22(READ_ONLY), 
		trans1_tab_x_value_23(READ_ONLY), 
		trans1_tab_y_value_23(READ_ONLY), 
		trans1_tab_x_value_24(READ_ONLY), 
		trans1_tab_y_value_24(READ_ONLY), 
		trans1_tab_x_value_25(READ_ONLY), 
		trans1_tab_y_value_25(READ_ONLY), 
		trans1_tab_x_value_26(READ_ONLY), 
		trans1_tab_y_value_26(READ_ONLY), 
		trans1_tab_x_value_27(READ_ONLY), 
		trans1_tab_y_value_27(READ_ONLY), 
		trans1_tab_x_value_28(READ_ONLY), 
		trans1_tab_y_value_28(READ_ONLY), 
		trans1_tab_x_value_29(READ_ONLY), 
		trans1_tab_y_value_29(READ_ONLY), 
		trans1_tab_x_value_30(READ_ONLY), 
		trans1_tab_y_value_30(READ_ONLY), 
		trans1_tab_x_value_31(READ_ONLY), 
		trans1_tab_y_value_31(READ_ONLY), 

		trans1_tab_x_value_32(READ_ONLY), 
		trans1_tab_y_value_32(READ_ONLY), 
		trans1_tab_x_value_33(READ_ONLY), 
		trans1_tab_y_value_33(READ_ONLY), 
		trans1_tab_x_value_34(READ_ONLY), 
		trans1_tab_y_value_34(READ_ONLY), 
		trans1_tab_x_value_35(READ_ONLY), 
		trans1_tab_y_value_35(READ_ONLY), 
		trans1_tab_x_value_36(READ_ONLY), 
		trans1_tab_y_value_36(READ_ONLY), 
		trans1_tab_x_value_37(READ_ONLY), 
		trans1_tab_y_value_37(READ_ONLY), 
		trans1_tab_x_value_38(READ_ONLY), 
		trans1_tab_y_value_38(READ_ONLY), 
		trans1_tab_x_value_39(READ_ONLY), 
		trans1_tab_y_value_39(READ_ONLY), 
		trans1_tab_x_value_40(READ_ONLY), 
		trans1_tab_y_value_40(READ_ONLY), 
		trans1_tab_x_value_41(READ_ONLY), 
		trans1_tab_y_value_41(READ_ONLY), 
		trans1_tab_x_value_42(READ_ONLY), 
		trans1_tab_y_value_42(READ_ONLY), 
		trans1_tab_x_value_43(READ_ONLY), 
		trans1_tab_y_value_43(READ_ONLY), 
		trans1_tab_x_value_44(READ_ONLY), 
		trans1_tab_y_value_44(READ_ONLY), 
		trans1_tab_x_value_45(READ_ONLY), 
		trans1_tab_y_value_45(READ_ONLY), 
		trans1_tab_x_value_46(READ_ONLY), 
		trans1_tab_y_value_46(READ_ONLY), 
		trans1_tab_x_value_47(READ_ONLY), 
		trans1_tab_y_value_47(READ_ONLY), 

		trans1_tab_x_value_48(READ_ONLY), 
		trans1_tab_y_value_48(READ_ONLY), 
		trans1_tab_x_value_49(READ_ONLY), 
		trans1_tab_y_value_49(READ_ONLY), 
		trans1_tab_x_value_50(READ_ONLY), 
		trans1_tab_y_value_50(READ_ONLY), 
		trans1_tab_x_value_51(READ_ONLY), 
		trans1_tab_y_value_51(READ_ONLY), 
		trans1_tab_x_value_52(READ_ONLY), 
		trans1_tab_y_value_52(READ_ONLY), 
		trans1_tab_x_value_53(READ_ONLY), 
		trans1_tab_y_value_53(READ_ONLY), 
		trans1_tab_x_value_54(READ_ONLY), 
		trans1_tab_y_value_54(READ_ONLY), 
		trans1_tab_x_value_55(READ_ONLY), 
		trans1_tab_y_value_55(READ_ONLY), 
		trans1_tab_x_value_56(READ_ONLY), 
		trans1_tab_y_value_56(READ_ONLY), 
		trans1_tab_x_value_57(READ_ONLY), 
		trans1_tab_y_value_57(READ_ONLY), 
		trans1_tab_x_value_58(READ_ONLY), 
		trans1_tab_y_value_58(READ_ONLY), 
		trans1_tab_x_value_59(READ_ONLY), 
		trans1_tab_y_value_59(READ_ONLY), 
		trans1_tab_x_value_60(READ_ONLY), 
		trans1_tab_y_value_60(READ_ONLY), 
		trans1_tab_x_value_61(READ_ONLY), 
		trans1_tab_y_value_61(READ_ONLY), 
		trans1_tab_x_value_62(READ_ONLY), 
		trans1_tab_y_value_62(READ_ONLY), 
		trans1_tab_x_value_63(READ_ONLY), 
		trans1_tab_y_value_63(READ_ONLY), 

		trans1_tab_x_value_64(READ_ONLY), 
		trans1_tab_y_value_64(READ_ONLY), 
		trans1_tab_x_value_65(READ_ONLY), 
		trans1_tab_y_value_65(READ_ONLY), 
		trans1_tab_x_value_66(READ_ONLY), 
		trans1_tab_y_value_66(READ_ONLY), 
		trans1_tab_x_value_67(READ_ONLY), 
		trans1_tab_y_value_67(READ_ONLY), 
		trans1_tab_x_value_68(READ_ONLY), 
		trans1_tab_y_value_68(READ_ONLY), 
		trans1_tab_x_value_69(READ_ONLY), 
		trans1_tab_y_value_69(READ_ONLY), 
		trans1_tab_x_value_70(READ_ONLY), 
		trans1_tab_y_value_70(READ_ONLY), 
		trans1_tab_x_value_71(READ_ONLY), 
		trans1_tab_y_value_71(READ_ONLY), 
		trans1_tab_x_value_72(READ_ONLY), 
		trans1_tab_y_value_72(READ_ONLY), 
		trans1_tab_x_value_73(READ_ONLY), 
		trans1_tab_y_value_73(READ_ONLY), 
		trans1_tab_x_value_74(READ_ONLY), 
		trans1_tab_y_value_74(READ_ONLY), 
		trans1_tab_x_value_75(READ_ONLY), 
		trans1_tab_y_value_75(READ_ONLY), 
		trans1_tab_x_value_76(READ_ONLY), 
		trans1_tab_y_value_76(READ_ONLY), 
		trans1_tab_x_value_77(READ_ONLY), 
		trans1_tab_y_value_77(READ_ONLY), 
		trans1_tab_x_value_78(READ_ONLY), 
		trans1_tab_y_value_78(READ_ONLY), 
		trans1_tab_x_value_79(READ_ONLY), 
		trans1_tab_y_value_79(READ_ONLY), 

		trans1_tab_x_value_80(READ_ONLY), 
		trans1_tab_y_value_80(READ_ONLY), 
		trans1_tab_x_value_81(READ_ONLY), 
		trans1_tab_y_value_81(READ_ONLY), 
		trans1_tab_x_value_82(READ_ONLY), 
		trans1_tab_y_value_82(READ_ONLY), 
		trans1_tab_x_value_83(READ_ONLY), 
		trans1_tab_y_value_83(READ_ONLY), 
		trans1_tab_x_value_84(READ_ONLY), 
		trans1_tab_y_value_84(READ_ONLY), 
		trans1_tab_x_value_85(READ_ONLY), 
		trans1_tab_y_value_85(READ_ONLY), 
		trans1_tab_x_value_86(READ_ONLY), 
		trans1_tab_y_value_86(READ_ONLY), 
		trans1_tab_x_value_87(READ_ONLY), 
		trans1_tab_y_value_87(READ_ONLY), 
		trans1_tab_x_value_88(READ_ONLY), 
		trans1_tab_y_value_88(READ_ONLY), 
		trans1_tab_x_value_89(READ_ONLY), 
		trans1_tab_y_value_89(READ_ONLY), 
		trans1_tab_x_value_90(READ_ONLY), 
		trans1_tab_y_value_90(READ_ONLY), 
		trans1_tab_x_value_91(READ_ONLY), 
		trans1_tab_y_value_91(READ_ONLY), 
		trans1_tab_x_value_92(READ_ONLY), 
		trans1_tab_y_value_92(READ_ONLY), 
		trans1_tab_x_value_93(READ_ONLY), 
		trans1_tab_y_value_93(READ_ONLY), 
		trans1_tab_x_value_94(READ_ONLY), 
		trans1_tab_y_value_94(READ_ONLY), 
		trans1_tab_x_value_95(READ_ONLY), 
		trans1_tab_y_value_95(READ_ONLY), 

		trans1_tab_x_value_96(READ_ONLY), 
		trans1_tab_y_value_96(READ_ONLY), 
		trans1_tab_x_value_97(READ_ONLY), 
		trans1_tab_y_value_97(READ_ONLY), 
		trans1_tab_x_value_98(READ_ONLY), 
		trans1_tab_y_value_98(READ_ONLY), 
		trans1_tab_x_value_99(READ_ONLY), 
		trans1_tab_y_value_99(READ_ONLY), 
		trans1_tab_x_value_100(READ_ONLY), 
		trans1_tab_y_value_100(READ_ONLY), 
		trans1_tab_x_value_101(READ_ONLY), 
		trans1_tab_y_value_101(READ_ONLY), 
		trans1_tab_x_value_102(READ_ONLY), 
		trans1_tab_y_value_102(READ_ONLY), 
		trans1_tab_x_value_103(READ_ONLY), 
		trans1_tab_y_value_103(READ_ONLY), 
		trans1_tab_x_value_104(READ_ONLY), 
		trans1_tab_y_value_104(READ_ONLY), 
		trans1_tab_x_value_105(READ_ONLY), 
		trans1_tab_y_value_105(READ_ONLY), 
		trans1_tab_x_value_106(READ_ONLY), 
		trans1_tab_y_value_106(READ_ONLY), 
		trans1_tab_x_value_107(READ_ONLY), 
		trans1_tab_y_value_107(READ_ONLY), 
		trans1_tab_x_value_108(READ_ONLY), 
		trans1_tab_y_value_108(READ_ONLY), 
		trans1_tab_x_value_109(READ_ONLY), 
		trans1_tab_y_value_109(READ_ONLY), 
		trans1_tab_x_value_110(READ_ONLY), 
		trans1_tab_y_value_110(READ_ONLY), 
		trans1_tab_x_value_111(READ_ONLY), 
		trans1_tab_y_value_111(READ_ONLY), 

		trans1_tab_x_value_112(READ_ONLY), 
		trans1_tab_y_value_112(READ_ONLY), 
		trans1_tab_x_value_113(READ_ONLY), 
		trans1_tab_y_value_113(READ_ONLY), 
		trans1_tab_x_value_114(READ_ONLY), 
		trans1_tab_y_value_114(READ_ONLY), 
		trans1_tab_x_value_115(READ_ONLY), 
		trans1_tab_y_value_115(READ_ONLY), 
		trans1_tab_x_value_116(READ_ONLY), 
		trans1_tab_y_value_116(READ_ONLY), 
		trans1_tab_x_value_117(READ_ONLY), 
		trans1_tab_y_value_117(READ_ONLY), 
		trans1_tab_x_value_118(READ_ONLY), 
		trans1_tab_y_value_118(READ_ONLY), 
		trans1_tab_x_value_119(READ_ONLY), 
		trans1_tab_y_value_119(READ_ONLY), 
		trans1_tab_x_value_120(READ_ONLY), 
		trans1_tab_y_value_120(READ_ONLY), 
		trans1_tab_x_value_121(READ_ONLY), 
		trans1_tab_y_value_121(READ_ONLY), 
		trans1_tab_x_value_122(READ_ONLY), 
		trans1_tab_y_value_122(READ_ONLY), 
		trans1_tab_x_value_123(READ_ONLY), 
		trans1_tab_y_value_123(READ_ONLY), 
		trans1_tab_x_value_124(READ_ONLY), 
		trans1_tab_y_value_124(READ_ONLY), 
		trans1_tab_x_value_125(READ_ONLY), 
		trans1_tab_y_value_125(READ_ONLY), 
		trans1_tab_x_value_126(READ_ONLY), 
		trans1_tab_y_value_126(READ_ONLY), 
		trans1_tab_x_value_127(READ_ONLY), 
		trans1_tab_y_value_127(READ_ONLY) 
	}
}


MENU Tab_m_input_measindicator
{
	LABEL		[menu_output_indicator];
	ITEMS
	{
		trans1_min_sensor_value_1(READ_ONLY),
		trans1_max_sensor_value_1(READ_ONLY)		
	}
}

MENU Tab_m_input_measrange
{
	LABEL		[menu_input_measrange];
	ITEMS
	{
		trans1_lower_sensor_limit(READ_ONLY),	
		trans1_upper_sensor_limit(READ_ONLY),
		trans1_INPUT_LOWER_RANGE(READ_ONLY),
        trans1_INPUT_UPPER_RANGE(READ_ONLY)
			
	}
}

MENU Tab_m_input_measwindow
{
	LABEL		[menu_input_measwindow];
	ITEMS
	{
		func1_AI_pv_lower_range_value(READ_ONLY),	
		func1_AI_pv_upper_range_value(READ_ONLY)	
	}
}

MENU Tab_m_output
{
	LABEL		[menu_output];
	ITEMS
	{
		Tab_m_output_scalewindow,
		Tab_m_output_signal,
		Tab_m_output_limits	
	}
}

MENU Tab_m_output_scalewindow
{
	LABEL		[menu_output_scalewindow];
	ITEMS
	{
		func1_AI_out_lower_range_value(READ_ONLY),	
		func1_AI_out_upper_range_value(READ_ONLY)
	}
}

MENU Tab_m_output_signal
{
	LABEL		[menu_output_signal];
	ITEMS
	{
		func1_AI_out_unit(READ_ONLY),	
		func1_AI_out_decimal_point(READ_ONLY),
		func1_AI_pv_ftime(READ_ONLY),
		func1_AI_FSafeType(READ_ONLY),		
		func1_AI_FSafeValue	(READ_ONLY)	
	}
}

MENU Tab_m_output_limits
{
	LABEL		[menu_output_limits];
	ITEMS
	{
		func1_AI_lo_lo_lim(READ_ONLY),	
		func1_AI_lo_lim(READ_ONLY),	
		func1_AI_hi_lim(READ_ONLY),	
		func1_AI_hi_hi_lim(READ_ONLY),	
		func1_AI_alarm_hys(READ_ONLY)	
	}
}




MENU Tab_m_interface
{
	LABEL		[menu_interface];
	ITEMS
	{
		Tab_m_interface_simulate
	}
}

MENU Tab_m_interface_simulate
{
	LABEL		[menu_interface_simulate];
	ITEMS
	{
		func1_AI_simulation_enabled		(READ_ONLY),
		func1_AI_simulate_value			(READ_ONLY),
		func1_AI_simulate_status_quality	(READ_ONLY),
		func1_AI_simulate_status_limit		(READ_ONLY)
	}
}

MENU Tab_m_certificates
{
	LABEL		[menu_certificates];
	ITEMS
	{
		phys_device_certification(READ_ONLY)	
	}
}






/*******************************************************************************/
/*****	Methods		************************************************************/
/*******************************************************************************/

METHOD method_set
{
	LABEL		[transfer];
	HELP		[transfer_help];
	DEFINITION
	{
	}
}


METHOD method_set_trans1_primary_value_unit
{
	LABEL		"method_set_trans1_primary_value_unit";
	CLASS		INPUT;

	DEFINITION
	{
		int	input_range;
		//int temperature_unit;

		//linear 
		if( ivar_value(trans1_lin_type) == 0)
		{	
			//  ACKNOWLEDGE(" linear");
			
			input_range = ivar_value(trans1_input_range);
			
			if ((input_range >= 0) && (input_range <= 5))
			{
				iassign(trans1_primary_value_unit, 1243);			// linear [mV]
			}


			else if  ((input_range >= 240) && (input_range <= 245))
			{
				iassign(trans1_primary_value_unit, 1342);		// linear [%]
			}

			else //if  ((input_range >= 128) && (input_range <= 133))
			{
				iassign(trans1_primary_value_unit, 1281);		// linear [Ohm]
			}


		}
		//  table
		else if( ivar_value(trans1_lin_type) == 1)
		{		
			input_range = ivar_value(trans1_input_range);
			
			if ((input_range >= 0) && (input_range <= 5))
			{
				iassign(trans1_primary_value_unit, 1243);			// linear [mV]
			}

			else //if  ((input_range >= 128) && (input_range <= 133))
			{
				iassign(trans1_primary_value_unit, 1281);		// linear [Ohm]
			}



		}

		else // LIN_TYPE > 1 (RTD/TC)
		{

		  // if lin-type changes here, so the unit must always C !!!

		  //	temperature_unit = ivar_value(trans1_primary_value_unit);
		  //	if ((temperature_unit < 1000) || (temperature_unit > 1003))
				iassign(trans1_primary_value_unit, 1001);			// Temperature [C]

		}
	}
}



METHOD  method_set_trans1_input_range
{
	CLASS		INPUT;
	DEFINITION
	{
		int	primary_value_unit;
		primary_value_unit=0;
		primary_value_unit = ivar_value(trans1_primary_value_unit);
	


       //LINEAR 
		if( ivar_value(trans1_lin_type) == 0)
		{		
 
			if (primary_value_unit == 1243)					// linear [mV]
			{

				if ((ivar_value(trans1_input_range) < 0) || (ivar_value(trans1_input_range) > 5))
					iassign(trans1_input_range, 0);
			}
			
			else if (primary_value_unit == 1240)					// linear [V]
			{

				if ((ivar_value(trans1_input_range) < 0) || (ivar_value(trans1_input_range) > 5))
					iassign(trans1_input_range, 0);
			}
			
			else if (primary_value_unit == 1281)			// linear [Ohm]
			{

				if ((ivar_value(trans1_input_range) < 128) || (ivar_value(trans1_input_range) > 133))
					iassign(trans1_input_range, 128);
			}


			else if (primary_value_unit == 1342)			// linear [%]
			{

				if ((ivar_value(trans1_input_range) < 240) || (ivar_value(trans1_input_range) > 245))
					iassign(trans1_input_range, 240);
			}

		}

		// TABLE

		else if( ivar_value(trans1_lin_type) == 1)
		{		
 		
			
			if (primary_value_unit == 1243)					// linear [mV]
			{

				if ((ivar_value(trans1_input_range) < 0) || (ivar_value(trans1_input_range) > 5))
					iassign(trans1_input_range, 0);
			}
			
			else if (primary_value_unit == 1240)					// linear [V]
			{

				if ((ivar_value(trans1_input_range) < 0) || (ivar_value(trans1_input_range) > 5))
					iassign(trans1_input_range, 0);
			}
			
			else if (primary_value_unit == 1281)			// linear [Ohm]
			{

				if ((ivar_value(trans1_input_range) < 128) || (ivar_value(trans1_input_range) > 133))
					iassign(trans1_input_range, 128);
			}

		}


		// RTD's:
		else if ((ivar_value(trans1_lin_type) >= 102)  && (ivar_value(trans1_lin_type) <= 126))
		{

			if ((ivar_value(trans1_input_range) < 128) || (ivar_value(trans1_input_range) > 133))
				iassign(trans1_input_range, 128);
		}
		// RTD's Manu. Spec.:
		else if ((ivar_value(trans1_lin_type) >= 240)  && (ivar_value(trans1_lin_type) <= 242))
		{

			if ((ivar_value(trans1_input_range) < 128) || (ivar_value(trans1_input_range) > 133))
				iassign(trans1_input_range, 128);
		}


		// Thermo-Elemente:
		else if ((ivar_value(trans1_lin_type) >= 128)  && (ivar_value(trans1_lin_type) <= 138))
		{

			if ((ivar_value(trans1_input_range) < 0) || (ivar_value(trans1_input_range) > 5))
				iassign(trans1_input_range, 0);
		}
		// Default
		else
		{
		   	iassign(trans1_input_range, 128);
		}


		if (ivar_value(trans1_input_range) == 250)
					   	iassign(trans1_input_range, 128);


	}
}

METHOD method_set_sensor_wire
{
	CLASS		INPUT;
	DEFINITION
	{
	

		int	input_range;
		int	lin_type;

 		input_range = ivar_value(trans1_input_range);
		lin_type    = ivar_value(trans1_lin_type);

		// RTD
		if( (lin_type >= 102) && (lin_type <= 126) || (lin_type >= 240) && (lin_type <= 242)  )
		{
		   iassign(trans1_sensor_wire_check_1,1);//,	[enabled]	},  
		}
		else 
		{		//TC
				if( (lin_type >= 128) && (lin_type <= 138))
				{
				  iassign(trans1_sensor_wire_check_1,3);//	[disabled]	},

				}
				else
				{		//LIN ,TABLE
						if( (lin_type ==0) || (lin_type ==1))
						{
						   
						    //mV
							if ( (input_range >= 0) && (input_range <= 5))
							{
									  iassign(trans1_sensor_wire_check_1,3);//	[disabled]	},

							}
							// Ohm , Poti
							else
							{
								   iassign(trans1_sensor_wire_check_1,1);//,	[enabled]	},  
							}

						}
				}
		}
	}
}

METHOD method_set_out_unit
{
  
	DEFINITION
	{
        func1_AI_out_unit = ivar_value(trans1_primary_value_unit); 
	
	}

}



METHOD method_set_upper_and_lower_values 
{
	CLASS		INPUT;
	DEFINITION
	{
		int		lin_type;
		float	lower_val, upper_val;
	 	int true_flag;

		true_flag=0;
	 													  			 
		lin_type = ivar_value(trans1_lin_type);			  			 
		lower_val=0;
		upper_val=0;
	  
   		assign_var(func1_AI_out_unit,trans1_primary_value_unit);
	

		// +++++++++++1++++++++++++++
		switch (lin_type)
		{
			case 0:
			case 1:	
			
				switch (ivar_value(trans1_input_range))
				{
				  
					case  0		:	
					if(ivar_value(trans1_primary_value_unit)==1243)
					{
						lower_val = -10 ;		 upper_val =	31.25 ; true_flag=1; /*  31.25mV	   */   					
					}
					else
					{
						if(ivar_value(trans1_primary_value_unit)==1240)
						{
							lower_val = -0.01 ;		 upper_val =	0.03125 ; true_flag=1; /*  0.03125V	   */   					
						}
					}
					break;	 
					
					case  1		:	
					if(ivar_value(trans1_primary_value_unit)==1243)
					{
						lower_val = -10 ;		 upper_val =	62.5 ; true_flag=1; /*  62.5mV	   */   					
					}
					else
					{
						if(ivar_value(trans1_primary_value_unit)==1240)
						{
							lower_val = -0.01 ;		 upper_val =	0.0625 ; true_flag=1; /*  0.0625V	   */   					
						}
					}
					break;	 
				  
					case  2		:	
					if(ivar_value(trans1_primary_value_unit)==1243)
					{
						lower_val = -10 ;		 upper_val =	125 ; true_flag=1; /*  125mV	   */   					
					}
					else
					{
						if(ivar_value(trans1_primary_value_unit)==1240)
						{
							lower_val = -0.01 ;		 upper_val =	0.125 ; true_flag=1; /*  0.125V	   */   					
						}
					}
					break;	 
				  
					case  3		:	
					if(ivar_value(trans1_primary_value_unit)==1243)
					{
						lower_val = -12.5 ;		 upper_val =	250 ; true_flag=1; /*  250mV	   */   					
					}
					else
					{
						if(ivar_value(trans1_primary_value_unit)==1240)
						{
							lower_val = -0.0125 ;		 upper_val =	0.25 ; true_flag=1; /*  0.25V	   */   					
						}
					}
					break;	 
				  
					case  4		:	
					if(ivar_value(trans1_primary_value_unit)==1243)
					{
						lower_val = -25 ;		 upper_val =	500 ; true_flag=1; /*  500mV	   */   					
					}
					else
					{
						if(ivar_value(trans1_primary_value_unit)==1240)
						{
							lower_val = -0.025 ;		 upper_val =	0.5 ; true_flag=1; /*  0.5V	   */   					
						}
					}
					break;	 
				  
					case  5		:	
					if(ivar_value(trans1_primary_value_unit)==1243)
					{
						lower_val = -50 ;		 upper_val =	1000 ; true_flag=1; /*  1000mV	   */   					
					}
					else
					{
						if(ivar_value(trans1_primary_value_unit)==1240)
						{
							lower_val = -0.05 ;		 upper_val =	1 ; true_flag=1; /*  1V	   */   					
						}
					}
					break;	 
				  
					
					
					case  128	:	lower_val =  0  	 ;		 upper_val =    125	 ; true_flag=1; break;	 /*   125 Ohm   */   					
					case  129	:	lower_val =  0  	 ;		 upper_val =    250	 ; true_flag=1; break;	 /*   250 Ohm   */   					
					case  130	:	lower_val =  0  	 ;		 upper_val =    500	 ; true_flag=1; break;	 /*   500 Ohm   */   					
					case  131	:	lower_val =  0  	 ;		 upper_val =   1000	 ; true_flag=1; break;	 /*  1000 Ohm   */   					
					case  132	:	lower_val =  0  	 ;		 upper_val =   2000	 ; true_flag=1; break;	 /*  2000 Ohm   */   					
					case  133	:	lower_val =  0  	 ;		 upper_val =   4095	 ; true_flag=1; break;	 /*  4000 Ohm   */   					
					case  240	:	lower_val =  0	 ;		 upper_val =   100	 ; true_flag=1; break;	 /*  Potentiometer 125Ohm		  */								 
					case  241	:	lower_val =  0	 ;		 upper_val =   100	 ; true_flag=1; break;	 /*  Potentiometer 250Ohm		  */								 
					case  242	:	lower_val =  0	 ;		 upper_val =   100	 ; true_flag=1; break;	 /*  Potentiometer 500Ohm		  */
					case  243 	:	lower_val =  0	 ;		 upper_val =   100	 ; true_flag=1; break;	 /*  Potentiometer 1000Ohm		  */
					case  244   :	lower_val =  0	 ;		 upper_val =   100	 ; true_flag=1; break;	 /*  Potentiometer 2000Ohm		  */
					case  245   :	lower_val =  0	 ;		 upper_val =   100 	 ; true_flag=1; break;	 /*  Potentiometer 4000Ohm		  */
				}
			   	break;	/* Linear  and tables		*/
		   }

		  //values only valid for unit C !!!
		  if(ivar_value(trans1_primary_value_unit)==1001)
		  {
			switch (lin_type)
			{
			
			case  102    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	 -150 ;			 upper_val =	720	 ; true_flag=1; break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	 -150 ;			 upper_val =	720	 ; true_flag=1; break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	 -150 ;			 upper_val =	720	 ; true_flag=1; break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	 -150 ;			 upper_val =	720	 ; true_flag=1; break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	 -150 ;			 upper_val =	720	 ; true_flag=1; break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	 -240 ;			 upper_val =	580	 ; true_flag=1; break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	 -100 ;			 upper_val =	360	 ; true_flag=1; break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	 -65  ;			 upper_val =	280	 ; true_flag=1; break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	 -210 ;			 upper_val =	770	 ; true_flag=1; break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	 -270 ;			 upper_val =	1390   ; true_flag=1; break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	 -270 ;			 upper_val =	1013   ; true_flag=1; break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	 -270 ;			 upper_val =	407	 ; true_flag=1; break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	 -50  ;			 upper_val =	1786   ; true_flag=1; break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	 -50  ;			 upper_val =	1786   ; true_flag=1; break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	 200  ;			 upper_val =	1836   ; true_flag=1; break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	 -270 ;			 upper_val =	1316   ; true_flag=1; break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	 0    ;			 upper_val =	2338   ; true_flag=1; break;	 /*  TC-C   		   */  
		   	}			  														   
					  
		}
		  if(ivar_value(func1_AI_out_unit)==1002)
		  {
			switch (lin_type)
			{
			
			case  102    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	-238 ;			 upper_val =  1328     ; true_flag=1; break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	-238 ;			 upper_val =  1328     ; true_flag=1; break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	-238 ;			 upper_val =  1328     ; true_flag=1; break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	-238 ;			 upper_val =  1328     ; true_flag=1; break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	-238 ;			 upper_val =  1328     ; true_flag=1; break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	-400 ;			 upper_val =  1076     ; true_flag=1; break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	-148 ;			 upper_val =  680      ; true_flag=1; break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	-85 ;			 	 upper_val =  536      ; true_flag=1; break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	-346 ;			 upper_val =  1418     ; true_flag=1; break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	-454 ;			 upper_val =  2534     ; true_flag=1; break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	-454 ;			 upper_val =  1855.4   ; true_flag=1; break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	-454 ;			 upper_val =  764.6    ; true_flag=1; break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	-58 ;				 upper_val =  3246.8   ; true_flag=1; break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	-58 ;				 upper_val =  3246.8   ; true_flag=1; break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	392 ;				 upper_val =  3336.8   ; true_flag=1; break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	-454 ;			 upper_val =  2400.8   ; true_flag=1; break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	32 ;				 upper_val =  4240.4   ; true_flag=1; break;	 /*  TC-C   		   */  
		   	}			  														   
					  
		}



		  if(ivar_value(func1_AI_out_unit)==1003)
		  {
			switch (lin_type)
			{
			
			case  102    :		lower_val =	59.67	;			 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	59.67	;			 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	59.67	;			 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	59.67	;			 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	59.67	;			 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	59.67	;			 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	221.67	;			 upper_val =  1787.67		; true_flag=1; break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	221.67	;			 upper_val =  1787.67		; true_flag=1; break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	221.67	;			 upper_val =  1787.67		; true_flag=1; break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	221.67	;			 upper_val =  1787.67		; true_flag=1; break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	221.67	;			 upper_val =  1787.67		; true_flag=1; break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	59.67	;			 upper_val =  1535.67		; true_flag=1; break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	311.67	;			 upper_val =  1139.67		; true_flag=1; break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	374.67	;			 upper_val =  995.67		; true_flag=1; break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	113.67	;			 upper_val =  1877.67		; true_flag=1; break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	5.67	;			 upper_val =  2993.67		; true_flag=1; break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	5.67	;			 upper_val =  2315.07		; true_flag=1; break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	5.67	;			 upper_val =  1224.27		; true_flag=1; break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	401.67	;			 upper_val =  3706.47		; true_flag=1; break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	401.67	;			 upper_val =  3706.47		; true_flag=1; break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	851.67	;			 upper_val =  3796.47		; true_flag=1; break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	5.67	;			 upper_val =  2860.47		; true_flag=1; break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	491.67	;			 upper_val =  4700.07		; true_flag=1; break;	 /*  TC-C   		   */  
		   	}			  														   
					  
		}


		  if(ivar_value(func1_AI_out_unit)==1000)
		  {
			switch (lin_type)
			{
			
			case  102    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	 123.15	;			 upper_val =  993.15		; true_flag=1; break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	 123.15	;			 upper_val =  993.15		; true_flag=1; break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	 123.15	;			 upper_val =  993.15		; true_flag=1; break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	 123.15	;			 upper_val =  993.15		; true_flag=1; break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	 123.15	;			 upper_val =  993.15		; true_flag=1; break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	 33.15	;			 upper_val =  853.15		; true_flag=1; break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	 173.15	;			 upper_val =  633.15		; true_flag=1; break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	 208.15	;			 upper_val =  553.15		; true_flag=1; break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	 63.15	;			 upper_val =  1043.15		; true_flag=1; break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	 3.15		;			 upper_val =  1663.15		; true_flag=1; break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	 3.15		;			 upper_val =  1286.15		; true_flag=1; break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	 3.15		;			 upper_val =  680.15		; true_flag=1; break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	 223.15	;			 upper_val =  2059.15		; true_flag=1; break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	 223.15	;			 upper_val =  2059.15		; true_flag=1; break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	 473.15	;			 upper_val =  2109.15		; true_flag=1; break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	 3.15		;			 upper_val =  1589.15		; true_flag=1; break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	 273.15	;			 upper_val =  2611.15		; true_flag=1; break;	 /*  TC-C   		   */  
		   	}			  														   
					  
		}


		
	  	if(true_flag==1){


 

		fassign(trans1_lower_sensor_limit, lower_val);
		fassign(trans1_upper_sensor_limit, upper_val);


/*		fassign(trans1_INPUT_LOWER_RANGE  , lower_val);
		fassign(trans1_INPUT_UPPER_RANGE  , upper_val);
		
		fassign(func1_AI_pv_lower_range_value, lower_val);
		fassign(func1_AI_pv_upper_range_value, upper_val);	*/


		fassign(trans1_min_sensor_value_1,0);
		fassign(trans1_max_sensor_value_1,0);
		fassign(trans1_bias_1,0);



        /* add , JR Vers 1.6 */
		fassign(trans1_TRIM_POINT_ZERO , lower_val);
		fassign(trans1_TRIM_POINT_SPAN , upper_val);
		fassign(trans1_TRIM_VALUE_ZERO , lower_val);
		fassign(trans1_TRIM_VALUE_SPAN , upper_val);

	   	}

	}
}



METHOD method_set_upper_and_lower_values_func
{
	CLASS		INPUT;
	DEFINITION
	{
		int		lin_type;
		float	lower_val, upper_val;
	 	int true_flag;

		true_flag=0;
	 													  			 
		lin_type = ivar_value(trans1_lin_type);			  			 
		lower_val=0;
		upper_val=0;

		// +++++++++++1++++++++++++++
		switch (lin_type)
		{
			case 0:
			case 1:	
			
				switch (ivar_value(trans1_input_range))
				{
				  
					case  0		:	
					if(ivar_value(func1_AI_out_unit)==1243)
					{
						lower_val = -10 ;		 upper_val =	31.25 ; true_flag=1; /*  31.25 mV	   */   					
					}
					else
					{
						if(ivar_value(func1_AI_out_unit)==1240)
						{
							lower_val = -0.01 ;		 upper_val =	0.03125 ; true_flag=1; /*  0.03125V	   */   					
						}
					}
					break;	 
										
					case  1		:	
					if(ivar_value(func1_AI_out_unit)==1243)
					{
						lower_val = -10 ;		 upper_val =	62.5 ; true_flag=1; /*  62.5 mV	   */   					
					}
					else
					{
						if(ivar_value(func1_AI_out_unit)==1240)
						{
							lower_val = -0.01 ;		 upper_val =	0.0625 ; true_flag=1; /*  0.0625V	   */   					
						}
					}
					break;
						 
					case  2		:	
					if(ivar_value(func1_AI_out_unit)==1243)
					{
						lower_val = -10 ;		 upper_val =	125 ; true_flag=1; /*  125 mV	   */   					
					}
					else
					{
						if(ivar_value(func1_AI_out_unit)==1240)
						{
							lower_val = -0.01 ;		 upper_val =	0.125 ; true_flag=1; /*  0.125V	   */   					
						}
					}
					break;	 
					
					case  3		:	
					if(ivar_value(func1_AI_out_unit)==1243)
					{
						lower_val = -12.5 ;		 upper_val =	250 ; true_flag=1; /*  250 mV	   */   					
					}
					else
					{
						if(ivar_value(func1_AI_out_unit)==1240)
						{
							lower_val = -0.0125 ;		 upper_val =	0.25 ; true_flag=1; /*  0.25V	   */   					
						}
					}
					break;	 
					
					case  4		:	
					if(ivar_value(func1_AI_out_unit)==1243)
					{
						lower_val = -25 ;		 upper_val =	 500 ; true_flag=1; /*   500 mV	   */   					
					}
					else
					{
						if(ivar_value(func1_AI_out_unit)==1240)
						{
							lower_val = -0.025 ;		 upper_val =	0.5 ; true_flag=1; /*  0.5V	   */   					
						}
					}
					break;	 

					case  5		:	
					if(ivar_value(func1_AI_out_unit)==1243)
					{
						lower_val = -50 ;		 upper_val =	1000 ; true_flag=1; /*  1000 mV	   */   					
					}
					else
					{
						if(ivar_value(func1_AI_out_unit)==1240)
						{
							lower_val = -0.05 ;		 upper_val =	1 ; true_flag=1; /*  1V	   */   					
						}
					}
					break;	 
					
					
					case  128	:	lower_val =  0  ;		 upper_val =    125 	 ; true_flag=1; break;	 /*   125 Ohm   */   					
					case  129	:	lower_val =  0  ;		 upper_val =    250 	 ; true_flag=1; break;	 /*   250 Ohm   */   					
					case  130	:	lower_val =  0  ;		 upper_val =    500 	 ; true_flag=1; break;	 /*   500 Ohm   */   					
					case  131	:	lower_val =  0  ;		 upper_val =   1000 	 ; true_flag=1; break;	 /*  1000 Ohm   */   					
					case  132	:	lower_val =  0  ;		 upper_val =   2000 	 ; true_flag=1; break;	 /*  2000 Ohm   */   					
					case  133	:	lower_val =  0  ;		 upper_val =   4095 	 ; true_flag=1; break;	 /*  4000 Ohm   */   					
					case  240	:	lower_val =  0  ;		 upper_val =   100	 ; true_flag=1; break;	 /*  Potentiometer 125Ohm		  */
					case  241	:	lower_val =  0  ;		 upper_val =   100	 ; true_flag=1; break;	 /*  Potentiometer 250Ohm		  */
					case  242	:	lower_val =  0  ;		 upper_val =   100	 ; true_flag=1; break;	 /*  Potentiometer 500Ohm		  */
					case  243 	:	lower_val =  0  ;		 upper_val =   100	 ; true_flag=1; break;	 /*  Potentiometer 1000Ohm		  */
					case  244   :	lower_val =  0  ;		 upper_val =   100	 ; true_flag=1; break;	 /*  Potentiometer 2000Ohm		  */
					case  245   :	lower_val =  0  ;		 upper_val =   100 	 ; true_flag=1; break;	 /*  Potentiometer 4000Ohm		  */
								 
				}
			   	break;	/* Linear  and tables		*/
		   }

		  //values only valid for unit C !!!
		  if(ivar_value(func1_AI_out_unit)==1001)
		  {
			switch (lin_type)
			{
			
			case  102    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	 -150 ;			 upper_val =	720	 ; true_flag=1; break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	 -150 ;			 upper_val =	720	 ; true_flag=1; break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	 -150 ;			 upper_val =	720	 ; true_flag=1; break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	 -150 ;			 upper_val =	720	 ; true_flag=1; break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	 -150 ;			 upper_val =	720	 ; true_flag=1; break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	 -240 ;			 upper_val =	580	 ; true_flag=1; break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	 -100 ;			 upper_val =	360	 ; true_flag=1; break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	 -65  ;			 upper_val =	280	 ; true_flag=1; break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	 -210 ;			 upper_val =	770	 ; true_flag=1; break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	 -270 ;			 upper_val =	1390 ; true_flag=1; break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	 -270 ;			 upper_val =	1013 ; true_flag=1; break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	 -270 ;			 upper_val =	407	 ; true_flag=1; break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	 -50  ;			 upper_val =	1786 ; true_flag=1; break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	 -50  ;			 upper_val =	1786 ; true_flag=1; break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	 200  ;			 upper_val =	1836 ; true_flag=1; break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	 -270 ;			 upper_val =	1316 ; true_flag=1; break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	 0    ;			 upper_val =	2338 ; true_flag=1; break;	 /*  TC-C   		   */  
		   	}			  														   
					  
		}
		  if(ivar_value(func1_AI_out_unit)==1002)
		  {
			switch (lin_type)
			{
			
			case  102    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	-238 ;			 upper_val =  1328     ; true_flag=1; break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	-238 ;			 upper_val =  1328     ; true_flag=1; break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	-238 ;			 upper_val =  1328     ; true_flag=1; break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	-238 ;			 upper_val =  1328     ; true_flag=1; break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	-238 ;			 upper_val =  1328     ; true_flag=1; break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	-400 ;			 upper_val =  1076     ; true_flag=1; break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	-148 ;			 upper_val =  680      ; true_flag=1; break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	-85 ;			 	 upper_val =  536      ; true_flag=1; break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	-346 ;			 upper_val =  1418     ; true_flag=1; break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	-454 ;			 upper_val =  2534     ; true_flag=1; break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	-454 ;			 upper_val =  1855.4   ; true_flag=1; break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	-454 ;			 upper_val =  764.6    ; true_flag=1; break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	-58 ;				 upper_val =  3246.8   ; true_flag=1; break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	-58 ;				 upper_val =  3246.8   ; true_flag=1; break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	392 ;				 upper_val =  3336.8   ; true_flag=1; break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	-454 ;			 upper_val =  2400.8   ; true_flag=1; break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	32 ;				 upper_val =  4240.4   ; true_flag=1; break;	 /*  TC-C   		   */  
		   	}			  														   
					  
		}



		  if(ivar_value(func1_AI_out_unit)==1003)
		  {
			switch (lin_type)
			{
			
			case  102    :		lower_val =	59.67	;			 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	59.67	;			 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	59.67	;			 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	59.67	;			 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	59.67	;			 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	59.67	;			 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	221.67	;			 upper_val =  1787.67		; true_flag=1; break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	221.67	;			 upper_val =  1787.67		; true_flag=1; break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	221.67	;			 upper_val =  1787.67		; true_flag=1; break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	221.67	;			 upper_val =  1787.67		; true_flag=1; break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	221.67	;			 upper_val =  1787.67		; true_flag=1; break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	59.67	;			 upper_val =  1535.67		; true_flag=1; break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	311.67	;			 upper_val =  1139.67		; true_flag=1; break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	374.67	;			 upper_val =  995.67		; true_flag=1; break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	113.67	;			 upper_val =  1877.67		; true_flag=1; break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	5.67	;			 upper_val =  2993.67		; true_flag=1; break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	5.67	;			 upper_val =  2315.07		; true_flag=1; break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	5.67	;			 upper_val =  1224.27		; true_flag=1; break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	401.67	;			 upper_val =  3706.47		; true_flag=1; break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	401.67	;			 upper_val =  3706.47		; true_flag=1; break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	851.67	;			 upper_val =  3796.47		; true_flag=1; break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	5.67	;			 upper_val =  2860.47		; true_flag=1; break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	491.67	;			 upper_val =  4700.07		; true_flag=1; break;	 /*  TC-C   		   */  
		   	}			  														   
					  
		}


		  if(ivar_value(func1_AI_out_unit)==1000)
		  {
			switch (lin_type)
			{
			
			case  102    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	 123.15	;			 upper_val =  993.15		; true_flag=1; break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	 123.15	;			 upper_val =  993.15		; true_flag=1; break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	 123.15	;			 upper_val =  993.15		; true_flag=1; break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	 123.15	;			 upper_val =  993.15		; true_flag=1; break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	 123.15	;			 upper_val =  993.15		; true_flag=1; break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	 33.15	;			 upper_val =  853.15		; true_flag=1; break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	 173.15	;			 upper_val =  633.15		; true_flag=1; break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	 208.15	;			 upper_val =  553.15		; true_flag=1; break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	 63.15	;			 upper_val =  1043.15		; true_flag=1; break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	 3.15		;			 upper_val =  1663.15		; true_flag=1; break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	 3.15		;			 upper_val =  1286.15		; true_flag=1; break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	 3.15		;			 upper_val =  680.15		; true_flag=1; break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	 223.15	;			 upper_val =  2059.15		; true_flag=1; break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	 223.15	;			 upper_val =  2059.15		; true_flag=1; break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	 473.15	;			 upper_val =  2109.15		; true_flag=1; break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	 3.15		;			 upper_val =  1589.15		; true_flag=1; break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	 273.15	;			 upper_val =  2611.15		; true_flag=1; break;	 /*  TC-C   		   */  
		   	}			  														   
					  
		}


		
	  	if(true_flag==1){


 
 /*		fassign(func1_AI_out_lower_range_value, lower_val);
		fassign(func1_AI_out_upper_range_value, upper_val);   */

		fassign(func1_AI_lo_lo_lim, lower_val);
		fassign(func1_AI_hi_hi_lim, upper_val);


		fassign (func1_AI_alarm_hys,(upper_val-lower_val) * 0.05);

		iassign(func1_AI_out_decimal_point,3);
		fassign(func1_AI_pv_ftime,0);

	   	}

	}
}





METHOD method_set_upper_and_lower_values_func_default
{
	CLASS		INPUT;
	DEFINITION
	{
		int		lin_type;
		float	lower_val, upper_val;
	 	int true_flag;

		true_flag=0;
	 													  			 
		lin_type = ivar_value(trans1_lin_type);			  			 
		lower_val=0;
		upper_val=0;


				  
		if(ivar_value(func1_AI_out_unit)==1243)
		{
			lower_val = -50 ;		 upper_val =	1000 ; true_flag=1; /*  1000mV	   */   					
		}

		if(ivar_value(func1_AI_out_unit)==1240)
		{
			lower_val = -0.05 ;		 upper_val =	1 ; true_flag=1; /*  1V	   */   					
		}
					
		if(ivar_value(func1_AI_out_unit)==1281)
		{
			lower_val =  0  ;		 upper_val =	4095 ; true_flag=1;  /*  Ohm   */   					
		}
					

		if(ivar_value(func1_AI_out_unit)==1342)
		{
			lower_val =  0  ;		 upper_val =	100 ; true_flag=1;  /*  %   */   					
		}

		  //values only valid for unit C !!!
		  if(ivar_value(func1_AI_out_unit)==1001)
		  {
			switch (lin_type)
			{
			
			case  102    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	 -240 ;			 upper_val =	960	 ; true_flag=1; break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	 -150 ;			 upper_val =	720	 ; true_flag=1; break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	 -150 ;			 upper_val =	720	 ; true_flag=1; break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	 -150 ;			 upper_val =	720	 ; true_flag=1; break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	 -150 ;			 upper_val =	720	 ; true_flag=1; break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	 -150 ;			 upper_val =	720	 ; true_flag=1; break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	 -240 ;			 upper_val =	580	 ; true_flag=1; break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	 -100 ;			 upper_val =	360	 ; true_flag=1; break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	 -65  ;			 upper_val =	280	 ; true_flag=1; break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	 -210 ;			 upper_val =	770	 ; true_flag=1; break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	 -270 ;			 upper_val =	1390   ; true_flag=1; break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	 -270 ;			 upper_val =	1013   ; true_flag=1; break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	 -270 ;			 upper_val =	407	 ; true_flag=1; break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	 -50  ;			 upper_val =	1786   ; true_flag=1; break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	 -50  ;			 upper_val =	1786   ; true_flag=1; break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	 200  ;			 upper_val =	1836   ; true_flag=1; break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	 -270 ;			 upper_val =	1316   ; true_flag=1; break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	 0    ;			 upper_val =	2338   ; true_flag=1; break;	 /*  TC-C   		   */  
		   	}			  														   
					  
		}


		  if(ivar_value(func1_AI_out_unit)==1002)
		  {
			switch (lin_type)
			{
			
			case  102    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	-400 ;			 upper_val =  1760     ; true_flag=1; break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	-238 ;			 upper_val =  1328     ; true_flag=1; break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	-238 ;			 upper_val =  1328     ; true_flag=1; break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	-238 ;			 upper_val =  1328     ; true_flag=1; break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	-238 ;			 upper_val =  1328     ; true_flag=1; break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	-238 ;			 upper_val =  1328     ; true_flag=1; break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	-400 ;			 upper_val =  1076     ; true_flag=1; break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	-148 ;			 upper_val =  680      ; true_flag=1; break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	-85 ;			 	 upper_val =  536      ; true_flag=1; break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	-346 ;			 upper_val =  1418     ; true_flag=1; break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	-454 ;			 upper_val =  2534     ; true_flag=1; break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	-454 ;			 upper_val =  1855.4   ; true_flag=1; break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	-454 ;			 upper_val =  764.6    ; true_flag=1; break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	-58 ;				 upper_val =  3246.8   ; true_flag=1; break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	-58 ;				 upper_val =  3246.8   ; true_flag=1; break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	392 ;				 upper_val =  3336.8   ; true_flag=1; break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	-454 ;			 upper_val =  2400.8   ; true_flag=1; break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	32 ;				 upper_val =  4240.4   ; true_flag=1; break;	 /*  TC-C   		   */  
		   	}			  														   
					  
		}



		  if(ivar_value(func1_AI_out_unit)==1003)
		  {
			switch (lin_type)
			{
			
			case  102    :		lower_val =	59.67	;				 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	59.67	;				 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	59.67	;				 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	59.67	;				 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	59.67	;				 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	59.67	;				 upper_val =  2219.67		; true_flag=1; break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	221.67	;			 upper_val =  1787.67		; true_flag=1; break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	221.67	;			 upper_val =  1787.67		; true_flag=1; break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	221.67	;			 upper_val =  1787.67		; true_flag=1; break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	221.67	;			 upper_val =  1787.67		; true_flag=1; break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	221.67	;			 upper_val =  1787.67		; true_flag=1; break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	59.67	;				 upper_val =  1535.67		; true_flag=1; break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	311.67	;			 upper_val =  1139.67		; true_flag=1; break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	374.67	;			 upper_val =  995.67		; true_flag=1; break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	113.67	;			 upper_val =  1877.67		; true_flag=1; break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	5.67	;				 upper_val =  2993.67		; true_flag=1; break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	5.67	;				 upper_val =  2315.07		; true_flag=1; break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	5.67	;				 upper_val =  1224.27		; true_flag=1; break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	401.67	;			 upper_val =  3706.47		; true_flag=1; break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	401.67	;			 upper_val =  3706.47		; true_flag=1; break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	851.67	;			 upper_val =  3796.47		; true_flag=1; break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	5.67	;			 	 upper_val =  2860.47		; true_flag=1; break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	491.67	;			 upper_val =  4700.07		; true_flag=1; break;	 /*  TC-C   		   */  
		   	}			  														   
					  
		}


		  if(ivar_value(func1_AI_out_unit)==1000)
		  {
			switch (lin_type)
			{
			
			case  102    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	 33.15	;			 upper_val =  1233.15		; true_flag=1; break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	 123.15	;			 upper_val =  993.15		; true_flag=1; break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	 123.15	;			 upper_val =  993.15		; true_flag=1; break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	 123.15	;			 upper_val =  993.15		; true_flag=1; break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	 123.15	;			 upper_val =  993.15		; true_flag=1; break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	 123.15	;			 upper_val =  993.15		; true_flag=1; break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	 33.15	;			 upper_val =  853.15		; true_flag=1; break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	 173.15	;			 upper_val =  633.15		; true_flag=1; break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	 208.15	;			 upper_val =  553.15		; true_flag=1; break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	 63.15	;			 upper_val =  1043.15		; true_flag=1; break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	 3.15		;			 upper_val =  1663.15		; true_flag=1; break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	 3.15		;			 upper_val =  1286.15		; true_flag=1; break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	 3.15		;			 upper_val =  680.15		; true_flag=1; break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	 223.15	;			 upper_val =  2059.15		; true_flag=1; break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	 223.15	;			 upper_val =  2059.15		; true_flag=1; break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	 473.15	;			 upper_val =  2109.15		; true_flag=1; break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	 3.15		;			 upper_val =  1589.15		; true_flag=1; break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	 273.15	;			 upper_val =  2611.15		; true_flag=1; break;	 /*  TC-C   		   */  
		   	}			  														   
					  
		}


		
	  	if(true_flag==1){

	   	fassign(lower_sensor_limit_def	, lower_val);
	   	fassign(upper_sensor_limit_def	, upper_val);


	   	}

	}
}


METHOD method_set_upper_and_lower_values_conformance
{
	CLASS		INPUT;
	DEFINITION
	{
		int		lin_type;
		float	lower_val, upper_val;
	 	int true_flag;

		true_flag=0;
	 													  			 
		lin_type = ivar_value(trans1_lin_type);			  			 
		lower_val=0;
		upper_val=0;
	  
	
		switch (lin_type)
		{
			case 0:
			case 1:	

				switch (ivar_value(trans1_input_range))
				{

					case  0		:	
					if(ivar_value(func1_AI_out_unit)==1243)
					{
						lower_val = -10 ;		 upper_val =	31.25 ; true_flag=1; /*  31.25 mV	   */   					
					}
					else
					{
						if(ivar_value(func1_AI_out_unit)==1240)
						{
							lower_val = -0.01 ;		 upper_val =	0.03125 ; true_flag=1; /*  0.03125V	   */   					
						}
					}
					break;	 

					case  1		:	
					if(ivar_value(func1_AI_out_unit)==1243)
					{
						lower_val = -10 ;		 upper_val =	62.5 ; true_flag=1; /*  62.5 mV	   */   					
					}
					else
					{
						if(ivar_value(func1_AI_out_unit)==1240)
						{
							lower_val = -0.01 ;		 upper_val =	0.0625 ; true_flag=1; /*  62.5V	   */   					
						}
					}
					break;	 
					
					case  3		:	
					if(ivar_value(func1_AI_out_unit)==1243)
					{
						lower_val = -12.5 ;		 upper_val =	250 ; true_flag=1; /*  250 mV	   */   					
					}
					else
					{
						if(ivar_value(func1_AI_out_unit)==1240)
						{
							lower_val = -0.0125 ;		 upper_val =	0.25 ; true_flag=1; /*  0.25V	   */   					
						}
					}
					break;	 
					
					case  2		:	
					if(ivar_value(func1_AI_out_unit)==1243)
					{
						lower_val = -10 ;		 upper_val =	125 ; true_flag=1; /*  125 mV	   */   					
					}
					else
					{
						if(ivar_value(func1_AI_out_unit)==1240)
						{
							lower_val = -0.01 ;		 upper_val =	0.125 ; true_flag=1; /*  0.125V	   */   					
						}
					}
					break;	 
					
					case  4		:	
					if(ivar_value(func1_AI_out_unit)==1243)
					{
						lower_val = -25 ;		 upper_val =	  500 ; true_flag=1; /*  500 mV	   */   					
					}
					else
					{
						if(ivar_value(func1_AI_out_unit)==1240)
						{
							lower_val = -0.025 ;		 upper_val =	0.5 ; true_flag=1; /*  0.5V	   */   					
						}
					}
					break;	 
					
					case  5		:	
					if(ivar_value(func1_AI_out_unit)==1243)
					{
						lower_val = -50 ;		 upper_val =	1000 ; true_flag=1; /*  1000 mV	   */   					
					}
					else
					{
						if(ivar_value(func1_AI_out_unit)==1240)
						{
							lower_val = -0.05 ;		 upper_val =	1 ; true_flag=1; /*  1V	   */   					
						}
					}
					break;	 
					
					case  128	:	lower_val = 0   ;		 upper_val =	 125;true_flag=1;  break;	 /*   125 Ohm   */   					
					case  129	:	lower_val = 0   ;		 upper_val =	 250;true_flag=1;  break;	 /*   250 Ohm   */   					
					case  130	:	lower_val = 0   ;		 upper_val =	 500;true_flag=1;  break;	 /*   500 Ohm   */   					
					case  131	:	lower_val = 0   ;		 upper_val =	1000;true_flag=1;  break;	 /*  1000 Ohm   */   					
					case  132	:	lower_val = 0   ;		 upper_val =	2000;true_flag=1;  break;	 /*  2000 Ohm   */   					
					case  133	:	lower_val = 0   ;		 upper_val =	4000;true_flag=1;  break;	 /*  4000 Ohm   */   					
					case  240	:	lower_val = 0 ;		 upper_val =	100	;true_flag=1; break;	 /*  Potentiometer 125Ohm		  */
					case  241	:	lower_val = 0 ;		 upper_val =	100	;true_flag=1; break;	 /*  Potentiometer 250Ohm		  */
					case  242	:	lower_val = 0 ;		 upper_val =	100	;true_flag=1;  break;	 /*  Potentiometer 500Ohm		  */
					case  243 	:	lower_val = 0 ;		 upper_val =	100	;true_flag=1;  break;	 /*  Potentiometer 1000Ohm		  */
					case  244   :	lower_val = 0 ;		 upper_val =  	100	;true_flag=1;  break;	 /*  Potentiometer 2000Ohm		  */
					case  245   :	lower_val = 0 ;		 upper_val =	100	;true_flag=1;  break;	 /*  Potentiometer 4000Ohm		  */
								 
				}
			   	break;	/* Linear  and tables		*/
		   }

		  //values only valid for unit C !!!
		  if(ivar_value(func1_AI_out_unit)==1001)
		  {
			switch (lin_type)
			{


			case  102    :		lower_val =	-200;			 upper_val =  850   ;true_flag=1;  break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	-200;			 upper_val =  850   ;true_flag=1;  break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	-200;			 upper_val =  850   ;true_flag=1;  break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	-200;			 upper_val =  850   ;true_flag=1;  break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	-200;			 upper_val =  850   ;true_flag=1;  break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	-200;			 upper_val =  850   ;true_flag=1;  break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	-100;			 upper_val =  650   ;true_flag=1;  break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	-100;			 upper_val =  650   ;true_flag=1;  break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	-100;			 upper_val =  650   ;true_flag=1;  break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	-100;			 upper_val =  650   ;true_flag=1;  break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	-100;			 upper_val =  650   ;true_flag=1;  break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	-200;			 upper_val =  510   ;true_flag=1;  break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	-80 ;			 upper_val =  320   ;true_flag=1;  break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	-50 ;			 upper_val =  250   ;true_flag=1;  break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	-180;			 upper_val =  760   ;true_flag=1;  break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	-150;			 upper_val =  1370  ;true_flag=1;  break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	-170;			 upper_val =  1000  ;true_flag=1;  break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	-170;			 upper_val =  400   ;true_flag=1;  break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	0;			 upper_val =  1760  ;true_flag=1;  break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	0;			 upper_val =  1760  ;true_flag=1;  break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	400;			 upper_val =  1820  ;true_flag=1;  break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	-130;			 upper_val =  1300  ;true_flag=1;  break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	0;			 upper_val =  2300  ;true_flag=1;  break;	 /*  TC-C   		   */  
		   	}			  														    
					  
		}
		  if(ivar_value(func1_AI_out_unit)==1002)
		  {
			switch (lin_type)
			{


			case  102    :		lower_val =-328;   				upper_val =  1562 ;true_flag=1;  break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =-328;   				upper_val =  1562 ;true_flag=1;  break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =-328;   				upper_val =  1562 ;true_flag=1;  break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =-328;   				upper_val =  1562 ;true_flag=1;  break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =-328;   				upper_val =  1562 ;true_flag=1;  break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =-328;   				upper_val =  1562 ;true_flag=1;  break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =-148;   				upper_val =  1202 ;true_flag=1;  break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =-148;   				upper_val =  1202 ;true_flag=1;  break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =-148;   				upper_val =  1202 ;true_flag=1;  break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =-148;   				upper_val =  1202 ;true_flag=1;  break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =-148;   				upper_val =  1202 ;true_flag=1;  break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =-328;   				upper_val =  950 ;true_flag=1;  break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =-112;   				upper_val =  608 ;true_flag=1;  break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =-58;	   				upper_val =  482 ;true_flag=1;  break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =-292;   				upper_val =  1400 ;true_flag=1;  break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =-238;   				upper_val =  2498 ;true_flag=1;  break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =-274;   				upper_val =  1832 ;true_flag=1;  break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =-274;   				upper_val =  752 ;true_flag=1;  break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =32;	   				upper_val =  3200 ;true_flag=1;  break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =32;	   				upper_val =  3200 ;true_flag=1;  break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =752;   				upper_val =  3308 ;true_flag=1;  break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =-202;   				upper_val =  2372 ;true_flag=1;  break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =32;	   				upper_val =  4172 ;true_flag=1;  break;	 /*  TC-C   		   */  
		   	}			  														    
					  
		}


		  if(ivar_value(func1_AI_out_unit)==1003)
		  {
			switch (lin_type)
			{


			case  102    :		lower_val =	131.67;			 upper_val =  2021.67 ;true_flag=1;  break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	131.67;			 upper_val =  2021.67 ;true_flag=1;  break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	131.67;			 upper_val =  2021.67 ;true_flag=1;  break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	131.67;			 upper_val =  2021.67 ;true_flag=1;  break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	131.67;			 upper_val =  2021.67 ;true_flag=1;  break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	131.67;			 upper_val =  2021.67 ;true_flag=1;  break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	311.67;			 upper_val =  1661.67 ;true_flag=1;  break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	311.67;			 upper_val =  1661.67 ;true_flag=1;  break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	311.67;			 upper_val =  1661.67 ;true_flag=1;  break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	311.67;			 upper_val =  1661.67 ;true_flag=1;  break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	311.67;			 upper_val =  1661.67 ;true_flag=1;  break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	131.67;			 upper_val =  1409.67 ;true_flag=1;  break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	347.67;			 upper_val =  1067.67 ;true_flag=1;  break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	401.67;			 upper_val =  941.67  ;true_flag=1;  break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	167.67;			 upper_val =  1859.67 ;true_flag=1;  break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	221.67;			 upper_val =  2957.67 ;true_flag=1;  break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	185.67;			 upper_val =  2291.67 ;true_flag=1;  break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	185.67;			 upper_val =  1211.67 ;true_flag=1;  break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	491.67;			 upper_val =  3659.67 ;true_flag=1;  break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	491.67;			 upper_val =  3659.67 ;true_flag=1;  break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	1211.67;		 	 upper_val =  3767.67 ;true_flag=1;  break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	257.67;			 upper_val =  2831.67 ;true_flag=1;  break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	491.67;			 upper_val =  4631.67 ;true_flag=1;  break;	 /*  TC-C   		   */  
		   	}			  														    
					  
		}


		  if(ivar_value(func1_AI_out_unit)==1000)
		  {
			switch (lin_type)
			{


			case  102    :		lower_val =73.15;				 upper_val =  1123.15 ;true_flag=1;  break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =73.15;				 upper_val =  1123.15 ;true_flag=1;  break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =73.15;				 upper_val =  1123.15 ;true_flag=1;  break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =73.15;				 upper_val =  1123.15 ;true_flag=1;  break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =73.15;				 upper_val =  1123.15 ;true_flag=1;  break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =73.15;				 upper_val =  1123.15 ;true_flag=1;  break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =173.15;			 upper_val =  923.15  ;true_flag=1;  break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =173.15;			 upper_val =  923.15  ;true_flag=1;  break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =173.15;			 upper_val =  923.15  ;true_flag=1;  break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =173.15;			 upper_val =  923.15  ;true_flag=1;  break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =173.15;			 upper_val =  923.15  ;true_flag=1;  break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =73.15;			 	 upper_val =  783.15  ;true_flag=1;  break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =193.15;			 upper_val =  593.15  ;true_flag=1;  break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =223.15;			 upper_val =  523.15  ;true_flag=1;  break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =93.15;				 upper_val =  1033.15  ;true_flag=1;  break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =123.15;			 upper_val =  1643.15 ;true_flag=1;  break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =103.15;			 upper_val =  1273.15 ;true_flag=1;  break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =103.15;			 upper_val =  673.15  ;true_flag=1;  break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =273.15;			 upper_val =  2033.15 ;true_flag=1;  break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =273.15;			 upper_val =  2033.15 ;true_flag=1;  break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =673.15;			 upper_val =  2093.15 ;true_flag=1;  break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =143.15;			 upper_val =  1573.15 ;true_flag=1;  break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =273.15;			 upper_val =  2573.15 ;true_flag=1;  break;	 /*  TC-C   		   */  
		   	}			  														    
					  
		}


		
	  	if(true_flag==1){
					
  		fassign(func1_AI_lo_lim	 , lower_val);
		fassign(func1_AI_hi_lim	 , upper_val);

		fassign(trans1_INPUT_LOWER_RANGE  , lower_val);
		fassign(trans1_INPUT_UPPER_RANGE  , upper_val);
		
		fassign(func1_AI_pv_lower_range_value, lower_val);
		fassign(func1_AI_pv_upper_range_value, upper_val);

 		fassign(func1_AI_out_lower_range_value, lower_val);
		fassign(func1_AI_out_upper_range_value, upper_val);
		}

	}
}


METHOD method_set_upper_and_lower_values_conformance_default
{
	CLASS		INPUT;
	DEFINITION
	{
		int		lin_type;
		float	lower_val, upper_val;
	 	int true_flag;

		true_flag=0;
	 													  			 
		lin_type = ivar_value(trans1_lin_type);			  			 
		lower_val=0;
		upper_val=0;



		if(ivar_value(func1_AI_out_unit)==1243)
		{
			lower_val = -50 ;		 upper_val =	1000 ; true_flag=1; /*  mV	   */   					
		}

		if(ivar_value(func1_AI_out_unit)==1240)
		{
			lower_val = -0.05 ;		 upper_val =	1 ; true_flag=1; /*  V	   */   					
		}
					

		if(ivar_value(func1_AI_out_unit)==1281)
		{
			lower_val =  0  ;		 upper_val =	4000 ; true_flag=1;  /*  Ohm   */   					
		}
					

		if(ivar_value(func1_AI_out_unit)==1342)
		{
			lower_val =  100  ;		 upper_val =	100 ; true_flag=1;  /*  Ohm   */   					
		}



		  //values only valid for unit C !!!
		  if(ivar_value(func1_AI_out_unit)==1001)
		  {
			switch (lin_type)
			{


			case  102    :		lower_val =	-200;			 upper_val =  850   ;true_flag=1;  break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	-200;			 upper_val =  850   ;true_flag=1;  break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	-200;			 upper_val =  850   ;true_flag=1;  break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	-200;			 upper_val =  850   ;true_flag=1;  break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	-200;			 upper_val =  850   ;true_flag=1;  break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	-200;			 upper_val =  850   ;true_flag=1;  break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	-100;			 upper_val =  650   ;true_flag=1;  break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	-100;			 upper_val =  650   ;true_flag=1;  break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	-100;			 upper_val =  650   ;true_flag=1;  break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	-100;			 upper_val =  650   ;true_flag=1;  break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	-100;			 upper_val =  650   ;true_flag=1;  break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	-200;			 upper_val =  510   ;true_flag=1;  break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	-80 ;			 upper_val =  320   ;true_flag=1;  break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	-50 ;			 upper_val =  250   ;true_flag=1;  break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	-180;			 upper_val =  760   ;true_flag=1;  break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	-150;			 upper_val =  1370  ;true_flag=1;  break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	-170;			 upper_val =  1000  ;true_flag=1;  break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	-170;			 upper_val =  400   ;true_flag=1;  break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	0;			 upper_val =  1760  ;true_flag=1;  break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	0;			 upper_val =  1760  ;true_flag=1;  break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	400;			 upper_val =  1820  ;true_flag=1;  break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	-130;			 upper_val =  1300  ;true_flag=1;  break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	0;			 upper_val =  2300  ;true_flag=1;  break;	 /*  TC-C   		   */  
		   	}			  														    
					  
		}

		  //values only valid for unit F !!!
		  if(ivar_value(func1_AI_out_unit)==1002)
		  {
			switch (lin_type)
			{


			case  102    :		lower_val =-328;   				upper_val =  1562 ;true_flag=1;  break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =-328;   				upper_val =  1562 ;true_flag=1;  break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =-328;   				upper_val =  1562 ;true_flag=1;  break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =-328;   				upper_val =  1562 ;true_flag=1;  break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =-328;   				upper_val =  1562 ;true_flag=1;  break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =-328;   				upper_val =  1562 ;true_flag=1;  break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =-148;   				upper_val =  1202 ;true_flag=1;  break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =-148;   				upper_val =  1202 ;true_flag=1;  break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =-148;   				upper_val =  1202 ;true_flag=1;  break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =-148;   				upper_val =  1202 ;true_flag=1;  break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =-148;   				upper_val =  1202 ;true_flag=1;  break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =-328;   				upper_val =  950 ;true_flag=1;  break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =-112;   				upper_val =  608 ;true_flag=1;  break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =-58;	   				upper_val =  482 ;true_flag=1;  break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =-292;   				upper_val =  1400 ;true_flag=1;  break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =-238;   				upper_val =  2498 ;true_flag=1;  break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =-274;   				upper_val =  1832 ;true_flag=1;  break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =-274;   				upper_val =  752 ;true_flag=1;  break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =32;	   				upper_val =  3200 ;true_flag=1;  break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =32;	   				upper_val =  3200 ;true_flag=1;  break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =752;   				upper_val =  3308 ;true_flag=1;  break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =-202;   				upper_val =  2372 ;true_flag=1;  break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =32;	   				upper_val =  4172 ;true_flag=1;  break;	 /*  TC-C   		   */  
		   	}			  														    
					  
		}


		  if(ivar_value(func1_AI_out_unit)==1003)
		  {
			switch (lin_type)
			{


			case  102    :		lower_val =	131.67;			 upper_val =  2021.67 ;true_flag=1;  break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =	131.67;			 upper_val =  2021.67 ;true_flag=1;  break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =	131.67;			 upper_val =  2021.67 ;true_flag=1;  break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =	131.67;			 upper_val =  2021.67 ;true_flag=1;  break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =	131.67;			 upper_val =  2021.67 ;true_flag=1;  break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =	131.67;			 upper_val =  2021.67 ;true_flag=1;  break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =	311.67;			 upper_val =  1661.67 ;true_flag=1;  break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =	311.67;			 upper_val =  1661.67 ;true_flag=1;  break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =	311.67;			 upper_val =  1661.67 ;true_flag=1;  break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =	311.67;			 upper_val =  1661.67 ;true_flag=1;  break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =	311.67;			 upper_val =  1661.67 ;true_flag=1;  break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =	131.67;			 upper_val =  1409.67 ;true_flag=1;  break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =	347.67;			 upper_val =  1067.67 ;true_flag=1;  break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =	401.67;			 upper_val =  941.67  ;true_flag=1;  break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =	167.67;			 upper_val =  1859.67 ;true_flag=1;  break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =	221.67;			 upper_val =  2957.67 ;true_flag=1;  break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =	185.67;			 upper_val =  2291.67 ;true_flag=1;  break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =	185.67;			 upper_val =  1211.67 ;true_flag=1;  break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =	491.67;			 upper_val =  3659.67 ;true_flag=1;  break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =	491.67;			 upper_val =  3659.67 ;true_flag=1;  break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =	1211.67;		 	 upper_val =  3767.67 ;true_flag=1;  break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =	257.67;			 upper_val =  2831.67 ;true_flag=1;  break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =	491.67;			 upper_val =  4631.67 ;true_flag=1;  break;	 /*  TC-C   		   */  
		   	}			  														    
					  
		}


		  if(ivar_value(func1_AI_out_unit)==1000)
		  {
			switch (lin_type)
			{


			case  102    :		lower_val =73.15;				 upper_val =  1123.15 ;true_flag=1;  break;	 /*  RTD 100(a=3850)   */  
			case  103    :		lower_val =73.15;				 upper_val =  1123.15 ;true_flag=1;  break;	 /*  RTD 200(a=3850)   */  
			case  242    :		lower_val =73.15;				 upper_val =  1123.15 ;true_flag=1;  break;	 /*  RTD 300(a=3850)   */  
			case  240    :		lower_val =73.15;				 upper_val =  1123.15 ;true_flag=1;  break;	 /*  RTD 400(a=3850)   */  
			case  104    :		lower_val =73.15;				 upper_val =  1123.15 ;true_flag=1;  break;	 /*  RTD 500(a=3850)   */  
			case  105    :		lower_val =73.15;				 upper_val =  1123.15 ;true_flag=1;  break;	 /*  RTD 1000(a=3850)  */  
			case  111    :		lower_val =173.15;			 upper_val =  923.15  ;true_flag=1;  break;	 /*  RTD 100(a=3902)   */  
			case  112    :		lower_val =173.15;			 upper_val =  923.15  ;true_flag=1;  break;	 /*  RTD 200(a=3902)   */  
			case  241    :		lower_val =173.15;			 upper_val =  923.15  ;true_flag=1;  break;	 /*  RTD 400(a=3902)   */  
			case  113    :		lower_val =173.15;			 upper_val =  923.15  ;true_flag=1;  break;	 /*  RTD 500(a=3902)   */  
			case  114    :		lower_val =173.15;			 upper_val =  923.15  ;true_flag=1;  break;	 /*  RTD 1000(a=3902)  */  
			case  108    :		lower_val =73.15;			 	 upper_val =  783.15  ;true_flag=1;  break;	 /*  RTD 100(a=3916)   */  
			case  120    :		lower_val =193.15;			 upper_val =  593.15  ;true_flag=1;  break;	 /*  RTD 120(a=0.672)  */  
			case  126    :		lower_val =223.15;			 upper_val =  523.15  ;true_flag=1;  break;	 /*  RTD 100(a=0.427)  */  
			case  133	: 		lower_val =93.15;				 upper_val =  1033.15  ;true_flag=1;  break;	 /*  TC-J   		   */  
			case  134	: 		lower_val =123.15;			 upper_val =  1643.15 ;true_flag=1;  break;	 /*  TC-K   		   */  
			case  131	: 		lower_val =103.15;			 upper_val =  1273.15 ;true_flag=1;  break;	 /*  TC-E   		   */  
			case  138	: 		lower_val =103.15;			 upper_val =  673.15  ;true_flag=1;  break;	 /*  TC-T   		   */  
			case  136	: 		lower_val =273.15;			 upper_val =  2033.15 ;true_flag=1;  break;	 /*  TC-R   		   */  
			case  137	: 		lower_val =273.15;			 upper_val =  2033.15 ;true_flag=1;  break;	 /*  TC-S   		   */  
			case  128	: 		lower_val =673.15;			 upper_val =  2093.15 ;true_flag=1;  break;	 /*  TC-B   		   */  
			case  135	: 		lower_val =143.15;			 upper_val =  1573.15 ;true_flag=1;  break;	 /*  TC-N   		   */  
			case  129	: 		lower_val =273.15;			 upper_val =  2573.15 ;true_flag=1;  break;	 /*  TC-C   		   */  
		   	}			  														    
					  
		}

		
	  	if(true_flag==1){
					
	   	fassign(lower_sensor_limit_con	, lower_val);
	   	fassign(upper_sensor_limit_con	, upper_val);
		}

	}
}

METHOD method_set_rj_type
{
	CLASS		INPUT;
	DEFINITION
	{

		int	lin_type;

		lin_type    = ivar_value(trans1_lin_type);

		//LIN, TABLE
		if(	lin_type ==0   || 	lin_type==1    )
		{
			iassign(trans1_reference_junction_type,0);
		}
		else
		{

				// RTD
				if( (lin_type >= 102) && (lin_type <= 126) || (lin_type >= 240) && (lin_type <= 242)  )
				{
					iassign(trans1_reference_junction_type,0);
				}
				// TC
				else 
				{	  
					iassign(trans1_reference_junction_type,1);

				}

		}

	}
}
/*--------------------------------------------------------------------------------------*/

/*

{	0,	[trans_temp_sensor_connection_2_WIRE]		},
{	1,	[trans_temp_sensor_connection_3_WIRE]		},
{	2,	[trans_temp_sensor_connection_4_WIRE]		}


*/


METHOD method_set_trans1_sensor_connection
{
	CLASS		INPUT;
	DEFINITION
	{
 
		int	input_range;
		int	lin_type;

		lin_type    = ivar_value(trans1_lin_type);
		input_range = ivar_value(trans1_input_range);

		//LIN, TABLE
		if(	lin_type ==0   || 	lin_type==1    )
		{
				// poti
				if( (input_range >= 240) && (input_range <= 245) )
				{
					   
						if (ivar_value(trans1_sensor_connection) != 1)
							iassign(trans1_sensor_connection, 1);

				}
				// ohms or mV
				else 
				{	  
				  
					if (ivar_value(trans1_sensor_connection) != 0)
						iassign(trans1_sensor_connection, 0);

				}
		}
		else
		{

				// RTD
				if( (lin_type >= 102) && (lin_type <= 126) || (lin_type >= 240) && (lin_type <= 242)  )
				{
					   
						if (ivar_value(trans1_sensor_connection) != 2)
							iassign(trans1_sensor_connection, 2);

				}
				// TC
				else 
				{	  
				   
					if (ivar_value(trans1_sensor_connection) != 0)
						iassign(trans1_sensor_connection, 0);
				}

		}

	}
}

/*--------------------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------------*/


METHOD method_set_status_limit
{
	CLASS		INPUT;
	DEFINITION
	{
		int	quality;
		int block_mode;		  

		quality = ivar_value(func1_AI_simulate_status_quality);
		if ((quality == 0x20) || (quality == 0x30))
			iassign(func1_AI_simulate_status_limit, 0);

		block_mode	= ivar_value(func1_AI_target_mode);
		quality = ivar_value(func1_AI_out_status_quality);
		if ((block_mode == BLOCK_MODE_MAN) && ((quality == 0x20) || (quality == 0x30)))
			iassign(func1_AI_out_status_limit, 0);
	}
}




METHOD method_start_table_transfer
{
	CLASS		INPUT;
	DEFINITION
	{
		int		n;
		int		error;
		float	y_val[128];
		char	text[];

		error	= 0;
		
		y_val[0]	= fvar_value(trans1_tab_y_value_0);
		y_val[1]	= fvar_value(trans1_tab_y_value_1);
		y_val[2]	= fvar_value(trans1_tab_y_value_2);
		y_val[3]	= fvar_value(trans1_tab_y_value_3);
		y_val[4]	= fvar_value(trans1_tab_y_value_4);
		y_val[5]	= fvar_value(trans1_tab_y_value_5);
		y_val[6]	= fvar_value(trans1_tab_y_value_6);
		y_val[7]	= fvar_value(trans1_tab_y_value_7);
		y_val[8]	= fvar_value(trans1_tab_y_value_8);
		y_val[9]	= fvar_value(trans1_tab_y_value_9);
		y_val[10]	= fvar_value(trans1_tab_y_value_10);
		y_val[11]	= fvar_value(trans1_tab_y_value_11);
		y_val[12]	= fvar_value(trans1_tab_y_value_12);
		y_val[13]	= fvar_value(trans1_tab_y_value_13);
		y_val[14]	= fvar_value(trans1_tab_y_value_14);
		y_val[15]	= fvar_value(trans1_tab_y_value_15);
		y_val[16]	= fvar_value(trans1_tab_y_value_16);

		y_val[17]	= fvar_value(trans1_tab_y_value_17);
		y_val[18]	= fvar_value(trans1_tab_y_value_18);
		y_val[19]	= fvar_value(trans1_tab_y_value_19);
		y_val[20]	= fvar_value(trans1_tab_y_value_20);
		y_val[21]	= fvar_value(trans1_tab_y_value_21);
		y_val[22]   = fvar_value(trans1_tab_y_value_22);
		y_val[23]   = fvar_value(trans1_tab_y_value_23);
		y_val[24]   = fvar_value(trans1_tab_y_value_24);
		y_val[25]   = fvar_value(trans1_tab_y_value_25);
		y_val[26]   = fvar_value(trans1_tab_y_value_26);
		y_val[27]   = fvar_value(trans1_tab_y_value_27);
		y_val[28]   = fvar_value(trans1_tab_y_value_28);
		y_val[29]   = fvar_value(trans1_tab_y_value_29);
		y_val[30]   = fvar_value(trans1_tab_y_value_30);
		y_val[31]   = fvar_value(trans1_tab_y_value_31);
		y_val[32]   = fvar_value(trans1_tab_y_value_32);

		y_val[33]   = fvar_value(trans1_tab_y_value_33);
		y_val[34]   = fvar_value(trans1_tab_y_value_34);
		y_val[35]   = fvar_value(trans1_tab_y_value_35);
		y_val[36]   = fvar_value(trans1_tab_y_value_36);
		y_val[37]   = fvar_value(trans1_tab_y_value_37);
		y_val[38]   = fvar_value(trans1_tab_y_value_38);
		y_val[39]   = fvar_value(trans1_tab_y_value_39);
		y_val[40]   = fvar_value(trans1_tab_y_value_40);
		y_val[41]   = fvar_value(trans1_tab_y_value_41);
		y_val[42]   = fvar_value(trans1_tab_y_value_42);
		y_val[43]   = fvar_value(trans1_tab_y_value_43);
		y_val[44]   = fvar_value(trans1_tab_y_value_44);
		y_val[45]   = fvar_value(trans1_tab_y_value_45);
		y_val[46]   = fvar_value(trans1_tab_y_value_46);
		y_val[47]   = fvar_value(trans1_tab_y_value_47);
		y_val[48]   = fvar_value(trans1_tab_y_value_48);

		y_val[49]   = fvar_value(trans1_tab_y_value_49);
		y_val[50]   = fvar_value(trans1_tab_y_value_50);
		y_val[51]   = fvar_value(trans1_tab_y_value_51);
		y_val[52]   = fvar_value(trans1_tab_y_value_52);
		y_val[53]   = fvar_value(trans1_tab_y_value_53);
		y_val[54]   = fvar_value(trans1_tab_y_value_54);
		y_val[55]   = fvar_value(trans1_tab_y_value_55);
		y_val[56]   = fvar_value(trans1_tab_y_value_56);
		y_val[57]   = fvar_value(trans1_tab_y_value_57);
		y_val[58]   = fvar_value(trans1_tab_y_value_58);
		y_val[59]   = fvar_value(trans1_tab_y_value_59);
		y_val[60]   = fvar_value(trans1_tab_y_value_60);
		y_val[61]   = fvar_value(trans1_tab_y_value_61);
		y_val[62]   = fvar_value(trans1_tab_y_value_62);
		y_val[63]   = fvar_value(trans1_tab_y_value_63);

		y_val[64]	= fvar_value(trans1_tab_y_value_64);
		y_val[65]	= fvar_value(trans1_tab_y_value_65);
		y_val[66]	= fvar_value(trans1_tab_y_value_66);
		y_val[67]	= fvar_value(trans1_tab_y_value_67);
		y_val[68]	= fvar_value(trans1_tab_y_value_68);
		y_val[69]	= fvar_value(trans1_tab_y_value_69);
		y_val[70]	= fvar_value(trans1_tab_y_value_70);
		y_val[71]	= fvar_value(trans1_tab_y_value_71);
		y_val[72]	= fvar_value(trans1_tab_y_value_72);
		y_val[73]	= fvar_value(trans1_tab_y_value_73);
		y_val[74]	= fvar_value(trans1_tab_y_value_74);
		y_val[75]	= fvar_value(trans1_tab_y_value_75);
		y_val[76]	= fvar_value(trans1_tab_y_value_76);
		y_val[77]	= fvar_value(trans1_tab_y_value_77);
		y_val[78]	= fvar_value(trans1_tab_y_value_78);
		y_val[79]	= fvar_value(trans1_tab_y_value_79);
		y_val[80]	= fvar_value(trans1_tab_y_value_80);

		y_val[81]	= fvar_value(trans1_tab_y_value_81);
		y_val[82]	= fvar_value(trans1_tab_y_value_82);
		y_val[83]	= fvar_value(trans1_tab_y_value_83);
		y_val[84]	= fvar_value(trans1_tab_y_value_84);
		y_val[85]	= fvar_value(trans1_tab_y_value_85);
		y_val[86]	= fvar_value(trans1_tab_y_value_86);
		y_val[87]	= fvar_value(trans1_tab_y_value_87);
		y_val[88]	= fvar_value(trans1_tab_y_value_88);
		y_val[89]	= fvar_value(trans1_tab_y_value_89);
		y_val[90]	= fvar_value(trans1_tab_y_value_90);
		y_val[91]	= fvar_value(trans1_tab_y_value_91);
		y_val[92]	= fvar_value(trans1_tab_y_value_92);
		y_val[93]	= fvar_value(trans1_tab_y_value_93);
		y_val[94]	= fvar_value(trans1_tab_y_value_94);
		y_val[95]	= fvar_value(trans1_tab_y_value_95);
		y_val[96]	= fvar_value(trans1_tab_y_value_96);

		y_val[97]	= fvar_value(trans1_tab_y_value_97);
		y_val[98]	= fvar_value(trans1_tab_y_value_98);
		y_val[99]	= fvar_value(trans1_tab_y_value_99);
		y_val[100]	= fvar_value(trans1_tab_y_value_100);
		y_val[101]	= fvar_value(trans1_tab_y_value_101);
		y_val[102]	= fvar_value(trans1_tab_y_value_102);
		y_val[103]	= fvar_value(trans1_tab_y_value_103);
		y_val[104]	= fvar_value(trans1_tab_y_value_104);
		y_val[105]	= fvar_value(trans1_tab_y_value_105);
		y_val[106]	= fvar_value(trans1_tab_y_value_106);
		y_val[107]	= fvar_value(trans1_tab_y_value_107);
		y_val[108]	= fvar_value(trans1_tab_y_value_108);
		y_val[109]	= fvar_value(trans1_tab_y_value_109);
		y_val[110]	= fvar_value(trans1_tab_y_value_110);
		y_val[111]	= fvar_value(trans1_tab_y_value_111);
		y_val[112]	= fvar_value(trans1_tab_y_value_112);

		y_val[113]	= fvar_value(trans1_tab_y_value_113);
		y_val[114]	= fvar_value(trans1_tab_y_value_114);
		y_val[115]	= fvar_value(trans1_tab_y_value_115);
		y_val[116]	= fvar_value(trans1_tab_y_value_116);
		y_val[117]	= fvar_value(trans1_tab_y_value_117);
		y_val[118]	= fvar_value(trans1_tab_y_value_118);
		y_val[119]	= fvar_value(trans1_tab_y_value_119);
		y_val[120]	= fvar_value(trans1_tab_y_value_120);
		y_val[121]	= fvar_value(trans1_tab_y_value_121);
		y_val[122]	= fvar_value(trans1_tab_y_value_122);
		y_val[123]	= fvar_value(trans1_tab_y_value_123);
		y_val[124]	= fvar_value(trans1_tab_y_value_124);
		y_val[125]	= fvar_value(trans1_tab_y_value_125);
		y_val[126]	= fvar_value(trans1_tab_y_value_126);
		y_val[127]	= fvar_value(trans1_tab_y_value_127);


		for (n = 1; n < tab_actual_number; n++)

		{
			if (y_val[n] < y_val[n-1])
			{
				error = 1;
				break;
			}
		}

		if (error != 0)
		{
			get_dictionary_string(lin_tab_status_NOT_INC, text);
			PUT_MESSAGE (text);
		}

		iassign(trans1_tab_op_code, 1);			// START of transmission
		WriteCommand(write_trans1_tab_op_code);
	}
}




METHOD method_end_table_transfer(int index)
{
	CLASS		INPUT;
	DEFINITION
	{
		int		status;
		char	text[];
		int num;

		num = index + 1;
		if(num == tab_actual_number)
		{

			iassign(trans1_tab_op_code, 3);			// END of transmission
			WriteCommand(write_trans1_tab_op_code);
			ReadCommand(read_trans1_tab_status);
			status = ivar_value(trans1_tab_status);
			switch (status)
		 	{
				case 0:
				{
					get_dictionary_string(lin_tab_status_NOT_INIT, text);
					PUT_MESSAGE (text);
					break;
				}
				case 2:
				{
					get_dictionary_string(lin_tab_status_NOT_INC, text);
					PUT_MESSAGE (text);
					break;
				}
				case 3:
				{
					get_dictionary_string(lin_tab_status_NOT_DEC, text);
					PUT_MESSAGE (text);
					break;
				}
				case 4:
				{
					get_dictionary_string(lin_tab_status_NOT_ENOUGH_VALUES, text);
					PUT_MESSAGE (text);
					break;
				}
				case 5:
				{
					get_dictionary_string(lin_tab_status_TOO_MANY_VALUES, text);
					PUT_MESSAGE (text);
					break;
				}
				case 6:
				{
					get_dictionary_string(lin_tab_status_GRADIENT, text);
					PUT_MESSAGE (text);
					break;
				}
				case 7:
				{
					get_dictionary_string(lin_tab_status_NOT_ACCEPTED, text);
					PUT_MESSAGE (text);
					break;
				}
				case 1:		// table status: good
				default:
				{
					  ReadCommand(	read_trans1_tab_actual_number ); 
					break;	
				}

	    	}
	   	}

	}
}






METHOD method_set_tab_entry	(int entry)
{
	CLASS		INPUT;
	DEFINITION
	{
		int num;
		num = entry + 1;
		iassign(trans1_tab_entry, num);
		WriteCommand(write_trans1_tab_entry);
	}
}


METHOD set_tab_actual_number
{
	DEFINITION
	{
		tab_actual_number = ivar_value(trans1_tab_actual_number);
	}
}


METHOD set_valid_coordinates
{
	LABEL		[valid_coordinates];
	DEFINITION
	{
		if ((ivar_value(tab_actual_number) < 2))
			{
				iassign(tab_actual_number, 2);
				PUT_MESSAGE ([valid_coordinates]);
			}
		if ((ivar_value(tab_actual_number) > 128))
			{
				iassign(tab_actual_number, 128);
				PUT_MESSAGE ([valid_coordinates]);
			}
	}
}




/* method calibration mv */
METHOD method_calibration_mv
{
	LABEL [calibration_mv] ;
	CLASS		INPUT;
	DEFINITION
	{
		// Nr.,Slot,Index,Parametername,Access,Store,Type,Range,Default,Handle,Expected answer
		//,,,Calibration of MV-Input
		//3,1,99,Execute reset(FACTORY_RESET=1),rw,S,DU16,[x],[1],Write,good
		iassign(phys_factory_reset,1);
		WriteCommand(write_phys_factory_reset);
		//4,,,Wait(3s) until coldstart is completed,,,DU8,[x],[3],Wait
		DELAY(3,[wait_msg1]); 
		//
		 add_abort_method(abort_initialization);

		iassign (phys_write_locking,37865);
 	  	WriteCommand( write_phys_write_locking);
		//,,,PROFIBUS PRIMARY_VALUE_UNIT to UFE units
		//
		//6,1,174,set LIN_TYPE to linear,rw,N,DU8,[x],[0],Write,good
		iassign(trans1_lin_type,0);
		WriteCommand( write_trans1_lin_type );
		//7,1,173,INPUT_RANGE  0 - mV,rw,S,DU8,[x],[0],Write,good
		iassign(trans1_input_range,0);
		WriteCommand( write_trans1_input_range);
		//8,1,150,INPUT_SENSOR_TYPE,rw,N,DU8,[x],[85],CheckDefault,good
		iassign(phys_INPUT_SENSOR_TYPE,85);
		WriteCommand( write_phys_INPUT_SENSOR_TYPE);
	   //	9,1,149,MEASUREMENT_TYPE,rw,N,DU8,[x],[4],CheckDefault,good
		iassign(phys_MEASUREMENT_TYPE,4);
		WriteCommand( write_phys_MEASUREMENT_TYPE);

		//10,1,151,PRIMARY_MEASURE_UNIT,rw,N,DU8,[x],[36],CheckDefault,good
		
		iassign( phys_PRIMARY_MEASURE_UNIT,36);
		WriteCommand( write_phys_PRIMARY_MEASURE_UNIT);
		//
		//11,1,98,WRITE_ LOCKING,rw,N,DU16,[x],[37865],Write,good
		//
		//,,,Calibration of zero scale for mV input
		//
		//11,,,Calibrate for Gain=1set input to 0.0mV and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_mv_msg1]);
		//13,,,Wait 3s until value is stable,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg2]); 

		//12,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00004000],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00004000 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//13,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 
		//
		//14,,,Calibrate for Gain=2set input to 0.0mV and press <ENTER>,,,DU8,,[x],Hold,dummy
		//15,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00004001],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00004001 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//16,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 
		//
		//17,,,Calibrate for Gain=4set input to 0.0mV and press <ENTER>,,,DU8,,[x],Hold,dummy
		//18,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00004002],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00004002 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//19,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 

		//
		//20,,,Calibrate for Gain=8set input to 0.0mV and press <ENTER>,,,DU8,,[x],Hold,dummy
		//21,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00004003],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00004003 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);

		//22,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 

		//
		//23,,,Calibrate for Gain=16set input to 0.0mV and press <ENTER>,,,DU8,,[x],Hold,dummy
		//24,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00004004],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00004004 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);

		//25,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 


		//
		//26,,,Calibrate for Gain=32set input to 0.0mV and press <ENTER>,,,DU8,,[x],Hold,dummy
		//27,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00004005],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00004005 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);

		//28,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 

		//
		//29,,,Calibrate for Gain=64 set input to 0.0mV and press <ENTER>,,,DU8,,[x],Hold,dummy
		//30,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00004006],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00004006 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);

		//31,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 

		//
		//,,,Calibration of fuLL scale for mV input
		//
		//32,,,Calibrate for Gain=1set input to 1000.0mV and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_mv_msg4]);

		//33,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00004020],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00004020 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);

		//34,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 

		//
		//36,,,Calibrate for Gain=2set input to 500.0mV and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_mv_msg5]);

		//37,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00004021],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00004021 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);

		//38,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 

		//
	   //	39,,,Calibrate for Gain=4set input to 250.0mV and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_mv_msg6]);

		//40,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00004022],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00004022 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//41,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 

		//
		//42,,,Calibrate for Gain=8set input to 125.0mV and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_mv_msg7]);

		//43,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00004023],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00004023 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//44,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 

		//
		//45,,,Calibrate for Gain=16set input to 62.5mV and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_mv_msg8]);

		//46,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00004024],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00004024 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//47,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 

		//
		//48,,,Calibrate for Gain=32set input to 31.25mV and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_mv_msg9]);

		//49,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00004025],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00004025 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//50,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 

		//
		//51,,,Calibrate for Gain=64 set input to 15.625mV and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_mv_msg10]);

		//52,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00004026],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00004026 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//53,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 

		//
		//,,,End of calibration of mV-Input, proceed coldstart and normal operation
		//
		//54,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00000000],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00000000 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//
		//55,1,99,Execute reset(FACTORY_RESET=1),rw,S,DU16,[x],[1],Write,good
		iassign(phys_factory_reset, 2506)	;
		WriteCommand(write_phys_factory_reset);
		//
		DELAY(3,[wait_msg2]); 
		//56,,,Wait(3s) until warmstart is completed,,,DU8,[x],[3],Wait
		//57,,,Verbindung neu aufbauen,,,DU8,[x],[3],ConnectPA
		//
		//,,,PROFIBUS PRIMARY_VALUE_UNIT to UFE units
		//
		iassign (phys_write_locking,37865);
 	  	WriteCommand( write_phys_write_locking);

		//,,,PROFIBUS PRIMARY_VALUE_UNIT to UFE units
		//
		//58,1,174,set LIN_TYPE to linear,rw,N,DU8,[x],[0],Write,good
		
		iassign(trans1_lin_type,0);
		WriteCommand( write_trans1_lin_type );

		//59,1,173,INPUT_RANGE  0 - mV,rw,S,DU8,[x],[0],Write,good
		iassign(trans1_input_range,0);
		WriteCommand( write_trans1_input_range);

		//60,1,150,INPUT_SENSOR_TYPE,rw,N,DU8,[x],[85],CheckDefault,good
		iassign(phys_INPUT_SENSOR_TYPE,85);
		WriteCommand( write_phys_INPUT_SENSOR_TYPE);


		//61,1,149,MEASUREMENT_TYPE,rw,N,DU8,[x],[4],CheckDefault,good
		iassign(phys_MEASUREMENT_TYPE,4);
		WriteCommand( write_phys_MEASUREMENT_TYPE);

		//62,1,151,PRIMARY_MEASURE_UNIT,rw,N,DU8,[x],[36],CheckDefault,good
		
		iassign( phys_PRIMARY_MEASURE_UNIT,36);
		WriteCommand( write_phys_PRIMARY_MEASURE_UNIT);
	
		iassign (phys_write_locking,2457);
 	  	WriteCommand( write_phys_write_locking);

		//
		//,,,End of calibration of MV-Input
		PUT_MESSAGE([calib_mv_msg11]);

		PUT_MESSAGE([refresh_download]);
 }
  VALIDITY  IF(SERVICECODE){ TRUE;} ELSE {FALSE;}

}


/* method calibration ohm */
METHOD method_calibration_ohm
{
	LABEL [calibration_ohm] ;
	CLASS		INPUT;
	DEFINITION
	{
		// Nr.,Slot,Index,Parametername,Access,Store,Type,Range,Default,Handle,Expected answer
		//,,,Calibration of Ohm-Input
		//3,1,99,Execute reset(FACTORY_RESET=1),rw,S,DU16,[x],[1],Write,good
	   	iassign(phys_factory_reset,1);
	  	WriteCommand(write_phys_factory_reset);
		//4,,,Wait(3s) until coldstart is completed,,,DU8,[x],[3],Wait
	  	DELAY(3,[wait_msg1]); 
		//
		iassign (phys_write_locking,37865);
 	  	WriteCommand( write_phys_write_locking);
		//,,,PROFIBUS PRIMARY_VALUE_UNIT to UFE units
		//
	   add_abort_method(abort_initialization);

		//6,1,174,set LIN_TYPE to linear,rw,N,DU8,[x],[0],Write,good
		iassign(trans1_lin_type,0);
		WriteCommand( write_trans1_lin_type );
		//7,1,173,INPUT_RANGE  128 - Ohm,rw,S,DU8,[x],[128],Write,good
	   iassign(trans1_input_range,128);
		WriteCommand( write_trans1_input_range);
		//8,1,150,INPUT_SENSOR_TYPE,rw,N,DU8,[x],[33],CheckDefault,good
		iassign(phys_INPUT_SENSOR_TYPE,33);
		WriteCommand( write_phys_INPUT_SENSOR_TYPE);
		//9,1,149,MEASUREMENT_TYPE,rw,N,DU8,[x],[5],CheckDefault,good
		iassign(phys_MEASUREMENT_TYPE,5);
		WriteCommand( write_phys_MEASUREMENT_TYPE);
		//10,1,151,PRIMARY_MEASURE_UNIT,rw,N,DU8,[x],[37],CheckDefault,good
		iassign( phys_PRIMARY_MEASURE_UNIT,37);
		WriteCommand( write_phys_PRIMARY_MEASURE_UNIT);
		//6,1,196,SENSOR_CONNECTION: 2 - 4 wires,rw,S,DU8,[x],[2],Write,good
		iassign( trans1_sensor_connection,2);
		WriteCommand( write_trans1_sensor_connection);
		//11,1,98,WRITE_ LOCKING,rw,N,DU16,[x],[37865],Write,good
		//
		//,,,Calibration of zero scale for Ohm input
		//
		//11,,,Calibrate for Gain=1set input to 0.0 Ohm and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_ohm_msg1]);
		//12,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00008000],Write,good
   	
		fassign(  trans1_ADC_CAL_INDEX,0x00008000 );

   
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 


		//
		//14,,,Calibrate for Gain=2set input to 0.0 Ohm and press <ENTER>,,,DU8,,[x],Hold,dummy
		//15,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00008001],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00008001 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 
		//
		//17,,,Calibrate for Gain=4set input to 0.0 Ohm and press <ENTER>,,,DU8,,[x],Hold,dummy
		//18,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00008002],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00008002 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 
		//
		//20,,,Calibrate for Gain=8set input to 0.0 Ohm and press <ENTER>,,,DU8,,[x],Hold,dummy
		//21,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00008003],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00008003 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 
		//
		//23,,,Calibrate for Gain=16set input to 0.0 Ohm and press <ENTER>,,,DU8,,[x],Hold,dummy
		//24,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00008004],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00008004 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 
		//
		//26,,,Calibrate for Gain=32set input to 0.0 Ohm and press <ENTER>,,,DU8,,[x],Hold,dummy
		//27,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00008005],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00008005 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 
		//
		//29,,,Calibrate for Gain=64 set input to 0.0 Ohm and press <ENTER>,,,DU8,,[x],Hold,dummy
		//30,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00008008],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00008008 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 
		//
		//,,,Calibration of fuLL scale for Ohm input
		//
		//32,,,Calibrate for Gain=1set input to 4000.0 Ohm and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_ohm_msg2]);

		//33,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00008020],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00008020 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 
		//
		//36,,,Calibrate for Gain=2set input to 2000.0 Ohm and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_ohm_msg3]);

		//37,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00008021],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00008021 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 
		//
		//39,,,Calibrate for Gain=4set input to 1000.0 Ohm and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_ohm_msg4]);

		//40,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00008022],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00008022 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 
		//
		//42,,,Calibrate for Gain=8set input to 500.0 Ohm and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_ohm_msg5]);

		//43,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00008023],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00008023 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 
		//
		//45,,,Calibrate for Gain=16set input to 250.0 Ohm and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_ohm_msg6]);

		//46,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00008024],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00008024 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 
		//
		//48,,,Calibrate for Gain=32set input to 125.0 Ohm and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_ohm_msg7]);

		//49,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00008025],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00008025 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 
		//
		//51,,,Calibrate for Gain=64 set input to 62.5 Ohm and press <ENTER>,,,DU8,,[x],Hold,dummy
		ACKNOWLEDGE([calib_ohm_msg8]);

		//52,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00008026],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00008026 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);
		//,,,Wait 3s until calibration has completed,,,DU8,[x],[3],Wait
		DELAY(3,[calib_mv_msg3]); 
		//
		//,,,End of calibration of Ohm-Input, proceed coldstart and normal operation
		//
		//54,1,155,ADC_CAL_INDEX,rw,D,XU32,[x],[0x00000000],Write,good
		fassign(  trans1_ADC_CAL_INDEX,0x00000000 );
		WriteCommand( write_trans1_ADC_CAL_INDEX);

		//
		//55,1,99,Execute reset(FACTORY_RESET=1),rw,S,DU16,[x],[1],Write,good
		iassign(phys_factory_reset,2506);
		WriteCommand(write_phys_factory_reset);

		//56,,,Wait(3s) until warmstart is completed,,,DU8,[x],[3],Wait
	   	DELAY(3,[wait_msg2]); 

		//57,,,Verbindung neu aufbauen,,,DU8,[x],[3],ConnectPA
		//
		//,,,PROFIBUS PRIMARY_VALUE_UNIT to UFE units
		//
		//
		iassign (phys_write_locking,37865);
 	  	WriteCommand( write_phys_write_locking);
		//,,,PROFIBUS PRIMARY_VALUE_UNIT to UFE units
		//
		//58,1,174,set LIN_TYPE to linear,rw,N,DU8,[x],[0],Write,good

		iassign(trans1_lin_type,0);
		WriteCommand( write_trans1_lin_type );
		//59,1,173,INPUT_RANGE  128 - Ohm,rw,S,DU8,[x],[128],Write,good
		iassign(trans1_input_range,128);
		WriteCommand( write_trans1_input_range);
		//60,1,150,INPUT_SENSOR_TYPE,rw,N,DU8,[x],[33],CheckDefault,good
		iassign(phys_INPUT_SENSOR_TYPE,33);
		WriteCommand( write_phys_INPUT_SENSOR_TYPE);
		//61,1,149,MEASUREMENT_TYPE,rw,N,DU8,[x],[5],CheckDefault,good
		iassign(phys_MEASUREMENT_TYPE,5);
		WriteCommand( write_phys_MEASUREMENT_TYPE);
		//62,1,151,PRIMARY_MEASURE_UNIT,rw,N,DU8,[x],[37],CheckDefault,good
		iassign( phys_PRIMARY_MEASURE_UNIT,37);
		WriteCommand( write_phys_PRIMARY_MEASURE_UNIT);
		//6,1,196,SENSOR_CONNECTION: 2 - 4 wires,rw,S,DU8,[x],[2],Write,good
		iassign( trans1_sensor_connection,2);
		WriteCommand( write_trans1_sensor_connection);

		//
		//,,,End of calibration of Ohm-Input
		//
		iassign (phys_write_locking,2457);
 	  	WriteCommand( write_phys_write_locking);
		//
		PUT_MESSAGE([calib_ohm_msg9]);
		PUT_MESSAGE([refresh_download]);
	}
	  VALIDITY  IF(SERVICECODE){ TRUE;} ELSE {FALSE;}

}

METHOD method_set_to_mv
{
	LABEL [set_to_mv] ;
	CLASS		INPUT;
	DEFINITION
	{


	   //	iassign(phys_factory_reset,1);
	   //	WriteCommand(write_phys_factory_reset);
		//4,,,Wait(3s) until coldstart is completed,,,DU8,[x],[3],Wait
	   //	DELAY(3,[wait_msg1]); 
		//
		 add_abort_method(abort_initialization);

		iassign (phys_write_locking,37865);
 	  	WriteCommand( write_phys_write_locking);
		//,,,PROFIBUS PRIMARY_VALUE_UNIT to UFE units
		//
		//15,1,174,set LIN_TYPE to a mV range,rw,N,DU8,[x],[0],Write,good
		iassign(trans1_lin_type,0);
		WriteCommand( write_trans1_lin_type );

		//2,1,173,INPUT_RANGE  0 - mV,rw,S,DU8,[x],[0],Write,good
	    iassign(trans1_input_range,0);
		WriteCommand( write_trans1_input_range);

		//16,1,169,PRIMARY_VALUE_UNIT[mV],rw,S,DU16,[x],[1243],Write,good
		iassign( trans1_primary_value_unit,1243);
		WriteCommand( write_trans1_primary_value_unit);

		//17,1,151,PRIMARY_MEASURE_UNIT,rw,N,DU8,[x],[36],CheckDefault,good
		iassign( phys_PRIMARY_MEASURE_UNIT,36);
		WriteCommand( write_phys_PRIMARY_MEASURE_UNIT);

		//18,1,152,AMBIENT_MEASURE_UNIT,rw,N,DU8,[x],[32],CheckDefault,good
		iassign( phys_AMBIENT_MEASURE_UNIT,32);
		WriteCommand( write_phys_AMBIENT_MEASURE_UNIT);

		iassign (phys_write_locking,2457);
 	  	WriteCommand( write_phys_write_locking);

		PUT_MESSAGE([refresh_download]);
	}
}




METHOD method_set_to_ohm
{
	LABEL [set_to_ohm] ;
	CLASS		INPUT;
	DEFINITION
	{


	   //	iassign(phys_factory_reset,1);
	   //	WriteCommand(write_phys_factory_reset);
		//4,,,Wait(3s) until coldstart is completed,,,DU8,[x],[3],Wait
	   //	DELAY(5,[wait_msg1]); 
		//
		 add_abort_method(abort_initialization);

		iassign (phys_write_locking,37865);
 	  	WriteCommand( write_phys_write_locking);
		//,,,PROFIBUS PRIMARY_VALUE_UNIT to UFE units
		//

		//6,1,174,set LIN_TYPE to linear,rw,N,DU8,[x],[0],Write,good
		iassign(trans1_lin_type,0);
		WriteCommand( write_trans1_lin_type );

		//7,1,173,INPUT_RANGE  128 - Ohm,rw,S,DU8,[x],[128],Write,good
	    iassign(trans1_input_range,128);
		WriteCommand( write_trans1_input_range);


		//8,1,150,INPUT_SENSOR_TYPE,rw,N,DU8,[x],[33],CheckDefault,good
		iassign(phys_INPUT_SENSOR_TYPE,33);
		WriteCommand( write_phys_INPUT_SENSOR_TYPE);


		//9,1,149,MEASUREMENT_TYPE,rw,N,DU8,[x],[5],CheckDefault,good
		iassign(phys_MEASUREMENT_TYPE,5);
		WriteCommand( write_phys_MEASUREMENT_TYPE);


		//10,1,151,PRIMARY_MEASURE_UNIT,rw,N,DU8,[x],[37],CheckDefault,good
		iassign( phys_PRIMARY_MEASURE_UNIT,37);
		WriteCommand( write_phys_PRIMARY_MEASURE_UNIT);



		iassign (phys_write_locking,2457);
 	  	WriteCommand( write_phys_write_locking);

		PUT_MESSAGE([refresh_download]);
	}
}




METHOD method_set_to_poti
{
	LABEL [set_to_poti] ;
	CLASS		INPUT;
	DEFINITION
	{


	   //	iassign(phys_factory_reset,1);
	   //	WriteCommand(write_phys_factory_reset);
		//4,,,Wait(3s) until coldstart is completed,,,DU8,[x],[3],Wait
	  //	DELAY(5,[wait_msg1]); 
		//
		 add_abort_method(abort_initialization);

		iassign (phys_write_locking,37865);
 	  	WriteCommand( write_phys_write_locking);
		//,,,PROFIBUS PRIMARY_VALUE_UNIT to UFE units
		//



		//16,1,174,set LIN_TYPE to linear,rw,N,DU8,[x],[0],Write,good
		iassign(trans1_lin_type,0);
		WriteCommand( write_trans1_lin_type );

		//17,1,173,INPUT_RANGE  242 - Poti 1(0..1000Ohm),rw,S,DU8,[x],[242],Write,good
	    iassign(trans1_input_range,242);
		WriteCommand( write_trans1_input_range);


		//18,1,150,INPUT_SENSOR_TYPE: 33- Ohm,rw,N,DU8,[x],[40],CheckDefault,good
		iassign(phys_INPUT_SENSOR_TYPE,40);
		WriteCommand( write_phys_INPUT_SENSOR_TYPE);

		//
		//6,1,196,SENSOR_CONNECTION: 2 - 4 wires,rw,S,DU8,[x],[2],Write,good
		iassign( trans1_sensor_connection,1);
		WriteCommand( write_trans1_sensor_connection);


		//18,1,181,UPPER_SENSOR_LIMIT,r,N,F,[x],[100.0(0xFFFFFFF0)],CheckDefault,good
		fassign(trans1_upper_sensor_limit,100.0);
		WriteCommand( write_trans1_upper_sensor_limit);

		//20,1,182,LOWER_SENSOR_LIMIT,r,N,F,[x],[0.0(0xFFFFFFF0)],CheckDefault,good
		fassign(trans1_lower_sensor_limit,100.0);
		WriteCommand( write_trans1_lower_sensor_limit);



		iassign (phys_write_locking,2457);
 	  	WriteCommand( write_phys_write_locking);

		PUT_MESSAGE([refresh_download]);
	}
}






METHOD method_set_to_rtd{
	LABEL [set_to_rtd] ;
	CLASS		INPUT;
	DEFINITION
	{

	  add_abort_method(abort_initialization);


		//
		//  Set up to RTD PT100(alpha=0.03850), -240.0C..960C, 4-wire, sensor wire check enable
		//
		//16,1,174,set LIN_TYPE to RTD sensor type(Pt100),rw,N,DU8,[x],[102],Write,good
		iassign(trans1_lin_type,102);
		WriteCommand( write_trans1_lin_type );

		//
		//,,,PROFIBUS SENSOR_WIRE_CHECK
		//
		//1,1,187,SENSOR_WIRE_CHECK: 1 - enable,rw,N,DU8,[x],[1],Write,good
		
		iassign(trans1_sensor_wire_check_1,1);
		WriteCommand( write_trans1_sensor_wire_check_1 );

		//
		//
		//
		//6,1,196,SENSOR_CONNECTION: 2 - 4 wires,rw,S,DU8,[x],[2],Write,good
		iassign( trans1_sensor_connection,2);
		WriteCommand( write_trans1_sensor_connection);

		//
		//
		// Set scaling & unit of AIFB1
		//
		//3,1,28,OUT_SCALE,rw,S,DS36,[x],[960.0][-240.0][1001][0],Write,good
		
		fassign( func1_AI_out_upper_range_value, 960.0 );
		fassign( func1_AI_out_lower_range_value, -240.0);
		iassign( func1_AI_out_unit,	 1001);
		iassign( func1_AI_out_decimal_point,0);
		WriteCommand( write_func1_AI_out_scale );

		//
		// Set up unit of TBT PV
		//
		//5,1,169,PRIMARY_VALUE_UNIT[C],rw,S,DU16,[x],[1001],Write,good
		iassign( trans1_primary_value_unit,1001);
		WriteCommand( write_trans1_primary_value_unit);

		PUT_MESSAGE([refresh_download]);
	}
}







METHOD method_set_to_tck
{
	LABEL [set_to_tck] ;
	CLASS		INPUT;
	DEFINITION
	{
		    add_abort_method(abort_initialization);


			//
			//108,1,174,LIN_TYPE: 134 - TC Type K,rw,N,DU8,[x],[134],Write,good
			iassign(trans1_lin_type,134);
			WriteCommand( write_trans1_lin_type );
			
			//109,1,150,INPUT_SENSOR_TYPE:,rw,N,DU8,[x],[50],CheckDefault,good
		    iassign(trans1_input_range,50);
			WriteCommand( write_trans1_input_range);

			//110,1,181,UPPER_SENSOR_LIMIT,r,N,F,[x],[1390.0(0xFFFFFFF0)],CheckDefault,good
			fassign(trans1_upper_sensor_limit,1390.0);
			WriteCommand( write_trans1_upper_sensor_limit);

			//111,1,182,LOWER_SENSOR_LIMIT,r,N,F,[x],[-270.0(0xFFFFFFF0)],CheckDefault,good
			fassign(trans1_lower_sensor_limit,-270.0);
			WriteCommand( write_trans1_lower_sensor_limit);
		
		
			//50,1,194,RJ_TYPE,rw,S,XU8,[x],[0x00],CheckDefault,good
			//
			iassign(trans1_reference_junction_type,0x00);
			WriteCommand( write_trans1_reference_junction_type);

			//2,1,194,RJ_TYPE: 1 - internal,rw,S,XU8,[x],[0x01],Write,good
			iassign(trans1_reference_junction_type,0x01);
			WriteCommand( write_trans1_reference_junction_type);

			
			
			//3,1,147,CONFIG_BYTE_3,rw,N,XU8,[x],[0x20(0x20)],CheckDefault,good
			iassign (phys_write_locking,37865);
	 	  	WriteCommand( write_phys_write_locking);

			iassign (phys_CONFIG_BYTE_3,0x20);
	 	  	WriteCommand( write_phys_CONFIG_BYTE_3);


			//4,1,149,MEASUREMENT_TYPE: TC+RJC,rw,N,DU8,[x],[9],CheckDefault,good
			iassign(phys_MEASUREMENT_TYPE,9);
			WriteCommand( write_phys_MEASUREMENT_TYPE);

			//
			//5,1,194,RJ_TYPE: 0 - no ref.,rw,S,XU8,[x],[0x00],Write,good
			//6,1,147,CONFIG_BYTE_3,rw,N,XU8,[x],[0x00(0x20)],CheckDefault,good
			//7,1,149,MEASUREMENT_TYPE: TC,rw,N,DU8,[x],[8],CheckDefault,good
			//
			//,,,Channel switching(Wished value has to generated manually)
			//
			//1,1,30,CHANNEL(PV),rw,S,XU16,[x],[0x0108],Write,good
			
			iassign(func1_AI_channel,0x0108);
			WriteCommand( write_func1_AI_channel);

			iassign (phys_write_locking,2457);
	 	  	WriteCommand( write_phys_write_locking);


			PUT_MESSAGE([refresh_download]);
	}
}


METHOD method_set_to_4wohm
{
	LABEL [set_to_4wohm] ;
	CLASS		INPUT;
	DEFINITION
	{

		    add_abort_method(abort_initialization);


			//6,1,174,set LIN_TYPE to linear,rw,N,DU8,[x],[0],Write,good
			iassign(trans1_lin_type,0);
			WriteCommand( write_trans1_lin_type );

			//7,1,173,INPUT_RANGE  128 - Ohm,rw,S,DU8,[x],[128],Write,good
			iassign(trans1_input_range,128);
			WriteCommand( write_trans1_input_range);

			//8,1,150,INPUT_SENSOR_TYPE,rw,N,DU8,[x],[33],CheckDefault,good
			iassign (phys_write_locking,37865);
	 	  	WriteCommand( write_phys_write_locking);
			
			iassign(phys_INPUT_SENSOR_TYPE,33);
			WriteCommand( write_phys_INPUT_SENSOR_TYPE);
		
		
			//9,1,149,MEASUREMENT_TYPE,rw,N,DU8,[x],[5],CheckDefault,good
			iassign(phys_MEASUREMENT_TYPE,5);
			WriteCommand( write_phys_MEASUREMENT_TYPE);


			//10,1,151,PRIMARY_MEASURE_UNIT,rw,N,DU8,[x],[37],CheckDefault,good
			iassign( phys_PRIMARY_MEASURE_UNIT,37);
			WriteCommand( write_phys_PRIMARY_MEASURE_UNIT);

			//
			//,,,PROFIBUS SENSOR_WIRE_CHECK to UFE configuration byte 3
			//
			//1,1,187,SENSOR_WIRE_CHECK: 1 - enable,rw,N,DU8,[x],[1],Write,good
			iassign(trans1_sensor_wire_check_1,1);
			WriteCommand( write_trans1_sensor_wire_check_1 );

			//
			//6,1,196,SENSOR_CONNECTION: 2 - 4 wires,rw,S,DU8,[x],[2],Write,good
			iassign( trans1_sensor_connection,2);
			WriteCommand( write_trans1_sensor_connection);

			//7,1,149,MEASUREMENT_TYPE: Ohm-4 wire,rw,N,DU8,[x],[7],CheckDefault,good
			iassign(phys_MEASUREMENT_TYPE,7);
			WriteCommand( write_phys_MEASUREMENT_TYPE);

			//
			iassign (phys_write_locking,2457);
	 	  	WriteCommand( write_phys_write_locking);



		PUT_MESSAGE([refresh_download]);
	}
}




METHOD method_delay_writing_3s
{
	DEFINITION
	{
		DELAY_TIME(5); /* Verzgerung in s ohne Meldung */
	}
}


METHOD abort_initialization            /* Abbruch der Initialisierungssequenz */
{
    LABEL "Abort process in action"
          "|de|Laufende Aktion abbrechen";
	DEFINITION
	{
        
		//IGNORE_ALL_COMM_STATUS();
		//IGNORE_ALL_DEVICE_STATUS();
		//IGNORE_ALL_RESPONSE_CODES();
		//IGNORE_COMM_ERROR();

        PUT_MESSAGE("Action aborted"
                    "|de|Aktion wurde abgebrochen");
	}
    HELP "Abort process in action: Aborts running sequence."
	     "|de|Laufende Aktion abbrechen: Bricht laufende Sequenz ab.";
}
/*ACKNOWLEDGEPUT_MESSAGE*/

/*******************************************************************************/
/*****	Commands  **************************************************************/
/*******************************************************************************/
MENU download_variables
{
	LABEL		[menu_load_to_PC];

	ITEMS
	{

	/*method_select_trim_mode,*/
		phys_write_locking,
		//Tab_s_ident							  ,
		//Tab_s_ident_opunit					  ,
		phys_tag_desc							  ,
		phys_descriptor							  ,
		phys_message							  ,
		//Tab_s_ident_device					  ,
		phys_device_man_id						  ,
		phys_device_id							  ,
		phys_device_ser_num						  ,
		phys_software_rev						  ,
		phys_hardware_rev						  ,
		phys_install_date						  ,
		phys_blk_profile_rev					  ,
		phys_ident_number						  ,
		Tab_st_rev								  ,
		phys_st_rev								  ,
		trans1_st_rev							  ,
		func1_AI_st_rev							  ,
		//Tab_s_man_spec_pys_param				  ,
		phys_MEASUREMENT_TYPE					  ,
		phys_INPUT_SENSOR_TYPE					  ,
		phys_PRIMARY_MEASURE_UNIT				  ,
		phys_AMBIENT_MEASURE_UNIT				  ,
		phys_INPUT_FILTER						  ,
		phys_FILTER_SIZE						  ,
		phys_LCD_ADDR							  ,
		phys_LCD_SELECTOR						  ,
		phys_LCD_STRING						  ,
		phys_TOT_HRS_CALIB						  ,
		phys_LCD_PRECISION
		//Tab_s_Custom_Curve					  ,
		IF (trans1_lin_type == 1)
		{
			trans1_tab_x_value_0, 
			trans1_tab_y_value_0,
			trans1_tab_x_value_1,
			trans1_tab_y_value_1,
			trans1_tab_x_value_2,
			trans1_tab_y_value_2,
			trans1_tab_x_value_3,
			trans1_tab_y_value_3,
			trans1_tab_x_value_4,
			trans1_tab_y_value_4,
			trans1_tab_x_value_5,
			trans1_tab_y_value_5,
			trans1_tab_x_value_6, 
			trans1_tab_y_value_6,
			trans1_tab_x_value_7, 
			trans1_tab_y_value_7,
			trans1_tab_x_value_8, 
			trans1_tab_y_value_8,
			trans1_tab_x_value_9, 
			trans1_tab_y_value_9,
			trans1_tab_x_value_10  , 
			trans1_tab_y_value_10,
			trans1_tab_x_value_11  , 
			trans1_tab_y_value_11,
			trans1_tab_x_value_12  , 
			trans1_tab_y_value_12,
			trans1_tab_x_value_13  , 
			trans1_tab_y_value_13,
			trans1_tab_x_value_14  , 
			trans1_tab_y_value_14,
			trans1_tab_x_value_15  , 
			trans1_tab_y_value_15,

			trans1_tab_x_value_16  , 
			trans1_tab_y_value_16,
			trans1_tab_x_value_17  , 
			trans1_tab_y_value_17,
			trans1_tab_x_value_18  , 
			trans1_tab_y_value_18,
			trans1_tab_x_value_19  , 
			trans1_tab_y_value_19,
			trans1_tab_x_value_20  , 
			trans1_tab_y_value_20,
			trans1_tab_x_value_21  , 
			trans1_tab_y_value_21 ,
			trans1_tab_x_value_22, 
			trans1_tab_y_value_22, 
			trans1_tab_x_value_23, 
			trans1_tab_y_value_23, 
			trans1_tab_x_value_24, 
			trans1_tab_y_value_24, 
			trans1_tab_x_value_25, 
			trans1_tab_y_value_25, 
			trans1_tab_x_value_26, 
			trans1_tab_y_value_26, 
			trans1_tab_x_value_27, 
			trans1_tab_y_value_27, 
			trans1_tab_x_value_28, 
			trans1_tab_y_value_28, 
			trans1_tab_x_value_29, 
			trans1_tab_y_value_29, 
			trans1_tab_x_value_30, 
			trans1_tab_y_value_30, 
			trans1_tab_x_value_31, 
			trans1_tab_y_value_31, 

			trans1_tab_x_value_32, 
			trans1_tab_y_value_32, 
			trans1_tab_x_value_33, 
			trans1_tab_y_value_33, 
			trans1_tab_x_value_34, 
			trans1_tab_y_value_34, 
			trans1_tab_x_value_35, 
			trans1_tab_y_value_35, 
			trans1_tab_x_value_36, 
			trans1_tab_y_value_36, 
			trans1_tab_x_value_37, 
			trans1_tab_y_value_37, 
			trans1_tab_x_value_38, 
			trans1_tab_y_value_38, 
			trans1_tab_x_value_39, 
			trans1_tab_y_value_39, 
			trans1_tab_x_value_40, 
			trans1_tab_y_value_40, 
			trans1_tab_x_value_41, 
			trans1_tab_y_value_41, 
			trans1_tab_x_value_42, 
			trans1_tab_y_value_42, 
			trans1_tab_x_value_43, 
			trans1_tab_y_value_43, 
			trans1_tab_x_value_44, 
			trans1_tab_y_value_44, 
			trans1_tab_x_value_45, 
			trans1_tab_y_value_45, 
			trans1_tab_x_value_46, 
			trans1_tab_y_value_46, 
			trans1_tab_x_value_47, 
			trans1_tab_y_value_47, 

			trans1_tab_x_value_48, 
			trans1_tab_y_value_48, 
			trans1_tab_x_value_49, 
			trans1_tab_y_value_49, 
			trans1_tab_x_value_50, 
			trans1_tab_y_value_50, 
			trans1_tab_x_value_51, 
			trans1_tab_y_value_51, 
			trans1_tab_x_value_52, 
			trans1_tab_y_value_52, 
			trans1_tab_x_value_53, 
			trans1_tab_y_value_53, 
			trans1_tab_x_value_54, 
			trans1_tab_y_value_54, 
			trans1_tab_x_value_55, 
			trans1_tab_y_value_55, 
			trans1_tab_x_value_56, 
			trans1_tab_y_value_56, 
			trans1_tab_x_value_57, 
			trans1_tab_y_value_57, 
			trans1_tab_x_value_58, 
			trans1_tab_y_value_58, 
			trans1_tab_x_value_59, 
			trans1_tab_y_value_59, 
			trans1_tab_x_value_60, 
			trans1_tab_y_value_60, 
			trans1_tab_x_value_61, 
			trans1_tab_y_value_61, 
			trans1_tab_x_value_62, 
			trans1_tab_y_value_62, 
			trans1_tab_x_value_63, 
			trans1_tab_y_value_63, 

			trans1_tab_x_value_64, 
			trans1_tab_y_value_64, 
			trans1_tab_x_value_65, 
			trans1_tab_y_value_65, 
			trans1_tab_x_value_66, 
			trans1_tab_y_value_66, 
			trans1_tab_x_value_67, 
			trans1_tab_y_value_67, 
			trans1_tab_x_value_68, 
			trans1_tab_y_value_68, 
			trans1_tab_x_value_69, 
			trans1_tab_y_value_69, 
			trans1_tab_x_value_70, 
			trans1_tab_y_value_70, 
			trans1_tab_x_value_71, 
			trans1_tab_y_value_71, 
			trans1_tab_x_value_72, 
			trans1_tab_y_value_72, 
			trans1_tab_x_value_73, 
			trans1_tab_y_value_73, 
			trans1_tab_x_value_74, 
			trans1_tab_y_value_74, 
			trans1_tab_x_value_75, 
			trans1_tab_y_value_75, 
			trans1_tab_x_value_76, 
			trans1_tab_y_value_76, 
			trans1_tab_x_value_77, 
			trans1_tab_y_value_77, 
			trans1_tab_x_value_78, 
			trans1_tab_y_value_78, 
			trans1_tab_x_value_79, 
			trans1_tab_y_value_79, 

			trans1_tab_x_value_80, 
			trans1_tab_y_value_80, 
			trans1_tab_x_value_81, 
			trans1_tab_y_value_81, 
			trans1_tab_x_value_82, 
			trans1_tab_y_value_82, 
			trans1_tab_x_value_83, 
			trans1_tab_y_value_83, 
			trans1_tab_x_value_84, 
			trans1_tab_y_value_84, 
			trans1_tab_x_value_85, 
			trans1_tab_y_value_85, 
			trans1_tab_x_value_86, 
			trans1_tab_y_value_86, 
			trans1_tab_x_value_87, 
			trans1_tab_y_value_87, 
			trans1_tab_x_value_88, 
			trans1_tab_y_value_88, 
			trans1_tab_x_value_89, 
			trans1_tab_y_value_89, 
			trans1_tab_x_value_90, 
			trans1_tab_y_value_90, 
			trans1_tab_x_value_91, 
			trans1_tab_y_value_91, 
			trans1_tab_x_value_92, 
			trans1_tab_y_value_92, 
			trans1_tab_x_value_93, 
			trans1_tab_y_value_93, 
			trans1_tab_x_value_94, 
			trans1_tab_y_value_94, 
			trans1_tab_x_value_95, 
			trans1_tab_y_value_95, 

			trans1_tab_x_value_96, 
			trans1_tab_y_value_96, 
			trans1_tab_x_value_97, 
			trans1_tab_y_value_97, 
			trans1_tab_x_value_98, 
			trans1_tab_y_value_98, 
			trans1_tab_x_value_99, 
			trans1_tab_y_value_99, 
			trans1_tab_x_value_100, 
			trans1_tab_y_value_100, 
			trans1_tab_x_value_101, 
			trans1_tab_y_value_101, 
			trans1_tab_x_value_102, 
			trans1_tab_y_value_102, 
			trans1_tab_x_value_103, 
			trans1_tab_y_value_103, 
			trans1_tab_x_value_104, 
			trans1_tab_y_value_104, 
			trans1_tab_x_value_105, 
			trans1_tab_y_value_105, 
			trans1_tab_x_value_106, 
			trans1_tab_y_value_106, 
			trans1_tab_x_value_107, 
			trans1_tab_y_value_107, 
			trans1_tab_x_value_108, 
			trans1_tab_y_value_108, 
			trans1_tab_x_value_109, 
			trans1_tab_y_value_109, 
			trans1_tab_x_value_110, 
			trans1_tab_y_value_110, 
			trans1_tab_x_value_111, 
			trans1_tab_y_value_111, 

			trans1_tab_x_value_112, 
			trans1_tab_y_value_112, 
			trans1_tab_x_value_113, 
			trans1_tab_y_value_113, 
			trans1_tab_x_value_114, 
			trans1_tab_y_value_114, 
			trans1_tab_x_value_115, 
			trans1_tab_y_value_115, 
			trans1_tab_x_value_116, 
			trans1_tab_y_value_116, 
			trans1_tab_x_value_117, 
			trans1_tab_y_value_117, 
			trans1_tab_x_value_118, 
			trans1_tab_y_value_118, 
			trans1_tab_x_value_119, 
			trans1_tab_y_value_119, 
			trans1_tab_x_value_120, 
			trans1_tab_y_value_120, 
			trans1_tab_x_value_121, 
			trans1_tab_y_value_121, 
			trans1_tab_x_value_122, 
			trans1_tab_y_value_122, 
			trans1_tab_x_value_123, 
			trans1_tab_y_value_123, 
			trans1_tab_x_value_124, 
			trans1_tab_y_value_124, 
			trans1_tab_x_value_125, 
			trans1_tab_y_value_125, 
			trans1_tab_x_value_126, 
			trans1_tab_y_value_126, 
			trans1_tab_x_value_127, 
			trans1_tab_y_value_127 
		}
		//Tab_s_input							  
	   	func1_AI_out_unit						  ,
	   	trans1_primary_value_unit				  ,

  
	  	trans1_lin_type							  ,
	  	trans1_input_range						  ,
		trans1_sensor_measure_type				  ,
		trans1_bias_1							  ,
		trans1_reference_junction_type			  ,
		trans1_sensor_connection				  ,
		trans1_comp_wire_1						  ,
		trans1_sensor_wire_check_1				  ,
		//Tab_s_characterization				  ,
		trans1_tab_min_number					  ,
		trans1_tab_max_number					  ,
		trans1_tab_actual_number				  ,
		//Tab_s_input_measindicator				  ,
		trans1_min_sensor_value_1				  ,
		trans1_max_sensor_value_1				  ,
		//Tab_s_input_measrange					  ,
		trans1_lower_sensor_limit				  ,
		trans1_upper_sensor_limit				  ,
		trans1_INPUT_LOWER_RANGE				  ,
		trans1_INPUT_UPPER_RANGE				  ,
		//Tab_s_input_measwindow				  ,
		func1_AI_pv_lower_range_value			  ,
		func1_AI_pv_upper_range_value			  ,
		//Tab_s_output							  ,
		//Tab_s_output_scalewindow				  ,
	   	func1_AI_out_lower_range_value			  ,
	   	func1_AI_out_upper_range_value			  ,
		//Tab_s_output_signal					  ,
	   	
	    func1_AI_out_decimal_point				  ,
		func1_AI_pv_ftime						  ,
		func1_AI_FSafeType						  ,
		func1_AI_FSafeValue						  ,
		//Tab_s_output_limits					  ,
		func1_AI_lo_lo_lim						  ,
		func1_AI_lo_lim							  ,
		func1_AI_hi_lim							  ,
		func1_AI_hi_hi_lim						  ,
		func1_AI_alarm_hys						  ,
		//Tab_s_interface						  ,
		//Tab_s_interface_simulate				  ,
		func1_AI_simulation_enabled				  ,
		func1_AI_simulate_value					  ,
		func1_AI_simulate_status_quality		  ,
		func1_AI_simulate_status_limit			  ,
		//Tab_s_certificates					  ,
		phys_device_certification	   ,
		
		/* bugzilla #413 mod */
		trans1_SENSOR_TRIM_MODE,
		trans1_TRIM_POINT_ZERO ,
		trans1_TRIM_POINT_SPAN ,
		trans1_TRIM_VALUE_ZERO ,
		trans1_TRIM_VALUE_SPAN 
		/* bugzilla #413 mod end */
 							   
		}					   
		PRE_READ_ACTIONS
		{
			method_pre_read_params
  		}
		POST_READ_ACTIONS
		{
		    method_lese_y_werte,
			method_lese_x_werte

		}
}


METHOD method_pre_read_params
{
	CLASS		INPUT;
	DEFINITION
	{
	  ReadCommand(read_func1_AI_out_scale);

	  ReadCommand(read_trans1_primary_value_unit);
	  ReadCommand(read_trans1_lin_type); 
	  ReadCommand(read_trans1_input_range); 

	}
}


MENU upload_variables
{
	LABEL		[menu_load_to_device];
	ITEMS
	{

		//Tab_s__ident							,
		//Tab_s__ident_opunit					,
		phys_tag_desc							,
		phys_descriptor							,
		phys_message							,
		//Tab_s__ident_device					,
		phys_install_date						,
		phys_ident_number						,
		//Tab_s_t_rev							,
		//Tab_s__man_spec_pys_param				,
		phys_LCD_ADDR							,
		phys_LCD_SELECTOR						,
		phys_LCD_STRING							,
		phys_LCD_PRECISION,
		phys_FILTER_SIZE						,
	 	phys_INPUT_FILTER	/* Freed from SERVICECODE restriction - PMS 2006-06-07 */

		IF (trans1_lin_type == 1)
		{
        IF (tab_actual_number > 0) { trans1_tab_x_value_0 }
        IF (tab_actual_number > 0) { trans1_tab_y_value_0 }
        IF (tab_actual_number > 1) { trans1_tab_x_value_1 }
        IF (tab_actual_number > 1) { trans1_tab_y_value_1 }
        IF (tab_actual_number > 2) { trans1_tab_x_value_2 }
        IF (tab_actual_number > 2) { trans1_tab_y_value_2 }
        IF (tab_actual_number > 3) { trans1_tab_x_value_3 }
        IF (tab_actual_number > 3) { trans1_tab_y_value_3 }
        IF (tab_actual_number > 4) { trans1_tab_x_value_4 }
        IF (tab_actual_number > 4) { trans1_tab_y_value_4 }
        IF (tab_actual_number > 5) { trans1_tab_x_value_5 }
        IF (tab_actual_number > 5) { trans1_tab_y_value_5 }
        IF (tab_actual_number > 6) { trans1_tab_x_value_6 }
        IF (tab_actual_number > 6) { trans1_tab_y_value_6 }
        IF (tab_actual_number > 7) { trans1_tab_x_value_7 }
        IF (tab_actual_number > 7) { trans1_tab_y_value_7 }
        IF (tab_actual_number > 8) { trans1_tab_x_value_8 }
        IF (tab_actual_number > 8) { trans1_tab_y_value_8 }
        IF (tab_actual_number > 9) { trans1_tab_x_value_9 }
        IF (tab_actual_number > 9) { trans1_tab_y_value_9 }
        IF (tab_actual_number > 10) { trans1_tab_x_value_10 }
        IF (tab_actual_number > 10) { trans1_tab_y_value_10 }
        IF (tab_actual_number > 11) { trans1_tab_x_value_11 }
        IF (tab_actual_number > 11) { trans1_tab_y_value_11 }
        IF (tab_actual_number > 12) { trans1_tab_x_value_12 }
        IF (tab_actual_number > 12) { trans1_tab_y_value_12 }
        IF (tab_actual_number > 13) { trans1_tab_x_value_13 }
        IF (tab_actual_number > 13) { trans1_tab_y_value_13 }
        IF (tab_actual_number > 14) { trans1_tab_x_value_14 }
        IF (tab_actual_number > 14) { trans1_tab_y_value_14 }
        IF (tab_actual_number > 15) { trans1_tab_x_value_15 }
        IF (tab_actual_number > 15) { trans1_tab_y_value_15 }
        IF (tab_actual_number > 16) { trans1_tab_x_value_16 }
        IF (tab_actual_number > 16) { trans1_tab_y_value_16 }
        IF (tab_actual_number > 17) { trans1_tab_x_value_17 }
        IF (tab_actual_number > 17) { trans1_tab_y_value_17 }
        IF (tab_actual_number > 18) { trans1_tab_x_value_18 }
        IF (tab_actual_number > 18) { trans1_tab_y_value_18 }
        IF (tab_actual_number > 19) { trans1_tab_x_value_19 }
        IF (tab_actual_number > 19) { trans1_tab_y_value_19 }
        IF (tab_actual_number > 20) { trans1_tab_x_value_20 }
        IF (tab_actual_number > 20) { trans1_tab_y_value_20 }
        IF (tab_actual_number > 21) { trans1_tab_x_value_21 }
        IF (tab_actual_number > 21) { trans1_tab_y_value_21 }
        IF (tab_actual_number > 22) { trans1_tab_x_value_22 }
        IF (tab_actual_number > 22) { trans1_tab_y_value_22 }
        IF (tab_actual_number > 23) { trans1_tab_x_value_23 }
        IF (tab_actual_number > 23) { trans1_tab_y_value_23 }
        IF (tab_actual_number > 24) { trans1_tab_x_value_24 }
        IF (tab_actual_number > 24) { trans1_tab_y_value_24 }
        IF (tab_actual_number > 25) { trans1_tab_x_value_25 }
        IF (tab_actual_number > 25) { trans1_tab_y_value_25 }
        IF (tab_actual_number > 26) { trans1_tab_x_value_26 }
        IF (tab_actual_number > 26) { trans1_tab_y_value_26 }
        IF (tab_actual_number > 27) { trans1_tab_x_value_27 }
        IF (tab_actual_number > 27) { trans1_tab_y_value_27 }
        IF (tab_actual_number > 28) { trans1_tab_x_value_28 }
        IF (tab_actual_number > 28) { trans1_tab_y_value_28 }
        IF (tab_actual_number > 29) { trans1_tab_x_value_29 }
        IF (tab_actual_number > 29) { trans1_tab_y_value_29 }
        IF (tab_actual_number > 30) { trans1_tab_x_value_30 }
        IF (tab_actual_number > 30) { trans1_tab_y_value_30 }
        IF (tab_actual_number > 31) { trans1_tab_x_value_31 }
        IF (tab_actual_number > 31) { trans1_tab_y_value_31 }
        IF (tab_actual_number > 32) { trans1_tab_x_value_32 }
        IF (tab_actual_number > 32) { trans1_tab_y_value_32 }
        IF (tab_actual_number > 33) { trans1_tab_x_value_33 }
        IF (tab_actual_number > 33) { trans1_tab_y_value_33 }
        IF (tab_actual_number > 34) { trans1_tab_x_value_34 }
        IF (tab_actual_number > 34) { trans1_tab_y_value_34 }
        IF (tab_actual_number > 35) { trans1_tab_x_value_35 }
        IF (tab_actual_number > 35) { trans1_tab_y_value_35 }
        IF (tab_actual_number > 36) { trans1_tab_x_value_36 }
        IF (tab_actual_number > 36) { trans1_tab_y_value_36 }
        IF (tab_actual_number > 37) { trans1_tab_x_value_37 }
        IF (tab_actual_number > 37) { trans1_tab_y_value_37 }
        IF (tab_actual_number > 38) { trans1_tab_x_value_38 }
        IF (tab_actual_number > 38) { trans1_tab_y_value_38 }
        IF (tab_actual_number > 39) { trans1_tab_x_value_39 }
        IF (tab_actual_number > 39) { trans1_tab_y_value_39 }
        IF (tab_actual_number > 40) { trans1_tab_x_value_40 }
        IF (tab_actual_number > 40) { trans1_tab_y_value_40 }
        IF (tab_actual_number > 41) { trans1_tab_x_value_41 }
        IF (tab_actual_number > 41) { trans1_tab_y_value_41 }
        IF (tab_actual_number > 42) { trans1_tab_x_value_42 }
        IF (tab_actual_number > 42) { trans1_tab_y_value_42 }
        IF (tab_actual_number > 43) { trans1_tab_x_value_43 }
        IF (tab_actual_number > 43) { trans1_tab_y_value_43 }
        IF (tab_actual_number > 44) { trans1_tab_x_value_44 }
        IF (tab_actual_number > 44) { trans1_tab_y_value_44 }
        IF (tab_actual_number > 45) { trans1_tab_x_value_45 }
        IF (tab_actual_number > 45) { trans1_tab_y_value_45 }
        IF (tab_actual_number > 46) { trans1_tab_x_value_46 }
        IF (tab_actual_number > 46) { trans1_tab_y_value_46 }
        IF (tab_actual_number > 47) { trans1_tab_x_value_47 }
        IF (tab_actual_number > 47) { trans1_tab_y_value_47 }
        IF (tab_actual_number > 48) { trans1_tab_x_value_48 }
        IF (tab_actual_number > 48) { trans1_tab_y_value_48 }
        IF (tab_actual_number > 49) { trans1_tab_x_value_49 }
        IF (tab_actual_number > 49) { trans1_tab_y_value_49 }
        IF (tab_actual_number > 50) { trans1_tab_x_value_50 }
        IF (tab_actual_number > 50) { trans1_tab_y_value_50 }
        IF (tab_actual_number > 51) { trans1_tab_x_value_51 }
        IF (tab_actual_number > 51) { trans1_tab_y_value_51 }
        IF (tab_actual_number > 52) { trans1_tab_x_value_52 }
        IF (tab_actual_number > 52) { trans1_tab_y_value_52 }
        IF (tab_actual_number > 53) { trans1_tab_x_value_53 }
        IF (tab_actual_number > 53) { trans1_tab_y_value_53 }
        IF (tab_actual_number > 54) { trans1_tab_x_value_54 }
        IF (tab_actual_number > 54) { trans1_tab_y_value_54 }
        IF (tab_actual_number > 55) { trans1_tab_x_value_55 }
        IF (tab_actual_number > 55) { trans1_tab_y_value_55 }
        IF (tab_actual_number > 56) { trans1_tab_x_value_56 }
        IF (tab_actual_number > 56) { trans1_tab_y_value_56 }
        IF (tab_actual_number > 57) { trans1_tab_x_value_57 }
        IF (tab_actual_number > 57) { trans1_tab_y_value_57 }
        IF (tab_actual_number > 58) { trans1_tab_x_value_58 }
        IF (tab_actual_number > 58) { trans1_tab_y_value_58 }
        IF (tab_actual_number > 59) { trans1_tab_x_value_59 }
        IF (tab_actual_number > 59) { trans1_tab_y_value_59 }
        IF (tab_actual_number > 60) { trans1_tab_x_value_60 }
        IF (tab_actual_number > 60) { trans1_tab_y_value_60 }
        IF (tab_actual_number > 61) { trans1_tab_x_value_61 }
        IF (tab_actual_number > 61) { trans1_tab_y_value_61 }
        IF (tab_actual_number > 62) { trans1_tab_x_value_62 }
        IF (tab_actual_number > 62) { trans1_tab_y_value_62 }
        IF (tab_actual_number > 63) { trans1_tab_x_value_63 }
        IF (tab_actual_number > 63) { trans1_tab_y_value_63 }
        IF (tab_actual_number > 64) { trans1_tab_x_value_64 }
        IF (tab_actual_number > 64) { trans1_tab_y_value_64 }
        IF (tab_actual_number > 65) { trans1_tab_x_value_65 }
        IF (tab_actual_number > 65) { trans1_tab_y_value_65 }
        IF (tab_actual_number > 66) { trans1_tab_x_value_66 }
        IF (tab_actual_number > 66) { trans1_tab_y_value_66 }
        IF (tab_actual_number > 67) { trans1_tab_x_value_67 }
        IF (tab_actual_number > 67) { trans1_tab_y_value_67 }
        IF (tab_actual_number > 68) { trans1_tab_x_value_68 }
        IF (tab_actual_number > 68) { trans1_tab_y_value_68 }
        IF (tab_actual_number > 69) { trans1_tab_x_value_69 }
        IF (tab_actual_number > 69) { trans1_tab_y_value_69 }
        IF (tab_actual_number > 70) { trans1_tab_x_value_70 }
        IF (tab_actual_number > 70) { trans1_tab_y_value_70 }
        IF (tab_actual_number > 71) { trans1_tab_x_value_71 }
        IF (tab_actual_number > 71) { trans1_tab_y_value_71 }
        IF (tab_actual_number > 72) { trans1_tab_x_value_72 }
        IF (tab_actual_number > 72) { trans1_tab_y_value_72 }
        IF (tab_actual_number > 73) { trans1_tab_x_value_73 }
        IF (tab_actual_number > 73) { trans1_tab_y_value_73 }
        IF (tab_actual_number > 74) { trans1_tab_x_value_74 }
        IF (tab_actual_number > 74) { trans1_tab_y_value_74 }
        IF (tab_actual_number > 75) { trans1_tab_x_value_75 }
        IF (tab_actual_number > 75) { trans1_tab_y_value_75 }
        IF (tab_actual_number > 76) { trans1_tab_x_value_76 }
        IF (tab_actual_number > 76) { trans1_tab_y_value_76 }
        IF (tab_actual_number > 77) { trans1_tab_x_value_77 }
        IF (tab_actual_number > 77) { trans1_tab_y_value_77 }
        IF (tab_actual_number > 78) { trans1_tab_x_value_78 }
        IF (tab_actual_number > 78) { trans1_tab_y_value_78 }
        IF (tab_actual_number > 79) { trans1_tab_x_value_79 }
        IF (tab_actual_number > 79) { trans1_tab_y_value_79 }
        IF (tab_actual_number > 80) { trans1_tab_x_value_80 }
        IF (tab_actual_number > 80) { trans1_tab_y_value_80 }
        IF (tab_actual_number > 81) { trans1_tab_x_value_81 }
        IF (tab_actual_number > 81) { trans1_tab_y_value_81 }
        IF (tab_actual_number > 82) { trans1_tab_x_value_82 }
        IF (tab_actual_number > 82) { trans1_tab_y_value_82 }
        IF (tab_actual_number > 83) { trans1_tab_x_value_83 }
        IF (tab_actual_number > 83) { trans1_tab_y_value_83 }
        IF (tab_actual_number > 84) { trans1_tab_x_value_84 }
        IF (tab_actual_number > 84) { trans1_tab_y_value_84 }
        IF (tab_actual_number > 85) { trans1_tab_x_value_85 }
        IF (tab_actual_number > 85) { trans1_tab_y_value_85 }
        IF (tab_actual_number > 86) { trans1_tab_x_value_86 }
        IF (tab_actual_number > 86) { trans1_tab_y_value_86 }
        IF (tab_actual_number > 87) { trans1_tab_x_value_87 }
        IF (tab_actual_number > 87) { trans1_tab_y_value_87 }
        IF (tab_actual_number > 88) { trans1_tab_x_value_88 }
        IF (tab_actual_number > 88) { trans1_tab_y_value_88 }
        IF (tab_actual_number > 89) { trans1_tab_x_value_89 }
        IF (tab_actual_number > 89) { trans1_tab_y_value_89 }
        IF (tab_actual_number > 90) { trans1_tab_x_value_90 }
        IF (tab_actual_number > 90) { trans1_tab_y_value_90 }
        IF (tab_actual_number > 91) { trans1_tab_x_value_91 }
        IF (tab_actual_number > 91) { trans1_tab_y_value_91 }
        IF (tab_actual_number > 92) { trans1_tab_x_value_92 }
        IF (tab_actual_number > 92) { trans1_tab_y_value_92 }
        IF (tab_actual_number > 93) { trans1_tab_x_value_93 }
        IF (tab_actual_number > 93) { trans1_tab_y_value_93 }
        IF (tab_actual_number > 94) { trans1_tab_x_value_94 }
        IF (tab_actual_number > 94) { trans1_tab_y_value_94 }
        IF (tab_actual_number > 95) { trans1_tab_x_value_95 }
        IF (tab_actual_number > 95) { trans1_tab_y_value_95 }
        IF (tab_actual_number > 96) { trans1_tab_x_value_96 }
        IF (tab_actual_number > 96) { trans1_tab_y_value_96 }
        IF (tab_actual_number > 97) { trans1_tab_x_value_97 }
        IF (tab_actual_number > 97) { trans1_tab_y_value_97 }
        IF (tab_actual_number > 98) { trans1_tab_x_value_98 }
        IF (tab_actual_number > 98) { trans1_tab_y_value_98 }
        IF (tab_actual_number > 99) { trans1_tab_x_value_99 }
        IF (tab_actual_number > 99) { trans1_tab_y_value_99 }
        IF (tab_actual_number > 100) { trans1_tab_x_value_100 }
        IF (tab_actual_number > 100) { trans1_tab_y_value_100 }
        IF (tab_actual_number > 101) { trans1_tab_x_value_101 }
        IF (tab_actual_number > 101) { trans1_tab_y_value_101 }
        IF (tab_actual_number > 102) { trans1_tab_x_value_102 }
        IF (tab_actual_number > 102) { trans1_tab_y_value_102 }
        IF (tab_actual_number > 103) { trans1_tab_x_value_103 }
        IF (tab_actual_number > 103) { trans1_tab_y_value_103 }
        IF (tab_actual_number > 104) { trans1_tab_x_value_104 }
        IF (tab_actual_number > 104) { trans1_tab_y_value_104 }
        IF (tab_actual_number > 105) { trans1_tab_x_value_105 }
        IF (tab_actual_number > 105) { trans1_tab_y_value_105 }
        IF (tab_actual_number > 106) { trans1_tab_x_value_106 }
        IF (tab_actual_number > 106) { trans1_tab_y_value_106 }
        IF (tab_actual_number > 107) { trans1_tab_x_value_107 }
        IF (tab_actual_number > 107) { trans1_tab_y_value_107 }
        IF (tab_actual_number > 108) { trans1_tab_x_value_108 }
        IF (tab_actual_number > 108) { trans1_tab_y_value_108 }
        IF (tab_actual_number > 109) { trans1_tab_x_value_109 }
        IF (tab_actual_number > 109) { trans1_tab_y_value_109 }
        IF (tab_actual_number > 110) { trans1_tab_x_value_110 }
        IF (tab_actual_number > 110) { trans1_tab_y_value_110 }
        IF (tab_actual_number > 111) { trans1_tab_x_value_111 }
        IF (tab_actual_number > 111) { trans1_tab_y_value_111 }
        IF (tab_actual_number > 112) { trans1_tab_x_value_112 }
        IF (tab_actual_number > 112) { trans1_tab_y_value_112 }
        IF (tab_actual_number > 113) { trans1_tab_x_value_113 }
        IF (tab_actual_number > 113) { trans1_tab_y_value_113 }
        IF (tab_actual_number > 114) { trans1_tab_x_value_114 }
        IF (tab_actual_number > 114) { trans1_tab_y_value_114 }
        IF (tab_actual_number > 115) { trans1_tab_x_value_115 }
        IF (tab_actual_number > 115) { trans1_tab_y_value_115 }
        IF (tab_actual_number > 116) { trans1_tab_x_value_116 }
        IF (tab_actual_number > 116) { trans1_tab_y_value_116 }
        IF (tab_actual_number > 117) { trans1_tab_x_value_117 }
        IF (tab_actual_number > 117) { trans1_tab_y_value_117 }
        IF (tab_actual_number > 118) { trans1_tab_x_value_118 }
        IF (tab_actual_number > 118) { trans1_tab_y_value_118 }
        IF (tab_actual_number > 119) { trans1_tab_x_value_119 }
        IF (tab_actual_number > 119) { trans1_tab_y_value_119 }
        IF (tab_actual_number > 120) { trans1_tab_x_value_120 }
        IF (tab_actual_number > 120) { trans1_tab_y_value_120 }
        IF (tab_actual_number > 121) { trans1_tab_x_value_121 }
        IF (tab_actual_number > 121) { trans1_tab_y_value_121 }
        IF (tab_actual_number > 122) { trans1_tab_x_value_122 }
        IF (tab_actual_number > 122) { trans1_tab_y_value_122 }
        IF (tab_actual_number > 123) { trans1_tab_x_value_123 }
        IF (tab_actual_number > 123) { trans1_tab_y_value_123 }
        IF (tab_actual_number > 124) { trans1_tab_x_value_124 }
        IF (tab_actual_number > 124) { trans1_tab_y_value_124 }
        IF (tab_actual_number > 125) { trans1_tab_x_value_125 }
        IF (tab_actual_number > 125) { trans1_tab_y_value_125 }
        IF (tab_actual_number > 126) { trans1_tab_x_value_126 }
        IF (tab_actual_number > 126) { trans1_tab_y_value_126 }
        IF (tab_actual_number > 127) { trans1_tab_x_value_127 }
        IF (tab_actual_number > 127) { trans1_tab_y_value_127 }
		}


				//Tab_s__interface						
				//Tab_s__interface_simulate				
				//Tab_s__certificates					
		  IF(SERVICECODE)						
		  {										
				phys_device_certification ,		

				phys_device_id			  ,
				phys_device_ser_num		  ,
				phys_software_rev		  ,
				phys_hardware_rev		  
			 
/* Doesn't need SERVICECODE - PMS 206-06-07	phys_INPUT_FILTER, */

		   }	
		   
				//Tab_s__input							,

          IF (trans1_lin_type == 1)
            {
                IF(tab_actual_number >=	  1){trans1_lin_type}
            }
			ELSE
			{
				trans1_lin_type				
			} 
	

             trans1_lin_type

			
			IF (trans1_lin_type < 2)
			{
     		    trans1_input_range	
			}
			ELSE
			{
				trans1_primary_value_unit	
			} 
			 
				trans1_bias_1	

			IF( (trans1_lin_type >= 128) && (trans1_lin_type <= 138))
			{							   

				trans1_reference_junction_type	
			}


			  	trans1_sensor_connection				,
				trans1_comp_wire_1					,
				trans1_sensor_wire_check_1				,
				//Tab_s__characterization				,
				//Tab_s__Custom_Curve					,
				//Tab_s__input_measindicator				,
				trans1_min_sensor_value_1				,
				trans1_max_sensor_value_1				,
				//Tab_s__input_measrange				,
				trans1_INPUT_LOWER_RANGE				,
				trans1_INPUT_UPPER_RANGE				,


				//Tab_s__input_measwindow				,
				func1_AI_pv_lower_range_value				,
				func1_AI_pv_upper_range_value				,
				//Tab_s__output						,
				//Tab_s__output_scalewindow				,
				func1_AI_out_lower_range_value				,
				func1_AI_out_upper_range_value				,
				//Tab_s__output_signal					,
				func1_AI_out_unit					,
				func1_AI_out_decimal_point				,
				func1_AI_pv_ftime					,
				func1_AI_FSafeType					,
				func1_AI_FSafeValue					,
				//Tab_s__output_limits					,
				func1_AI_lo_lo_lim					,
				func1_AI_lo_lim						,
				func1_AI_hi_lim						,
				func1_AI_hi_hi_lim					,
				func1_AI_alarm_hys				
	}
}



/*---------------------------------------------------------------------*/
/*    Physical Block												   */
/*---------------------------------------------------------------------*/

COMMAND read_phys_blk
{
	BLOCK physical_block;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_blk_reserve, phys_blk_object, phys_blk_parent_class, phys_blk_class,
			phys_blk_dd_reference, phys_blk_dd_rev, phys_blk_profile, phys_blk_profile_rev,
			phys_blk_execution_time, phys_blk_num_parameters, phys_blk_index_view_1,
			phys_blk_num_view_lists
		}
	}
}

COMMAND read_phys_st_rev
{
	BLOCK physical_block;
	INDEX 1;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_st_rev
		}
	}
}

COMMAND read_phys_tag_desc
{
	BLOCK physical_block;
	INDEX 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_tag_desc
		}
	}
}

COMMAND write_phys_tag_desc
{
	BLOCK physical_block;
	INDEX 2;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_tag_desc
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_strategy
{
	BLOCK physical_block;
	INDEX 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_strategy
		}
	}
}

COMMAND write_phys_strategy
{
	BLOCK physical_block;
	INDEX 3;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_strategy
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_alert_key
{
	BLOCK physical_block;
	INDEX 4;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_alert_key
		}
	}
}

COMMAND write_phys_alert_key
{
	BLOCK physical_block;
	INDEX 4;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_alert_key
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_target_mode
{
	BLOCK physical_block;
	INDEX 5;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_target_mode
		}
	}
}

COMMAND write_phys_target_mode
{
	BLOCK physical_block;
	INDEX 5;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
		 	phys_target_mode
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_mode
{
	BLOCK physical_block;
	INDEX 6;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			 phys_actual_mode, phys_permitted_mode, phys_normal_mode
		}
	}
}

COMMAND read_phys_alarm
{
	BLOCK physical_block;
	INDEX 7;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_current_state_alarm_sum, phys_unacknowledged_state_alarm_sum,
			phys_unreported_state_alarm_sum, phys_disabled_state_alarm_sum
		}
	}
}

COMMAND read_phys_software_rev
{
	BLOCK physical_block;
	INDEX 8;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_software_rev
		}
	}
}


COMMAND write_phys_software_rev
{
	BLOCK physical_block;
	INDEX 8;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_software_rev
		}
		REPLY
		{
			
		}
	}
}

COMMAND read_phys_hardware_rev
{
	BLOCK physical_block;
	INDEX 9;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_hardware_rev
		}
	}
}

COMMAND write_phys_hardware_rev
{
	BLOCK physical_block;
	INDEX 9;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_hardware_rev
		}
		REPLY
		{
			
		}
	}
}

COMMAND read_phys_device_man_id
{
	BLOCK physical_block;
	INDEX 10;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_device_man_id
		}
	}
}

COMMAND read_phys_device_id
{
	BLOCK physical_block;
	INDEX 11;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_device_id
		}
	}
}
COMMAND write_phys_device_id
{
	BLOCK physical_block;
	INDEX 11;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_device_id
		}
		REPLY
		{
			
		}
	}
}

COMMAND read_phys_device_ser_num
{
	BLOCK physical_block;
	INDEX 12;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_device_ser_num
		}
	}
}

COMMAND write_phys_device_ser_num
{
	BLOCK physical_block;
	INDEX 12;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
		phys_device_ser_num
		}
		REPLY
		{
			
		}
	}
}

COMMAND read_phys_diagnosis
{
	BLOCK physical_block;
	INDEX 13;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_diagnosis
		}
	}
}

COMMAND read_phys_diagnosis_extension
{
	BLOCK physical_block;
	INDEX 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_diagnosis_extension
		}
	}
}

COMMAND read_phys_diagnosis_mask
{
	BLOCK physical_block;
	INDEX 15;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_diagnosis_mask
		}
	}
}

COMMAND read_phys_diagnosis_extension_mask
{
	BLOCK physical_block;
	INDEX 16;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_diagnosis_extension_mask
		}
	}
}

COMMAND read_phys_device_certification
{
	BLOCK physical_block;
	INDEX 17;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_device_certification
		}
	}
}

COMMAND write_phys_device_certification
{
	BLOCK physical_block;
	INDEX 17;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_device_certification
		}
		REPLY
		{
			
		}
	}
}


COMMAND read_phys_write_locking
{
	BLOCK physical_block;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_write_locking
		}
	}
}

COMMAND write_phys_write_locking
{
	BLOCK physical_block;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_write_locking
		}
		REPLY
		{
		}
	}
}


COMMAND write_phys_factory_reset
{
	BLOCK physical_block;
	INDEX 19;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_factory_reset
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_descriptor
{
	BLOCK physical_block;
	INDEX 20;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_descriptor
		}
	}
}

COMMAND write_phys_descriptor
{
	BLOCK physical_block;
	INDEX 20;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_descriptor
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_message
{
	BLOCK physical_block;
	INDEX 21;
	OPERATION  READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_message
		}
	}
}

COMMAND write_phys_message
{
	BLOCK physical_block;
	INDEX 21;
	OPERATION  WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_message
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_install_date
{
	BLOCK physical_block;
	INDEX 22;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_install_date
		}
	}
}

COMMAND write_phys_install_date
{
	BLOCK physical_block;
	INDEX 22;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_install_date
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_local_operation_enable
{
	BLOCK physical_block;
	INDEX 23;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_local_operation_enable
		}
	}
}

COMMAND write_phys_local_operation_enable
{
	BLOCK physical_block;
	INDEX 23;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_local_operation_enable
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_ident_number
{
	BLOCK physical_block;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_ident_number
		}
	}
}

COMMAND write_phys_ident_number
{
	BLOCK physical_block;
	INDEX 24;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_ident_number
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_hw_write_protection
{
	BLOCK physical_block;
	INDEX 25;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_hw_write_protection
		}
	}
}


/*---------------------------------------------------------------------*/
/*    Physical Block: Manufacturer specific parameters                 */
/*---------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
/*    Transducer Block:  Temperature								   */
/*---------------------------------------------------------------------*/

COMMAND read_trans1_blk
{
	BLOCK transducer_block_1;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_blk_reserve, trans1_blk_object, trans1_blk_parent_class, trans1_blk_class,
			trans1_blk_dd_reference, trans1_blk_dd_rev, trans1_blk_profile, trans1_blk_profile_rev,
			trans1_blk_execution_time, trans1_blk_num_parameters, trans1_blk_index_view_1,
			trans1_blk_num_view_lists
		}
	}
}

COMMAND read_trans1_st_rev
{
	BLOCK transducer_block_1;
	INDEX 1;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_st_rev
		}
	}
}

COMMAND read_trans1_tag_desc
{
	BLOCK transducer_block_1;
	INDEX 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_tag_desc
		}
	}
}

COMMAND write_trans1_tag_desc
{
	BLOCK transducer_block_1;
	INDEX 2;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_tag_desc
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_strategy
{
	BLOCK transducer_block_1;
	INDEX 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_strategy
		}
	}
}

COMMAND write_trans1_strategy
{
	BLOCK transducer_block_1;
	INDEX 3;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_strategy
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_alert_key
{
	BLOCK transducer_block_1;
	INDEX 4;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_alert_key
		}
	}
}

COMMAND write_trans1_alert_key
{
	BLOCK transducer_block_1;
	INDEX 4;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_alert_key
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_target_mode
{
	BLOCK transducer_block_1;
	INDEX 5;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_target_mode
		}
	}
}

COMMAND write_trans1_target_mode
{
	BLOCK transducer_block_1;
	INDEX 5;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_target_mode
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_mode
{
	BLOCK transducer_block_1;
	INDEX 6;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			 trans1_actual_mode, trans1_permitted_mode, trans1_normal_mode
		}
	}
}

COMMAND read_trans1_alarm
{
	BLOCK transducer_block_1;
	INDEX 7;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_current_state_alarm_sum, trans1_unacknowledged_state_alarm_sum,
			trans1_unreported_state_alarm_sum, trans1_disabled_state_alarm_sum
		}
	}
}

COMMAND read_trans1_primary_value
{
	BLOCK transducer_block_1;
	INDEX 8;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_primary_value, 
			trans1_primary_value_status_quality	<0xFC>,
			trans1_primary_value_status_limit	<0x03>
		}
	}
}

COMMAND read_trans1_primary_value_unit
{
	BLOCK transducer_block_1;
	INDEX 9;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_primary_value_unit 
		}
	}
}

COMMAND write_trans1_primary_value_unit
{
	BLOCK transducer_block_1;
	INDEX 9;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_primary_value_unit 
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_secondary_value_1
{
	BLOCK transducer_block_1;
	INDEX 10;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_secondary_value_1, 
			trans1_secondary_value_1_status_quality	<0xFC>,
			trans1_secondary_value_1_status_limit	<0x03>
		}
	}
}


COMMAND read_trans1_sensor_measure_type
{
	BLOCK transducer_block_1;
	INDEX 12;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_sensor_measure_type
		}
	}
}

COMMAND write_trans1_sensor_measure_type
{
	BLOCK transducer_block_1;
	INDEX 12;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_sensor_measure_type
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_input_range
{
	BLOCK transducer_block_1;
	INDEX 13;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_input_range
		}
	}
}

COMMAND write_trans1_input_range
{
	BLOCK transducer_block_1;
	INDEX 13;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_input_range
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_lin_type
{
	BLOCK transducer_block_1;
	INDEX 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_lin_type
		}
	}
}

COMMAND write_trans1_lin_type
{
	BLOCK transducer_block_1;
	INDEX 14;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_lin_type
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_bias_1
{
	BLOCK transducer_block_1;
	INDEX 19;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_bias_1
		}
	}
}

COMMAND write_trans1_bias_1
{
	BLOCK transducer_block_1;
	INDEX 19;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_bias_1
		}
		REPLY
		{
		}
	}
}


COMMAND read_trans1_upper_sensor_limit
{
	BLOCK transducer_block_1;
	INDEX 21;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_upper_sensor_limit
		}
	}
}
COMMAND write_trans1_upper_sensor_limit
{
	BLOCK transducer_block_1;
	INDEX 21;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_upper_sensor_limit
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_lower_sensor_limit
{
	BLOCK transducer_block_1;
	INDEX 22;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_lower_sensor_limit
		}
	}
}
COMMAND write_trans1_lower_sensor_limit
{
	BLOCK transducer_block_1;
	INDEX 22;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_lower_sensor_limit
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_input_fault_gen
{
	BLOCK transducer_block_1;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_input_fault_gen
		}
	}
}

COMMAND read_trans1_input_fault_1
{
	BLOCK transducer_block_1;
	INDEX 25;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_input_fault_1
		}
	}
}


COMMAND read_trans1_sensor_wire_check_1
{
	BLOCK transducer_block_1;
	INDEX 27;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_sensor_wire_check_1
		}
	}
}

COMMAND write_trans1_sensor_wire_check_1
{
	BLOCK transducer_block_1;
	INDEX 27;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_sensor_wire_check_1
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_max_sensor_value_1
{
	BLOCK transducer_block_1;
	INDEX 29;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_max_sensor_value_1
		}
	}
}

COMMAND write_trans1_max_sensor_value_1
{
	BLOCK transducer_block_1;
	INDEX 29;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_max_sensor_value_1
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_min_sensor_value_1
{
	BLOCK transducer_block_1;
	INDEX 30;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_min_sensor_value_1
		}
	}
}

COMMAND write_trans1_min_sensor_value_1
{
	BLOCK transducer_block_1;
	INDEX 30;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_min_sensor_value_1
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_reference_junction_temp
{
	BLOCK transducer_block_1;
	INDEX 33; 
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_reference_junction_temp
		}
	}
}

COMMAND read_trans1_reference_junction_type
{
	BLOCK transducer_block_1;
	INDEX 34; 
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_reference_junction_type
		}
	}
}

COMMAND write_trans1_reference_junction_type
{
	BLOCK transducer_block_1;
	INDEX 34;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_reference_junction_type
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_sensor_connection
{
	BLOCK transducer_block_1;
	INDEX 36; 
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_sensor_connection
		}
	}
}

COMMAND write_trans1_sensor_connection
{
	BLOCK transducer_block_1;
	INDEX 36; 
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_sensor_connection
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_comp_wire_1
{
	BLOCK transducer_block_1;
	INDEX 37; 
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_comp_wire_1
		}
	}
}

COMMAND write_trans1_comp_wire_1
{
	BLOCK transducer_block_1;
	INDEX 37; 
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_comp_wire_1
		}
		REPLY
		{
		}
	}
}

/*---------------------------------------------------------------------*/
/*    Function Block												   */
/*---------------------------------------------------------------------*/

COMMAND read_func1_AI_blk
{
	BLOCK function_block_1;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_blk_reserve, func1_AI_blk_object, func1_AI_blk_parent_class, func1_AI_blk_class,
			func1_AI_blk_dd_reference, func1_AI_blk_dd_rev, func1_AI_blk_profile, func1_AI_blk_profile_rev,
			func1_AI_blk_execution_time, func1_AI_blk_num_parameters, func1_AI_blk_index_view_1,
			func1_AI_blk_num_view_lists
		}
	}
}

COMMAND read_func1_AI_st_rev
{
	BLOCK function_block_1;
	INDEX 1;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_st_rev   
		}
	}
}

COMMAND read_func1_AI_tag_desc
{
	BLOCK function_block_1;
	INDEX 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_tag_desc
		}
	}
}

COMMAND write_func1_AI_tag_desc
{
	BLOCK function_block_1;
	INDEX 2;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_tag_desc
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_strategy
{
	BLOCK function_block_1;
	INDEX 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_strategy
		}
	}
}

COMMAND write_func1_AI_strategy
{
	BLOCK function_block_1;
	INDEX 3;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_strategy
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_alert_key
{
	BLOCK function_block_1;
	INDEX 4;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_alert_key
		}
	}
}

COMMAND write_func1_AI_alert_key
{
	BLOCK function_block_1;
	INDEX 4;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_alert_key
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_target_mode
{
	BLOCK function_block_1;
	INDEX 5;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_target_mode
		}
	}
}

COMMAND write_func1_AI_target_mode
{
	BLOCK function_block_1;
	INDEX 5;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_target_mode
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_mode
{
	BLOCK function_block_1;
	INDEX 6;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			 func1_AI_actual_mode, func1_AI_permitted_mode, func1_AI_normal_mode
		}
	}
}

COMMAND read_func1_AI_alarm
{
	BLOCK function_block_1;
	INDEX 7;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_current_state_alarm_sum, func1_AI_unacknowledged_state_alarm_sum,
			func1_AI_unreported_state_alarm_sum, func1_AI_disabled_state_alarm_sum
		}
	}
}

COMMAND read_func1_AI_batch_information
{
	BLOCK function_block_1;
	INDEX 8;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_batch_id, func1_AI_batch_unit, func1_AI_batch_operation, func1_AI_batch_phase
		}
	}
}

COMMAND write_func1_AI_batch_information
{
	BLOCK function_block_1;
	INDEX 8;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_batch_id, func1_AI_batch_unit, func1_AI_batch_operation, func1_AI_batch_phase
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_out
{
	BLOCK function_block_1;
	INDEX 10;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_out_value, 
			func1_AI_out_status_quality		<0xFC>,
			func1_AI_out_status_limit		<0x03>
		}
	}
}

COMMAND write_func1_AI_out
{
	BLOCK function_block_1;
	INDEX 10;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_out_value, 
			func1_AI_out_status_quality		<0xFC>,
			func1_AI_out_status_limit		<0x03>
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_pv
{
	BLOCK function_block_1;
	INDEX 11;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_pv_upper_range_value, func1_AI_pv_lower_range_value
		}
	}
}

COMMAND write_func1_AI_pv
{
	BLOCK function_block_1;
	INDEX 11;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_pv_upper_range_value, func1_AI_pv_lower_range_value
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_out_scale
{
	BLOCK function_block_1;
	INDEX 12;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_out_upper_range_value,	func1_AI_out_lower_range_value, 
			func1_AI_out_unit, func1_AI_out_decimal_point
		}
	}
}

COMMAND write_func1_AI_out_scale
{
	BLOCK function_block_1;
	INDEX 12;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_out_upper_range_value, func1_AI_out_lower_range_value, 	
			func1_AI_out_unit, func1_AI_out_decimal_point
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_lin_type
{
	BLOCK function_block_1;
	INDEX 13;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_lin_type
		}
	}
}

COMMAND write_func1_AI_lin_type
{
	BLOCK function_block_1;
	INDEX 13;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_lin_type
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_channel
{
	BLOCK function_block_1;
	INDEX 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_channel
		}
	}
}

COMMAND write_func1_AI_channel
{
	BLOCK function_block_1;
	INDEX 14;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_channel
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_pv_ftime
{
	BLOCK function_block_1;
	INDEX 16;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_pv_ftime
		}
	}
}

COMMAND write_func1_AI_pv_ftime
{
	BLOCK function_block_1;
	INDEX 16;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_pv_ftime
		}
		REPLY
		{
		}
	}
}


COMMAND read_func1_AI_FSafeType
{
	BLOCK function_block_1;
	INDEX 17;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_FSafeType
		}
	}
}

COMMAND write_func1_AI_FSafeType
{
	BLOCK function_block_1;
	INDEX 17;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_FSafeType
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_FSafeValue
{
	BLOCK function_block_1;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_FSafeValue
		}
	}
}

COMMAND write_func1_AI_FSafeValue
{
	BLOCK function_block_1;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_FSafeValue
		}
		REPLY
		{
		}
	}
}


COMMAND read_func1_AI_alarm_hys
{
	BLOCK function_block_1;
	INDEX 19;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_alarm_hys
		}
	}
}

COMMAND write_func1_AI_alarm_hys
{
	BLOCK function_block_1;
	INDEX 19;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_alarm_hys
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_hi_hi_lim
{
	BLOCK function_block_1;
	INDEX 21;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_hi_hi_lim
		}
	}
}

COMMAND write_func1_AI_hi_hi_lim
{
	BLOCK function_block_1;
	INDEX 21;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_hi_hi_lim
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_hi_lim
{
	BLOCK function_block_1;
	INDEX 23;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_hi_lim
		}
	}
}

COMMAND write_func1_AI_hi_lim
{
	BLOCK function_block_1;
	INDEX 23;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_hi_lim
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_lo_lim
{
	BLOCK function_block_1;
	INDEX 25;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_lo_lim
		}
	}
}

COMMAND write_func1_AI_lo_lim
{
	BLOCK function_block_1;
	INDEX 25;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_lo_lim
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_lo_lo_lim
{
	BLOCK function_block_1;
	INDEX 27;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_lo_lo_lim
		}
	}
}

COMMAND write_func1_AI_lo_lo_lim
{
	BLOCK function_block_1;
	INDEX 27;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_lo_lo_lim
		}
		REPLY
		{
		}
	}
}

COMMAND read_func1_AI_hi_hi_alm
{
	BLOCK function_block_1;
	INDEX 30;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_hi_hi_alm_unacknowledged, func1_AI_hi_hi_alm_state,
			func1_AI_hi_hi_alm_time_stamp, func1_AI_hi_hi_alm_subcode,
			func1_AI_hi_hi_alm_value
		}
	}
}

COMMAND read_func1_AI_hi_alm
{
	BLOCK function_block_1;
	INDEX 31;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_hi_alm_unacknowledged, func1_AI_hi_alm_state,
			func1_AI_hi_alm_time_stamp, func1_AI_hi_alm_subcode,
			func1_AI_hi_alm_value
		}
	}
}

COMMAND read_func1_AI_lo_alm
{
	BLOCK function_block_1;
	INDEX 32;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_lo_alm_unacknowledged, func1_AI_lo_alm_state,
			func1_AI_lo_alm_time_stamp, func1_AI_lo_alm_subcode,
			func1_AI_lo_alm_value
		}
	}
}

COMMAND read_func1_AI_lo_lo_alm
{
	BLOCK function_block_1;
	INDEX 33;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_lo_lo_alm_unacknowledged, func1_AI_lo_lo_alm_state,
			func1_AI_lo_lo_alm_time_stamp, func1_AI_lo_lo_alm_subcode,
			func1_AI_lo_lo_alm_value
		}
	}
}

COMMAND read_func1_AI_simulate
{
	BLOCK function_block_1;
	INDEX 34;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AI_simulate_status_quality	<0xFC>,
			func1_AI_simulate_status_limit		<0x03>,
			func1_AI_simulate_value, 
			func1_AI_simulation_enabled
		}
	}
}

COMMAND write_func1_AI_simulate
{
	BLOCK function_block_1;
	INDEX 34;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_AI_simulate_status_quality	<0xFC>,
			func1_AI_simulate_status_limit		<0x03>,
			func1_AI_simulate_value, 
			func1_AI_simulation_enabled
		}
		REPLY
		{
		}
	}
}


/************************ TABLES ***********************/

COMMAND read_trans1_tab_entry
{
	BLOCK transducer_block_1;
	INDEX 45;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_tab_entry
		}
	}
}

COMMAND write_trans1_tab_entry
{
	BLOCK transducer_block_1;
	INDEX 45;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_tab_entry
		}
		REPLY
		{
		}
	}
}



COMMAND read_trans1_tab_min_number
{
	BLOCK transducer_block_1;
	INDEX 47;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_tab_min_number
		}
	}
}

COMMAND read_trans1_tab_max_number
{
	BLOCK transducer_block_1;
	INDEX 48;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_tab_max_number
		}
	}
}



COMMAND read_trans1_tab_op_code
{
	BLOCK transducer_block_1;
	INDEX 49;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_tab_op_code
		}
	}
}

COMMAND write_trans1_tab_op_code
{
	BLOCK transducer_block_1;
	INDEX 49;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_tab_op_code
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_tab_status
{
	BLOCK transducer_block_1;
	INDEX 50;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_tab_status
		}
	}
}

COMMAND read_trans1_tab_actual_number
{
	BLOCK transducer_block_1;
	INDEX 51;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_tab_actual_number
		}
	}
}



/*---------------------------------------------------------------------*/

COMMAND read_trans1_tab_value_0
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_0,
            trans1_tab_y_value_0
        }
    }
}
COMMAND write_trans1_tab_value_0
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_0,
            trans1_tab_y_value_0
        }
        REPLY
        {
        }
    }
}


COMMAND read_trans1_tab_value_1
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_1,
            trans1_tab_y_value_1
        }
    }
}
COMMAND write_trans1_tab_value_1
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_1,
            trans1_tab_y_value_1
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_2
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_2,
            trans1_tab_y_value_2
        }
    }
}
COMMAND write_trans1_tab_value_2
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_2,
            trans1_tab_y_value_2
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_3
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_3,
            trans1_tab_y_value_3
        }
    }
}
COMMAND write_trans1_tab_value_3
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_3,
            trans1_tab_y_value_3
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_4
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_4,
            trans1_tab_y_value_4
        }
    }
}
COMMAND write_trans1_tab_value_4
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_4,
            trans1_tab_y_value_4
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_5
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_5,
            trans1_tab_y_value_5
        }
    }
}
COMMAND write_trans1_tab_value_5
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_5,
            trans1_tab_y_value_5
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_6
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_6,
            trans1_tab_y_value_6
        }
    }
}
COMMAND write_trans1_tab_value_6
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_6,
            trans1_tab_y_value_6
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_7
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_7,
            trans1_tab_y_value_7
        }
    }
}
COMMAND write_trans1_tab_value_7
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_7,
            trans1_tab_y_value_7
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_8
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_8,
            trans1_tab_y_value_8
        }
    }
}
COMMAND write_trans1_tab_value_8
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_8,
            trans1_tab_y_value_8
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_9
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_9,
            trans1_tab_y_value_9
        }
    }
}
COMMAND write_trans1_tab_value_9
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_9,
            trans1_tab_y_value_9
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_10
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_10,
            trans1_tab_y_value_10
        }
    }
}
COMMAND write_trans1_tab_value_10
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_10,
            trans1_tab_y_value_10
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_11
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_11,
            trans1_tab_y_value_11
        }
    }
}
COMMAND write_trans1_tab_value_11
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_11,
            trans1_tab_y_value_11
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_12
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_12,
            trans1_tab_y_value_12
        }
    }
}
COMMAND write_trans1_tab_value_12
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_12,
            trans1_tab_y_value_12
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_13
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_13,
            trans1_tab_y_value_13
        }
    }
}
COMMAND write_trans1_tab_value_13
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_13,
            trans1_tab_y_value_13
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_14
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_14,
            trans1_tab_y_value_14
        }
    }
}
COMMAND write_trans1_tab_value_14
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_14,
            trans1_tab_y_value_14
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_15
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_15,
            trans1_tab_y_value_15
        }
    }
}
COMMAND write_trans1_tab_value_15
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_15,
            trans1_tab_y_value_15
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_16
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_16,
            trans1_tab_y_value_16
        }
    }
}
COMMAND write_trans1_tab_value_16
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_16,
            trans1_tab_y_value_16
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_17
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_17,
            trans1_tab_y_value_17
        }
    }
}
COMMAND write_trans1_tab_value_17
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_17,
            trans1_tab_y_value_17
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_18
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_18,
            trans1_tab_y_value_18
        }
    }
}
COMMAND write_trans1_tab_value_18
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_18,
            trans1_tab_y_value_18
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_19
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_19,
            trans1_tab_y_value_19
        }
    }
}
COMMAND write_trans1_tab_value_19
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_19,
            trans1_tab_y_value_19
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_20
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_20,
            trans1_tab_y_value_20
        }
    }
}
COMMAND write_trans1_tab_value_20
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_20,
            trans1_tab_y_value_20
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_21
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_21,
            trans1_tab_y_value_21
        }
    }
}
COMMAND write_trans1_tab_value_21
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_21,
            trans1_tab_y_value_21
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_22
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_22,
            trans1_tab_y_value_22
        }
    }
}
COMMAND write_trans1_tab_value_22
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_22,
            trans1_tab_y_value_22
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_23
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_23,
            trans1_tab_y_value_23
        }
    }
}
COMMAND write_trans1_tab_value_23
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_23,
            trans1_tab_y_value_23
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_24
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_24,
            trans1_tab_y_value_24
        }
    }
}
COMMAND write_trans1_tab_value_24
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_24,
            trans1_tab_y_value_24
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_25
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_25,
            trans1_tab_y_value_25
        }
    }
}
COMMAND write_trans1_tab_value_25
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_25,
            trans1_tab_y_value_25
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_26
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_26,
            trans1_tab_y_value_26
        }
    }
}
COMMAND write_trans1_tab_value_26
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_26,
            trans1_tab_y_value_26
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_27
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_27,
            trans1_tab_y_value_27
        }
    }
}
COMMAND write_trans1_tab_value_27
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_27,
            trans1_tab_y_value_27
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_28
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_28,
            trans1_tab_y_value_28
        }
    }
}
COMMAND write_trans1_tab_value_28
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_28,
            trans1_tab_y_value_28
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_29
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_29,
            trans1_tab_y_value_29
        }
    }
}
COMMAND write_trans1_tab_value_29
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_29,
            trans1_tab_y_value_29
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_30
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_30,
            trans1_tab_y_value_30
        }
    }
}
COMMAND write_trans1_tab_value_30
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_30,
            trans1_tab_y_value_30
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_31
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_31,
            trans1_tab_y_value_31
        }
    }
}
COMMAND write_trans1_tab_value_31
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_31,
            trans1_tab_y_value_31
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_32
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_32,
            trans1_tab_y_value_32
        }
    }
}
COMMAND write_trans1_tab_value_32
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_32,
            trans1_tab_y_value_32
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_33
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_33,
            trans1_tab_y_value_33
        }
    }
}
COMMAND write_trans1_tab_value_33
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_33,
            trans1_tab_y_value_33
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_34
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_34,
            trans1_tab_y_value_34
        }
    }
}
COMMAND write_trans1_tab_value_34
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_34,
            trans1_tab_y_value_34
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_35
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_35,
            trans1_tab_y_value_35
        }
    }
}
COMMAND write_trans1_tab_value_35
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_35,
            trans1_tab_y_value_35
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_36
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_36,
            trans1_tab_y_value_36
        }
    }
}
COMMAND write_trans1_tab_value_36
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_36,
            trans1_tab_y_value_36
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_37
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_37,
            trans1_tab_y_value_37
        }
    }
}
COMMAND write_trans1_tab_value_37
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_37,
            trans1_tab_y_value_37
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_38
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_38,
            trans1_tab_y_value_38
        }
    }
}
COMMAND write_trans1_tab_value_38
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_38,
            trans1_tab_y_value_38
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_39
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_39,
            trans1_tab_y_value_39
        }
    }
}
COMMAND write_trans1_tab_value_39
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_39,
            trans1_tab_y_value_39
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_40
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_40,
            trans1_tab_y_value_40
        }
    }
}
COMMAND write_trans1_tab_value_40
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_40,
            trans1_tab_y_value_40
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_41
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_41,
            trans1_tab_y_value_41
        }
    }
}
COMMAND write_trans1_tab_value_41
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_41,
            trans1_tab_y_value_41
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_42
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_42,
            trans1_tab_y_value_42
        }
    }
}
COMMAND write_trans1_tab_value_42
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_42,
            trans1_tab_y_value_42
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_43
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_43,
            trans1_tab_y_value_43
        }
    }
}
COMMAND write_trans1_tab_value_43
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_43,
            trans1_tab_y_value_43
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_44
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_44,
            trans1_tab_y_value_44
        }
    }
}
COMMAND write_trans1_tab_value_44
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_44,
            trans1_tab_y_value_44
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_45
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_45,
            trans1_tab_y_value_45
        }
    }
}
COMMAND write_trans1_tab_value_45
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_45,
            trans1_tab_y_value_45
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_46
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_46,
            trans1_tab_y_value_46
        }
    }
}
COMMAND write_trans1_tab_value_46
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_46,
            trans1_tab_y_value_46
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_47
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_47,
            trans1_tab_y_value_47
        }
    }
}
COMMAND write_trans1_tab_value_47
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_47,
            trans1_tab_y_value_47
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_48
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_48,
            trans1_tab_y_value_48
        }
    }
}
COMMAND write_trans1_tab_value_48
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_48,
            trans1_tab_y_value_48
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_49
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_49,
            trans1_tab_y_value_49
        }
    }
}
COMMAND write_trans1_tab_value_49
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_49,
            trans1_tab_y_value_49
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_50
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_50,
            trans1_tab_y_value_50
        }
    }
}
COMMAND write_trans1_tab_value_50
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_50,
            trans1_tab_y_value_50
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_51
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_51,
            trans1_tab_y_value_51
        }
    }
}
COMMAND write_trans1_tab_value_51
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_51,
            trans1_tab_y_value_51
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_52
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_52,
            trans1_tab_y_value_52
        }
    }
}
COMMAND write_trans1_tab_value_52
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_52,
            trans1_tab_y_value_52
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_53
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_53,
            trans1_tab_y_value_53
        }
    }
}
COMMAND write_trans1_tab_value_53
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_53,
            trans1_tab_y_value_53
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_54
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_54,
            trans1_tab_y_value_54
        }
    }
}
COMMAND write_trans1_tab_value_54
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_54,
            trans1_tab_y_value_54
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_55
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_55,
            trans1_tab_y_value_55
        }
    }
}
COMMAND write_trans1_tab_value_55
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_55,
            trans1_tab_y_value_55
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_56
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_56,
            trans1_tab_y_value_56
        }
    }
}
COMMAND write_trans1_tab_value_56
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_56,
            trans1_tab_y_value_56
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_57
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_57,
            trans1_tab_y_value_57
        }
    }
}
COMMAND write_trans1_tab_value_57
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_57,
            trans1_tab_y_value_57
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_58
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_58,
            trans1_tab_y_value_58
        }
    }
}
COMMAND write_trans1_tab_value_58
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_58,
            trans1_tab_y_value_58
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_59
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_59,
            trans1_tab_y_value_59
        }
    }
}
COMMAND write_trans1_tab_value_59
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_59,
            trans1_tab_y_value_59
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_60
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_60,
            trans1_tab_y_value_60
        }
    }
}
COMMAND write_trans1_tab_value_60
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_60,
            trans1_tab_y_value_60
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_61
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_61,
            trans1_tab_y_value_61
        }
    }
}
COMMAND write_trans1_tab_value_61
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_61,
            trans1_tab_y_value_61
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_62
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_62,
            trans1_tab_y_value_62
        }
    }
}
COMMAND write_trans1_tab_value_62
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_62,
            trans1_tab_y_value_62
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_63
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_63,
            trans1_tab_y_value_63
        }
    }
}
COMMAND write_trans1_tab_value_63
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_63,
            trans1_tab_y_value_63
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_64
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_64,
            trans1_tab_y_value_64
        }
    }
}
COMMAND write_trans1_tab_value_64
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_64,
            trans1_tab_y_value_64
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_65
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_65,
            trans1_tab_y_value_65
        }
    }
}
COMMAND write_trans1_tab_value_65
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_65,
            trans1_tab_y_value_65
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_66
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_66,
            trans1_tab_y_value_66
        }
    }
}
COMMAND write_trans1_tab_value_66
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_66,
            trans1_tab_y_value_66
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_67
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_67,
            trans1_tab_y_value_67
        }
    }
}
COMMAND write_trans1_tab_value_67
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_67,
            trans1_tab_y_value_67
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_68
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_68,
            trans1_tab_y_value_68
        }
    }
}
COMMAND write_trans1_tab_value_68
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_68,
            trans1_tab_y_value_68
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_69
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_69,
            trans1_tab_y_value_69
        }
    }
}
COMMAND write_trans1_tab_value_69
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_69,
            trans1_tab_y_value_69
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_70
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_70,
            trans1_tab_y_value_70
        }
    }
}
COMMAND write_trans1_tab_value_70
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_70,
            trans1_tab_y_value_70
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_71
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_71,
            trans1_tab_y_value_71
        }
    }
}
COMMAND write_trans1_tab_value_71
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_71,
            trans1_tab_y_value_71
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_72
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_72,
            trans1_tab_y_value_72
        }
    }
}
COMMAND write_trans1_tab_value_72
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_72,
            trans1_tab_y_value_72
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_73
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_73,
            trans1_tab_y_value_73
        }
    }
}
COMMAND write_trans1_tab_value_73
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_73,
            trans1_tab_y_value_73
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_74
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_74,
            trans1_tab_y_value_74
        }
    }
}
COMMAND write_trans1_tab_value_74
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_74,
            trans1_tab_y_value_74
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_75
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_75,
            trans1_tab_y_value_75
        }
    }
}
COMMAND write_trans1_tab_value_75
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_75,
            trans1_tab_y_value_75
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_76
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_76,
            trans1_tab_y_value_76
        }
    }
}
COMMAND write_trans1_tab_value_76
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_76,
            trans1_tab_y_value_76
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_77
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_77,
            trans1_tab_y_value_77
        }
    }
}
COMMAND write_trans1_tab_value_77
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_77,
            trans1_tab_y_value_77
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_78
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_78,
            trans1_tab_y_value_78
        }
    }
}
COMMAND write_trans1_tab_value_78
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_78,
            trans1_tab_y_value_78
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_79
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_79,
            trans1_tab_y_value_79
        }
    }
}
COMMAND write_trans1_tab_value_79
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_79,
            trans1_tab_y_value_79
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_80
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_80,
            trans1_tab_y_value_80
        }
    }
}
COMMAND write_trans1_tab_value_80
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_80,
            trans1_tab_y_value_80
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_81
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_81,
            trans1_tab_y_value_81
        }
    }
}
COMMAND write_trans1_tab_value_81
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_81,
            trans1_tab_y_value_81
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_82
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_82,
            trans1_tab_y_value_82
        }
    }
}
COMMAND write_trans1_tab_value_82
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_82,
            trans1_tab_y_value_82
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_83
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_83,
            trans1_tab_y_value_83
        }
    }
}
COMMAND write_trans1_tab_value_83
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_83,
            trans1_tab_y_value_83
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_84
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_84,
            trans1_tab_y_value_84
        }
    }
}
COMMAND write_trans1_tab_value_84
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_84,
            trans1_tab_y_value_84
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_85
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_85,
            trans1_tab_y_value_85
        }
    }
}
COMMAND write_trans1_tab_value_85
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_85,
            trans1_tab_y_value_85
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_86
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_86,
            trans1_tab_y_value_86
        }
    }
}
COMMAND write_trans1_tab_value_86
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_86,
            trans1_tab_y_value_86
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_87
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_87,
            trans1_tab_y_value_87
        }
    }
}
COMMAND write_trans1_tab_value_87
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_87,
            trans1_tab_y_value_87
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_88
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_88,
            trans1_tab_y_value_88
        }
    }
}
COMMAND write_trans1_tab_value_88
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_88,
            trans1_tab_y_value_88
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_89
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_89,
            trans1_tab_y_value_89
        }
    }
}
COMMAND write_trans1_tab_value_89
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_89,
            trans1_tab_y_value_89
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_90
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_90,
            trans1_tab_y_value_90
        }
    }
}
COMMAND write_trans1_tab_value_90
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_90,
            trans1_tab_y_value_90
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_91
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_91,
            trans1_tab_y_value_91
        }
    }
}
COMMAND write_trans1_tab_value_91
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_91,
            trans1_tab_y_value_91
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_92
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_92,
            trans1_tab_y_value_92
        }
    }
}
COMMAND write_trans1_tab_value_92
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_92,
            trans1_tab_y_value_92
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_93
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_93,
            trans1_tab_y_value_93
        }
    }
}
COMMAND write_trans1_tab_value_93
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_93,
            trans1_tab_y_value_93
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_94
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_94,
            trans1_tab_y_value_94
        }
    }
}
COMMAND write_trans1_tab_value_94
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_94,
            trans1_tab_y_value_94
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_95
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_95,
            trans1_tab_y_value_95
        }
    }
}
COMMAND write_trans1_tab_value_95
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_95,
            trans1_tab_y_value_95
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_96
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_96,
            trans1_tab_y_value_96
        }
    }
}
COMMAND write_trans1_tab_value_96
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_96,
            trans1_tab_y_value_96
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_97
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_97,
            trans1_tab_y_value_97
        }
    }
}
COMMAND write_trans1_tab_value_97
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_97,
            trans1_tab_y_value_97
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_98
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_98,
            trans1_tab_y_value_98
        }
    }
}
COMMAND write_trans1_tab_value_98
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_98,
            trans1_tab_y_value_98
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_99
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_99,
            trans1_tab_y_value_99
        }
    }
}
COMMAND write_trans1_tab_value_99
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_99,
            trans1_tab_y_value_99
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_100
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_100,
            trans1_tab_y_value_100
        }
    }
}
COMMAND write_trans1_tab_value_100
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_100,
            trans1_tab_y_value_100
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_101
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_101,
            trans1_tab_y_value_101
        }
    }
}
COMMAND write_trans1_tab_value_101
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_101,
            trans1_tab_y_value_101
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_102
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_102,
            trans1_tab_y_value_102
        }
    }
}
COMMAND write_trans1_tab_value_102
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_102,
            trans1_tab_y_value_102
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_103
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_103,
            trans1_tab_y_value_103
        }
    }
}
COMMAND write_trans1_tab_value_103
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_103,
            trans1_tab_y_value_103
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_104
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_104,
            trans1_tab_y_value_104
        }
    }
}
COMMAND write_trans1_tab_value_104
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_104,
            trans1_tab_y_value_104
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_105
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_105,
            trans1_tab_y_value_105
        }
    }
}
COMMAND write_trans1_tab_value_105
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_105,
            trans1_tab_y_value_105
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_106
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_106,
            trans1_tab_y_value_106
        }
    }
}
COMMAND write_trans1_tab_value_106
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_106,
            trans1_tab_y_value_106
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_107
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_107,
            trans1_tab_y_value_107
        }
    }
}
COMMAND write_trans1_tab_value_107
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_107,
            trans1_tab_y_value_107
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_108
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_108,
            trans1_tab_y_value_108
        }
    }
}
COMMAND write_trans1_tab_value_108
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_108,
            trans1_tab_y_value_108
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_109
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_109,
            trans1_tab_y_value_109
        }
    }
}
COMMAND write_trans1_tab_value_109
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_109,
            trans1_tab_y_value_109
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_110
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_110,
            trans1_tab_y_value_110
        }
    }
}
COMMAND write_trans1_tab_value_110
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_110,
            trans1_tab_y_value_110
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_111
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_111,
            trans1_tab_y_value_111
        }
    }
}
COMMAND write_trans1_tab_value_111
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_111,
            trans1_tab_y_value_111
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_112
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_112,
            trans1_tab_y_value_112
        }
    }
}
COMMAND write_trans1_tab_value_112
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_112,
            trans1_tab_y_value_112
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_113
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_113,
            trans1_tab_y_value_113
        }
    }
}
COMMAND write_trans1_tab_value_113
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_113,
            trans1_tab_y_value_113
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_114
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_114,
            trans1_tab_y_value_114
        }
    }
}
COMMAND write_trans1_tab_value_114
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_114,
            trans1_tab_y_value_114
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_115
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_115,
            trans1_tab_y_value_115
        }
    }
}
COMMAND write_trans1_tab_value_115
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_115,
            trans1_tab_y_value_115
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_116
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_116,
            trans1_tab_y_value_116
        }
    }
}
COMMAND write_trans1_tab_value_116
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_116,
            trans1_tab_y_value_116
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_117
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_117,
            trans1_tab_y_value_117
        }
    }
}
COMMAND write_trans1_tab_value_117
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_117,
            trans1_tab_y_value_117
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_118
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_118,
            trans1_tab_y_value_118
        }
    }
}
COMMAND write_trans1_tab_value_118
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_118,
            trans1_tab_y_value_118
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_119
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_119,
            trans1_tab_y_value_119
        }
    }
}
COMMAND write_trans1_tab_value_119
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_119,
            trans1_tab_y_value_119
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_120
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_120,
            trans1_tab_y_value_120
        }
    }
}
COMMAND write_trans1_tab_value_120
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_120,
            trans1_tab_y_value_120
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_121
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_121,
            trans1_tab_y_value_121
        }
    }
}
COMMAND write_trans1_tab_value_121
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_121,
            trans1_tab_y_value_121
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_122
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_122,
            trans1_tab_y_value_122
        }
    }
}
COMMAND write_trans1_tab_value_122
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_122,
            trans1_tab_y_value_122
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_123
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_123,
            trans1_tab_y_value_123
        }
    }
}
COMMAND write_trans1_tab_value_123
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_123,
            trans1_tab_y_value_123
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_124
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_124,
            trans1_tab_y_value_124
        }
    }
}
COMMAND write_trans1_tab_value_124
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_124,
            trans1_tab_y_value_124
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_125
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_125,
            trans1_tab_y_value_125
        }
    }
}
COMMAND write_trans1_tab_value_125
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_125,
            trans1_tab_y_value_125
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_126
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_126,
            trans1_tab_y_value_126
        }
    }
}
COMMAND write_trans1_tab_value_126
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_126,
            trans1_tab_y_value_126
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_tab_value_127
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tab_x_value_127,
            trans1_tab_y_value_127
        }
    }
}
COMMAND write_trans1_tab_value_127
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tab_x_value_127,
            trans1_tab_y_value_127
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
// *********************	Page: x-y-Darstellung	mit / ohne Wertepaare	***************************

MENU OfflineWindow_Kennlinie
{
	LABEL	   [menu_input_table];

    ITEMS
	{
		Page_display_OCX_xy_kennlinie
	
	}

}

MENU Page_display_OCX_xy_kennlinie					// 2. Page: OCX-Control mit x-y-Darstellungen
{
	LABEL	   [menu_input_table];
	ITEMS
	{
		OCX_out_display_xy_kennlinie
	}
}


MENU OCX_out_display_xy_kennlinie					// OCX-Control
{
	LABEL	   [menu_input_table];
	STYLE		"PDMTVPROXY.PDMTVProxyCtrl.1";		// Name, unter dem das OCX in Windows registriert ist
	ITEMS
	{
		OCX_ProfilNum_xy,							// Profil-Nummer
		OCX_out_display_kennlinie							// 1. Kurve

		//OCX_UserSettings_xy		// Fr Speicherung von Settings, die vom Benutzer zur Laufzeit gendert wurden
	}
}
MENU Page_display_xy_kennlinie					// OCX-Control
{
	LABEL	   [menu_input_table];
	STYLE		"PDMTVPROXY.PDMTVProxyCtrl.1";		// Name, unter dem das OCX in Windows registriert ist
	ITEMS
	{
		OCX_ProfilNum_xy,							// Profil-Nummer
		OCX_out_display_kennlinie							// 1. Kurve

		//OCX_UserSettings_xy		// Fr Speicherung von Settings, die vom Benutzer zur Laufzeit gendert wurden
	}
}

// ------------------	1. Kurve: x-y-Darstellung	mit Wertepaaren	----------------------------------------

MENU OCX_out_display_kennlinie								// 1. Kurve im OCX-Control xy
{
	LABEL	   [menu_input_table];
	STYLE		"OCX_DYNAMIC_XY";
	ITEMS
	{
		
		x_value_min_kennlinie	(READ_ONLY),					// Untergrenze x-Bereich
		x_value_max_kennlinie	(READ_ONLY),					// Obgrenze x-Bereich
		y_value_min_kennlinie	(READ_ONLY),					// untergrenze y-Bereich
		y_value_max_kennlinie	(READ_ONLY),					// Obergrenze y-Bereich
		x_values_kennlinie,									// Liste aller y-Wert-Variablen
		y_values_kennlinie									// Liste aller x-Wert-Variablen


 	}
}

MENU OnlineWindow_kennlinie_2								// 1. Kurve im OCX-Control xy
{
	LABEL	   [menu_input_table];
	STYLE		WINDOW;
//	STYLE		"OCX_DYNAMIC_XY";
	ITEMS
	{
		
		Page_kennlinie_2,								// Liste aller x-Wert-Variablen
		Page_x_values_kennlinie_2,							// Liste aller y-Wert-Variablen
		Page_y_values_kennlinie_2							// Liste aller x-Wert-Variablen
 	}
}
MENU Page_kennlinie_2								// 1. Kurve im OCX-Control xy
{
	LABEL	   [menu_input_table];
	STYLE		PAGE;
//	STYLE		"OCX_DYNAMIC_XY";
	ITEMS
	{
		
		OCX_ProfilNum_xy,							// Profil-Nummer
		x_value_min_kennlinie_2	(READ_ONLY),					// Untergrenze x-Bereich
		x_value_max_kennlinie_2	(READ_ONLY),					// Obgrenze x-Bereich
		y_value_min_kennlinie_2	(READ_ONLY),					// untergrenze y-Bereich
		y_value_max_kennlinie_2	(READ_ONLY)					// Obergrenze y-Bereich
 	}
}



MENU x_values_kennlinie										// Liste aller x-Wert-Variablen
{
	STYLE		"OCX_X_LIST";
    ITEMS
    {

		x_value_0,									// 1. x-Wert-Variable
		x_value_1,
		x_value_2,
		x_value_3,
		x_value_4,
		x_value_5,
		x_value_6,
		x_value_7,
		x_value_8,
		x_value_9,
		x_value_10,
		x_value_11,
		x_value_12,
		x_value_13,
		x_value_14,
		x_value_15,

		x_value_16,
		x_value_17,
		x_value_18,
		x_value_19,
		x_value_20,
		x_value_21,
		x_value_22,
		x_value_23,
		x_value_24,
		x_value_25,
		x_value_26,
		x_value_27,
		x_value_28,
		x_value_29,
		x_value_30,
		x_value_31,

		x_value_32,
		x_value_33,
		x_value_34,
		x_value_35,
		x_value_36,
		x_value_37,
		x_value_38,
		x_value_39,
		x_value_40,
		x_value_41,
		x_value_42,
		x_value_43,
		x_value_44,
		x_value_45,
		x_value_46,
		x_value_47,

		x_value_48,
		x_value_49,
		x_value_50,
		x_value_51,
		x_value_52,
		x_value_53,
		x_value_54,
		x_value_55,
		x_value_56,
		x_value_57,
		x_value_58,
		x_value_59,
		x_value_60,
		x_value_61,
		x_value_62,
		x_value_63,

		x_value_64,
		x_value_65,
		x_value_66,
		x_value_67,
		x_value_68,
		x_value_69,
		x_value_70,
		x_value_71,
		x_value_72,
		x_value_73,
		x_value_74,
		x_value_75,
		x_value_76,
		x_value_77,
		x_value_78,
		x_value_79,

		x_value_80,
		x_value_81,
		x_value_82,
		x_value_83,
		x_value_84,
		x_value_85,
		x_value_86,
		x_value_87,
		x_value_88,
		x_value_89,
		x_value_90,
		x_value_91,
		x_value_92,
		x_value_93,
		x_value_94,
		x_value_95,

		x_value_96,
		x_value_97,
		x_value_98,
		x_value_99,
		x_value_100,
		x_value_101,
		x_value_102,
		x_value_103,
		x_value_104,
		x_value_105,
		x_value_106,
		x_value_107,
		x_value_108,
		x_value_109,
		x_value_110,
		x_value_111,

		x_value_112,
		x_value_113,
		x_value_114,
		x_value_115,
		x_value_116,
		x_value_117,
		x_value_118,
		x_value_119,
		x_value_120,
		x_value_121,
		x_value_122,
		x_value_123,
		x_value_124,
		x_value_125,
		x_value_126,
		x_value_127
	}
}

MENU Page_x_values_kennlinie_2										// Liste aller x-Wert-Variablen
{
//	STYLE		"OCX_X_LIST";
	LABEL	   "X - Values";
	STYLE		PAGE;
    ITEMS
    {

		x_value_0,									// 1. x-Wert-Variable
		x_value_1,
		x_value_2,
		x_value_3,
		x_value_4,
		x_value_5,
		x_value_6,
		x_value_7,
		x_value_8,
		x_value_9,
		x_value_10,
		x_value_11,
		x_value_12,
		x_value_13,
		x_value_14,
		x_value_15,

		x_value_16,
		x_value_17,
		x_value_18,
		x_value_19,
		x_value_20,
		x_value_21,
		x_value_22,
		x_value_23,
		x_value_24,
		x_value_25,
		x_value_26,
		x_value_27,
		x_value_28,
		x_value_29,
		x_value_30,
		x_value_31,

		x_value_32,
		x_value_33,
		x_value_34,
		x_value_35,
		x_value_36,
		x_value_37,
		x_value_38,
		x_value_39,
		x_value_40,
		x_value_41,
		x_value_42,
		x_value_43,
		x_value_44,
		x_value_45,
		x_value_46,
		x_value_47,

		x_value_48,
		x_value_49,
		x_value_50,
		x_value_51,
		x_value_52,
		x_value_53,
		x_value_54,
		x_value_55,
		x_value_56,
		x_value_57,
		x_value_58,
		x_value_59,
		x_value_60,
		x_value_61,
		x_value_62,
		x_value_63,

		x_value_64,
		x_value_65,
		x_value_66,
		x_value_67,
		x_value_68,
		x_value_69,
		x_value_70,
		x_value_71,
		x_value_72,
		x_value_73,
		x_value_74,
		x_value_75,
		x_value_76,
		x_value_77,
		x_value_78,
		x_value_79,

		x_value_80,
		x_value_81,
		x_value_82,
		x_value_83,
		x_value_84,
		x_value_85,
		x_value_86,
		x_value_87,
		x_value_88,
		x_value_89,
		x_value_90,
		x_value_91,
		x_value_92,
		x_value_93,
		x_value_94,
		x_value_95,

		x_value_96,
		x_value_97,
		x_value_98,
		x_value_99,
		x_value_100,
		x_value_101,
		x_value_102,
		x_value_103,
		x_value_104,
		x_value_105,
		x_value_106,
		x_value_107,
		x_value_108,
		x_value_109,
		x_value_110,
		x_value_111,

		x_value_112,
		x_value_113,
		x_value_114,
		x_value_115,
		x_value_116,
		x_value_117,
		x_value_118,
		x_value_119,
		x_value_120,
		x_value_121,
		x_value_122,
		x_value_123,
		x_value_124,
		x_value_125,
		x_value_126,
		x_value_127
	}
	VALIDITY    VALID_LIN_TABLE_XY (1)
}
						

//--- x|y-Value: Ende ---------------------------------------------

VARIABLE x_value_0	
{
	LABEL		"X (0)";
	CLASS		LOCAL;
    TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_0; }
	HANDLING    READ;
 // CONSTANT_UNIT trans1_primary_value_unit;
}



VARIABLE x_value_1	
{
	LABEL		"X (1)";
	CLASS		LOCAL;
    TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_1; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (1)
 // CONSTANT_UNIT trans1_primary_value_unit;
}


VARIABLE x_value_2	
{
	LABEL		"X (2)";
	CLASS		LOCAL;
    TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_2; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (2)
 // CONSTANT_UNIT trans1_primary_value_unit;
}


VARIABLE x_value_3	
{
	LABEL		"X (3)";
	CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_3; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (3)
 // CONSTANT_UNIT trans1_primary_value_unit;
}




VARIABLE x_value_4	
{
	LABEL		"X (4)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_4; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (4)
 // CONSTANT_UNIT trans1_primary_value_unit;
}



VARIABLE x_value_5	
{
	LABEL		"X (5)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_5; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (5)
 // CONSTANT_UNIT trans1_primary_value_unit;
}



VARIABLE x_value_6	
{
	LABEL		"X (6)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_6; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (6)
 // CONSTANT_UNIT trans1_primary_value_unit;
}



VARIABLE x_value_7	
{
	LABEL		"X (7)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_7; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (7)
 // CONSTANT_UNIT trans1_primary_value_unit;
}



VARIABLE x_value_8	
{
	LABEL		"X (8)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_8; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (8)
 // CONSTANT_UNIT trans1_primary_value_unit;
}


VARIABLE x_value_9	
{
	LABEL		"X (9)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_9; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (9)
 // CONSTANT_UNIT trans1_primary_value_unit;
}




VARIABLE x_value_10	
{
	LABEL		"X (10)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_10; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (10)
 // CONSTANT_UNIT trans1_primary_value_unit;
}




VARIABLE x_value_11	
{
	LABEL		"X (11)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_11; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (11)
 // CONSTANT_UNIT trans1_primary_value_unit;
}



VARIABLE x_value_12	
{
	LABEL		"X (12)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_12; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (12)
 // CONSTANT_UNIT trans1_primary_value_unit;
}



VARIABLE x_value_13	
{
	LABEL		"X (13)";
	CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_13; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (13)
 // CONSTANT_UNIT trans1_primary_value_unit;
}



VARIABLE x_value_14	
{
	LABEL		"X (14)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_14; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (14)
 // CONSTANT_UNIT trans1_primary_value_unit;
}



VARIABLE x_value_15	
{
	LABEL		"X (15)";
	CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_15; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (15)
 // CONSTANT_UNIT trans1_primary_value_unit;
}



VARIABLE x_value_16	
{
	LABEL		"X (16)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_16; }		
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (16)
 // CONSTANT_UNIT trans1_primary_value_unit;
}



VARIABLE x_value_17	
{
	LABEL		"X (17)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_17; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (17)
 // CONSTANT_UNIT trans1_primary_value_unit;
}



VARIABLE x_value_18	
{
	LABEL		"X (18)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_18; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (18)
 // CONSTANT_UNIT trans1_primary_value_unit;
}



VARIABLE x_value_19	
{
	LABEL		"X (19)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_19; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (19)
 // CONSTANT_UNIT trans1_primary_value_unit;
}



VARIABLE x_value_20	
{
	LABEL		"X (20)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_20; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (20)
 // CONSTANT_UNIT trans1_primary_value_unit;
}




VARIABLE x_value_21	
{
	LABEL		"X (21)";
		CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_x_value_21; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (21)
 // CONSTANT_UNIT trans1_primary_value_unit;
}


VARIABLE x_value_22
{
	LABEL		"X (22)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_22; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (22)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_23
{
	LABEL		"X (23)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_23; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (23)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_24
{
	LABEL		"X (24)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_24; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (24)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_25
{
	LABEL		"X (25)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_25; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (25)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_26
{
	LABEL		"X (26)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_26; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (26)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_27
{
	LABEL		"X (27)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_27; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (27)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_28
{
	LABEL		"X (28)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_28; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (28)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_29
{
	LABEL		"X (29)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_29; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (29)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_30
{
	LABEL		"X (30)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_30; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (30)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_31
{
	LABEL		"X (31)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_31; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (31)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_32
{
	LABEL		"X (32)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_32; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (32)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_33
{
	LABEL		"X (33)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_33; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (33)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_34
{
	LABEL		"X (34)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_34; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (34)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_35
{
	LABEL		"X (35)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_35; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (35)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_36
{
	LABEL		"X (36)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_36; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (36)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_37
{
	LABEL		"X (37)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_37; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (37)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_38
{
	LABEL		"X (38)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_38; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (38)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_39
{
	LABEL		"X (39)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_39; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (39)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_40
{
	LABEL		"X (40)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_40; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (40)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_41
{
	LABEL		"X (41)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_41; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (41)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_42
{
	LABEL		"X (42)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_42; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (42)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_43
{
	LABEL		"X (43)";
	    CLASS       LOCAL;
		TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_43;  }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (43)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_44
{
	LABEL		"X (44)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_44; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (44)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_45
{
	LABEL		"X (45)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_45; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (45)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_46
{
	LABEL		"X (46)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_46; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (46)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_47
{
	LABEL		"X (47)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_47; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (47)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_48
{
	LABEL		"X (48)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_48; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (48)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_49
{
	LABEL		"X (49)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_49; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (49)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_50
{
	LABEL		"X (50)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_50; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (50)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_51
{
	LABEL		"X (51)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_51; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (51)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_52
{
	LABEL		"X (52)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_52; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (52)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_53
{
	LABEL		"X (53)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_53; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (53)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_54
{
	LABEL		"X (54)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_54; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (54)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_55
{
	LABEL		"X (55)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_55; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (55)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_56
{
	LABEL		"X (56)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_56; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (56)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_57
{
	LABEL		"X (57)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_57; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (57)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_58
{
	LABEL		"X (58)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_58; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (58)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_59
{
	LABEL		"X (59)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_59; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (59)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_60
{
	LABEL		"X (60)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_60; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (60)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_61
{
	LABEL		"X (61)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_61; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (61)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_62
{
	LABEL		"X (62)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_62; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (62)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_63
{
	LABEL		"X (63)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_63; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (63)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_64
{
	LABEL		"X (64)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_64; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (64)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_65
{
	LABEL		"X (65)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_65; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (65)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_66
{
	LABEL		"X (66)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_66; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (66)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_67
{
	LABEL		"X (67)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_67; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (67)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_68
{
	LABEL		"X (68)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_68; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (68)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_69
{
	LABEL		"X (69)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_69; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (69)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_70
{
	LABEL		"X (70)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_70; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (70)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_71
{
	LABEL		"X (71)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_71; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (71)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_72
{
	LABEL		"X (72)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_72; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (72)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_73
{
	LABEL		"X (73)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_73; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (73)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_74
{
	LABEL		"X (74)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_74; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (74)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_75
{
	LABEL		"X (75)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_75; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (75)
 // CONSTANT_UNIT trans1_primary_value_unit;
}


VARIABLE x_value_76
{
	LABEL		"X (76)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_76; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (76)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_77
{
	LABEL		"X (77)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_77; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (77)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_78
{
	LABEL		"X (78)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_78; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (78)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_79
{
	LABEL		"X (79)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_79; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (79)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_80
{
	LABEL		"X (80)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_80; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (80)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_81
{
	LABEL		"X (81)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_81; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (81)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_82
{
	LABEL		"X (82)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_82; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (82)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_83
{
	LABEL		"X (83)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_83; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (83)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_84
{
	LABEL		"X (84)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_84; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (84)
}
VARIABLE x_value_85
{
	LABEL		"X (85)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_85; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (85)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_86
{
	LABEL		"X (86)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_86; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (86)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_87
{
	LABEL		"X (87)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_87; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (87)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_88
{
	LABEL		"X (88)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_88; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (88)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_89
{
	LABEL		"X (89)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_89; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (89)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_90
{
	LABEL		"X (90)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_90; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (90)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_91
{
	LABEL		"X (91)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_91; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (91)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_92
{
	LABEL		"X (92)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_92; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (92)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_93
{
	LABEL		"X (93)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_93; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (93)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_94
{
	LABEL		"X (94)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_94; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (94)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_95
{
	LABEL		"X (95)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_95; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (95)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_96
{
	LABEL		"X (96)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_96; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (96)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_97
{
	LABEL		"X (97)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_97; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (97)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_98
{
	LABEL		"X (98)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_98; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (98)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_99
{
	LABEL		"X (99)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_99; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (99)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_100
{
	LABEL		"X (100)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_100; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (100)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_101
{
	LABEL		"X (101)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_101; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (101)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_102
{
	LABEL		"X (102)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_102; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (102)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_103
{
	LABEL		"X (103)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_103; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (103)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_104
{
	LABEL		"X (104)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_104; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (104)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_105
{
	LABEL		"X (105)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_105; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (105)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_106
{
	LABEL		"X (106)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_106; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (106)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_107
{
	LABEL		"X (107)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_107; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (107)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_108
{
	LABEL		"X (108)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_108; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (108)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_109
{
	LABEL		"X (109)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_109; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (109)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_110
{
	LABEL		"X (110)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_110; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (110)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_111
{
	LABEL		"X (111)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_111; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (111)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_112
{
	LABEL		"X (112)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_112; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (112)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_113
{
	LABEL		"X (113)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_113; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (113)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_114
{
	LABEL		"X (114)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_114; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (114)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_115
{
	LABEL		"X (115)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_115; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (115)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_116
{
	LABEL		"X (116)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_116; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (116)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_117
{
	LABEL		"X (117)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_117; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (117)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_118
{
	LABEL		"X (118)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_118; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (118)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_119
{
	LABEL		"X (119)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_119; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (119)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_120
{
	LABEL		"X (120)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_120; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (120)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_121
{
	LABEL		"X (121)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_121; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (121)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_122
{
	LABEL		"X (122)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_122; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (122)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_123
{
	LABEL		"X (123)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_123; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (123)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_124
{
	LABEL		"X (124)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_124; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (124)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_125
{
	LABEL		"X (125)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_125; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (125)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_126
{
	LABEL		"X (126)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_126; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (126)
 // CONSTANT_UNIT trans1_primary_value_unit;
}

VARIABLE x_value_127
{
	LABEL		"X (127)";
	    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_x_value_127; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (127)
 // CONSTANT_UNIT trans1_primary_value_unit;
}



MENU y_values_kennlinie									// Liste aller y-Wert-Variablen
{
	STYLE		"OCX_Y_LIST";
    ITEMS
    {
		y_value_0,									// 1. y-Wert-Variable
		y_value_1,
		y_value_2,
		y_value_3,
		y_value_4,
		y_value_5,
		y_value_6,
		y_value_7,
		y_value_8,
		y_value_9,
		y_value_10,
		y_value_11,
		y_value_12,
		y_value_13,
		y_value_14,
		y_value_15,

		y_value_16,
		y_value_17,
		y_value_18,
		y_value_19,
		y_value_20,
		y_value_21,
		y_value_22,
		y_value_23,
		y_value_24,
		y_value_25,
		y_value_26,
		y_value_27,
		y_value_28,
		y_value_29,
		y_value_30,
		y_value_31,

		y_value_32,
		y_value_33,
		y_value_34,
		y_value_35,
		y_value_36,
		y_value_37,
		y_value_38,
		y_value_39,
		y_value_40,
		y_value_41,
		y_value_42,
		y_value_43,
		y_value_44,
		y_value_45,
		y_value_46,
		y_value_47,

		y_value_48,
		y_value_49,
		y_value_50,
		y_value_51,
		y_value_52,
		y_value_53,
		y_value_54,
		y_value_55,
		y_value_56,
		y_value_57,
		y_value_58,
		y_value_59,
		y_value_60,
		y_value_61,
		y_value_62,
		y_value_63,

		y_value_64,
		y_value_65,
		y_value_66,
		y_value_67,
		y_value_68,
		y_value_69,
		y_value_70,
		y_value_71,
		y_value_72,
		y_value_73,
		y_value_74,
		y_value_75,
		y_value_76,
		y_value_77,
		y_value_78,
		y_value_79,

		y_value_80,
		y_value_81,
		y_value_82,
		y_value_83,
		y_value_84,
		y_value_85,
		y_value_86,
		y_value_87,
		y_value_88,
		y_value_89,
		y_value_90,
		y_value_91,
		y_value_92,
		y_value_93,
		y_value_94,
		y_value_95,

		y_value_96,
		y_value_97,
		y_value_98,
		y_value_99,
		y_value_100,
		y_value_101,
		y_value_102,
		y_value_103,
		y_value_104,
		y_value_105,
		y_value_106,
		y_value_107,
		y_value_108,
		y_value_109,
		y_value_110,
		y_value_111,

		y_value_112,
		y_value_113,
		y_value_114,
		y_value_115,
		y_value_116,
		y_value_117,
		y_value_118,
		y_value_119,
		y_value_120,
		y_value_121,
		y_value_122,
		y_value_123,
		y_value_124,
		y_value_125,
		y_value_126,
		y_value_127
	}
}

MENU Page_y_values_kennlinie_2									// Liste aller y-Wert-Variablen
{
//	STYLE		"OCX_Y_LIST";
	LABEL	   "Y - Values";
	STYLE		PAGE;
    ITEMS
    {
		y_value_0,									// 1. y-Wert-Variable
		y_value_1,
		y_value_2,
		y_value_3,
		y_value_4,
		y_value_5,
		y_value_6,
		y_value_7,
		y_value_8,
		y_value_9,
		y_value_10,
		y_value_11,
		y_value_12,
		y_value_13,
		y_value_14,
		y_value_15,

		y_value_16,
		y_value_17,
		y_value_18,
		y_value_19,
		y_value_20,
		y_value_21,
		y_value_22,
		y_value_23,
		y_value_24,
		y_value_25,
		y_value_26,
		y_value_27,
		y_value_28,
		y_value_29,
		y_value_30,
		y_value_31,

		y_value_32,
		y_value_33,
		y_value_34,
		y_value_35,
		y_value_36,
		y_value_37,
		y_value_38,
		y_value_39,
		y_value_40,
		y_value_41,
		y_value_42,
		y_value_43,
		y_value_44,
		y_value_45,
		y_value_46,
		y_value_47,

		y_value_48,
		y_value_49,
		y_value_50,
		y_value_51,
		y_value_52,
		y_value_53,
		y_value_54,
		y_value_55,
		y_value_56,
		y_value_57,
		y_value_58,
		y_value_59,
		y_value_60,
		y_value_61,
		y_value_62,
		y_value_63,

		y_value_64,
		y_value_65,
		y_value_66,
		y_value_67,
		y_value_68,
		y_value_69,
		y_value_70,
		y_value_71,
		y_value_72,
		y_value_73,
		y_value_74,
		y_value_75,
		y_value_76,
		y_value_77,
		y_value_78,
		y_value_79,

		y_value_80,
		y_value_81,
		y_value_82,
		y_value_83,
		y_value_84,
		y_value_85,
		y_value_86,
		y_value_87,
		y_value_88,
		y_value_89,
		y_value_90,
		y_value_91,
		y_value_92,
		y_value_93,
		y_value_94,
		y_value_95,

		y_value_96,
		y_value_97,
		y_value_98,
		y_value_99,
		y_value_100,
		y_value_101,
		y_value_102,
		y_value_103,
		y_value_104,
		y_value_105,
		y_value_106,
		y_value_107,
		y_value_108,
		y_value_109,
		y_value_110,
		y_value_111,

		y_value_112,
		y_value_113,
		y_value_114,
		y_value_115,
		y_value_116,
		y_value_117,
		y_value_118,
		y_value_119,
		y_value_120,
		y_value_121,
		y_value_122,
		y_value_123,
		y_value_124,
		y_value_125,
		y_value_126,
		y_value_127
	}
	VALIDITY    VALID_LIN_TABLE_XY (1)
}

VARIABLE dummy_action_variable
{
	LABEL		"";
	CLASS		CONTAINED;
   //	CONSTANT_UNIT	[Percent];
  TYPE		FLOAT;
 HANDLING    READ;	// funktioniert nur dann, wenn es als OnlineWindow deklariert wurde, 
 POST_READ_ACTIONS	// loest ein ereignis nach dem lesen aus
 {	
	 
	 	 method_lese_y_werte // startet methode
 }
}




METHOD method_lese_x_werte	
{
	LABEL		"";
	DEFINITION
	{  
		x_value_0 =fvar_value(trans1_tab_x_value_0);
		x_value_1 =fvar_value(trans1_tab_x_value_1);
		x_value_2 =fvar_value(trans1_tab_x_value_2);
		x_value_3 =fvar_value(trans1_tab_x_value_3);
		x_value_4 =fvar_value(trans1_tab_x_value_4);
		x_value_5 =fvar_value(trans1_tab_x_value_5);
		x_value_6 =fvar_value(trans1_tab_x_value_6);
		x_value_7 =fvar_value(trans1_tab_x_value_7);
		x_value_8 =fvar_value(trans1_tab_x_value_8);
		x_value_9 =fvar_value(trans1_tab_x_value_9);
		x_value_10 =fvar_value(trans1_tab_x_value_10);
		x_value_11 =fvar_value(trans1_tab_x_value_11);
		x_value_12 =fvar_value(trans1_tab_x_value_12);
		x_value_13 =fvar_value(trans1_tab_x_value_13);
		x_value_14 =fvar_value(trans1_tab_x_value_14);
		x_value_15 =fvar_value(trans1_tab_x_value_15);

		x_value_16 =fvar_value(trans1_tab_x_value_16);
		x_value_17 =fvar_value(trans1_tab_x_value_17);
		x_value_18 =fvar_value(trans1_tab_x_value_18);
		x_value_19 =fvar_value(trans1_tab_x_value_19);
		x_value_20 =fvar_value(trans1_tab_x_value_20);
		x_value_21 =fvar_value(trans1_tab_x_value_21);
		x_value_22 =fvar_value(trans1_tab_x_value_22);
		x_value_23 =fvar_value(trans1_tab_x_value_23);
		x_value_24 =fvar_value(trans1_tab_x_value_24);
		x_value_25 =fvar_value(trans1_tab_x_value_25);
		x_value_26 =fvar_value(trans1_tab_x_value_26);
		x_value_27 =fvar_value(trans1_tab_x_value_27);
		x_value_28 =fvar_value(trans1_tab_x_value_28);
		x_value_29 =fvar_value(trans1_tab_x_value_29);
		x_value_30 =fvar_value(trans1_tab_x_value_30);
		x_value_31 =fvar_value(trans1_tab_x_value_31);

		x_value_32 =fvar_value(trans1_tab_x_value_32);
		x_value_33 =fvar_value(trans1_tab_x_value_33);
		x_value_34 =fvar_value(trans1_tab_x_value_34);
		x_value_35 =fvar_value(trans1_tab_x_value_35);
		x_value_36 =fvar_value(trans1_tab_x_value_36);
		x_value_37 =fvar_value(trans1_tab_x_value_37);
		x_value_38 =fvar_value(trans1_tab_x_value_38);
		x_value_39 =fvar_value(trans1_tab_x_value_39);
		x_value_40 =fvar_value(trans1_tab_x_value_40);
		x_value_41 =fvar_value(trans1_tab_x_value_41);
		x_value_42 =fvar_value(trans1_tab_x_value_42);
		x_value_43 =fvar_value(trans1_tab_x_value_43);
		x_value_44 =fvar_value(trans1_tab_x_value_44);
		x_value_45 =fvar_value(trans1_tab_x_value_45);
		x_value_46 =fvar_value(trans1_tab_x_value_46);
		x_value_47 =fvar_value(trans1_tab_x_value_47);

		x_value_48 =fvar_value(trans1_tab_x_value_48);
		x_value_49 =fvar_value(trans1_tab_x_value_49);
		x_value_50 =fvar_value(trans1_tab_x_value_50);
		x_value_51 =fvar_value(trans1_tab_x_value_51);
		x_value_52 =fvar_value(trans1_tab_x_value_52);
		x_value_53 =fvar_value(trans1_tab_x_value_53);
		x_value_54 =fvar_value(trans1_tab_x_value_54);
		x_value_55 =fvar_value(trans1_tab_x_value_55);
		x_value_56 =fvar_value(trans1_tab_x_value_56);
		x_value_57 =fvar_value(trans1_tab_x_value_57);
		x_value_58 =fvar_value(trans1_tab_x_value_58);
		x_value_59 =fvar_value(trans1_tab_x_value_59);
		x_value_60 =fvar_value(trans1_tab_x_value_60);
		x_value_61 =fvar_value(trans1_tab_x_value_61);
		x_value_62 =fvar_value(trans1_tab_x_value_62);
		x_value_63 =fvar_value(trans1_tab_x_value_63);

		x_value_64 =fvar_value(trans1_tab_x_value_64);
		x_value_65 =fvar_value(trans1_tab_x_value_65);
		x_value_66 =fvar_value(trans1_tab_x_value_66);
		x_value_67 =fvar_value(trans1_tab_x_value_67);
		x_value_68 =fvar_value(trans1_tab_x_value_68);
		x_value_69 =fvar_value(trans1_tab_x_value_69);
		x_value_70 =fvar_value(trans1_tab_x_value_70);
		x_value_71 =fvar_value(trans1_tab_x_value_71);
		x_value_72 =fvar_value(trans1_tab_x_value_72);
		x_value_73 =fvar_value(trans1_tab_x_value_73);
		x_value_74 =fvar_value(trans1_tab_x_value_74);
		x_value_75 =fvar_value(trans1_tab_x_value_75);
		x_value_76 =fvar_value(trans1_tab_x_value_76);
		x_value_77 =fvar_value(trans1_tab_x_value_77);
		x_value_78 =fvar_value(trans1_tab_x_value_78);
		x_value_79 =fvar_value(trans1_tab_x_value_79);

		x_value_80 =fvar_value(trans1_tab_x_value_80);
		x_value_81 =fvar_value(trans1_tab_x_value_81);
		x_value_82 =fvar_value(trans1_tab_x_value_82);
		x_value_83 =fvar_value(trans1_tab_x_value_83);
		x_value_84 =fvar_value(trans1_tab_x_value_84);
		x_value_85 =fvar_value(trans1_tab_x_value_85);
		x_value_86 =fvar_value(trans1_tab_x_value_86);
		x_value_87 =fvar_value(trans1_tab_x_value_87);
		x_value_88 =fvar_value(trans1_tab_x_value_88);
		x_value_89 =fvar_value(trans1_tab_x_value_89);
		x_value_90 =fvar_value(trans1_tab_x_value_90);
		x_value_91 =fvar_value(trans1_tab_x_value_91);
		x_value_92 =fvar_value(trans1_tab_x_value_92);
		x_value_93 =fvar_value(trans1_tab_x_value_93);
		x_value_94 =fvar_value(trans1_tab_x_value_94);
		x_value_95 =fvar_value(trans1_tab_x_value_95);

		x_value_96 =fvar_value(trans1_tab_x_value_96);
		x_value_97 =fvar_value(trans1_tab_x_value_97);
		x_value_98 =fvar_value(trans1_tab_x_value_98);
		x_value_99 =fvar_value(trans1_tab_x_value_99);
		x_value_100 =fvar_value(trans1_tab_x_value_100);
		x_value_101 =fvar_value(trans1_tab_x_value_101);
		x_value_102 =fvar_value(trans1_tab_x_value_102);
		x_value_103 =fvar_value(trans1_tab_x_value_103);
		x_value_104 =fvar_value(trans1_tab_x_value_104);
		x_value_105 =fvar_value(trans1_tab_x_value_105);
		x_value_106 =fvar_value(trans1_tab_x_value_106);
		x_value_107 =fvar_value(trans1_tab_x_value_107);
		x_value_108 =fvar_value(trans1_tab_x_value_108);
		x_value_109 =fvar_value(trans1_tab_x_value_109);
		x_value_110 =fvar_value(trans1_tab_x_value_110);
		x_value_111 =fvar_value(trans1_tab_x_value_111);

		x_value_112 =fvar_value(trans1_tab_x_value_112);
		x_value_113 =fvar_value(trans1_tab_x_value_113);
		x_value_114 =fvar_value(trans1_tab_x_value_114);
		x_value_115 =fvar_value(trans1_tab_x_value_115);
		x_value_116 =fvar_value(trans1_tab_x_value_116);
		x_value_117 =fvar_value(trans1_tab_x_value_117);
		x_value_118 =fvar_value(trans1_tab_x_value_118);
		x_value_119 =fvar_value(trans1_tab_x_value_119);
		x_value_120 =fvar_value(trans1_tab_x_value_120);
		x_value_121 =fvar_value(trans1_tab_x_value_121);
		x_value_122 =fvar_value(trans1_tab_x_value_122);
		x_value_123 =fvar_value(trans1_tab_x_value_123);
		x_value_124 =fvar_value(trans1_tab_x_value_124);
		x_value_125 =fvar_value(trans1_tab_x_value_125);
		x_value_126 =fvar_value(trans1_tab_x_value_126);
		x_value_127 =fvar_value(trans1_tab_x_value_127);
	}
}



METHOD method_lese_y_werte	
{
	LABEL		"";
	DEFINITION
	{
		y_value_0 =fvar_value(trans1_tab_y_value_0);
		y_value_1 =fvar_value(trans1_tab_y_value_1);
		y_value_2 =fvar_value(trans1_tab_y_value_2);
		y_value_3 =fvar_value(trans1_tab_y_value_3);
		y_value_4 =fvar_value(trans1_tab_y_value_4);
		y_value_5 =fvar_value(trans1_tab_y_value_5);
		y_value_6 =fvar_value(trans1_tab_y_value_6);
		y_value_7 =fvar_value(trans1_tab_y_value_7);
		y_value_8 =fvar_value(trans1_tab_y_value_8);
		y_value_9 =fvar_value(trans1_tab_y_value_9);
		y_value_10 =fvar_value(trans1_tab_y_value_10);
		y_value_11 =fvar_value(trans1_tab_y_value_11);
		y_value_12 =fvar_value(trans1_tab_y_value_12);
		y_value_13 =fvar_value(trans1_tab_y_value_13);
		y_value_14 =fvar_value(trans1_tab_y_value_14);
		y_value_15 =fvar_value(trans1_tab_y_value_15);

		y_value_16 =fvar_value(trans1_tab_y_value_16);
		y_value_17 =fvar_value(trans1_tab_y_value_17);
		y_value_18 =fvar_value(trans1_tab_y_value_18);
		y_value_19 =fvar_value(trans1_tab_y_value_19);
		y_value_20 =fvar_value(trans1_tab_y_value_20);
		y_value_21 =fvar_value(trans1_tab_y_value_21);
		y_value_22 =fvar_value(trans1_tab_y_value_22);
		y_value_23 =fvar_value(trans1_tab_y_value_23);
		y_value_24 =fvar_value(trans1_tab_y_value_24);
		y_value_25 =fvar_value(trans1_tab_y_value_25);
		y_value_26 =fvar_value(trans1_tab_y_value_26);
		y_value_27 =fvar_value(trans1_tab_y_value_27);
		y_value_28 =fvar_value(trans1_tab_y_value_28);
		y_value_29 =fvar_value(trans1_tab_y_value_29);
		y_value_30 =fvar_value(trans1_tab_y_value_30);
		y_value_31 =fvar_value(trans1_tab_y_value_31);

		y_value_32 =fvar_value(trans1_tab_y_value_32);
		y_value_33 =fvar_value(trans1_tab_y_value_33);
		y_value_34 =fvar_value(trans1_tab_y_value_34);
		y_value_35 =fvar_value(trans1_tab_y_value_35);
		y_value_36 =fvar_value(trans1_tab_y_value_36);
		y_value_37 =fvar_value(trans1_tab_y_value_37);
		y_value_38 =fvar_value(trans1_tab_y_value_38);
		y_value_39 =fvar_value(trans1_tab_y_value_39);
		y_value_40 =fvar_value(trans1_tab_y_value_40);
		y_value_41 =fvar_value(trans1_tab_y_value_41);
		y_value_42 =fvar_value(trans1_tab_y_value_42);
		y_value_43 =fvar_value(trans1_tab_y_value_43);
		y_value_44 =fvar_value(trans1_tab_y_value_44);
		y_value_45 =fvar_value(trans1_tab_y_value_45);
		y_value_46 =fvar_value(trans1_tab_y_value_46);
		y_value_47 =fvar_value(trans1_tab_y_value_47);

		y_value_48 =fvar_value(trans1_tab_y_value_48);
		y_value_49 =fvar_value(trans1_tab_y_value_49);
		y_value_50 =fvar_value(trans1_tab_y_value_50);
		y_value_51 =fvar_value(trans1_tab_y_value_51);
		y_value_52 =fvar_value(trans1_tab_y_value_52);
		y_value_53 =fvar_value(trans1_tab_y_value_53);
		y_value_54 =fvar_value(trans1_tab_y_value_54);
		y_value_55 =fvar_value(trans1_tab_y_value_55);
		y_value_56 =fvar_value(trans1_tab_y_value_56);
		y_value_57 =fvar_value(trans1_tab_y_value_57);
		y_value_58 =fvar_value(trans1_tab_y_value_58);
		y_value_59 =fvar_value(trans1_tab_y_value_59);
		y_value_60 =fvar_value(trans1_tab_y_value_60);
		y_value_61 =fvar_value(trans1_tab_y_value_61);
		y_value_62 =fvar_value(trans1_tab_y_value_62);
		y_value_63 =fvar_value(trans1_tab_y_value_63);

		y_value_64 =fvar_value(trans1_tab_y_value_64);
		y_value_65 =fvar_value(trans1_tab_y_value_65);
		y_value_66 =fvar_value(trans1_tab_y_value_66);
		y_value_67 =fvar_value(trans1_tab_y_value_67);
		y_value_68 =fvar_value(trans1_tab_y_value_68);
		y_value_69 =fvar_value(trans1_tab_y_value_69);
		y_value_70 =fvar_value(trans1_tab_y_value_70);
		y_value_71 =fvar_value(trans1_tab_y_value_71);
		y_value_72 =fvar_value(trans1_tab_y_value_72);
		y_value_73 =fvar_value(trans1_tab_y_value_73);
		y_value_74 =fvar_value(trans1_tab_y_value_74);
		y_value_75 =fvar_value(trans1_tab_y_value_75);
		y_value_76 =fvar_value(trans1_tab_y_value_76);
		y_value_77 =fvar_value(trans1_tab_y_value_77);
		y_value_78 =fvar_value(trans1_tab_y_value_78);
		y_value_79 =fvar_value(trans1_tab_y_value_79);

		y_value_80 =fvar_value(trans1_tab_y_value_80);
		y_value_81 =fvar_value(trans1_tab_y_value_81);
		y_value_82 =fvar_value(trans1_tab_y_value_82);
		y_value_83 =fvar_value(trans1_tab_y_value_83);
		y_value_84 =fvar_value(trans1_tab_y_value_84);
		y_value_85 =fvar_value(trans1_tab_y_value_85);
		y_value_86 =fvar_value(trans1_tab_y_value_86);
		y_value_87 =fvar_value(trans1_tab_y_value_87);
		y_value_88 =fvar_value(trans1_tab_y_value_88);
		y_value_89 =fvar_value(trans1_tab_y_value_89);
		y_value_90 =fvar_value(trans1_tab_y_value_90);
		y_value_91 =fvar_value(trans1_tab_y_value_91);
		y_value_92 =fvar_value(trans1_tab_y_value_92);
		y_value_93 =fvar_value(trans1_tab_y_value_93);
		y_value_94 =fvar_value(trans1_tab_y_value_94);
		y_value_95 =fvar_value(trans1_tab_y_value_95);

		y_value_96 =fvar_value(trans1_tab_y_value_96);
		y_value_97 =fvar_value(trans1_tab_y_value_97);
		y_value_98 =fvar_value(trans1_tab_y_value_98);
		y_value_99 =fvar_value(trans1_tab_y_value_99);
		y_value_100 =fvar_value(trans1_tab_y_value_100);
		y_value_101 =fvar_value(trans1_tab_y_value_101);
		y_value_102 =fvar_value(trans1_tab_y_value_102);
		y_value_103 =fvar_value(trans1_tab_y_value_103);
		y_value_104 =fvar_value(trans1_tab_y_value_104);
		y_value_105 =fvar_value(trans1_tab_y_value_105);
		y_value_106 =fvar_value(trans1_tab_y_value_106);
		y_value_107 =fvar_value(trans1_tab_y_value_107);
		y_value_108 =fvar_value(trans1_tab_y_value_108);
		y_value_109 =fvar_value(trans1_tab_y_value_109);
		y_value_110 =fvar_value(trans1_tab_y_value_110);
		y_value_111 =fvar_value(trans1_tab_y_value_111);

		y_value_112 =fvar_value(trans1_tab_y_value_112);
		y_value_113 =fvar_value(trans1_tab_y_value_113);
		y_value_114 =fvar_value(trans1_tab_y_value_114);
		y_value_115 =fvar_value(trans1_tab_y_value_115);
		y_value_116 =fvar_value(trans1_tab_y_value_116);
		y_value_117 =fvar_value(trans1_tab_y_value_117);
		y_value_118 =fvar_value(trans1_tab_y_value_118);
		y_value_119 =fvar_value(trans1_tab_y_value_119);
		y_value_120 =fvar_value(trans1_tab_y_value_120);
		y_value_121 =fvar_value(trans1_tab_y_value_121);
		y_value_122 =fvar_value(trans1_tab_y_value_122);
		y_value_123 =fvar_value(trans1_tab_y_value_123);
		y_value_124 =fvar_value(trans1_tab_y_value_124);
		y_value_125 =fvar_value(trans1_tab_y_value_125);
		y_value_126 =fvar_value(trans1_tab_y_value_126);
		y_value_127 =fvar_value(trans1_tab_y_value_127);
	}
}









// 1. y-Wert-Variable
VARIABLE y_value_0 
{
    LABEL       "Y (0)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_0; }
  
 HANDLING    READ;
 CONSTANT_UNIT phys_LCD_STRING;
}


VARIABLE y_value_1 
{
    LABEL       "Y (1)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_1; }

 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (1)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_2 
{
    LABEL       "Y (2)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_2; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (2)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_3 
{
    LABEL       "Y (3)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_3; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (3)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_4 
{
	LABEL		"Y (4)";
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_4; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (4)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_5 
{
    LABEL       "Y (5)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_5; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (5)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_6 
{
    LABEL       "Y (6)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_6; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (6)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_7 
{
    LABEL       "Y (7)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_7; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (7)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_8 
{
    LABEL       "Y (8)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_8; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (8)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_9 
{
    LABEL       "Y (9)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_9; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (9)
 CONSTANT_UNIT phys_LCD_STRING;
}

VARIABLE y_value_10 
{
    LABEL       "Y (10)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_10; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (10)
 CONSTANT_UNIT phys_LCD_STRING;
}

VARIABLE y_value_11 
{
    LABEL       "Y (11)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_11; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (11)
 CONSTANT_UNIT phys_LCD_STRING;
}

VARIABLE y_value_12 
{
    LABEL       "Y (12)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_12; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (12)
 CONSTANT_UNIT phys_LCD_STRING;
}

VARIABLE y_value_13 
{
    LABEL       "Y (13)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_13; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (13)
 CONSTANT_UNIT phys_LCD_STRING;
}

VARIABLE y_value_14 
{
    LABEL       "Y (14)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_14; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (14)
 CONSTANT_UNIT phys_LCD_STRING;
}

VARIABLE y_value_15 
{
    LABEL       "Y (15)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_15; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (15)
 CONSTANT_UNIT phys_LCD_STRING;
}

VARIABLE y_value_16 
{
    LABEL       "Y (16)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_16; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (16)
 CONSTANT_UNIT phys_LCD_STRING;
}

VARIABLE y_value_17 
{
    LABEL       "Y (17)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_17; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (17)
 CONSTANT_UNIT phys_LCD_STRING;
}

VARIABLE y_value_18 
{
    LABEL       "Y (18)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_18; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (18)
 CONSTANT_UNIT phys_LCD_STRING;
}

VARIABLE y_value_19 
{
    LABEL       "Y (19)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_19; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (19)
 CONSTANT_UNIT phys_LCD_STRING;
}

VARIABLE y_value_20
{
    LABEL       "Y (20)"; 
	CLASS		LOCAL;
  TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_20; }
 HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (20)
 CONSTANT_UNIT phys_LCD_STRING;
}

VARIABLE y_value_21	
{
    LABEL       "Y (21)"; 
	CLASS		LOCAL;
	TYPE		FLOAT {	 DEFAULT_VALUE trans1_tab_y_value_21; }	
	HANDLING    READ;
	VALIDITY    VALID_LIN_TABLE_XY (21)
 CONSTANT_UNIT phys_LCD_STRING;
}

VARIABLE y_value_22
{
    LABEL       "Y (22)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_22; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (22)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_23
{
    LABEL       "Y (23)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_23; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (23)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_24
{
    LABEL       "Y (24)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_24; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (24)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_25
{
    LABEL       "Y (25)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_25; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (25)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_26
{
    LABEL       "Y (26)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_26; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (26)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_27
{
    LABEL       "Y (27)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_27; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (27)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_28
{
    LABEL       "Y (28)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_28; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (28)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_29
{
    LABEL       "Y (29)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_29; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (29)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_30
{
    LABEL       "Y (30)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_30; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (30)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_31
{
    LABEL       "Y (31)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_31; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (31)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_32
{
    LABEL       "Y (32)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_32; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (32)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_33
{
    LABEL       "Y (33)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_33; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (33)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_34
{
    LABEL       "Y (34)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_34; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (34)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_35
{
    LABEL       "Y (35)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_35; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (35)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_36
{
    LABEL       "Y (36)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_36; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (36)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_37
{
    LABEL       "Y (37)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_37; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (37)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_38
{
    LABEL       "Y (38)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_38; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (38)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_39
{
    LABEL       "Y (39)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_39; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (39)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_40
{
    LABEL       "Y (40)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_40; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (40)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_41
{
    LABEL       "Y (41)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_41; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (41)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_42
{
    LABEL       "Y (42)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_42; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (42)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_43
{
    LABEL       "Y (43)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_43; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (43)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_44
{
    LABEL       "Y (44)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_44; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (44)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_45
{
    LABEL       "Y (45)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_45; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (45)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_46
{
    LABEL       "Y (46)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_46; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (46)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_47
{
    LABEL       "Y (47)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_47; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (47)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_48
{
    LABEL       "Y (48)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_48; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (48)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_49
{
    LABEL       "Y (49)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_49; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (49)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_50
{
    LABEL       "Y (50)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_50; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (50)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_51
{
    LABEL       "Y (51)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_51; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (51)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_52
{
    LABEL       "Y (52)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_52; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (52)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_53
{
    LABEL       "Y (53)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_53; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (53)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_54
{
    LABEL       "Y (54)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_54; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (54)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_55
{
    LABEL       "Y (55)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_55; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (55)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_56
{
    LABEL       "Y (56)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_56; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (56)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_57
{
    LABEL       "Y (57)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_57; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (57)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_58
{
    LABEL       "Y (58)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_58; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (58)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_59
{
    LABEL       "Y (59)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_59; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (59)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_60
{
    LABEL       "Y (60)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_60; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (60)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_61
{
    LABEL       "Y (61)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_61; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (61)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_62
{
    LABEL       "Y (62)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_62; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (62)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_63
{
    LABEL       "Y (63)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_63; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (63)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_64
{
    LABEL       "Y (64)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_64; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (64)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_65
{
    LABEL       "Y (65)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_65; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (65)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_66
{
    LABEL       "Y (66)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_66; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (66)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_67
{
    LABEL       "Y (67)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_67; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (67)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_68
{
    LABEL       "Y (68)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_68; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (68)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_69
{
    LABEL       "Y (69)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_69; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (69)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_70
{
    LABEL       "Y (70)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_70; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (70)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_71
{
    LABEL       "Y (71)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_71; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (71)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_72
{
    LABEL       "Y (72)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_72; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (72)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_73
{
    LABEL       "Y (73)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_73; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (73)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_74
{
    LABEL       "Y (74)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_74; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (74)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_75
{
    LABEL       "Y (75)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_75; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (75)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_76
{
    LABEL       "Y (76)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_76; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (76)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_77
{
    LABEL       "Y (77)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_77; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (77)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_78
{
    LABEL       "Y (78)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_78; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (78)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_79
{
    LABEL       "Y (79)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_79; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (79)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_80
{
    LABEL       "Y (80)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_80; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (80)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_81
{
    LABEL       "Y (81)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_81; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (81)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_82
{
    LABEL       "Y (82)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_82; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (82)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_83
{
    LABEL       "Y (83)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_83; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (83)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_84
{
    LABEL       "Y (84)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_84; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (84)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_85
{
    LABEL       "Y (85)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_85; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (85)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_86
{
    LABEL       "Y (86)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_86; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (86)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_87
{
    LABEL       "Y (87)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_87; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (87)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_88
{
    LABEL       "Y (88)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_88; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (88)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_89
{
    LABEL       "Y (89)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_89; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (89)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_90
{
    LABEL       "Y (90)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_90; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (90)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_91
{
    LABEL       "Y (91)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_91; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (91)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_92
{
    LABEL       "Y (92)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_92; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (92)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_93
{
    LABEL       "Y (93)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_93; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (93)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_94
{
    LABEL       "Y (94)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_94; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (94)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_95
{
    LABEL       "Y (95)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_95; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (95)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_96
{
    LABEL       "Y (96)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_96; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (96)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_97
{
    LABEL       "Y (97)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_97; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (97)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_98
{
    LABEL       "Y (98)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_98; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (98)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_99
{
    LABEL       "Y (99)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_99; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (99)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_100
{
    LABEL       "Y (100)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_100; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (100)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_101
{
    LABEL       "Y (101)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_101; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (101)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_102
{
    LABEL       "Y (102)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_102; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (102)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_103
{
    LABEL       "Y (103)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_103; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (103)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_104
{
    LABEL       "Y (104)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_104; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (104)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_105
{
    LABEL       "Y (105)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_105; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (105)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_106
{
    LABEL       "Y (106)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_106; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (106)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_107
{
    LABEL       "Y (107)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_107; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (107)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_108
{
    LABEL       "Y (108)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_108; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (108)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_109
{
    LABEL       "Y (109)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_109; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (109)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_110
{
    LABEL       "Y (110)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_110; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (110)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_111
{
    LABEL       "Y (111)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_111; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (111)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_112
{
    LABEL       "Y (112)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_112; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (112)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_113
{
    LABEL       "Y (113)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_113; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (113)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_114
{
    LABEL       "Y (114)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_114; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (114)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_115
{
    LABEL       "Y (115)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_115; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (115)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_116
{
    LABEL       "Y (116)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_116; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (116)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_117
{
    LABEL       "Y (117)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_117; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (117)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_118
{
    LABEL       "Y (118)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_118; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (118)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_119
{
    LABEL       "Y (119)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_119; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (119)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_120
{
    LABEL       "Y (120)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_120; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (120)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_121
{
    LABEL       "Y (121)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_121; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (121)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_122
{
    LABEL       "Y (122)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_122; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (122)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_123
{
    LABEL       "Y (123)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_123; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (123)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_124
{
    LABEL       "Y (124)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_124; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (124)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_125
{
    LABEL       "Y (125)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_125; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (125)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_126
{
    LABEL       "Y (126)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_126; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (126)
 CONSTANT_UNIT phys_LCD_STRING;
}
VARIABLE y_value_127
{
    LABEL       "Y (127)"; 
    CLASS       LOCAL;
    TYPE        FLOAT {  DEFAULT_VALUE trans1_tab_y_value_127; }
    HANDLING    READ;
    VALIDITY    VALID_LIN_TABLE_XY (127)
 CONSTANT_UNIT phys_LCD_STRING;
}





VARIABLE x_value_min_kennlinie  // Untergrenze x-Bereich
{
	CLASS		LOCAL; //CONTAINED;
	LABEL		"X min";
//	STYLE		"OCX_X_MIN";
	// CONSTANT_UNIT	[Percent];
	TYPE		FLOAT
	{
		DEFAULT_VALUE	-10;
	}
	HANDLING    READ;
}


VARIABLE x_value_max_kennlinie  // Obergrenze x-Bereich
{
	CLASS		LOCAL;
	LABEL		"X max";
//	STYLE		"OCX_X_MAX";
	// CONSTANT_UNIT	[Percent];
//	TYPE		FLOAT { DEFAULT_VALUE MAX_x_VALUE;}
	TYPE		FLOAT
	{
		DEFAULT_VALUE	110;
	}

	HANDLING    READ;
}

VARIABLE y_value_min_kennlinie  // Untergrenze y-Bereich
{
	CLASS		LOCAL;
	LABEL		"Y min";
//	STYLE		"OCX_Y_MIN";
	// CONSTANT_UNIT	[Percent];
	TYPE		FLOAT
	{
		DEFAULT_VALUE  -10;
	}
	HANDLING    READ;
}

VARIABLE y_value_max_kennlinie  // Obergrenze y-Bereich
{
	CLASS		LOCAL; //CONTAINED;
	LABEL		"Y max";
//	STYLE		"OCX_Y_MAX";
	// CONSTANT_UNIT	[Percent];
//	TYPE		FLOAT { DEFAULT_VALUE MAX_Y_VALUE;}
	TYPE		FLOAT
	{
		DEFAULT_VALUE	110;
	}


	HANDLING    READ;
}

VARIABLE x_value_min_kennlinie_2  // Untergrenze x-Bereich
{
	CLASS		LOCAL; //CONTAINED;
	LABEL		"X min";
//	STYLE		"OCX_X_MIN";
	// CONSTANT_UNIT	[Percent];
	TYPE		FLOAT
	{
		DEFAULT_VALUE	-10;
	}
	HANDLING    READ;
}


VARIABLE x_value_max_kennlinie_2  // Obergrenze x-Bereich
{
	CLASS		LOCAL;
	LABEL		"X max";
//	STYLE		"OCX_X_MAX";
	// CONSTANT_UNIT	[Percent];
//	TYPE		FLOAT { DEFAULT_VALUE MAX_x_VALUE;}
	TYPE		FLOAT
	{
		DEFAULT_VALUE	110;
	}

	HANDLING    READ;
}

VARIABLE y_value_min_kennlinie_2  // Untergrenze y-Bereich
{
	CLASS		LOCAL;
	LABEL		"Y min";
//	STYLE		"OCX_Y_MIN";
	// CONSTANT_UNIT	[Percent];
	TYPE		FLOAT
	{
		DEFAULT_VALUE  -10;
	}
	HANDLING    READ;
}

VARIABLE y_value_max_kennlinie_2  // Obergrenze y-Bereich
{
	CLASS		LOCAL; //CONTAINED;
	LABEL		"Y max";
//	STYLE		"OCX_Y_MAX";
	// CONSTANT_UNIT	[Percent];
//	TYPE		FLOAT { DEFAULT_VALUE MAX_Y_VALUE;}
	TYPE		FLOAT
	{
		DEFAULT_VALUE	110;
	}


	HANDLING    READ;
}

VARIABLE x_value_mark // x-Wert zustzliche Markierung
{
	CLASS		LOCAL;
//	STYLE		"OCX_X_MARK";
	LABEL		"X-Punkt";
	CONSTANT_UNIT	"";
	TYPE		FLOAT
	{	
		DEFAULT_VALUE 2;
	}	
	HANDLING    READ & WRITE;
}

VARIABLE y_value_mark // y-Wert zustzliche Markierung
{
	CLASS		LOCAL;
//	STYLE		"OCX_Y_MARK";
	LABEL		"Y-Punkt";
	CONSTANT_UNIT	"";
	TYPE		FLOAT
	{	
		DEFAULT_VALUE 5;
	}	
	HANDLING    READ & WRITE;
}

// --------------------		Properties der ersten x-y-Kurve		-------------------------------------------

VARIABLE OCX_y_YScActualRangeMin // OCX-Property: Untergrenze des aktuell sichtbaren x-Bereichs
{
	CLASS		LOCAL;
	LABEL		"YScActualRangeMin";
	STYLE		"OCX_PROPERTY";
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0;
	}
	HANDLING    READ;
}

VARIABLE OCX_y_YScDataRangeMin 	// OCX-Property: Untergrenze des x-Daten-Bereichs
{
	CLASS		LOCAL;
	LABEL		"YScDataRangeMin";
	STYLE		"OCX_PROPERTY";
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0;
	}
	HANDLING    READ;
}

VARIABLE OCX_y_YScRangeMin 	// OCX-Property: Untergrenze des maximalen x-Bereich
{
	CLASS		LOCAL;
	LABEL		"YScRangeMin";
	STYLE		"OCX_PROPERTY";
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0;
	}
	HANDLING    READ;
}

VARIABLE OCX_y_logarithmic 	// OCX-Property: Logarithmische y-Skale
{
	CLASS		LOCAL;
	LABEL		"YScLogarithmic";
	STYLE		"OCX_PROPERTY";
	TYPE		INTEGER(1)
	{
		DEFAULT_VALUE	1;
	}
	HANDLING    READ;
}

// -----------------------	Properties des OCX der 2. Page	--------------------------------------------------------------

VARIABLE OCX_ProfilNum_xy							// Profil-Variable fr OCX yx
{
	LABEL		"ProfilID";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		INTEGER(2)
	{
		DEFAULT_VALUE	1001;
	}
	HANDLING    READ;
}

VARIABLE OCX_UserSettings_xy		// Fr Speicherung von Settings, die vom Benutzer zur Laufzeit gendert wurden
{
	LABEL		"UserSettings";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		ASCII (1000)
	{
		DEFAULT_VALUE	"";
	}
	HANDLING	READ & WRITE;
}

VARIABLE OCX_TimeScale 	// OCX-Property: Keine Zeitachse
{
	LABEL		"XScTimescale";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		INTEGER(2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}



METHOD method_maximum_y_value // ermittle maximaler y-wert
{
	CLASS		INPUT;
	DEFINITION
	{
		int		n;
		float	y_val[128];

		// Y0..Y127 -> 128 y-werte
		y_val[0]	= fvar_value(trans1_tab_y_value_0);
		y_val[1]	= fvar_value(trans1_tab_y_value_1);
		y_val[2]	= fvar_value(trans1_tab_y_value_2);
		y_val[3]	= fvar_value(trans1_tab_y_value_3);
		y_val[4]	= fvar_value(trans1_tab_y_value_4);
		y_val[5]	= fvar_value(trans1_tab_y_value_5);
		y_val[6]	= fvar_value(trans1_tab_y_value_6);
		y_val[7]	= fvar_value(trans1_tab_y_value_7);
		y_val[8]	= fvar_value(trans1_tab_y_value_8);
		y_val[9]	= fvar_value(trans1_tab_y_value_9);
		y_val[10]	= fvar_value(trans1_tab_y_value_10);
		y_val[11]	= fvar_value(trans1_tab_y_value_11);
		y_val[12]	= fvar_value(trans1_tab_y_value_12);
		y_val[13]	= fvar_value(trans1_tab_y_value_13);
		y_val[14]	= fvar_value(trans1_tab_y_value_14);
		y_val[15]	= fvar_value(trans1_tab_y_value_15);

		y_val[16]	= fvar_value(trans1_tab_y_value_16);
		y_val[17]	= fvar_value(trans1_tab_y_value_17);
		y_val[18]	= fvar_value(trans1_tab_y_value_18);
		y_val[19]	= fvar_value(trans1_tab_y_value_19);
		y_val[20]	= fvar_value(trans1_tab_y_value_20);
		y_val[21]	= fvar_value(trans1_tab_y_value_21);
		y_val[22]	= fvar_value(trans1_tab_y_value_22);
		y_val[23]	= fvar_value(trans1_tab_y_value_23);
		y_val[24]	= fvar_value(trans1_tab_y_value_24);
		y_val[25]	= fvar_value(trans1_tab_y_value_25);
		y_val[26]	= fvar_value(trans1_tab_y_value_26);
		y_val[27]	= fvar_value(trans1_tab_y_value_27);
		y_val[28]	= fvar_value(trans1_tab_y_value_28);
		y_val[29]	= fvar_value(trans1_tab_y_value_29);
		y_val[30]	= fvar_value(trans1_tab_y_value_30);
		y_val[31]	= fvar_value(trans1_tab_y_value_31);

		y_val[32]	= fvar_value(trans1_tab_y_value_32);
		y_val[33]	= fvar_value(trans1_tab_y_value_33);
		y_val[34]	= fvar_value(trans1_tab_y_value_34);
		y_val[35]	= fvar_value(trans1_tab_y_value_35);
		y_val[36]	= fvar_value(trans1_tab_y_value_36);
		y_val[37]	= fvar_value(trans1_tab_y_value_37);
		y_val[38]	= fvar_value(trans1_tab_y_value_38);
		y_val[39]	= fvar_value(trans1_tab_y_value_39);
		y_val[40]	= fvar_value(trans1_tab_y_value_40);
		y_val[41]	= fvar_value(trans1_tab_y_value_41);
		y_val[42]	= fvar_value(trans1_tab_y_value_42);
		y_val[43]	= fvar_value(trans1_tab_y_value_43);
		y_val[44]	= fvar_value(trans1_tab_y_value_44);
		y_val[45]	= fvar_value(trans1_tab_y_value_45);
		y_val[46]	= fvar_value(trans1_tab_y_value_46);
		y_val[47]	= fvar_value(trans1_tab_y_value_47);

		y_val[48]	= fvar_value(trans1_tab_y_value_48);
		y_val[49]	= fvar_value(trans1_tab_y_value_49);
		y_val[50]	= fvar_value(trans1_tab_y_value_50);
		y_val[51]	= fvar_value(trans1_tab_y_value_51);
		y_val[52]	= fvar_value(trans1_tab_y_value_52);
		y_val[53]	= fvar_value(trans1_tab_y_value_53);
		y_val[54]	= fvar_value(trans1_tab_y_value_54);
		y_val[55]	= fvar_value(trans1_tab_y_value_55);
		y_val[56]	= fvar_value(trans1_tab_y_value_56);
		y_val[57]	= fvar_value(trans1_tab_y_value_57);
		y_val[58]	= fvar_value(trans1_tab_y_value_58);
		y_val[59]	= fvar_value(trans1_tab_y_value_59);
		y_val[60]	= fvar_value(trans1_tab_y_value_60);
		y_val[61]	= fvar_value(trans1_tab_y_value_61);
		y_val[62]	= fvar_value(trans1_tab_y_value_62);
		y_val[63]	= fvar_value(trans1_tab_y_value_63);

		y_val[64]	= fvar_value(trans1_tab_y_value_64);
		y_val[65]	= fvar_value(trans1_tab_y_value_65);
		y_val[66]	= fvar_value(trans1_tab_y_value_66);
		y_val[67]	= fvar_value(trans1_tab_y_value_67);
		y_val[68]	= fvar_value(trans1_tab_y_value_68);
		y_val[69]	= fvar_value(trans1_tab_y_value_69);
		y_val[70]	= fvar_value(trans1_tab_y_value_70);
		y_val[71]	= fvar_value(trans1_tab_y_value_71);
		y_val[72]	= fvar_value(trans1_tab_y_value_72);
		y_val[73]	= fvar_value(trans1_tab_y_value_73);
		y_val[74]	= fvar_value(trans1_tab_y_value_74);
		y_val[75]	= fvar_value(trans1_tab_y_value_75);
		y_val[76]	= fvar_value(trans1_tab_y_value_76);
		y_val[77]	= fvar_value(trans1_tab_y_value_77);
		y_val[78]	= fvar_value(trans1_tab_y_value_78);
		y_val[79]	= fvar_value(trans1_tab_y_value_79);

		y_val[80]	= fvar_value(trans1_tab_y_value_80);
		y_val[81]	= fvar_value(trans1_tab_y_value_81);
		y_val[82]	= fvar_value(trans1_tab_y_value_82);
		y_val[83]	= fvar_value(trans1_tab_y_value_83);
		y_val[84]	= fvar_value(trans1_tab_y_value_84);
		y_val[85]	= fvar_value(trans1_tab_y_value_85);
		y_val[86]	= fvar_value(trans1_tab_y_value_86);
		y_val[87]	= fvar_value(trans1_tab_y_value_87);
		y_val[88]	= fvar_value(trans1_tab_y_value_88);
		y_val[89]	= fvar_value(trans1_tab_y_value_89);
		y_val[90]	= fvar_value(trans1_tab_y_value_90);
		y_val[91]	= fvar_value(trans1_tab_y_value_91);
		y_val[92]	= fvar_value(trans1_tab_y_value_92);
		y_val[93]	= fvar_value(trans1_tab_y_value_93);
		y_val[94]	= fvar_value(trans1_tab_y_value_94);
		y_val[95]	= fvar_value(trans1_tab_y_value_95);

		y_val[96]	= fvar_value(trans1_tab_y_value_96);
		y_val[97]	= fvar_value(trans1_tab_y_value_97);
		y_val[98]	= fvar_value(trans1_tab_y_value_98);
		y_val[99]	= fvar_value(trans1_tab_y_value_99);
		y_val[100]	= fvar_value(trans1_tab_y_value_100);
		y_val[101]	= fvar_value(trans1_tab_y_value_101);
		y_val[102]	= fvar_value(trans1_tab_y_value_102);
		y_val[103]	= fvar_value(trans1_tab_y_value_103);
		y_val[104]	= fvar_value(trans1_tab_y_value_104);
		y_val[105]	= fvar_value(trans1_tab_y_value_105);
		y_val[106]	= fvar_value(trans1_tab_y_value_106);
		y_val[107]	= fvar_value(trans1_tab_y_value_107);
		y_val[108]	= fvar_value(trans1_tab_y_value_108);
		y_val[109]	= fvar_value(trans1_tab_y_value_109);
		y_val[110]	= fvar_value(trans1_tab_y_value_110);
		y_val[111]	= fvar_value(trans1_tab_y_value_111);

		y_val[112]	= fvar_value(trans1_tab_y_value_112);
		y_val[113]	= fvar_value(trans1_tab_y_value_113);
		y_val[114]	= fvar_value(trans1_tab_y_value_114);
		y_val[115]	= fvar_value(trans1_tab_y_value_115);
		y_val[116]	= fvar_value(trans1_tab_y_value_116);
		y_val[117]	= fvar_value(trans1_tab_y_value_117);
		y_val[118]	= fvar_value(trans1_tab_y_value_118);
		y_val[119]	= fvar_value(trans1_tab_y_value_119);
		y_val[120]	= fvar_value(trans1_tab_y_value_120);
		y_val[121]	= fvar_value(trans1_tab_y_value_121);
		y_val[122]	= fvar_value(trans1_tab_y_value_122);
		y_val[123]	= fvar_value(trans1_tab_y_value_123);
		y_val[124]	= fvar_value(trans1_tab_y_value_124);
		y_val[125]	= fvar_value(trans1_tab_y_value_125);
		y_val[126]	= fvar_value(trans1_tab_y_value_126);
		y_val[127]	= fvar_value(trans1_tab_y_value_127);

		for (n = 1; n < 128; n++)
		{
			if (MAX_Y_VALUE < y_val[n]) // max_value kleiner als der Wert n ?
			{
			
					assign_float(MAX_Y_VALUE,y_val[n]); 
			}

		}

	}
}

VARIABLE MAX_Y_VALUE
{
	CLASS		LOCAL;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0;
	}
	HANDLING    READ & WRITE;
}

METHOD method_maximum_x_value // ermittle maximaler x-wert
{
	CLASS		INPUT;
	DEFINITION
	{
		int		n;
		float	x_val[128];

		// x0..x127 -> 128 x-werte
		x_val[0]	= fvar_value(trans1_tab_x_value_0);
		x_val[1]	= fvar_value(trans1_tab_x_value_1);
		x_val[2]	= fvar_value(trans1_tab_x_value_2);
		x_val[3]	= fvar_value(trans1_tab_x_value_3);
		x_val[4]	= fvar_value(trans1_tab_x_value_4);
		x_val[5]	= fvar_value(trans1_tab_x_value_5);
		x_val[6]	= fvar_value(trans1_tab_x_value_6);
		x_val[7]	= fvar_value(trans1_tab_x_value_7);
		x_val[8]	= fvar_value(trans1_tab_x_value_8);
		x_val[9]	= fvar_value(trans1_tab_x_value_9);
		x_val[10]	= fvar_value(trans1_tab_x_value_10);
		x_val[11]	= fvar_value(trans1_tab_x_value_11);
		x_val[12]	= fvar_value(trans1_tab_x_value_12);
		x_val[13]	= fvar_value(trans1_tab_x_value_13);
		x_val[14]	= fvar_value(trans1_tab_x_value_14);
		x_val[15]	= fvar_value(trans1_tab_x_value_15);

		x_val[16]	= fvar_value(trans1_tab_x_value_16);
		x_val[17]	= fvar_value(trans1_tab_x_value_17);
		x_val[18]	= fvar_value(trans1_tab_x_value_18);
		x_val[19]	= fvar_value(trans1_tab_x_value_19);
		x_val[20]	= fvar_value(trans1_tab_x_value_20);
		x_val[21]	= fvar_value(trans1_tab_x_value_21);
		x_val[22]	= fvar_value(trans1_tab_x_value_22);
		x_val[23]	= fvar_value(trans1_tab_x_value_23);
		x_val[24]	= fvar_value(trans1_tab_x_value_24);
		x_val[25]	= fvar_value(trans1_tab_x_value_25);
		x_val[26]	= fvar_value(trans1_tab_x_value_26);
		x_val[27]	= fvar_value(trans1_tab_x_value_27);
		x_val[28]	= fvar_value(trans1_tab_x_value_28);
		x_val[29]	= fvar_value(trans1_tab_x_value_29);
		x_val[30]	= fvar_value(trans1_tab_x_value_30);
		x_val[31]	= fvar_value(trans1_tab_x_value_31);

		x_val[32]	= fvar_value(trans1_tab_x_value_32);
		x_val[33]	= fvar_value(trans1_tab_x_value_33);
		x_val[34]	= fvar_value(trans1_tab_x_value_34);
		x_val[35]	= fvar_value(trans1_tab_x_value_35);
		x_val[36]	= fvar_value(trans1_tab_x_value_36);
		x_val[37]	= fvar_value(trans1_tab_x_value_37);
		x_val[38]	= fvar_value(trans1_tab_x_value_38);
		x_val[39]	= fvar_value(trans1_tab_x_value_39);
		x_val[40]	= fvar_value(trans1_tab_x_value_40);
		x_val[41]	= fvar_value(trans1_tab_x_value_41);
		x_val[42]	= fvar_value(trans1_tab_x_value_42);
		x_val[43]	= fvar_value(trans1_tab_x_value_43);
		x_val[44]	= fvar_value(trans1_tab_x_value_44);
		x_val[45]	= fvar_value(trans1_tab_x_value_45);
		x_val[46]	= fvar_value(trans1_tab_x_value_46);
		x_val[47]	= fvar_value(trans1_tab_x_value_47);
		x_val[48]	= fvar_value(trans1_tab_x_value_48);

		x_val[49]	= fvar_value(trans1_tab_x_value_49);
		x_val[50]	= fvar_value(trans1_tab_x_value_50);
		x_val[51]	= fvar_value(trans1_tab_x_value_51);
		x_val[52]	= fvar_value(trans1_tab_x_value_52);
		x_val[53]	= fvar_value(trans1_tab_x_value_53);
		x_val[54]	= fvar_value(trans1_tab_x_value_54);
		x_val[55]	= fvar_value(trans1_tab_x_value_55);
		x_val[56]	= fvar_value(trans1_tab_x_value_56);
		x_val[57]	= fvar_value(trans1_tab_x_value_57);
		x_val[58]	= fvar_value(trans1_tab_x_value_58);
		x_val[59]	= fvar_value(trans1_tab_x_value_59);
		x_val[60]	= fvar_value(trans1_tab_x_value_60);
		x_val[61]	= fvar_value(trans1_tab_x_value_61);
		x_val[62]	= fvar_value(trans1_tab_x_value_62);
		x_val[63]	= fvar_value(trans1_tab_x_value_63);

		x_val[64]	= fvar_value(trans1_tab_x_value_64);
		x_val[65]	= fvar_value(trans1_tab_x_value_65);
		x_val[66]	= fvar_value(trans1_tab_x_value_66);
		x_val[67]	= fvar_value(trans1_tab_x_value_67);
		x_val[68]	= fvar_value(trans1_tab_x_value_68);
		x_val[69]	= fvar_value(trans1_tab_x_value_69);
		x_val[70]	= fvar_value(trans1_tab_x_value_60);
		x_val[71]	= fvar_value(trans1_tab_x_value_71);
		x_val[72]	= fvar_value(trans1_tab_x_value_72);
		x_val[73]	= fvar_value(trans1_tab_x_value_73);
		x_val[74]	= fvar_value(trans1_tab_x_value_74);
		x_val[75]	= fvar_value(trans1_tab_x_value_75);
		x_val[76]	= fvar_value(trans1_tab_x_value_76);
		x_val[77]	= fvar_value(trans1_tab_x_value_77);
		x_val[78]	= fvar_value(trans1_tab_x_value_78);
		x_val[79]	= fvar_value(trans1_tab_x_value_79);
		x_val[80]	= fvar_value(trans1_tab_x_value_80);

		x_val[81]	= fvar_value(trans1_tab_x_value_81);
		x_val[82]	= fvar_value(trans1_tab_x_value_82);
		x_val[83]	= fvar_value(trans1_tab_x_value_83);
		x_val[84]	= fvar_value(trans1_tab_x_value_84);
		x_val[85]	= fvar_value(trans1_tab_x_value_85);
		x_val[86]	= fvar_value(trans1_tab_x_value_86);
		x_val[87]	= fvar_value(trans1_tab_x_value_87);
		x_val[88]	= fvar_value(trans1_tab_x_value_88);
		x_val[89]	= fvar_value(trans1_tab_x_value_89);
		x_val[90]	= fvar_value(trans1_tab_x_value_90);
		x_val[91]	= fvar_value(trans1_tab_x_value_91);
		x_val[92]	= fvar_value(trans1_tab_x_value_92);
		x_val[93]	= fvar_value(trans1_tab_x_value_93);
		x_val[94]	= fvar_value(trans1_tab_x_value_94);
		x_val[95]	= fvar_value(trans1_tab_x_value_95);

		x_val[96]	= fvar_value(trans1_tab_x_value_96);
		x_val[97]	= fvar_value(trans1_tab_x_value_97);
		x_val[98]	= fvar_value(trans1_tab_x_value_98);
		x_val[99]	= fvar_value(trans1_tab_x_value_99);
		x_val[100]	= fvar_value(trans1_tab_x_value_100);
		x_val[101]	= fvar_value(trans1_tab_x_value_101);
		x_val[102]	= fvar_value(trans1_tab_x_value_102);
		x_val[103]	= fvar_value(trans1_tab_x_value_103);
		x_val[104]	= fvar_value(trans1_tab_x_value_104);
		x_val[105]	= fvar_value(trans1_tab_x_value_105);
		x_val[106]	= fvar_value(trans1_tab_x_value_106);
		x_val[107]	= fvar_value(trans1_tab_x_value_107);
		x_val[108]	= fvar_value(trans1_tab_x_value_108);
		x_val[109]	= fvar_value(trans1_tab_x_value_109);
		x_val[110]	= fvar_value(trans1_tab_x_value_110);
		x_val[111]	= fvar_value(trans1_tab_x_value_111);

		x_val[112]	= fvar_value(trans1_tab_x_value_112);
		x_val[113]	= fvar_value(trans1_tab_x_value_113);
		x_val[114]	= fvar_value(trans1_tab_x_value_114);
		x_val[115]	= fvar_value(trans1_tab_x_value_115);
		x_val[116]	= fvar_value(trans1_tab_x_value_116);
		x_val[117]	= fvar_value(trans1_tab_x_value_117);
		x_val[118]	= fvar_value(trans1_tab_x_value_118);
		x_val[119]	= fvar_value(trans1_tab_x_value_119);
		x_val[120]	= fvar_value(trans1_tab_x_value_120);
		x_val[121]	= fvar_value(trans1_tab_x_value_121);
		x_val[122]	= fvar_value(trans1_tab_x_value_122);
		x_val[123]	= fvar_value(trans1_tab_x_value_123);
		x_val[124]	= fvar_value(trans1_tab_x_value_124);
		x_val[125]	= fvar_value(trans1_tab_x_value_125);
		x_val[126]	= fvar_value(trans1_tab_x_value_126);
		x_val[127]	= fvar_value(trans1_tab_x_value_127);
		
		for (n = 1; n < 128; n++)
		{
			if (MAX_x_VALUE < x_val[n]) // max_value kleiner als der Wert n ?
			{
			
					assign_float(MAX_x_VALUE,x_val[n]); 
			}

		}
	}
}

VARIABLE MAX_x_VALUE
{
	CLASS		LOCAL;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0;
	}
	HANDLING    READ & WRITE;
}



/***********************************************************************/
/*    Unit relations                                                   */
/***********************************************************************/

/* Physical Block */
/* no unit relations */

/* Temperature Transducer Block */
UNIT TB_TEMPERATURE_UNIT
{
	trans1_primary_value_unit:
	
	
	trans1_INPUT_LOWER_RANGE,
	trans1_INPUT_UPPER_RANGE,
	
	trans1_primary_value,
	trans1_secondary_value_1,
	
	trans1_bias_1,
	
	trans1_upper_sensor_limit,
	trans1_lower_sensor_limit,
	trans1_TRIM_POINT_ZERO ,
	trans1_TRIM_POINT_SPAN ,
	trans1_TRIM_VALUE_ZERO ,
	trans1_TRIM_VALUE_SPAN,

	x_value_min_kennlinie,
	x_value_max_kennlinie,
	x_value_min_kennlinie_2,
	x_value_max_kennlinie_2,

	trans1_tab_x_value_0   ,
	trans1_tab_x_value_1   ,
	trans1_tab_x_value_2   ,
	trans1_tab_x_value_3   ,
	trans1_tab_x_value_4   ,
	trans1_tab_x_value_5   ,
	trans1_tab_x_value_6   ,
	trans1_tab_x_value_7   ,
	trans1_tab_x_value_8   ,
	trans1_tab_x_value_9   ,
	trans1_tab_x_value_10  ,
	trans1_tab_x_value_11  ,
	trans1_tab_x_value_12  ,
	trans1_tab_x_value_13  ,
	trans1_tab_x_value_14  ,
	trans1_tab_x_value_15  ,

	trans1_tab_x_value_16  ,
	trans1_tab_x_value_17  ,
	trans1_tab_x_value_18  ,
	trans1_tab_x_value_19  ,
	trans1_tab_x_value_20  ,
	trans1_tab_x_value_21  ,
	trans1_tab_x_value_22  ,
	trans1_tab_x_value_23  ,
	trans1_tab_x_value_24  ,
	trans1_tab_x_value_25  ,
	trans1_tab_x_value_26  ,
	trans1_tab_x_value_27  ,
	trans1_tab_x_value_28  ,
	trans1_tab_x_value_29  ,
	trans1_tab_x_value_30  ,
	trans1_tab_x_value_31  ,
	
	trans1_tab_x_value_32  ,
	trans1_tab_x_value_33  ,
	trans1_tab_x_value_34  ,
	trans1_tab_x_value_35  ,
	trans1_tab_x_value_36  ,
	trans1_tab_x_value_37  ,
	trans1_tab_x_value_38  ,
	trans1_tab_x_value_39  ,
	trans1_tab_x_value_40  ,
	trans1_tab_x_value_41  ,
	trans1_tab_x_value_42  ,
	trans1_tab_x_value_43  ,
	trans1_tab_x_value_44  ,
	trans1_tab_x_value_45  ,
	trans1_tab_x_value_46  ,
	trans1_tab_x_value_47  ,
	
	trans1_tab_x_value_48  ,
	trans1_tab_x_value_49  ,
	trans1_tab_x_value_50  ,
	trans1_tab_x_value_51  ,
	trans1_tab_x_value_52  ,
	trans1_tab_x_value_53  ,
	trans1_tab_x_value_54  ,
	trans1_tab_x_value_55  ,
	trans1_tab_x_value_56  ,
	trans1_tab_x_value_57  ,
	trans1_tab_x_value_58  ,
	trans1_tab_x_value_59  ,
	trans1_tab_x_value_60  ,
	trans1_tab_x_value_61  ,
	trans1_tab_x_value_62  ,
	trans1_tab_x_value_63  ,
	
	trans1_tab_x_value_64  ,
	trans1_tab_x_value_65  ,
	trans1_tab_x_value_66  ,
	trans1_tab_x_value_67  ,
	trans1_tab_x_value_68  ,
	trans1_tab_x_value_69  ,
	trans1_tab_x_value_70  ,
	trans1_tab_x_value_71  ,
	trans1_tab_x_value_72  ,
	trans1_tab_x_value_73  ,
	trans1_tab_x_value_74  ,
	trans1_tab_x_value_75  ,
	trans1_tab_x_value_76  ,
	trans1_tab_x_value_77  ,
	trans1_tab_x_value_78  ,
	trans1_tab_x_value_79  ,
	
	trans1_tab_x_value_80  ,
	trans1_tab_x_value_81  ,
	trans1_tab_x_value_82  ,
	trans1_tab_x_value_83  ,
	trans1_tab_x_value_84  ,
	trans1_tab_x_value_85  ,
	trans1_tab_x_value_86  ,
	trans1_tab_x_value_87  ,
	trans1_tab_x_value_88  ,
	trans1_tab_x_value_89  ,
	trans1_tab_x_value_90  ,
	trans1_tab_x_value_91  ,
	trans1_tab_x_value_92  ,
	trans1_tab_x_value_93  ,
	trans1_tab_x_value_94  ,
	trans1_tab_x_value_95  ,
	
	trans1_tab_x_value_96  ,
	trans1_tab_x_value_97  ,
	trans1_tab_x_value_98  ,
	trans1_tab_x_value_99  ,
	trans1_tab_x_value_100  ,
	trans1_tab_x_value_101  ,
	trans1_tab_x_value_102  ,
	trans1_tab_x_value_103  ,
	trans1_tab_x_value_104  ,
	trans1_tab_x_value_105  ,
	trans1_tab_x_value_106  ,
	trans1_tab_x_value_107  ,
	trans1_tab_x_value_108  ,
	trans1_tab_x_value_109  ,
	trans1_tab_x_value_110  ,
	trans1_tab_x_value_111  ,
	
	trans1_tab_x_value_112  ,
	trans1_tab_x_value_113  ,
	trans1_tab_x_value_114  ,
	trans1_tab_x_value_115  ,
	trans1_tab_x_value_116  ,
	trans1_tab_x_value_117  ,
	trans1_tab_x_value_118  ,
	trans1_tab_x_value_119  ,
	trans1_tab_x_value_120  ,
	trans1_tab_x_value_121  ,
	trans1_tab_x_value_122  ,
	trans1_tab_x_value_123  ,
	trans1_tab_x_value_124  ,
	trans1_tab_x_value_125  ,
	trans1_tab_x_value_126  ,
	trans1_tab_x_value_127 ,

	x_value_0 ,
	x_value_1 ,
	x_value_2 ,
	x_value_3 ,
	x_value_4 ,
	x_value_5 ,
	x_value_6 ,
	x_value_7 ,
	x_value_8 ,
	x_value_9 ,
	x_value_10,
	x_value_11,
	x_value_12,
	x_value_13,
	x_value_14,
	x_value_15,

	x_value_16,
	x_value_17,
	x_value_18,
	x_value_19,
	x_value_20,
	x_value_21,
	x_value_22,
	x_value_23,
	x_value_24,
	x_value_25,
	x_value_26,
	x_value_27,
	x_value_28,
	x_value_29,
	x_value_30,
	x_value_31,

	x_value_32 ,
	x_value_33 ,
	x_value_34 ,
	x_value_35 ,
	x_value_36 ,
	x_value_37 ,
	x_value_38 ,
	x_value_39 ,
	x_value_40 ,
	x_value_41 ,
	x_value_42 ,
	x_value_43 ,
	x_value_44 ,
	x_value_45 ,
	x_value_46 ,
	x_value_47 ,

	x_value_48 ,
	x_value_49 ,
	x_value_50 ,
	x_value_51 ,
	x_value_52 ,
	x_value_53 ,
	x_value_54 ,
	x_value_55 ,
	x_value_56 ,
	x_value_57 ,
	x_value_58 ,
	x_value_59 ,
	x_value_60 ,
	x_value_61 ,
	x_value_62 ,
	x_value_63 ,

	x_value_64 ,
	x_value_65 ,
	x_value_66 ,
	x_value_67 ,
	x_value_68 ,
	x_value_69 ,
	x_value_70 ,
	x_value_71 ,
	x_value_72 ,
	x_value_73 ,
	x_value_74 ,
	x_value_75 ,
	x_value_76 ,
	x_value_77 ,
	x_value_78 ,
	x_value_79 ,

	x_value_80 ,
	x_value_81 ,
	x_value_82 ,
	x_value_83 ,
	x_value_84 ,
	x_value_85 ,
	x_value_86 ,
	x_value_87 ,
	x_value_88 ,
	x_value_89 ,
	x_value_90 ,
	x_value_91 ,
	x_value_92 ,
	x_value_93 ,
	x_value_94 ,
	x_value_95 ,

	x_value_96 ,
	x_value_97 ,
	x_value_98 ,
	x_value_99 ,
	x_value_100,
	x_value_101,
	x_value_102,
	x_value_103,
	x_value_104,
	x_value_105,
	x_value_106,
	x_value_107,
	x_value_108,
	x_value_109,
	x_value_110,
	x_value_111,

	x_value_112,
	x_value_113,
	x_value_114,
	x_value_115,
	x_value_116,
	x_value_117,
	x_value_118,
	x_value_119,
	x_value_120,
	x_value_121,
	x_value_122,
	x_value_123,
	x_value_124,
	x_value_125,
	x_value_126,
	x_value_127,
			   
	
	func1_AI_pv_upper_range_value,
	func1_AI_pv_lower_range_value
}



UNIT Y_TABLE_UNIT
{
	phys_LCD_STRING:

	y_value_min_kennlinie,
	y_value_max_kennlinie,
	y_value_min_kennlinie_2,
	y_value_max_kennlinie_2,
	trans1_tab_y_value_0   ,
	trans1_tab_y_value_1   ,
	trans1_tab_y_value_2   ,
	trans1_tab_y_value_3   ,
	trans1_tab_y_value_4   ,
	trans1_tab_y_value_5   ,
	trans1_tab_y_value_6   ,
	trans1_tab_y_value_7   ,
	trans1_tab_y_value_8   ,
	trans1_tab_y_value_9   ,
	trans1_tab_y_value_10  ,
	trans1_tab_y_value_11  ,
	trans1_tab_y_value_12  ,
	trans1_tab_y_value_13  ,
	trans1_tab_y_value_14  ,
	trans1_tab_y_value_15  ,

	trans1_tab_y_value_16  ,
	trans1_tab_y_value_17  ,
	trans1_tab_y_value_18  ,
	trans1_tab_y_value_19  ,
	trans1_tab_y_value_20  ,
	trans1_tab_y_value_21  ,
	trans1_tab_y_value_22  ,
	trans1_tab_y_value_23  ,
	trans1_tab_y_value_24  ,
	trans1_tab_y_value_25  ,
	trans1_tab_y_value_26  ,
	trans1_tab_y_value_27  ,
	trans1_tab_y_value_28  ,
	trans1_tab_y_value_29  ,
	trans1_tab_y_value_30  ,
	trans1_tab_y_value_31  ,
	
	trans1_tab_y_value_32  ,
	trans1_tab_y_value_33  ,
	trans1_tab_y_value_34  ,
	trans1_tab_y_value_35  ,
	trans1_tab_y_value_36  ,
	trans1_tab_y_value_37  ,
	trans1_tab_y_value_38  ,
	trans1_tab_y_value_39  ,
	trans1_tab_y_value_40  ,
	trans1_tab_y_value_41  ,
	trans1_tab_y_value_42  ,
	trans1_tab_y_value_43  ,
	trans1_tab_y_value_44  ,
	trans1_tab_y_value_45  ,
	trans1_tab_y_value_46  ,
	trans1_tab_y_value_47  ,
	
	trans1_tab_y_value_48  ,
	trans1_tab_y_value_49  ,
	trans1_tab_y_value_50  ,
	trans1_tab_y_value_51  ,
	trans1_tab_y_value_52  ,
	trans1_tab_y_value_53  ,
	trans1_tab_y_value_54  ,
	trans1_tab_y_value_55  ,
	trans1_tab_y_value_56  ,
	trans1_tab_y_value_57  ,
	trans1_tab_y_value_58  ,
	trans1_tab_y_value_59  ,
	trans1_tab_y_value_60  ,
	trans1_tab_y_value_61  ,
	trans1_tab_y_value_62  ,
	trans1_tab_y_value_63  ,
	
	trans1_tab_y_value_64  ,
	trans1_tab_y_value_65  ,
	trans1_tab_y_value_66  ,
	trans1_tab_y_value_67  ,
	trans1_tab_y_value_68  ,
	trans1_tab_y_value_69  ,
	trans1_tab_y_value_70  ,
	trans1_tab_y_value_71  ,
	trans1_tab_y_value_72  ,
	trans1_tab_y_value_73  ,
	trans1_tab_y_value_74  ,
	trans1_tab_y_value_75  ,
	trans1_tab_y_value_76  ,
	trans1_tab_y_value_77  ,
	trans1_tab_y_value_78  ,
	trans1_tab_y_value_79  ,
	
	trans1_tab_y_value_80  ,
	trans1_tab_y_value_81  ,
	trans1_tab_y_value_82  ,
	trans1_tab_y_value_83  ,
	trans1_tab_y_value_84  ,
	trans1_tab_y_value_85  ,
	trans1_tab_y_value_86  ,
	trans1_tab_y_value_87  ,
	trans1_tab_y_value_88  ,
	trans1_tab_y_value_89  ,
	trans1_tab_y_value_90  ,
	trans1_tab_y_value_91  ,
	trans1_tab_y_value_92  ,
	trans1_tab_y_value_93  ,
	trans1_tab_y_value_94  ,
	trans1_tab_y_value_95  ,
	
	trans1_tab_y_value_96  ,
	trans1_tab_y_value_97  ,
	trans1_tab_y_value_98  ,
	trans1_tab_y_value_99  ,
	trans1_tab_y_value_100  ,
	trans1_tab_y_value_101  ,
	trans1_tab_y_value_102  ,
	trans1_tab_y_value_103  ,
	trans1_tab_y_value_104  ,
	trans1_tab_y_value_105  ,
	trans1_tab_y_value_106  ,
	trans1_tab_y_value_107  ,
	trans1_tab_y_value_108  ,
	trans1_tab_y_value_109  ,
	trans1_tab_y_value_110  ,
	trans1_tab_y_value_111  ,
	
	trans1_tab_y_value_112  ,
	trans1_tab_y_value_113  ,
	trans1_tab_y_value_114  ,
	trans1_tab_y_value_115  ,
	trans1_tab_y_value_116  ,
	trans1_tab_y_value_117  ,
	trans1_tab_y_value_118  ,
	trans1_tab_y_value_119  ,
	trans1_tab_y_value_120  ,
	trans1_tab_y_value_121  ,
	trans1_tab_y_value_122  ,
	trans1_tab_y_value_123  ,
	trans1_tab_y_value_124  ,
	trans1_tab_y_value_125  ,
	trans1_tab_y_value_126  ,
	trans1_tab_y_value_127  
					   
}





UNIT AI_OUT_SCALE_UNIT
{
	func1_AI_out_unit:


	lower_sensor_limit_con,
	upper_sensor_limit_con,



	func1_AI_out_value,
	func1_AI_out_upper_range_value,
	func1_AI_out_lower_range_value,
	func1_AI_hi_hi_lim,
	func1_AI_hi_lim,
	func1_AI_lo_lim,
	func1_AI_lo_lo_lim,
	func1_AI_hi_hi_alm_value,
	func1_AI_hi_alm_value,
	func1_AI_lo_alm_value,
	func1_AI_lo_lo_alm_value,
	func1_AI_FSafeValue, 
	func1_AI_alarm_hys
}


/*********  10. June 2003 ******+ add new parameters  *********/





/*--------------NR :65------------------------------------*/

VARIABLE trans1_SENSOR_TRIM_MODE
{
  LABEL [trans1_SENSOR_TRIM_MODE_LABEL];
  HELP  [trans1_SENSOR_TRIM_MODE_HELP];
  CLASS CONTAINED;
  TYPE ENUMERATED 
  {
     {0,[trans1_SENSOR_TRIM_MODE_enum_0]},
     {1,[trans1_SENSOR_TRIM_MODE_enum_1]},
     {2,[trans1_SENSOR_TRIM_MODE_enum_2]}
  }
  HANDLING READ & WRITE;
}


/*--------------NR :65------------------------------------*/
COMMAND read_trans1_SENSOR_TRIM_MODE
{
     BLOCK transducer_block_1;
     INDEX 65;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             
             trans1_SENSOR_TRIM_MODE
          }
     }


}
COMMAND write_trans1_SENSOR_TRIM_MODE
{
     BLOCK transducer_block_1;
     INDEX 65;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             
             trans1_SENSOR_TRIM_MODE
          }
          REPLY
          {
          }
     }


}

/*----------------------------------------------------------------------*/


/*--------------NUMBER :66------------------------------------*/


VARIABLE trans1_TRIM_POINT_ZERO
{
  LABEL [trans1_TRIM_POINT_ZERO_LABEL];
  HELP  [trans1_TRIM_POINT_ZERO_HELP];
  CLASS CONTAINED;
  TYPE FLOAT
  {
	MAX_VALUE trans1_upper_sensor_limit;
	MIN_VALUE trans1_lower_sensor_limit;

  }
  HANDLING READ & WRITE;
}


/*--------------NR :66------------------------------------*/
COMMAND read_trans1_TRIM_POINT_ZERO
{
     BLOCK transducer_block_1;
     INDEX 66;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             
             trans1_TRIM_POINT_ZERO
          }
     }


}
COMMAND write_trans1_TRIM_POINT_ZERO
{
     BLOCK transducer_block_1;
     INDEX 66;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             
             trans1_TRIM_POINT_ZERO
          }
          REPLY
          {
          }
     }


}

/*----------------------------------------------------------------------*/


/*--------------NUMBER :67------------------------------------*/


VARIABLE trans1_TRIM_POINT_SPAN
{
  LABEL [trans1_TRIM_POINT_SPAN_LABEL];
  HELP  [trans1_TRIM_POINT_SPAN_HELP];
  CLASS CONTAINED;
  TYPE FLOAT
  {
	MAX_VALUE trans1_upper_sensor_limit;
	MIN_VALUE trans1_lower_sensor_limit;

  }
  HANDLING READ & WRITE;
}


/*--------------NR :67------------------------------------*/
COMMAND read_trans1_TRIM_POINT_SPAN
{
     BLOCK transducer_block_1;
     INDEX 67;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             
             trans1_TRIM_POINT_SPAN
          }
     }


}
COMMAND write_trans1_TRIM_POINT_SPAN
{
     BLOCK transducer_block_1;
     INDEX 67;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             
             trans1_TRIM_POINT_SPAN
          }
          REPLY
          {
          }
     }


}

/*----------------------------------------------------------------------*/


/*--------------NUMBER :68------------------------------------*/


VARIABLE trans1_TRIM_VALUE_ZERO
{
  LABEL [trans1_TRIM_VALUE_ZERO_LABEL];
  HELP  [trans1_TRIM_VALUE_ZERO_HELP];
  CLASS CONTAINED;
  TYPE FLOAT;
  HANDLING READ & WRITE;
}


/*--------------NR :68------------------------------------*/
COMMAND read_trans1_TRIM_VALUE_ZERO
{
     BLOCK transducer_block_1;
     INDEX 68;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             
             trans1_TRIM_VALUE_ZERO
          }
     }


}
COMMAND write_trans1_TRIM_VALUE_ZERO
{
     BLOCK transducer_block_1;
     INDEX 68;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             
             trans1_TRIM_VALUE_ZERO
          }
          REPLY
          {
          }
     }


}

/*----------------------------------------------------------------------*/


/*--------------NUMBER :69------------------------------------*/


VARIABLE trans1_TRIM_VALUE_SPAN
{
  LABEL [trans1_TRIM_VALUE_SPAN_LABEL];
  HELP  [trans1_TRIM_VALUE_SPAN_HELP];
  CLASS CONTAINED;
  TYPE FLOAT;
  HANDLING READ & WRITE;
}


/*--------------NR :69------------------------------------*/
COMMAND read_trans1_TRIM_VALUE_SPAN
{
     BLOCK transducer_block_1;
     INDEX 69;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
             
             trans1_TRIM_VALUE_SPAN
          }
     }


}
COMMAND write_trans1_TRIM_VALUE_SPAN
{
     BLOCK transducer_block_1;
     INDEX 69;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
             
             trans1_TRIM_VALUE_SPAN
          }
          REPLY
          {
          }
     }


}

/*----------------------------------------------------------------------*/
/*--------------------------*/

/*----------------------------------------------------------------------*/
/*--------------------------*/

METHOD method_set_sensor_trim
{
	LABEL [method_SET_TRIM_POINT_LABEL];
	CLASS		INPUT;
	DEFINITION
	{
		int choice;
		long id[1];

		add_abort_method(abort_initialization);
/* ### */
	/*** Find out which trim point to do ***/

		choice = 0;
		if (trans1_SENSOR_TRIM_MODE == 1)
		{
			choice = SELECT_FROM_LIST([method_SET_TRIM_POINT_PROMPT], [method_SET_TRIM_POINT_LIST1]);
		}
		else if (trans1_SENSOR_TRIM_MODE == 2)
		{
			choice = SELECT_FROM_LIST([method_SET_TRIM_POINT_PROMPT], [method_SET_TRIM_POINT_LIST2]);
		}
		else
		{
			PUT_MESSAGE("Sensor trim is disabled!");
		}


	/*** Carry out the trim ***/

		switch ( choice )
		{

		case 1: /* lower point */
			ReadCommand(read_trans1_TRIM_POINT_ZERO);
			id[0] = VARID(trans1_TRIM_POINT_ZERO);

			do
			{
				get_dev_var_value([method_SET_TRIM_POINT_LOWER],id,trans1_TRIM_POINT_ZERO);
			}while( (fvar_value(  trans1_TRIM_POINT_ZERO ) > fvar_value( trans1_upper_sensor_limit) )  ||  (fvar_value(trans1_TRIM_POINT_ZERO) < fvar_value(trans1_lower_sensor_limit)) );

			WriteCommand( write_trans1_TRIM_POINT_ZERO );
			PUT_MESSAGE([refresh_download]);

			break;
			/* 1 point */

		case 2: /* 2 point */
			/*set Trim Point High */
			ReadCommand(read_trans1_TRIM_POINT_SPAN);
			id[0] = VARID(trans1_TRIM_POINT_SPAN);
			do
			{
				get_dev_var_value([method_SET_TRIM_POINT_UPPER],id,trans1_TRIM_POINT_SPAN);
			}while( (fvar_value(  trans1_TRIM_POINT_SPAN ) > fvar_value( trans1_upper_sensor_limit) )  ||  (fvar_value(trans1_TRIM_POINT_SPAN) < fvar_value(trans1_lower_sensor_limit)) );

			WriteCommand( write_trans1_TRIM_POINT_SPAN );
			PUT_MESSAGE([refresh_download]);

 			break;
			/* 2 point */

		default: /* no action */
			break;
		}
	}
}

METHOD method_select_trim_mode
{
	LABEL [method_SELECT_TRIM_MODE_LABEL];
	CLASS		INPUT;
	DEFINITION
	{
		int choice;

		choice = SELECT_FROM_LIST([method_SELECT_TRIM_MODE_PROMPT],[method_SELECT_TRIM_MODE_LIST]);

		switch ( choice )
		{
		case 1: /* disabled */
			iassign(trans1_SENSOR_TRIM_MODE,0);
			WriteCommand( write_trans1_SENSOR_TRIM_MODE );
			PUT_MESSAGE([refresh_download]);
			break;

		case 2: /* 1 point */
			iassign(trans1_SENSOR_TRIM_MODE,1);
			WriteCommand( write_trans1_SENSOR_TRIM_MODE );
			PUT_MESSAGE([refresh_download]);
			break;

		case 3: /* 2 point */
			iassign(trans1_SENSOR_TRIM_MODE,2);
			WriteCommand( write_trans1_SENSOR_TRIM_MODE );
			PUT_MESSAGE([refresh_download]);
			break;

		default:/* no action */
			PUT_MESSAGE([method_SELECT_TRIM_MODE_UNCHANGED]);
			break;
		}
	}
}



METHOD method_apply_sensor_trim
{
	LABEL [method_APPLY_TRIM_VALUE_LABEL];
	CLASS		INPUT;
	DEFINITION
	{
		int choice;
        long id[1];
		float val1;
		float val2;

		add_abort_method(abort_initialization);

/* ### */
	/*** Find out which trim point to do ***/

		choice = 0;
		if (trans1_SENSOR_TRIM_MODE == 1)
		{
			choice = SELECT_FROM_LIST([method_APPLY_TRIM_VALUE_PROMPT], [method_APPLY_TRIM_VALUE_LIST1]);
		}
		else if (trans1_SENSOR_TRIM_MODE == 2)
		{
			choice = SELECT_FROM_LIST([method_APPLY_TRIM_VALUE_PROMPT], [method_APPLY_TRIM_VALUE_LIST2]);
		}
		else
		{
			PUT_MESSAGE("Sensor trim is disabled!");
		}


		switch ( choice )
		{

		case 1: /* 1 point */
			ReadCommand(read_trans1_TRIM_VALUE_ZERO);
			ReadCommand(read_trans1_TRIM_POINT_ZERO);

			val1=fvar_value(trans1_TRIM_VALUE_ZERO);
			val2=fvar_value(trans1_TRIM_POINT_ZERO);

			id[0] = VARID(trans1_TRIM_VALUE_ZERO);

			acknowledge([method_APPLY_TRIM_LOWER_CURRENT],id);
			WriteCommand(write_trans1_TRIM_VALUE_ZERO);

			ReadCommand(read_trans1_TRIM_VALUE_ZERO);
			ReadCommand (read_trans1_primary_value);

			val1=fvar_value(trans1_TRIM_VALUE_ZERO);
			val2=fvar_value(trans1_primary_value);


			ACKNOWLEDGE([method_APPLY_TRIM_LOWER_NEW]);
			PUT_MESSAGE([refresh_download]);

			break;
			/* 1 point */


		case 2: /* 2 point */
			/* bugzilla #413 mod */
			ReadCommand(read_trans1_TRIM_VALUE_SPAN);
			//id[0] = VARID(trans1_TRIM_VALUE_SPAN);
			ReadCommand(read_trans1_TRIM_POINT_SPAN);

			val1=fvar_value(trans1_TRIM_VALUE_SPAN);
			val2=fvar_value(trans1_TRIM_POINT_SPAN);

			acknowledge([method_APPLY_TRIM_UPPER_CURRENT],id);
			WriteCommand(write_trans1_TRIM_VALUE_SPAN);

			ReadCommand(read_trans1_TRIM_VALUE_SPAN);
			/* bugzilla #413 mod end */
			ReadCommand (read_trans1_primary_value);
			/* bugzilla #413 mod */
			val1=fvar_value(trans1_TRIM_VALUE_SPAN);
			/* bugzilla #413 mod end */
			val2=fvar_value(trans1_primary_value);

			/* bugzilla #413 mod */
			ACKNOWLEDGE([method_APPLY_TRIM_UPPER_NEW]);
			/* bugzilla #413 mod end */
			PUT_MESSAGE([refresh_download]);
			break;
			/* 2 point */

		default: /* no action */
			break;
		}

	}
}
